/*
   SPDX-FileCopyrightText: 2019-2022 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: LGPL-2.0-or-later
*/

#include "emoticonunicodeutils.h"
using namespace KPIMTextEdit;

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeFlagsEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::FlagsEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":chequered_flag:"), QString::fromUtf16(u"\U0001F3C1"), category},
        {QStringLiteral(":triangular_flag:"), QString::fromUtf16(u"\U0001F6A9"), category},
        {QStringLiteral(":crossed_flags:"), QString::fromUtf16(u"\U0001F38C"), category},
        {QStringLiteral(":black_flag:"), QString::fromUtf16(u"\U0001F3F4"), category},
        {QStringLiteral(":white_flag:"), QString::fromUtf16(u"\U0001F3F3"), category},
        {QStringLiteral(":rainbow_flag:"), QString::fromUtf16(u"\U0001F3F3\U0000FE0F\U0000200D\U0001F308"), category},
        {QStringLiteral(":pirate_flag:"), QString::fromUtf16(u"\U0001F3F4\U0000200D\U00002620\U0000FE0F"), category},
        {QStringLiteral(":flag_Ascension_Island:"), QString::fromUtf16(u"\U0001F1E6\U0001F1E8"), category},
        {QStringLiteral(":flag_Andorra:"), QString::fromUtf16(u"\U0001F1E6\U0001F1E9"), category},
        {QStringLiteral(":flag_United_Arab_Emirates:"), QString::fromUtf16(u"\U0001F1E6\U0001F1EA"), category},
        {QStringLiteral(":flag_Afghanistan:"), QString::fromUtf16(u"\U0001F1E6\U0001F1EB"), category},
        {QStringLiteral(":flag_Antigua_&_Barbuda:"), QString::fromUtf16(u"\U0001F1E6\U0001F1EC"), category},
        {QStringLiteral(":flag_Anguilla:"), QString::fromUtf16(u"\U0001F1E6\U0001F1EE"), category},
        {QStringLiteral(":flag_Albania:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F1"), category},
        {QStringLiteral(":flag_Armenia:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F2"), category},
        {QStringLiteral(":flag_Angola:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F4"), category},
        {QStringLiteral(":flag_Antarctica:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F6"), category},
        {QStringLiteral(":flag_Argentina:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F7"), category},
        {QStringLiteral(":flag_American_Samoa:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F8"), category},
        {QStringLiteral(":flag_Austria:"), QString::fromUtf16(u"\U0001F1E6\U0001F1F9"), category},
        {QStringLiteral(":flag_Australia:"), QString::fromUtf16(u"\U0001F1E6\U0001F1FA"), category},
        {QStringLiteral(":flag_Aruba:"), QString::fromUtf16(u"\U0001F1E6\U0001F1FC"), category},
        {QStringLiteral(":flag_Åland_Islands:"), QString::fromUtf16(u"\U0001F1E6\U0001F1FD"), category},
        {QStringLiteral(":flag_Azerbaijan:"), QString::fromUtf16(u"\U0001F1E6\U0001F1FF"), category},
        {QStringLiteral(":flag_Bosnia_&_Herzegovina:"), QString::fromUtf16(u"\U0001F1E7\U0001F1E6"), category},
        {QStringLiteral(":flag_Barbados:"), QString::fromUtf16(u"\U0001F1E7\U0001F1E7"), category},
        {QStringLiteral(":flag_Bangladesh:"), QString::fromUtf16(u"\U0001F1E7\U0001F1E9"), category},
        {QStringLiteral(":flag_Belgium:"), QString::fromUtf16(u"\U0001F1E7\U0001F1EA"), category},
        {QStringLiteral(":flag_Burkina_Faso:"), QString::fromUtf16(u"\U0001F1E7\U0001F1EB"), category},
        {QStringLiteral(":flag_Bulgaria:"), QString::fromUtf16(u"\U0001F1E7\U0001F1EC"), category},
        {QStringLiteral(":flag_Bahrain:"), QString::fromUtf16(u"\U0001F1E7\U0001F1ED"), category},
        {QStringLiteral(":flag_Burundi:"), QString::fromUtf16(u"\U0001F1E7\U0001F1EE"), category},
        {QStringLiteral(":flag_Benin:"), QString::fromUtf16(u"\U0001F1E7\U0001F1EF"), category},
        {QStringLiteral(":flag_St._Barthélemy:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F1"), category},
        {QStringLiteral(":flag_Bermuda:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F2"), category},
        {QStringLiteral(":flag_Brunei:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F3"), category},
        {QStringLiteral(":flag_Bolivia:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F4"), category},
        {QStringLiteral(":flag_Caribbean_Netherlands:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F6"), category},
        {QStringLiteral(":flag_Brazil:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F7"), category},
        {QStringLiteral(":flag_Bahamas:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F8"), category},
        {QStringLiteral(":flag_Bhutan:"), QString::fromUtf16(u"\U0001F1E7\U0001F1F9"), category},
        {QStringLiteral(":flag_Bouvet_Island:"), QString::fromUtf16(u"\U0001F1E7\U0001F1FB"), category},
        {QStringLiteral(":flag_Botswana:"), QString::fromUtf16(u"\U0001F1E7\U0001F1FC"), category},
        {QStringLiteral(":flag_Belarus:"), QString::fromUtf16(u"\U0001F1E7\U0001F1FE"), category},
        {QStringLiteral(":flag_Belize:"), QString::fromUtf16(u"\U0001F1E7\U0001F1FF"), category},
        {QStringLiteral(":flag_Canada:"), QString::fromUtf16(u"\U0001F1E8\U0001F1E6"), category},
        {QStringLiteral(":flag_Cocos_(Keeling)_Islands:"), QString::fromUtf16(u"\U0001F1E8\U0001F1E8"), category},
        {QStringLiteral(":flag_Congo_-_Kinshasa:"), QString::fromUtf16(u"\U0001F1E8\U0001F1E9"), category},
        {QStringLiteral(":flag_Central_African_Republic:"), QString::fromUtf16(u"\U0001F1E8\U0001F1EB"), category},
        {QStringLiteral(":flag_Congo_-_Brazzaville:"), QString::fromUtf16(u"\U0001F1E8\U0001F1EC"), category},
        {QStringLiteral(":flag_Switzerland:"), QString::fromUtf16(u"\U0001F1E8\U0001F1ED"), category},
        {QStringLiteral(":flag_Côte_d’Ivoire:"), QString::fromUtf16(u"\U0001F1E8\U0001F1EE"), category},
        {QStringLiteral(":flag_Cook_Islands:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F0"), category},
        {QStringLiteral(":flag_Chile:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F1"), category},
        {QStringLiteral(":flag_Cameroon:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F2"), category},
        {QStringLiteral(":flag_China:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F3"), category},
        {QStringLiteral(":flag_Colombia:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F4"), category},
        {QStringLiteral(":flag_Clipperton_Island:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F5"), category},
        {QStringLiteral(":flag_Costa_Rica:"), QString::fromUtf16(u"\U0001F1E8\U0001F1F7"), category},
        {QStringLiteral(":flag_Cuba:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FA"), category},
        {QStringLiteral(":flag_Cape_Verde:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FB"), category},
        {QStringLiteral(":flag_Curaçao:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FC"), category},
        {QStringLiteral(":flag_Christmas_Island:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FD"), category},
        {QStringLiteral(":flag_Cyprus:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FE"), category},
        {QStringLiteral(":flag_Czechia:"), QString::fromUtf16(u"\U0001F1E8\U0001F1FF"), category},
        {QStringLiteral(":flag_Germany:"), QString::fromUtf16(u"\U0001F1E9\U0001F1EA"), category},
        {QStringLiteral(":flag_Diego_Garcia:"), QString::fromUtf16(u"\U0001F1E9\U0001F1EC"), category},
        {QStringLiteral(":flag_Djibouti:"), QString::fromUtf16(u"\U0001F1E9\U0001F1EF"), category},
        {QStringLiteral(":flag_Denmark:"), QString::fromUtf16(u"\U0001F1E9\U0001F1F0"), category},
        {QStringLiteral(":flag_Dominica:"), QString::fromUtf16(u"\U0001F1E9\U0001F1F2"), category},
        {QStringLiteral(":flag_Dominican_Republic:"), QString::fromUtf16(u"\U0001F1E9\U0001F1F4"), category},
        {QStringLiteral(":flag_Algeria:"), QString::fromUtf16(u"\U0001F1E9\U0001F1FF"), category},
        {QStringLiteral(":flag_Ceuta_&_Melilla:"), QString::fromUtf16(u"\U0001F1EA\U0001F1E6"), category},
        {QStringLiteral(":flag_Ecuador:"), QString::fromUtf16(u"\U0001F1EA\U0001F1E8"), category},
        {QStringLiteral(":flag_Estonia:"), QString::fromUtf16(u"\U0001F1EA\U0001F1EA"), category},
        {QStringLiteral(":flag_Egypt:"), QString::fromUtf16(u"\U0001F1EA\U0001F1EC"), category},
        {QStringLiteral(":flag_Western_Sahara:"), QString::fromUtf16(u"\U0001F1EA\U0001F1ED"), category},
        {QStringLiteral(":flag_Eritrea:"), QString::fromUtf16(u"\U0001F1EA\U0001F1F7"), category},
        {QStringLiteral(":flag_Spain:"), QString::fromUtf16(u"\U0001F1EA\U0001F1F8"), category},
        {QStringLiteral(":flag_Ethiopia:"), QString::fromUtf16(u"\U0001F1EA\U0001F1F9"), category},
        {QStringLiteral(":flag_European_Union:"), QString::fromUtf16(u"\U0001F1EA\U0001F1FA"), category},
        {QStringLiteral(":flag_Finland:"), QString::fromUtf16(u"\U0001F1EB\U0001F1EE"), category},
        {QStringLiteral(":flag_Fiji:"), QString::fromUtf16(u"\U0001F1EB\U0001F1EF"), category},
        {QStringLiteral(":flag_Falkland_Islands:"), QString::fromUtf16(u"\U0001F1EB\U0001F1F0"), category},
        {QStringLiteral(":flag_Micronesia:"), QString::fromUtf16(u"\U0001F1EB\U0001F1F2"), category},
        {QStringLiteral(":flag_Faroe_Islands:"), QString::fromUtf16(u"\U0001F1EB\U0001F1F4"), category},
        {QStringLiteral(":flag_France:"), QString::fromUtf16(u"\U0001F1EB\U0001F1F7"), category},
        {QStringLiteral(":flag_Gabon:"), QString::fromUtf16(u"\U0001F1EC\U0001F1E6"), category},
        {QStringLiteral(":flag_United_Kingdom:"), QString::fromUtf16(u"\U0001F1EC\U0001F1E7"), category},
        {QStringLiteral(":flag_Grenada:"), QString::fromUtf16(u"\U0001F1EC\U0001F1E9"), category},
        {QStringLiteral(":flag_Georgia:"), QString::fromUtf16(u"\U0001F1EC\U0001F1EA"), category},
        {QStringLiteral(":flag_French_Guiana:"), QString::fromUtf16(u"\U0001F1EC\U0001F1EB"), category},
        {QStringLiteral(":flag_Guernsey:"), QString::fromUtf16(u"\U0001F1EC\U0001F1EC"), category},
        {QStringLiteral(":flag_Ghana:"), QString::fromUtf16(u"\U0001F1EC\U0001F1ED"), category},
        {QStringLiteral(":flag_Gibraltar:"), QString::fromUtf16(u"\U0001F1EC\U0001F1EE"), category},
        {QStringLiteral(":flag_Greenland:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F1"), category},
        {QStringLiteral(":flag_Gambia:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F2"), category},
        {QStringLiteral(":flag_Guinea:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F3"), category},
        {QStringLiteral(":flag_Guadeloupe:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F5"), category},
        {QStringLiteral(":flag_Equatorial_Guinea:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F6"), category},
        {QStringLiteral(":flag_Greece:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F7"), category},
        {QStringLiteral(":flag_South_Georgia_&_South_Sandwich_Islands:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F8"), category},
        {QStringLiteral(":flag_Guatemala:"), QString::fromUtf16(u"\U0001F1EC\U0001F1F9"), category},
        {QStringLiteral(":flag_Guam:"), QString::fromUtf16(u"\U0001F1EC\U0001F1FA"), category},
        {QStringLiteral(":flag_Guinea-Bissau:"), QString::fromUtf16(u"\U0001F1EC\U0001F1FC"), category},
        {QStringLiteral(":flag_Guyana:"), QString::fromUtf16(u"\U0001F1EC\U0001F1FE"), category},
        {QStringLiteral(":flag_Hong_Kong_SAR_China:"), QString::fromUtf16(u"\U0001F1ED\U0001F1F0"), category},
        {QStringLiteral(":flag_Heard_&_McDonald_Islands:"), QString::fromUtf16(u"\U0001F1ED\U0001F1F2"), category},
        {QStringLiteral(":flag_Honduras:"), QString::fromUtf16(u"\U0001F1ED\U0001F1F3"), category},
        {QStringLiteral(":flag_Croatia:"), QString::fromUtf16(u"\U0001F1ED\U0001F1F7"), category},
        {QStringLiteral(":flag_Haiti:"), QString::fromUtf16(u"\U0001F1ED\U0001F1F9"), category},
        {QStringLiteral(":flag_Hungary:"), QString::fromUtf16(u"\U0001F1ED\U0001F1FA"), category},
        {QStringLiteral(":flag_Canary_Islands:"), QString::fromUtf16(u"\U0001F1EE\U0001F1E8"), category},
        {QStringLiteral(":flag_Indonesia:"), QString::fromUtf16(u"\U0001F1EE\U0001F1E9"), category},
        {QStringLiteral(":flag_Ireland:"), QString::fromUtf16(u"\U0001F1EE\U0001F1EA"), category},
        {QStringLiteral(":flag_Israel:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F1"), category},
        {QStringLiteral(":flag_Isle_of_Man:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F2"), category},
        {QStringLiteral(":flag_India:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F3"), category},
        {QStringLiteral(":flag_British_Indian_Ocean_Territory:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F4"), category},
        {QStringLiteral(":flag_Iraq:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F6"), category},
        {QStringLiteral(":flag_Iran:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F7"), category},
        {QStringLiteral(":flag_Iceland:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F8"), category},
        {QStringLiteral(":flag_Italy:"), QString::fromUtf16(u"\U0001F1EE\U0001F1F9"), category},
        {QStringLiteral(":flag_Jersey:"), QString::fromUtf16(u"\U0001F1EF\U0001F1EA"), category},
        {QStringLiteral(":flag_Jamaica:"), QString::fromUtf16(u"\U0001F1EF\U0001F1F2"), category},
        {QStringLiteral(":flag_Jordan:"), QString::fromUtf16(u"\U0001F1EF\U0001F1F4"), category},
        {QStringLiteral(":flag_Japan:"), QString::fromUtf16(u"\U0001F1EF\U0001F1F5"), category},
        {QStringLiteral(":flag_Kenya:"), QString::fromUtf16(u"\U0001F1F0\U0001F1EA"), category},
        {QStringLiteral(":flag_Kyrgyzstan:"), QString::fromUtf16(u"\U0001F1F0\U0001F1EC"), category},
        {QStringLiteral(":flag_Cambodia:"), QString::fromUtf16(u"\U0001F1F0\U0001F1ED"), category},
        {QStringLiteral(":flag_Kiribati:"), QString::fromUtf16(u"\U0001F1F0\U0001F1EE"), category},
        {QStringLiteral(":flag_Comoros:"), QString::fromUtf16(u"\U0001F1F0\U0001F1F2"), category},
        {QStringLiteral(":flag_St._Kitts_&_Nevis:"), QString::fromUtf16(u"\U0001F1F0\U0001F1F3"), category},
        {QStringLiteral(":flag_North_Korea:"), QString::fromUtf16(u"\U0001F1F0\U0001F1F5"), category},
        {QStringLiteral(":flag_South_Korea:"), QString::fromUtf16(u"\U0001F1F0\U0001F1F7"), category},
        {QStringLiteral(":flag_Kuwait:"), QString::fromUtf16(u"\U0001F1F0\U0001F1FC"), category},
        {QStringLiteral(":flag_Cayman_Islands:"), QString::fromUtf16(u"\U0001F1F0\U0001F1FE"), category},
        {QStringLiteral(":flag_Kazakhstan:"), QString::fromUtf16(u"\U0001F1F0\U0001F1FF"), category},
        {QStringLiteral(":flag_Laos:"), QString::fromUtf16(u"\U0001F1F1\U0001F1E6"), category},
        {QStringLiteral(":flag_Lebanon:"), QString::fromUtf16(u"\U0001F1F1\U0001F1E7"), category},
        {QStringLiteral(":flag_St._Lucia:"), QString::fromUtf16(u"\U0001F1F1\U0001F1E8"), category},
        {QStringLiteral(":flag_Liechtenstein:"), QString::fromUtf16(u"\U0001F1F1\U0001F1EE"), category},
        {QStringLiteral(":flag_Sri_Lanka:"), QString::fromUtf16(u"\U0001F1F1\U0001F1F0"), category},
        {QStringLiteral(":flag_Liberia:"), QString::fromUtf16(u"\U0001F1F1\U0001F1F7"), category},
        {QStringLiteral(":flag_Lesotho:"), QString::fromUtf16(u"\U0001F1F1\U0001F1F8"), category},
        {QStringLiteral(":flag_Lithuania:"), QString::fromUtf16(u"\U0001F1F1\U0001F1F9"), category},
        {QStringLiteral(":flag_Luxembourg:"), QString::fromUtf16(u"\U0001F1F1\U0001F1FA"), category},
        {QStringLiteral(":flag_Latvia:"), QString::fromUtf16(u"\U0001F1F1\U0001F1FB"), category},
        {QStringLiteral(":flag_Libya:"), QString::fromUtf16(u"\U0001F1F1\U0001F1FE"), category},
        {QStringLiteral(":flag_Morocco:"), QString::fromUtf16(u"\U0001F1F2\U0001F1E6"), category},
        {QStringLiteral(":flag_Monaco:"), QString::fromUtf16(u"\U0001F1F2\U0001F1E8"), category},
        {QStringLiteral(":flag_Moldova:"), QString::fromUtf16(u"\U0001F1F2\U0001F1E9"), category},
        {QStringLiteral(":flag_Montenegro:"), QString::fromUtf16(u"\U0001F1F2\U0001F1EA"), category},
        {QStringLiteral(":flag_St._Martin:"), QString::fromUtf16(u"\U0001F1F2\U0001F1EB"), category},
        {QStringLiteral(":flag_Madagascar:"), QString::fromUtf16(u"\U0001F1F2\U0001F1EC"), category},
        {QStringLiteral(":flag_Marshall_Islands:"), QString::fromUtf16(u"\U0001F1F2\U0001F1ED"), category},
        {QStringLiteral(":flag_North_Macedonia:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F0"), category},
        {QStringLiteral(":flag_Mali:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F1"), category},
        {QStringLiteral(":flag_Myanmar_(Burma):"), QString::fromUtf16(u"\U0001F1F2\U0001F1F2"), category},
        {QStringLiteral(":flag_Mongolia:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F3"), category},
        {QStringLiteral(":flag_Macao_SAR_China:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F4"), category},
        {QStringLiteral(":flag_Northern_Mariana_Islands:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F5"), category},
        {QStringLiteral(":flag_Martinique:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F6"), category},
        {QStringLiteral(":flag_Mauritania:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F7"), category},
        {QStringLiteral(":flag_Montserrat:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F8"), category},
        {QStringLiteral(":flag_Malta:"), QString::fromUtf16(u"\U0001F1F2\U0001F1F9"), category},
        {QStringLiteral(":flag_Mauritius:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FA"), category},
        {QStringLiteral(":flag_Maldives:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FB"), category},
        {QStringLiteral(":flag_Malawi:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FC"), category},
        {QStringLiteral(":flag_Mexico:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FD"), category},
        {QStringLiteral(":flag_Malaysia:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FE"), category},
        {QStringLiteral(":flag_Mozambique:"), QString::fromUtf16(u"\U0001F1F2\U0001F1FF"), category},
        {QStringLiteral(":flag_Namibia:"), QString::fromUtf16(u"\U0001F1F3\U0001F1E6"), category},
        {QStringLiteral(":flag_New_Caledonia:"), QString::fromUtf16(u"\U0001F1F3\U0001F1E8"), category},
        {QStringLiteral(":flag_Niger:"), QString::fromUtf16(u"\U0001F1F3\U0001F1EA"), category},
        {QStringLiteral(":flag_Norfolk_Island:"), QString::fromUtf16(u"\U0001F1F3\U0001F1EB"), category},
        {QStringLiteral(":flag_Nigeria:"), QString::fromUtf16(u"\U0001F1F3\U0001F1EC"), category},
        {QStringLiteral(":flag_Nicaragua:"), QString::fromUtf16(u"\U0001F1F3\U0001F1EE"), category},
        {QStringLiteral(":flag_Netherlands:"), QString::fromUtf16(u"\U0001F1F3\U0001F1F1"), category},
        {QStringLiteral(":flag_Norway:"), QString::fromUtf16(u"\U0001F1F3\U0001F1F4"), category},
        {QStringLiteral(":flag_Nepal:"), QString::fromUtf16(u"\U0001F1F3\U0001F1F5"), category},
        {QStringLiteral(":flag_Nauru:"), QString::fromUtf16(u"\U0001F1F3\U0001F1F7"), category},
        {QStringLiteral(":flag_Niue:"), QString::fromUtf16(u"\U0001F1F3\U0001F1FA"), category},
        {QStringLiteral(":flag_New_Zealand:"), QString::fromUtf16(u"\U0001F1F3\U0001F1FF"), category},
        {QStringLiteral(":flag_Oman:"), QString::fromUtf16(u"\U0001F1F4\U0001F1F2"), category},
        {QStringLiteral(":flag_Panama:"), QString::fromUtf16(u"\U0001F1F5\U0001F1E6"), category},
        {QStringLiteral(":flag_Peru:"), QString::fromUtf16(u"\U0001F1F5\U0001F1EA"), category},
        {QStringLiteral(":flag_French_Polynesia:"), QString::fromUtf16(u"\U0001F1F5\U0001F1EB"), category},
        {QStringLiteral(":flag_Papua_New_Guinea:"), QString::fromUtf16(u"\U0001F1F5\U0001F1EC"), category},
        {QStringLiteral(":flag_Philippines:"), QString::fromUtf16(u"\U0001F1F5\U0001F1ED"), category},
        {QStringLiteral(":flag_Pakistan:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F0"), category},
        {QStringLiteral(":flag_Poland:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F1"), category},
        {QStringLiteral(":flag_St._Pierre_&_Miquelon:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F2"), category},
        {QStringLiteral(":flag_Pitcairn_Islands:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F3"), category},
        {QStringLiteral(":flag_Puerto_Rico:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F7"), category},
        {QStringLiteral(":flag_Palestinian_Territories:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F8"), category},
        {QStringLiteral(":flag_Portugal:"), QString::fromUtf16(u"\U0001F1F5\U0001F1F9"), category},
        {QStringLiteral(":flag_Palau:"), QString::fromUtf16(u"\U0001F1F5\U0001F1FC"), category},
        {QStringLiteral(":flag_Paraguay:"), QString::fromUtf16(u"\U0001F1F5\U0001F1FE"), category},
        {QStringLiteral(":flag_Qatar:"), QString::fromUtf16(u"\U0001F1F6\U0001F1E6"), category},
        {QStringLiteral(":flag_Réunion:"), QString::fromUtf16(u"\U0001F1F7\U0001F1EA"), category},
        {QStringLiteral(":flag_Romania:"), QString::fromUtf16(u"\U0001F1F7\U0001F1F4"), category},
        {QStringLiteral(":flag_Serbia:"), QString::fromUtf16(u"\U0001F1F7\U0001F1F8"), category},
        {QStringLiteral(":flag_Russia:"), QString::fromUtf16(u"\U0001F1F7\U0001F1FA"), category},
        {QStringLiteral(":flag_Rwanda:"), QString::fromUtf16(u"\U0001F1F7\U0001F1FC"), category},
        {QStringLiteral(":flag_Saudi_Arabia:"), QString::fromUtf16(u"\U0001F1F8\U0001F1E6"), category},
        {QStringLiteral(":flag_Solomon_Islands:"), QString::fromUtf16(u"\U0001F1F8\U0001F1E7"), category},
        {QStringLiteral(":flag_Seychelles:"), QString::fromUtf16(u"\U0001F1F8\U0001F1E8"), category},
        {QStringLiteral(":flag_Sudan:"), QString::fromUtf16(u"\U0001F1F8\U0001F1E9"), category},
        {QStringLiteral(":flag_Sweden:"), QString::fromUtf16(u"\U0001F1F8\U0001F1EA"), category},
        {QStringLiteral(":flag_Singapore:"), QString::fromUtf16(u"\U0001F1F8\U0001F1EC"), category},
        {QStringLiteral(":flag_St._Helena:"), QString::fromUtf16(u"\U0001F1F8\U0001F1ED"), category},
        {QStringLiteral(":flag_Slovenia:"), QString::fromUtf16(u"\U0001F1F8\U0001F1EE"), category},
        {QStringLiteral(":flag_Svalbard_&_Jan_Mayen:"), QString::fromUtf16(u"\U0001F1F8\U0001F1EF"), category},
        {QStringLiteral(":flag_Slovakia:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F0"), category},
        {QStringLiteral(":flag_Sierra_Leone:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F1"), category},
        {QStringLiteral(":flag_San_Marino:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F2"), category},
        {QStringLiteral(":flag_Senegal:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F3"), category},
        {QStringLiteral(":flag_Somalia:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F4"), category},
        {QStringLiteral(":flag_Suriname:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F7"), category},
        {QStringLiteral(":flag_South_Sudan:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F8"), category},
        {QStringLiteral(":flag_São_Tomé_&_Príncipe:"), QString::fromUtf16(u"\U0001F1F8\U0001F1F9"), category},
        {QStringLiteral(":flag_El_Salvador:"), QString::fromUtf16(u"\U0001F1F8\U0001F1FB"), category},
        {QStringLiteral(":flag_Sint_Maarten:"), QString::fromUtf16(u"\U0001F1F8\U0001F1FD"), category},
        {QStringLiteral(":flag_Syria:"), QString::fromUtf16(u"\U0001F1F8\U0001F1FE"), category},
        {QStringLiteral(":flag_Eswatini:"), QString::fromUtf16(u"\U0001F1F8\U0001F1FF"), category},
        {QStringLiteral(":flag_Tristan_da_Cunha:"), QString::fromUtf16(u"\U0001F1F9\U0001F1E6"), category},
        {QStringLiteral(":flag_Turks_&_Caicos_Islands:"), QString::fromUtf16(u"\U0001F1F9\U0001F1E8"), category},
        {QStringLiteral(":flag_Chad:"), QString::fromUtf16(u"\U0001F1F9\U0001F1E9"), category},
        {QStringLiteral(":flag_French_Southern_Territories:"), QString::fromUtf16(u"\U0001F1F9\U0001F1EB"), category},
        {QStringLiteral(":flag_Togo:"), QString::fromUtf16(u"\U0001F1F9\U0001F1EC"), category},
        {QStringLiteral(":flag_Thailand:"), QString::fromUtf16(u"\U0001F1F9\U0001F1ED"), category},
        {QStringLiteral(":flag_Tajikistan:"), QString::fromUtf16(u"\U0001F1F9\U0001F1EF"), category},
        {QStringLiteral(":flag_Tokelau:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F0"), category},
        {QStringLiteral(":flag_Timor-Leste:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F1"), category},
        {QStringLiteral(":flag_Turkmenistan:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F2"), category},
        {QStringLiteral(":flag_Tunisia:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F3"), category},
        {QStringLiteral(":flag_Tonga:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F4"), category},
        {QStringLiteral(":flag_Turkey:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F7"), category},
        {QStringLiteral(":flag_Trinidad_&_Tobago:"), QString::fromUtf16(u"\U0001F1F9\U0001F1F9"), category},
        {QStringLiteral(":flag_Tuvalu:"), QString::fromUtf16(u"\U0001F1F9\U0001F1FB"), category},
        {QStringLiteral(":flag_Taiwan:"), QString::fromUtf16(u"\U0001F1F9\U0001F1FC"), category},
        {QStringLiteral(":flag_Tanzania:"), QString::fromUtf16(u"\U0001F1F9\U0001F1FF"), category},
        {QStringLiteral(":flag_Ukraine:"), QString::fromUtf16(u"\U0001F1FA\U0001F1E6"), category},
        {QStringLiteral(":flag_Uganda:"), QString::fromUtf16(u"\U0001F1FA\U0001F1EC"), category},
        {QStringLiteral(":flag_U.S._Outlying_Islands:"), QString::fromUtf16(u"\U0001F1FA\U0001F1F2"), category},
        {QStringLiteral(":flag_United_Nations:"), QString::fromUtf16(u"\U0001F1FA\U0001F1F3"), category},
        {QStringLiteral(":flag_United_States:"), QString::fromUtf16(u"\U0001F1FA\U0001F1F8"), category},
        {QStringLiteral(":flag_Uruguay:"), QString::fromUtf16(u"\U0001F1FA\U0001F1FE"), category},
        {QStringLiteral(":flag_Uzbekistan:"), QString::fromUtf16(u"\U0001F1FA\U0001F1FF"), category},
        {QStringLiteral(":flag_Vatican_City:"), QString::fromUtf16(u"\U0001F1FB\U0001F1E6"), category},
        {QStringLiteral(":flag_St._Vincent_&_Grenadines:"), QString::fromUtf16(u"\U0001F1FB\U0001F1E8"), category},
        {QStringLiteral(":flag_Venezuela:"), QString::fromUtf16(u"\U0001F1FB\U0001F1EA"), category},
        {QStringLiteral(":flag_British_Virgin_Islands:"), QString::fromUtf16(u"\U0001F1FB\U0001F1EC"), category},
        {QStringLiteral(":flag_U.S._Virgin_Islands:"), QString::fromUtf16(u"\U0001F1FB\U0001F1EE"), category},
        {QStringLiteral(":flag_Vietnam:"), QString::fromUtf16(u"\U0001F1FB\U0001F1F3"), category},
        {QStringLiteral(":flag_Vanuatu:"), QString::fromUtf16(u"\U0001F1FB\U0001F1FA"), category},
        {QStringLiteral(":flag_Wallis_&_Futuna:"), QString::fromUtf16(u"\U0001F1FC\U0001F1EB"), category},
        {QStringLiteral(":flag_Samoa:"), QString::fromUtf16(u"\U0001F1FC\U0001F1F8"), category},
        {QStringLiteral(":flag_Kosovo:"), QString::fromUtf16(u"\U0001F1FD\U0001F1F0"), category},
        {QStringLiteral(":flag_Yemen:"), QString::fromUtf16(u"\U0001F1FE\U0001F1EA"), category},
        {QStringLiteral(":flag_Mayotte:"), QString::fromUtf16(u"\U0001F1FE\U0001F1F9"), category},
        {QStringLiteral(":flag_South_Africa:"), QString::fromUtf16(u"\U0001F1FF\U0001F1E6"), category},
        {QStringLiteral(":flag_Zambia:"), QString::fromUtf16(u"\U0001F1FF\U0001F1F2"), category},
        {QStringLiteral(":flag_Zimbabwe:"), QString::fromUtf16(u"\U0001F1FF\U0001F1FC"), category},
        {QStringLiteral(":flag_England:"), QString::fromUtf16(u"\U0001F3F4\U000E0067\U000E0062\U000E0065\U000E006E\U000E0067\U000E007F"), category},
        {QStringLiteral(":flag_Scotland:"), QString::fromUtf16(u"\U0001F3F4\U000E0067\U000E0062\U000E0073\U000E0063\U000E0074\U000E007F"), category},
        {QStringLiteral(":flag_Wales:"), QString::fromUtf16(u"\U0001F3F4\U000E0067\U000E0062\U000E0077\U000E006C\U000E0073\U000E007F"), category}};
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeFaceEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::FaceEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":grinning_face:"), QString::fromUtf16(u"\U0001F600"), category},
        {QStringLiteral(":grinning_face_with_big_eyes:"), QString::fromUtf16(u"\U0001F603"), category},
        {QStringLiteral(":grinning_face_with_smiling_eyes:"), QString::fromUtf16(u"\U0001F604"), category},
        {QStringLiteral(":beaming_face_with_smiling_eyes:"), QString::fromUtf16(u"\U0001F601"), category},
        {QStringLiteral(":grinning_squinting_face:"), QString::fromUtf16(u"\U0001F606"), category},
        {QStringLiteral(":grinning_face_with_sweat:"), QString::fromUtf16(u"\U0001F605"), category},
        {QStringLiteral(":rolling_on_the_floor_laughing:"), QString::fromUtf16(u"\U0001F923"), category},
        {QStringLiteral(":face_with_tears_of_joy:"), QString::fromUtf16(u"\U0001F602"), category},
        {QStringLiteral(":slightly_smiling_face:"), QString::fromUtf16(u"\U0001F642"), category},
        {QStringLiteral(":upside-down_face:"), QString::fromUtf16(u"\U0001F643"), category},
        {QStringLiteral(":winking_face:"), QString::fromUtf16(u"\U0001F609"), category},
        {QStringLiteral(":smiling_face_with_smiling_eyes:"), QString::fromUtf16(u"\U0001F60A"), category},
        {QStringLiteral(":smiling_face_with_halo:"), QString::fromUtf16(u"\U0001F607"), category},
        {QStringLiteral(":smiling_face_with_hearts:"), QString::fromUtf16(u"\U0001F970"), category},
        {QStringLiteral(":smiling_face_with_heart-eyes:"), QString::fromUtf16(u"\U0001F60D"), category},
        {QStringLiteral(":star-struck:"), QString::fromUtf16(u"\U0001F929"), category},
        {QStringLiteral(":face_blowing_a_kiss:"), QString::fromUtf16(u"\U0001F618"), category},
        {QStringLiteral(":kissing_face:"), QString::fromUtf16(u"\U0001F617"), category},
        {QStringLiteral(":smiling_face:"), QString::fromUtf16(u"\U0000263A"), category},
        {QStringLiteral(":kissing_face_with_closed_eyes:"), QString::fromUtf16(u"\U0001F61A"), category},
        {QStringLiteral(":kissing_face_with_smiling_eyes:"), QString::fromUtf16(u"\U0001F619"), category},
        {QStringLiteral(":face_savoring_food:"), QString::fromUtf16(u"\U0001F60B"), category},
        {QStringLiteral(":face_with_tongue:"), QString::fromUtf16(u"\U0001F61B"), category},
        {QStringLiteral(":winking_face_with_tongue:"), QString::fromUtf16(u"\U0001F61C"), category},
        {QStringLiteral(":zany_face:"), QString::fromUtf16(u"\U0001F92A"), category},
        {QStringLiteral(":squinting_face_with_tongue:"), QString::fromUtf16(u"\U0001F61D"), category},
        {QStringLiteral(":money-mouth_face:"), QString::fromUtf16(u"\U0001F911"), category},
        {QStringLiteral(":hugging_face:"), QString::fromUtf16(u"\U0001F917"), category},
        {QStringLiteral(":face_with_hand_over_mouth:"), QString::fromUtf16(u"\U0001F92D"), category},
        {QStringLiteral(":shushing_face:"), QString::fromUtf16(u"\U0001F92B"), category},
        {QStringLiteral(":thinking_face:"), QString::fromUtf16(u"\U0001F914"), category},
        {QStringLiteral(":zipper-mouth_face:"), QString::fromUtf16(u"\U0001F910"), category},
        {QStringLiteral(":face_with_raised_eyebrow:"), QString::fromUtf16(u"\U0001F928"), category},
        {QStringLiteral(":neutral_face:"), QString::fromUtf16(u"\U0001F610"), category},
        {QStringLiteral(":expressionless_face:"), QString::fromUtf16(u"\U0001F611"), category},
        {QStringLiteral(":face_without_mouth:"), QString::fromUtf16(u"\U0001F636"), category},
        {QStringLiteral(":smirking_face:"), QString::fromUtf16(u"\U0001F60F"), category},
        {QStringLiteral(":unamused_face:"), QString::fromUtf16(u"\U0001F612"), category},
        {QStringLiteral(":face_with_rolling_eyes:"), QString::fromUtf16(u"\U0001F644"), category},
        {QStringLiteral(":grimacing_face:"), QString::fromUtf16(u"\U0001F62C"), category},
        {QStringLiteral(":lying_face:"), QString::fromUtf16(u"\U0001F925"), category},
        {QStringLiteral(":relieved_face:"), QString::fromUtf16(u"\U0001F60C"), category},
        {QStringLiteral(":pensive_face:"), QString::fromUtf16(u"\U0001F614"), category},
        {QStringLiteral(":sleepy_face:"), QString::fromUtf16(u"\U0001F62A"), category},
        {QStringLiteral(":drooling_face:"), QString::fromUtf16(u"\U0001F924"), category},
        {QStringLiteral(":sleeping_face:"), QString::fromUtf16(u"\U0001F634"), category},
        {QStringLiteral(":face_with_medical_mask:"), QString::fromUtf16(u"\U0001F637"), category},
        {QStringLiteral(":face_with_thermometer:"), QString::fromUtf16(u"\U0001F912"), category},
        {QStringLiteral(":face_with_head-bandage:"), QString::fromUtf16(u"\U0001F915"), category},
        {QStringLiteral(":nauseated_face:"), QString::fromUtf16(u"\U0001F922"), category},
        {QStringLiteral(":face_vomiting:"), QString::fromUtf16(u"\U0001F92E"), category},
        {QStringLiteral(":sneezing_face:"), QString::fromUtf16(u"\U0001F927"), category},
        {QStringLiteral(":hot_face:"), QString::fromUtf16(u"\U0001F975"), category},
        {QStringLiteral(":cold_face:"), QString::fromUtf16(u"\U0001F976"), category},
        {QStringLiteral(":woozy_face:"), QString::fromUtf16(u"\U0001F974"), category},
        {QStringLiteral(":dizzy_face:"), QString::fromUtf16(u"\U0001F635"), category},
        {QStringLiteral(":exploding_head:"), QString::fromUtf16(u"\U0001F92F"), category},
        {QStringLiteral(":cowboy_hat_face:"), QString::fromUtf16(u"\U0001F920"), category},
        {QStringLiteral(":partying_face:"), QString::fromUtf16(u"\U0001F973"), category},
        {QStringLiteral(":smiling_face_with_sunglasses:"), QString::fromUtf16(u"\U0001F60E"), category},
        {QStringLiteral(":nerd_face:"), QString::fromUtf16(u"\U0001F913"), category},
        {QStringLiteral(":face_with_monocle:"), QString::fromUtf16(u"\U0001F9D0"), category},
        {QStringLiteral(":confused_face:"), QString::fromUtf16(u"\U0001F615"), category},
        {QStringLiteral(":worried_face:"), QString::fromUtf16(u"\U0001F61F"), category},
        {QStringLiteral(":slightly_frowning_face:"), QString::fromUtf16(u"\U0001F641"), category},
        {QStringLiteral(":frowning_face:"), QString::fromUtf16(u"\U00002639"), category},
        {QStringLiteral(":face_with_open_mouth:"), QString::fromUtf16(u"\U0001F62E"), category},
        {QStringLiteral(":hushed_face:"), QString::fromUtf16(u"\U0001F62F"), category},
        {QStringLiteral(":astonished_face:"), QString::fromUtf16(u"\U0001F632"), category},
        {QStringLiteral(":flushed_face:"), QString::fromUtf16(u"\U0001F633"), category},
        {QStringLiteral(":pleading_face:"), QString::fromUtf16(u"\U0001F97A"), category},
        {QStringLiteral(":frowning_face_with_open_mouth:"), QString::fromUtf16(u"\U0001F626"), category},
        {QStringLiteral(":anguished_face:"), QString::fromUtf16(u"\U0001F627"), category},
        {QStringLiteral(":fearful_face:"), QString::fromUtf16(u"\U0001F628"), category},
        {QStringLiteral(":anxious_face_with_sweat:"), QString::fromUtf16(u"\U0001F630"), category},
        {QStringLiteral(":sad_but_relieved_face:"), QString::fromUtf16(u"\U0001F625"), category},
        {QStringLiteral(":crying_face:"), QString::fromUtf16(u"\U0001F622"), category},
        {QStringLiteral(":loudly_crying_face:"), QString::fromUtf16(u"\U0001F62D"), category},
        {QStringLiteral(":face_screaming_in_fear:"), QString::fromUtf16(u"\U0001F631"), category},
        {QStringLiteral(":confounded_face:"), QString::fromUtf16(u"\U0001F616"), category},
        {QStringLiteral(":persevering_face:"), QString::fromUtf16(u"\U0001F623"), category},
        {QStringLiteral(":disappointed_face:"), QString::fromUtf16(u"\U0001F61E"), category},
        {QStringLiteral(":downcast_face_with_sweat:"), QString::fromUtf16(u"\U0001F613"), category},
        {QStringLiteral(":weary_face:"), QString::fromUtf16(u"\U0001F629"), category},
        {QStringLiteral(":tired_face:"), QString::fromUtf16(u"\U0001F62B"), category},
        {QStringLiteral(":yawning_face:"), QString::fromUtf16(u"\U0001F971"), category},
        {QStringLiteral(":face_with_steam_from_nose:"), QString::fromUtf16(u"\U0001F624"), category},
        {QStringLiteral(":pouting_face:"), QString::fromUtf16(u"\U0001F621"), category},
        {QStringLiteral(":angry_face:"), QString::fromUtf16(u"\U0001F620"), category},
        {QStringLiteral(":face_with_symbols_on_mouth:"), QString::fromUtf16(u"\U0001F92C"), category},
        {QStringLiteral(":smiling_face_with_horns:"), QString::fromUtf16(u"\U0001F608"), category},
        {QStringLiteral(":angry_face_with_horns:"), QString::fromUtf16(u"\U0001F47F"), category},
        {QStringLiteral(":skull:"), QString::fromUtf16(u"\U0001F480"), category},
        {QStringLiteral(":skull_and_crossbones:"), QString::fromUtf16(u"\U00002620"), category},
        {QStringLiteral(":pile_of_poo:"), QString::fromUtf16(u"\U0001F4A9"), category},
        {QStringLiteral(":clown_face:"), QString::fromUtf16(u"\U0001F921"), category},
        {QStringLiteral(":ogre:"), QString::fromUtf16(u"\U0001F479"), category},
        {QStringLiteral(":goblin:"), QString::fromUtf16(u"\U0001F47A"), category},
        {QStringLiteral(":ghost:"), QString::fromUtf16(u"\U0001F47B"), category},
        {QStringLiteral(":alien:"), QString::fromUtf16(u"\U0001F47D"), category},
        {QStringLiteral(":alien_monster:"), QString::fromUtf16(u"\U0001F47E"), category},
        {QStringLiteral(":robot:"), QString::fromUtf16(u"\U0001F916"), category},
        {QStringLiteral(":grinning_cat:"), QString::fromUtf16(u"\U0001F63A"), category},
        {QStringLiteral(":grinning_cat_with_smiling_eyes:"), QString::fromUtf16(u"\U0001F638"), category},
        {QStringLiteral(":cat_with_tears_of_joy:"), QString::fromUtf16(u"\U0001F639"), category},
        {QStringLiteral(":smiling_cat_with_heart-eyes:"), QString::fromUtf16(u"\U0001F63B"), category},
        {QStringLiteral(":cat_with_wry_smile:"), QString::fromUtf16(u"\U0001F63C"), category},
        {QStringLiteral(":kissing_cat:"), QString::fromUtf16(u"\U0001F63D"), category},
        {QStringLiteral(":weary_cat:"), QString::fromUtf16(u"\U0001F640"), category},
        {QStringLiteral(":crying_cat:"), QString::fromUtf16(u"\U0001F63F"), category},
        {QStringLiteral(":pouting_cat:"), QString::fromUtf16(u"\U0001F63E"), category},
        {QStringLiteral(":see-no-evil_monkey:"), QString::fromUtf16(u"\U0001F648"), category},
        {QStringLiteral(":hear-no-evil_monkey:"), QString::fromUtf16(u"\U0001F649"), category},
        {QStringLiteral(":speak-no-evil_monkey:"), QString::fromUtf16(u"\U0001F64A"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeAnimalsEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::AnimalsEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{{QStringLiteral(":monkey_face:"), QString::fromUtf16(u"\U0001F435"), category},
                                                            {QStringLiteral(":monkey:"), QString::fromUtf16(u"\U0001F412"), category},
                                                            {QStringLiteral(":gorilla:"), QString::fromUtf16(u"\U0001F98D"), category},
                                                            {QStringLiteral(":orangutan:"), QString::fromUtf16(u"\U0001F9A7"), category},
                                                            {QStringLiteral(":dog_face:"), QString::fromUtf16(u"\U0001F436"), category},
                                                            {QStringLiteral(":dog:"), QString::fromUtf16(u"\U0001F415"), category},
                                                            {QStringLiteral(":guide_dog:"), QString::fromUtf16(u"\U0001F9AE"), category},
                                                            {QStringLiteral(":service_dog:"), QString::fromUtf16(u"\U0001F415\U0000200D\U0001F9BA"), category},
                                                            {QStringLiteral(":poodle:"), QString::fromUtf16(u"\U0001F429"), category},
                                                            {QStringLiteral(":wolf:"), QString::fromUtf16(u"\U0001F43A"), category},
                                                            {QStringLiteral(":fox:"), QString::fromUtf16(u"\U0001F98A"), category},
                                                            {QStringLiteral(":raccoon:"), QString::fromUtf16(u"\U0001F99D"), category},
                                                            {QStringLiteral(":cat_face:"), QString::fromUtf16(u"\U0001F431"), category},
                                                            {QStringLiteral(":cat:"), QString::fromUtf16(u"\U0001F408"), category},
                                                            {QStringLiteral(":lion:"), QString::fromUtf16(u"\U0001F981"), category},
                                                            {QStringLiteral(":tiger_face:"), QString::fromUtf16(u"\U0001F42F"), category},
                                                            {QStringLiteral(":tiger:"), QString::fromUtf16(u"\U0001F405"), category},
                                                            {QStringLiteral(":leopard:"), QString::fromUtf16(u"\U0001F406"), category},
                                                            {QStringLiteral(":horse_face:"), QString::fromUtf16(u"\U0001F434"), category},
                                                            {QStringLiteral(":horse:"), QString::fromUtf16(u"\U0001F40E"), category},
                                                            {QStringLiteral(":unicorn:"), QString::fromUtf16(u"\U0001F984"), category},
                                                            {QStringLiteral(":zebra:"), QString::fromUtf16(u"\U0001F993"), category},
                                                            {QStringLiteral(":deer:"), QString::fromUtf16(u"\U0001F98C"), category},
                                                            {QStringLiteral(":cow_face:"), QString::fromUtf16(u"\U0001F42E"), category},
                                                            {QStringLiteral(":ox:"), QString::fromUtf16(u"\U0001F402"), category},
                                                            {QStringLiteral(":water_buffalo:"), QString::fromUtf16(u"\U0001F403"), category},
                                                            {QStringLiteral(":cow:"), QString::fromUtf16(u"\U0001F404"), category},
                                                            {QStringLiteral(":pig_face:"), QString::fromUtf16(u"\U0001F437"), category},
                                                            {QStringLiteral(":pig:"), QString::fromUtf16(u"\U0001F416"), category},
                                                            {QStringLiteral(":boar:"), QString::fromUtf16(u"\U0001F417"), category},
                                                            {QStringLiteral(":pig_nose:"), QString::fromUtf16(u"\U0001F43D"), category},
                                                            {QStringLiteral(":ram:"), QString::fromUtf16(u"\U0001F40F"), category},
                                                            {QStringLiteral(":ewe:"), QString::fromUtf16(u"\U0001F411"), category},
                                                            {QStringLiteral(":goat:"), QString::fromUtf16(u"\U0001F410"), category},
                                                            {QStringLiteral(":camel:"), QString::fromUtf16(u"\U0001F42A"), category},
                                                            {QStringLiteral(":two-hump_camel:"), QString::fromUtf16(u"\U0001F42B"), category},
                                                            {QStringLiteral(":llama:"), QString::fromUtf16(u"\U0001F999"), category},
                                                            {QStringLiteral(":giraffe:"), QString::fromUtf16(u"\U0001F992"), category},
                                                            {QStringLiteral(":elephant:"), QString::fromUtf16(u"\U0001F418"), category},
                                                            {QStringLiteral(":rhinoceros:"), QString::fromUtf16(u"\U0001F98F"), category},
                                                            {QStringLiteral(":hippopotamus:"), QString::fromUtf16(u"\U0001F99B"), category},
                                                            {QStringLiteral(":mouse_face:"), QString::fromUtf16(u"\U0001F42D"), category},
                                                            {QStringLiteral(":mouse:"), QString::fromUtf16(u"\U0001F401"), category},
                                                            {QStringLiteral(":rat:"), QString::fromUtf16(u"\U0001F400"), category},
                                                            {QStringLiteral(":hamster:"), QString::fromUtf16(u"\U0001F439"), category},
                                                            {QStringLiteral(":rabbit_face:"), QString::fromUtf16(u"\U0001F430"), category},
                                                            {QStringLiteral(":rabbit:"), QString::fromUtf16(u"\U0001F407"), category},
                                                            {QStringLiteral(":chipmunk:"), QString::fromUtf16(u"\U0001F43F"), category},
                                                            {QStringLiteral(":hedgehog:"), QString::fromUtf16(u"\U0001F994"), category},
                                                            {QStringLiteral(":bat:"), QString::fromUtf16(u"\U0001F987"), category},
                                                            {QStringLiteral(":bear:"), QString::fromUtf16(u"\U0001F43B"), category},
                                                            {QStringLiteral(":koala:"), QString::fromUtf16(u"\U0001F428"), category},
                                                            {QStringLiteral(":panda:"), QString::fromUtf16(u"\U0001F43C"), category},
                                                            {QStringLiteral(":sloth:"), QString::fromUtf16(u"\U0001F9A5"), category},
                                                            {QStringLiteral(":otter:"), QString::fromUtf16(u"\U0001F9A6"), category},
                                                            {QStringLiteral(":skunk:"), QString::fromUtf16(u"\U0001F9A8"), category},
                                                            {QStringLiteral(":kangaroo:"), QString::fromUtf16(u"\U0001F998"), category},
                                                            {QStringLiteral(":badger:"), QString::fromUtf16(u"\U0001F9A1"), category},
                                                            {QStringLiteral(":paw_prints:"), QString::fromUtf16(u"\U0001F43E"), category},
                                                            {QStringLiteral(":turkey:"), QString::fromUtf16(u"\U0001F983"), category},
                                                            {QStringLiteral(":chicken:"), QString::fromUtf16(u"\U0001F414"), category},
                                                            {QStringLiteral(":rooster:"), QString::fromUtf16(u"\U0001F413"), category},
                                                            {QStringLiteral(":hatching_chick:"), QString::fromUtf16(u"\U0001F423"), category},
                                                            {QStringLiteral(":baby_chick:"), QString::fromUtf16(u"\U0001F424"), category},
                                                            {QStringLiteral(":front-facing_baby_chick:"), QString::fromUtf16(u"\U0001F425"), category},
                                                            {QStringLiteral(":bird:"), QString::fromUtf16(u"\U0001F426"), category},
                                                            {QStringLiteral(":penguin:"), QString::fromUtf16(u"\U0001F427"), category},
                                                            {QStringLiteral(":dove:"), QString::fromUtf16(u"\U0001F54A"), category},
                                                            {QStringLiteral(":eagle:"), QString::fromUtf16(u"\U0001F985"), category},
                                                            {QStringLiteral(":duck:"), QString::fromUtf16(u"\U0001F986"), category},
                                                            {QStringLiteral(":swan:"), QString::fromUtf16(u"\U0001F9A2"), category},
                                                            {QStringLiteral(":owl:"), QString::fromUtf16(u"\U0001F989"), category},
                                                            {QStringLiteral(":flamingo:"), QString::fromUtf16(u"\U0001F9A9"), category},
                                                            {QStringLiteral(":peacock:"), QString::fromUtf16(u"\U0001F99A"), category},
                                                            {QStringLiteral(":parrot:"), QString::fromUtf16(u"\U0001F99C"), category},
                                                            {QStringLiteral(":frog:"), QString::fromUtf16(u"\U0001F438"), category},
                                                            {QStringLiteral(":crocodile:"), QString::fromUtf16(u"\U0001F40A"), category},
                                                            {QStringLiteral(":turtle:"), QString::fromUtf16(u"\U0001F422"), category},
                                                            {QStringLiteral(":lizard:"), QString::fromUtf16(u"\U0001F98E"), category},
                                                            {QStringLiteral(":snake:"), QString::fromUtf16(u"\U0001F40D"), category},
                                                            {QStringLiteral(":dragon_face:"), QString::fromUtf16(u"\U0001F432"), category},
                                                            {QStringLiteral(":dragon:"), QString::fromUtf16(u"\U0001F409"), category},
                                                            {QStringLiteral(":sauropod:"), QString::fromUtf16(u"\U0001F995"), category},
                                                            {QStringLiteral(":T-Rex:"), QString::fromUtf16(u"\U0001F996"), category},
                                                            {QStringLiteral(":spouting_whale:"), QString::fromUtf16(u"\U0001F433"), category},
                                                            {QStringLiteral(":whale:"), QString::fromUtf16(u"\U0001F40B"), category},
                                                            {QStringLiteral(":dolphin:"), QString::fromUtf16(u"\U0001F42C"), category},
                                                            {QStringLiteral(":fish:"), QString::fromUtf16(u"\U0001F41F"), category},
                                                            {QStringLiteral(":tropical_fish:"), QString::fromUtf16(u"\U0001F420"), category},
                                                            {QStringLiteral(":blowfish:"), QString::fromUtf16(u"\U0001F421"), category},
                                                            {QStringLiteral(":shark:"), QString::fromUtf16(u"\U0001F988"), category},
                                                            {QStringLiteral(":octopus:"), QString::fromUtf16(u"\U0001F419"), category},
                                                            {QStringLiteral(":spiral_shell:"), QString::fromUtf16(u"\U0001F41A"), category},
                                                            {QStringLiteral(":snail:"), QString::fromUtf16(u"\U0001F40C"), category},
                                                            {QStringLiteral(":butterfly:"), QString::fromUtf16(u"\U0001F98B"), category},
                                                            {QStringLiteral(":bug:"), QString::fromUtf16(u"\U0001F41B"), category},
                                                            {QStringLiteral(":ant:"), QString::fromUtf16(u"\U0001F41C"), category},
                                                            {QStringLiteral(":honeybee:"), QString::fromUtf16(u"\U0001F41D"), category},
                                                            {QStringLiteral(":lady_beetle:"), QString::fromUtf16(u"\U0001F41E"), category},
                                                            {QStringLiteral(":cricket:"), QString::fromUtf16(u"\U0001F997"), category},
                                                            {QStringLiteral(":spider:"), QString::fromUtf16(u"\U0001F577"), category},
                                                            {QStringLiteral(":spider_web:"), QString::fromUtf16(u"\U0001F578"), category},
                                                            {QStringLiteral(":scorpion:"), QString::fromUtf16(u"\U0001F982"), category},
                                                            {QStringLiteral(":mosquito:"), QString::fromUtf16(u"\U0001F99F"), category},
                                                            {QStringLiteral(":microbe:"), QString::fromUtf16(u"\U0001F9A0"), category}};
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodePlantEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::PlantEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":bouquet:"), QString::fromUtf16(u"\U0001F490"), category},
        {QStringLiteral(":cherry_blossom:"), QString::fromUtf16(u"\U0001F338"), category},
        {QStringLiteral(":white_flower:"), QString::fromUtf16(u"\U0001F4AE"), category},
        {QStringLiteral(":rosette:"), QString::fromUtf16(u"\U0001F3F5"), category},
        {QStringLiteral(":rose:"), QString::fromUtf16(u"\U0001F339"), category},
        {QStringLiteral(":wilted_flower:"), QString::fromUtf16(u"\U0001F940"), category},
        {QStringLiteral(":hibiscus:"), QString::fromUtf16(u"\U0001F33A"), category},
        {QStringLiteral(":sunflower:"), QString::fromUtf16(u"\U0001F33B"), category},
        {QStringLiteral(":blossom:"), QString::fromUtf16(u"\U0001F33C"), category},
        {QStringLiteral(":tulip:"), QString::fromUtf16(u"\U0001F337"), category},
        {QStringLiteral(":seedling:"), QString::fromUtf16(u"\U0001F331"), category},
        {QStringLiteral(":evergreen_tree:"), QString::fromUtf16(u"\U0001F332"), category},
        {QStringLiteral(":deciduous_tree:"), QString::fromUtf16(u"\U0001F333"), category},
        {QStringLiteral(":palm_tree:"), QString::fromUtf16(u"\U0001F334"), category},
        {QStringLiteral(":cactus:"), QString::fromUtf16(u"\U0001F335"), category},
        {QStringLiteral(":sheaf_of_rice:"), QString::fromUtf16(u"\U0001F33E"), category},
        {QStringLiteral(":herb:"), QString::fromUtf16(u"\U0001F33F"), category},
        {QStringLiteral(":shamrock:"), QString::fromUtf16(u"\U00002618"), category},
        {QStringLiteral(":four_leaf_clover:"), QString::fromUtf16(u"\U0001F340"), category},
        {QStringLiteral(":maple_leaf:"), QString::fromUtf16(u"\U0001F341"), category},
        {QStringLiteral(":fallen_leaf:"), QString::fromUtf16(u"\U0001F342"), category},
        {QStringLiteral(":leaf_fluttering_in_wind:"), QString::fromUtf16(u"\U0001F343"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeScienceEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::ScienceEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":alembic:"), QString::fromUtf16(u"\U00002697"), category},
        {QStringLiteral(":test_tube:"), QString::fromUtf16(u"\U0001F9EA"), category},
        {QStringLiteral(":petri_dish:"), QString::fromUtf16(u"\U0001F9EB"), category},
        {QStringLiteral(":dna:"), QString::fromUtf16(u"\U0001F9EC"), category},
        {QStringLiteral(":microscope:"), QString::fromUtf16(u"\U0001F52C"), category},
        {QStringLiteral(":telescope:"), QString::fromUtf16(u"\U0001F52D"), category},
        {QStringLiteral(":satellite_antenna:"), QString::fromUtf16(u"\U0001F4E1"), category},
        {QStringLiteral(":syringe:"), QString::fromUtf16(u"\U0001F489"), category},
        {QStringLiteral(":drop_of_blood:"), QString::fromUtf16(u"\U0001FA78"), category},
        {QStringLiteral(":pill:"), QString::fromUtf16(u"\U0001F48A"), category},
        {QStringLiteral(":adhesive_bandage:"), QString::fromUtf16(u"\U0001FA79"), category},
        {QStringLiteral(":stethoscope:"), QString::fromUtf16(u"\U0001FA7A"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeComputerEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::ComputerEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":battery:"), QString::fromUtf16(u"\U0001F50B"), category},
        {QStringLiteral(":electric_plug:"), QString::fromUtf16(u"\U0001F50C"), category},
        {QStringLiteral(":laptop_computer:"), QString::fromUtf16(u"\U0001F4BB"), category},
        {QStringLiteral(":desktop_computer:"), QString::fromUtf16(u"\U0001F5A5"), category},
        {QStringLiteral(":printer:"), QString::fromUtf16(u"\U0001F5A8"), category},
        {QStringLiteral(":keyboard:"), QString::fromUtf16(u"\U00002328"), category},
        {QStringLiteral(":computer_mouse:"), QString::fromUtf16(u"\U0001F5B1"), category},
        {QStringLiteral(":trackball:"), QString::fromUtf16(u"\U0001F5B2"), category},
        {QStringLiteral(":computer_disk:"), QString::fromUtf16(u"\U0001F4BD"), category},
        {QStringLiteral(":floppy_disk:"), QString::fromUtf16(u"\U0001F4BE"), category},
        {QStringLiteral(":optical_disk:"), QString::fromUtf16(u"\U0001F4BF"), category},
        {QStringLiteral(":dvd:"), QString::fromUtf16(u"\U0001F4C0"), category},
        {QStringLiteral(":abacus:"), QString::fromUtf16(u"\U0001F9EE"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeBookPaperEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::BookPaperEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":notebook_with_decorative_cover:"), QString::fromUtf16(u"\U0001F4D4"), category},
        {QStringLiteral(":closed_book:"), QString::fromUtf16(u"\U0001F4D5"), category},
        {QStringLiteral(":open_book:"), QString::fromUtf16(u"\U0001F4D6"), category},
        {QStringLiteral(":green_book:"), QString::fromUtf16(u"\U0001F4D7"), category},
        {QStringLiteral(":blue_book:"), QString::fromUtf16(u"\U0001F4D8"), category},
        {QStringLiteral(":orange_book:"), QString::fromUtf16(u"\U0001F4D9"), category},
        {QStringLiteral(":books:"), QString::fromUtf16(u"\U0001F4DA"), category},
        {QStringLiteral(":notebook:"), QString::fromUtf16(u"\U0001F4D3"), category},
        {QStringLiteral(":ledger:"), QString::fromUtf16(u"\U0001F4D2"), category},
        {QStringLiteral(":page_with_curl:"), QString::fromUtf16(u"\U0001F4C3"), category},
        {QStringLiteral(":scroll:"), QString::fromUtf16(u"\U0001F4DC"), category},
        {QStringLiteral(":page_facing_up:"), QString::fromUtf16(u"\U0001F4C4"), category},
        {QStringLiteral(":newspaper:"), QString::fromUtf16(u"\U0001F4F0"), category},
        {QStringLiteral(":rolled-up_newspaper:"), QString::fromUtf16(u"\U0001F5DE"), category},
        {QStringLiteral(":bookmark_tabs:"), QString::fromUtf16(u"\U0001F4D1"), category},
        {QStringLiteral(":bookmark:"), QString::fromUtf16(u"\U0001F516"), category},
        {QStringLiteral(":label:"), QString::fromUtf16(u"\U0001F3F7"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeSoundMusicEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::SoundMusicEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":muted_speaker:"), QString::fromUtf16(u"\U0001F507"), category},
        {QStringLiteral(":speaker_low_volume:"), QString::fromUtf16(u"\U0001F508"), category},
        {QStringLiteral(":speaker_medium_volume:"), QString::fromUtf16(u"\U0001F509"), category},
        {QStringLiteral(":speaker_high_volume:"), QString::fromUtf16(u"\U0001F50A"), category},
        {QStringLiteral(":loudspeaker:"), QString::fromUtf16(u"\U0001F4E2"), category},
        {QStringLiteral(":megaphone:"), QString::fromUtf16(u"\U0001F4E3"), category},
        {QStringLiteral(":postal_horn:"), QString::fromUtf16(u"\U0001F4EF"), category},
        {QStringLiteral(":bell:"), QString::fromUtf16(u"\U0001F514"), category},
        {QStringLiteral(":bell_with_slash:"), QString::fromUtf16(u"\U0001F515"), category},
        {QStringLiteral(":musical_score:"), QString::fromUtf16(u"\U0001F3BC"), category},
        {QStringLiteral(":musical_note:"), QString::fromUtf16(u"\U0001F3B5"), category},
        {QStringLiteral(":musical_notes:"), QString::fromUtf16(u"\U0001F3B6"), category},
        {QStringLiteral(":studio_microphone:"), QString::fromUtf16(u"\U0001F399"), category},
        {QStringLiteral(":level_slider:"), QString::fromUtf16(u"\U0001F39A"), category},
        {QStringLiteral(":control_knobs:"), QString::fromUtf16(u"\U0001F39B"), category},
        {QStringLiteral(":microphone:"), QString::fromUtf16(u"\U0001F3A4"), category},
        {QStringLiteral(":headphone:"), QString::fromUtf16(u"\U0001F3A7"), category},
        {QStringLiteral(":radio:"), QString::fromUtf16(u"\U0001F4FB"), category},
        {QStringLiteral(":saxophone:"), QString::fromUtf16(u"\U0001F3B7"), category},
        {QStringLiteral(":guitar:"), QString::fromUtf16(u"\U0001F3B8"), category},
        {QStringLiteral(":musical_keyboard:"), QString::fromUtf16(u"\U0001F3B9"), category},
        {QStringLiteral(":trumpet:"), QString::fromUtf16(u"\U0001F3BA"), category},
        {QStringLiteral(":violin:"), QString::fromUtf16(u"\U0001F3BB"), category},
        {QStringLiteral(":banjo:"), QString::fromUtf16(u"\U0001FA95"), category},
        {QStringLiteral(":drum:"), QString::fromUtf16(u"\U0001F941"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeWeatherEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::WeatherEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":new_moon:"), QString::fromUtf16(u"\U0001F311"), category},
        {QStringLiteral(":waxing_crescent_moon:"), QString::fromUtf16(u"\U0001F312"), category},
        {QStringLiteral(":first_quarter_moon:"), QString::fromUtf16(u"\U0001F313"), category},
        {QStringLiteral(":waxing_gibbous_moon:"), QString::fromUtf16(u"\U0001F314"), category},
        {QStringLiteral(":full_moon:"), QString::fromUtf16(u"\U0001F315"), category},
        {QStringLiteral(":waning_gibbous_moon:"), QString::fromUtf16(u"\U0001F316"), category},
        {QStringLiteral(":last_quarter_moon:"), QString::fromUtf16(u"\U0001F317"), category},
        {QStringLiteral(":waning_crescent_moon:"), QString::fromUtf16(u"\U0001F318"), category},
        {QStringLiteral(":crescent_moon:"), QString::fromUtf16(u"\U0001F319"), category},
        {QStringLiteral(":new_moon_face:"), QString::fromUtf16(u"\U0001F31A"), category},
        {QStringLiteral(":first_quarter_moon_face:"), QString::fromUtf16(u"\U0001F31B"), category},
        {QStringLiteral(":last_quarter_moon_face:"), QString::fromUtf16(u"\U0001F31C"), category},
        {QStringLiteral(":thermometer:"), QString::fromUtf16(u"\U0001F321"), category},
        {QStringLiteral(":sun:"), QString::fromUtf16(u"\U00002600"), category},
        {QStringLiteral(":full_moon_face:"), QString::fromUtf16(u"\U0001F31D"), category},
        {QStringLiteral(":sun_with_face:"), QString::fromUtf16(u"\U0001F31E"), category},
        {QStringLiteral(":ringed_planet:"), QString::fromUtf16(u"\U0001FA90"), category},
        {QStringLiteral(":star:"), QString::fromUtf16(u"\U00002B50"), category},
        {QStringLiteral(":glowing_star:"), QString::fromUtf16(u"\U0001F31F"), category},
        {QStringLiteral(":shooting_star:"), QString::fromUtf16(u"\U0001F320"), category},
        {QStringLiteral(":milky_way:"), QString::fromUtf16(u"\U0001F30C"), category},
        {QStringLiteral(":cloud:"), QString::fromUtf16(u"\U00002601"), category},
        {QStringLiteral(":sun_behind_cloud:"), QString::fromUtf16(u"\U000026C5"), category},
        {QStringLiteral(":cloud_with_lightning_and_rain:"), QString::fromUtf16(u"\U000026C8"), category},
        {QStringLiteral(":sun_behind_small_cloud:"), QString::fromUtf16(u"\U0001F324"), category},
        {QStringLiteral(":sun_behind_large_cloud:"), QString::fromUtf16(u"\U0001F325"), category},
        {QStringLiteral(":sun_behind_rain_cloud:"), QString::fromUtf16(u"\U0001F326"), category},
        {QStringLiteral(":cloud_with_rain:"), QString::fromUtf16(u"\U0001F327"), category},
        {QStringLiteral(":cloud_with_snow:"), QString::fromUtf16(u"\U0001F328"), category},
        {QStringLiteral(":cloud_with_lightning:"), QString::fromUtf16(u"\U0001F329"), category},
        {QStringLiteral(":tornado:"), QString::fromUtf16(u"\U0001F32A"), category},
        {QStringLiteral(":fog:"), QString::fromUtf16(u"\U0001F32B"), category},
        {QStringLiteral(":wind_face:"), QString::fromUtf16(u"\U0001F32C"), category},
        {QStringLiteral(":cyclone:"), QString::fromUtf16(u"\U0001F300"), category},
        {QStringLiteral(":rainbow:"), QString::fromUtf16(u"\U0001F308"), category},
        {QStringLiteral(":closed_umbrella:"), QString::fromUtf16(u"\U0001F302"), category},
        {QStringLiteral(":umbrella:"), QString::fromUtf16(u"\U00002602"), category},
        {QStringLiteral(":umbrella_with_rain_drops:"), QString::fromUtf16(u"\U00002614"), category},
        {QStringLiteral(":umbrella_on_ground:"), QString::fromUtf16(u"\U000026F1"), category},
        {QStringLiteral(":high_voltage:"), QString::fromUtf16(u"\U000026A1"), category},
        {QStringLiteral(":snowflake:"), QString::fromUtf16(u"\U00002744"), category},
        {QStringLiteral(":snowman:"), QString::fromUtf16(u"\U00002603"), category},
        {QStringLiteral(":snowman_without_snow:"), QString::fromUtf16(u"\U000026C4"), category},
        {QStringLiteral(":comet:"), QString::fromUtf16(u"\U00002604"), category},
        {QStringLiteral(":fire:"), QString::fromUtf16(u"\U0001F525"), category},
        {QStringLiteral(":droplet:"), QString::fromUtf16(u"\U0001F4A7"), category},
        {QStringLiteral(":water_wave:"), QString::fromUtf16(u"\U0001F30A"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeTimeEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::TimeEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":hourglass_done:"), QString::fromUtf16(u"\U0000231B"), category},
        {QStringLiteral(":hourglass_not_done:"), QString::fromUtf16(u"\U000023F3"), category},
        {QStringLiteral(":watch:"), QString::fromUtf16(u"\U0000231A"), category},
        {QStringLiteral(":alarm_clock:"), QString::fromUtf16(u"\U000023F0"), category},
        {QStringLiteral(":stopwatch:"), QString::fromUtf16(u"\U000023F1"), category},
        {QStringLiteral(":timer_clock:"), QString::fromUtf16(u"\U000023F2"), category},
        {QStringLiteral(":mantelpiece_clock:"), QString::fromUtf16(u"\U0001F570"), category},
        {QStringLiteral(":twelve_o’clock:"), QString::fromUtf16(u"\U0001F55B"), category},
        {QStringLiteral(":twelve-thirty:"), QString::fromUtf16(u"\U0001F567"), category},
        {QStringLiteral(":one_o’clock:"), QString::fromUtf16(u"\U0001F550"), category},
        {QStringLiteral(":one-thirty:"), QString::fromUtf16(u"\U0001F55C"), category},
        {QStringLiteral(":two_o’clock:"), QString::fromUtf16(u"\U0001F551"), category},
        {QStringLiteral(":two-thirty:"), QString::fromUtf16(u"\U0001F55D"), category},
        {QStringLiteral(":three_o’clock:"), QString::fromUtf16(u"\U0001F552"), category},
        {QStringLiteral(":three-thirty:"), QString::fromUtf16(u"\U0001F55E"), category},
        {QStringLiteral(":four_o’clock:"), QString::fromUtf16(u"\U0001F553"), category},
        {QStringLiteral(":four-thirty:"), QString::fromUtf16(u"\U0001F55F"), category},
        {QStringLiteral(":five_o’clock:"), QString::fromUtf16(u"\U0001F554"), category},
        {QStringLiteral(":five-thirty:"), QString::fromUtf16(u"\U0001F560"), category},
        {QStringLiteral(":six_o’clock:"), QString::fromUtf16(u"\U0001F555"), category},
        {QStringLiteral(":six-thirty:"), QString::fromUtf16(u"\U0001F561"), category},
        {QStringLiteral(":seven_o’clock:"), QString::fromUtf16(u"\U0001F556"), category},
        {QStringLiteral(":seven-thirty:"), QString::fromUtf16(u"\U0001F562"), category},
        {QStringLiteral(":eight_o’clock:"), QString::fromUtf16(u"\U0001F557"), category},
        {QStringLiteral(":eight-thirty:"), QString::fromUtf16(u"\U0001F563"), category},
        {QStringLiteral(":nine_o’clock:"), QString::fromUtf16(u"\U0001F558"), category},
        {QStringLiteral(":nine-thirty:"), QString::fromUtf16(u"\U0001F564"), category},
        {QStringLiteral(":ten_o’clock:"), QString::fromUtf16(u"\U0001F559"), category},
        {QStringLiteral(":ten-thirty:"), QString::fromUtf16(u"\U0001F565"), category},
        {QStringLiteral(":eleven_o’clock:"), QString::fromUtf16(u"\U0001F55A"), category},
        {QStringLiteral(":eleven-thirty:"), QString::fromUtf16(u"\U0001F566"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeGameEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::GameEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":direct_hit:"), QString::fromUtf16(u"\U0001F3AF"), category},
        {QStringLiteral(":yo-yo:"), QString::fromUtf16(u"\U0001FA80"), category},
        {QStringLiteral(":kite:"), QString::fromUtf16(u"\U0001FA81"), category},
        {QStringLiteral(":pool_8_ball:"), QString::fromUtf16(u"\U0001F3B1"), category},
        {QStringLiteral(":crystal_ball:"), QString::fromUtf16(u"\U0001F52E"), category},
        {QStringLiteral(":nazar_amulet:"), QString::fromUtf16(u"\U0001F9FF"), category},
        {QStringLiteral(":video_game:"), QString::fromUtf16(u"\U0001F3AE"), category},
        {QStringLiteral(":joystick:"), QString::fromUtf16(u"\U0001F579"), category},
        {QStringLiteral(":slot_machine:"), QString::fromUtf16(u"\U0001F3B0"), category},
        {QStringLiteral(":game_die:"), QString::fromUtf16(u"\U0001F3B2"), category},
        {QStringLiteral(":puzzle_piece:"), QString::fromUtf16(u"\U0001F9E9"), category},
        {QStringLiteral(":teddy_bear:"), QString::fromUtf16(u"\U0001F9F8"), category},
        {QStringLiteral(":spade_suit:"), QString::fromUtf16(u"\U00002660"), category},
        {QStringLiteral(":heart_suit:"), QString::fromUtf16(u"\U00002665"), category},
        {QStringLiteral(":diamond_suit:"), QString::fromUtf16(u"\U00002666"), category},
        {QStringLiteral(":club_suit:"), QString::fromUtf16(u"\U00002663"), category},
        {QStringLiteral(":chess_pawn:"), QString::fromUtf16(u"\U0000265F"), category},
        {QStringLiteral(":joker:"), QString::fromUtf16(u"\U0001F0CF"), category},
        {QStringLiteral(":mahjong_red_dragon:"), QString::fromUtf16(u"\U0001F004"), category},
        {QStringLiteral(":flower_playing_cards:"), QString::fromUtf16(u"\U0001F3B4"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeClothingEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::ClothingEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":glasses:"), QString::fromUtf16(u"\U0001F453"), category},
        {QStringLiteral(":sunglasses:"), QString::fromUtf16(u"\U0001F576"), category},
        {QStringLiteral(":goggles:"), QString::fromUtf16(u"\U0001F97D"), category},
        {QStringLiteral(":lab_coat:"), QString::fromUtf16(u"\U0001F97C"), category},
        {QStringLiteral(":safety_vest:"), QString::fromUtf16(u"\U0001F9BA"), category},
        {QStringLiteral(":necktie:"), QString::fromUtf16(u"\U0001F454"), category},
        {QStringLiteral(":t-shirt:"), QString::fromUtf16(u"\U0001F455"), category},
        {QStringLiteral(":jeans:"), QString::fromUtf16(u"\U0001F456"), category},
        {QStringLiteral(":scarf:"), QString::fromUtf16(u"\U0001F9E3"), category},
        {QStringLiteral(":gloves:"), QString::fromUtf16(u"\U0001F9E4"), category},
        {QStringLiteral(":coat:"), QString::fromUtf16(u"\U0001F9E5"), category},
        {QStringLiteral(":socks:"), QString::fromUtf16(u"\U0001F9E6"), category},
        {QStringLiteral(":dress:"), QString::fromUtf16(u"\U0001F457"), category},
        {QStringLiteral(":kimono:"), QString::fromUtf16(u"\U0001F458"), category},
        {QStringLiteral(":sari:"), QString::fromUtf16(u"\U0001F97B"), category},
        {QStringLiteral(":one-piece_swimsuit:"), QString::fromUtf16(u"\U0001FA71"), category},
        {QStringLiteral(":briefs:"), QString::fromUtf16(u"\U0001FA72"), category},
        {QStringLiteral(":shorts:"), QString::fromUtf16(u"\U0001FA73"), category},
        {QStringLiteral(":bikini:"), QString::fromUtf16(u"\U0001F459"), category},
        {QStringLiteral(":woman’s_clothes:"), QString::fromUtf16(u"\U0001F45A"), category},
        {QStringLiteral(":purse:"), QString::fromUtf16(u"\U0001F45B"), category},
        {QStringLiteral(":handbag:"), QString::fromUtf16(u"\U0001F45C"), category},
        {QStringLiteral(":clutch_bag:"), QString::fromUtf16(u"\U0001F45D"), category},
        {QStringLiteral(":shopping_bags:"), QString::fromUtf16(u"\U0001F6CD"), category},
        {QStringLiteral(":backpack:"), QString::fromUtf16(u"\U0001F392"), category},
        {QStringLiteral(":man’s_shoe:"), QString::fromUtf16(u"\U0001F45E"), category},
        {QStringLiteral(":running_shoe:"), QString::fromUtf16(u"\U0001F45F"), category},
        {QStringLiteral(":hiking_boot:"), QString::fromUtf16(u"\U0001F97E"), category},
        {QStringLiteral(":flat_shoe:"), QString::fromUtf16(u"\U0001F97F"), category},
        {QStringLiteral(":high-heeled_shoe:"), QString::fromUtf16(u"\U0001F460"), category},
        {QStringLiteral(":woman’s_sandal:"), QString::fromUtf16(u"\U0001F461"), category},
        {QStringLiteral(":ballet_shoes:"), QString::fromUtf16(u"\U0001FA70"), category},
        {QStringLiteral(":woman’s_boot:"), QString::fromUtf16(u"\U0001F462"), category},
        {QStringLiteral(":crown:"), QString::fromUtf16(u"\U0001F451"), category},
        {QStringLiteral(":woman’s_hat:"), QString::fromUtf16(u"\U0001F452"), category},
        {QStringLiteral(":top_hat:"), QString::fromUtf16(u"\U0001F3A9"), category},
        {QStringLiteral(":graduation_cap:"), QString::fromUtf16(u"\U0001F393"), category},
        {QStringLiteral(":billed_cap:"), QString::fromUtf16(u"\U0001F9E2"), category},
        {QStringLiteral(":rescue_worker’s_helmet:"), QString::fromUtf16(u"\U000026D1"), category},
        {QStringLiteral(":prayer_beads:"), QString::fromUtf16(u"\U0001F4FF"), category},
        {QStringLiteral(":lipstick:"), QString::fromUtf16(u"\U0001F484"), category},
        {QStringLiteral(":ring:"), QString::fromUtf16(u"\U0001F48D"), category},
        {QStringLiteral(":gem_stone:"), QString::fromUtf16(u"\U0001F48E"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeEventEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::EventEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":jack-o-lantern:"), QString::fromUtf16(u"\U0001F383"), category},
        {QStringLiteral(":Christmas_tree:"), QString::fromUtf16(u"\U0001F384"), category},
        {QStringLiteral(":fireworks:"), QString::fromUtf16(u"\U0001F386"), category},
        {QStringLiteral(":sparkler:"), QString::fromUtf16(u"\U0001F387"), category},
        {QStringLiteral(":firecracker:"), QString::fromUtf16(u"\U0001F9E8"), category},
        {QStringLiteral(":sparkles:"), QString::fromUtf16(u"\U00002728"), category},
        {QStringLiteral(":balloon:"), QString::fromUtf16(u"\U0001F388"), category},
        {QStringLiteral(":party_popper:"), QString::fromUtf16(u"\U0001F389"), category},
        {QStringLiteral(":confetti_ball:"), QString::fromUtf16(u"\U0001F38A"), category},
        {QStringLiteral(":tanabata_tree:"), QString::fromUtf16(u"\U0001F38B"), category},
        {QStringLiteral(":pine_decoration:"), QString::fromUtf16(u"\U0001F38D"), category},
        {QStringLiteral(":Japanese_dolls:"), QString::fromUtf16(u"\U0001F38E"), category},
        {QStringLiteral(":carp_streamer:"), QString::fromUtf16(u"\U0001F38F"), category},
        {QStringLiteral(":wind_chime:"), QString::fromUtf16(u"\U0001F390"), category},
        {QStringLiteral(":moon_viewing_ceremony:"), QString::fromUtf16(u"\U0001F391"), category},
        {QStringLiteral(":red_envelope:"), QString::fromUtf16(u"\U0001F9E7"), category},
        {QStringLiteral(":ribbon:"), QString::fromUtf16(u"\U0001F380"), category},
        {QStringLiteral(":wrapped_gift:"), QString::fromUtf16(u"\U0001F381"), category},
        {QStringLiteral(":reminder_ribbon:"), QString::fromUtf16(u"\U0001F397"), category},
        {QStringLiteral(":admission_tickets:"), QString::fromUtf16(u"\U0001F39F"), category},
        {QStringLiteral(":ticket:"), QString::fromUtf16(u"\U0001F3AB"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeFoodEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::FoodEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":grapes:"), QString::fromUtf16(u"\U0001F347"), category},
        {QStringLiteral(":melon:"), QString::fromUtf16(u"\U0001F348"), category},
        {QStringLiteral(":watermelon:"), QString::fromUtf16(u"\U0001F349"), category},
        {QStringLiteral(":tangerine:"), QString::fromUtf16(u"\U0001F34A"), category},
        {QStringLiteral(":lemon:"), QString::fromUtf16(u"\U0001F34B"), category},
        {QStringLiteral(":banana:"), QString::fromUtf16(u"\U0001F34C"), category},
        {QStringLiteral(":pineapple:"), QString::fromUtf16(u"\U0001F34D"), category},
        {QStringLiteral(":mango:"), QString::fromUtf16(u"\U0001F96D"), category},
        {QStringLiteral(":red_apple:"), QString::fromUtf16(u"\U0001F34E"), category},
        {QStringLiteral(":green_apple:"), QString::fromUtf16(u"\U0001F34F"), category},
        {QStringLiteral(":pear:"), QString::fromUtf16(u"\U0001F350"), category},
        {QStringLiteral(":peach:"), QString::fromUtf16(u"\U0001F351"), category},
        {QStringLiteral(":cherries:"), QString::fromUtf16(u"\U0001F352"), category},
        {QStringLiteral(":strawberry:"), QString::fromUtf16(u"\U0001F353"), category},
        {QStringLiteral(":kiwi_fruit:"), QString::fromUtf16(u"\U0001F95D"), category},
        {QStringLiteral(":tomato:"), QString::fromUtf16(u"\U0001F345"), category},
        {QStringLiteral(":coconut:"), QString::fromUtf16(u"\U0001F965"), category},
        {QStringLiteral(":avocado:"), QString::fromUtf16(u"\U0001F951"), category},
        {QStringLiteral(":eggplant:"), QString::fromUtf16(u"\U0001F346"), category},
        {QStringLiteral(":potato:"), QString::fromUtf16(u"\U0001F954"), category},
        {QStringLiteral(":carrot:"), QString::fromUtf16(u"\U0001F955"), category},
        {QStringLiteral(":ear_of_corn:"), QString::fromUtf16(u"\U0001F33D"), category},
        {QStringLiteral(":hot_pepper:"), QString::fromUtf16(u"\U0001F336"), category},
        {QStringLiteral(":cucumber:"), QString::fromUtf16(u"\U0001F952"), category},
        {QStringLiteral(":leafy_green:"), QString::fromUtf16(u"\U0001F96C"), category},
        {QStringLiteral(":broccoli:"), QString::fromUtf16(u"\U0001F966"), category},
        {QStringLiteral(":garlic:"), QString::fromUtf16(u"\U0001F9C4"), category},
        {QStringLiteral(":onion:"), QString::fromUtf16(u"\U0001F9C5"), category},
        {QStringLiteral(":mushroom:"), QString::fromUtf16(u"\U0001F344"), category},
        {QStringLiteral(":peanuts:"), QString::fromUtf16(u"\U0001F95C"), category},
        {QStringLiteral(":chestnut:"), QString::fromUtf16(u"\U0001F330"), category},
        {QStringLiteral(":bread:"), QString::fromUtf16(u"\U0001F35E"), category},
        {QStringLiteral(":croissant:"), QString::fromUtf16(u"\U0001F950"), category},
        {QStringLiteral(":baguette_bread:"), QString::fromUtf16(u"\U0001F956"), category},
        {QStringLiteral(":pretzel:"), QString::fromUtf16(u"\U0001F968"), category},
        {QStringLiteral(":bagel:"), QString::fromUtf16(u"\U0001F96F"), category},
        {QStringLiteral(":pancakes:"), QString::fromUtf16(u"\U0001F95E"), category},
        {QStringLiteral(":waffle:"), QString::fromUtf16(u"\U0001F9C7"), category},
        {QStringLiteral(":cheese_wedge:"), QString::fromUtf16(u"\U0001F9C0"), category},
        {QStringLiteral(":meat_on_bone:"), QString::fromUtf16(u"\U0001F356"), category},
        {QStringLiteral(":poultry_leg:"), QString::fromUtf16(u"\U0001F357"), category},
        {QStringLiteral(":cut_of_meat:"), QString::fromUtf16(u"\U0001F969"), category},
        {QStringLiteral(":bacon:"), QString::fromUtf16(u"\U0001F953"), category},
        {QStringLiteral(":hamburger:"), QString::fromUtf16(u"\U0001F354"), category},
        {QStringLiteral(":french_fries:"), QString::fromUtf16(u"\U0001F35F"), category},
        {QStringLiteral(":pizza:"), QString::fromUtf16(u"\U0001F355"), category},
        {QStringLiteral(":hot_dog:"), QString::fromUtf16(u"\U0001F32D"), category},
        {QStringLiteral(":sandwich:"), QString::fromUtf16(u"\U0001F96A"), category},
        {QStringLiteral(":taco:"), QString::fromUtf16(u"\U0001F32E"), category},
        {QStringLiteral(":burrito:"), QString::fromUtf16(u"\U0001F32F"), category},
        {QStringLiteral(":stuffed_flatbread:"), QString::fromUtf16(u"\U0001F959"), category},
        {QStringLiteral(":falafel:"), QString::fromUtf16(u"\U0001F9C6"), category},
        {QStringLiteral(":egg:"), QString::fromUtf16(u"\U0001F95A"), category},
        {QStringLiteral(":cooking:"), QString::fromUtf16(u"\U0001F373"), category},
        {QStringLiteral(":shallow_pan_of_food:"), QString::fromUtf16(u"\U0001F958"), category},
        {QStringLiteral(":pot_of_food:"), QString::fromUtf16(u"\U0001F372"), category},
        {QStringLiteral(":bowl_with_spoon:"), QString::fromUtf16(u"\U0001F963"), category},
        {QStringLiteral(":green_salad:"), QString::fromUtf16(u"\U0001F957"), category},
        {QStringLiteral(":popcorn:"), QString::fromUtf16(u"\U0001F37F"), category},
        {QStringLiteral(":butter:"), QString::fromUtf16(u"\U0001F9C8"), category},
        {QStringLiteral(":salt:"), QString::fromUtf16(u"\U0001F9C2"), category},
        {QStringLiteral(":canned_food:"), QString::fromUtf16(u"\U0001F96B"), category},
        {QStringLiteral(":bento_box:"), QString::fromUtf16(u"\U0001F371"), category},
        {QStringLiteral(":rice_cracker:"), QString::fromUtf16(u"\U0001F358"), category},
        {QStringLiteral(":rice_ball:"), QString::fromUtf16(u"\U0001F359"), category},
        {QStringLiteral(":cooked_rice:"), QString::fromUtf16(u"\U0001F35A"), category},
        {QStringLiteral(":curry_rice:"), QString::fromUtf16(u"\U0001F35B"), category},
        {QStringLiteral(":steaming_bowl:"), QString::fromUtf16(u"\U0001F35C"), category},
        {QStringLiteral(":spaghetti:"), QString::fromUtf16(u"\U0001F35D"), category},
        {QStringLiteral(":roasted_sweet_potato:"), QString::fromUtf16(u"\U0001F360"), category},
        {QStringLiteral(":oden:"), QString::fromUtf16(u"\U0001F362"), category},
        {QStringLiteral(":sushi:"), QString::fromUtf16(u"\U0001F363"), category},
        {QStringLiteral(":fried_shrimp:"), QString::fromUtf16(u"\U0001F364"), category},
        {QStringLiteral(":fish_cake_with_swirl:"), QString::fromUtf16(u"\U0001F365"), category},
        {QStringLiteral(":moon_cake:"), QString::fromUtf16(u"\U0001F96E"), category},
        {QStringLiteral(":dango:"), QString::fromUtf16(u"\U0001F361"), category},
        {QStringLiteral(":dumpling:"), QString::fromUtf16(u"\U0001F95F"), category},
        {QStringLiteral(":fortune_cookie:"), QString::fromUtf16(u"\U0001F960"), category},
        {QStringLiteral(":takeout_box:"), QString::fromUtf16(u"\U0001F961"), category},
        {QStringLiteral(":crab:"), QString::fromUtf16(u"\U0001F980"), category},
        {QStringLiteral(":lobster:"), QString::fromUtf16(u"\U0001F99E"), category},
        {QStringLiteral(":shrimp:"), QString::fromUtf16(u"\U0001F990"), category},
        {QStringLiteral(":squid:"), QString::fromUtf16(u"\U0001F991"), category},
        {QStringLiteral(":oyster:"), QString::fromUtf16(u"\U0001F9AA"), category},
        {QStringLiteral(":soft_ice_cream:"), QString::fromUtf16(u"\U0001F366"), category},
        {QStringLiteral(":shaved_ice:"), QString::fromUtf16(u"\U0001F367"), category},
        {QStringLiteral(":ice_cream:"), QString::fromUtf16(u"\U0001F368"), category},
        {QStringLiteral(":doughnut:"), QString::fromUtf16(u"\U0001F369"), category},
        {QStringLiteral(":cookie:"), QString::fromUtf16(u"\U0001F36A"), category},
        {QStringLiteral(":birthday_cake:"), QString::fromUtf16(u"\U0001F382"), category},
        {QStringLiteral(":shortcake:"), QString::fromUtf16(u"\U0001F370"), category},
        {QStringLiteral(":cupcake:"), QString::fromUtf16(u"\U0001F9C1"), category},
        {QStringLiteral(":pie:"), QString::fromUtf16(u"\U0001F967"), category},
        {QStringLiteral(":chocolate_bar:"), QString::fromUtf16(u"\U0001F36B"), category},
        {QStringLiteral(":candy:"), QString::fromUtf16(u"\U0001F36C"), category},
        {QStringLiteral(":lollipop:"), QString::fromUtf16(u"\U0001F36D"), category},
        {QStringLiteral(":custard:"), QString::fromUtf16(u"\U0001F36E"), category},
        {QStringLiteral(":honey_pot:"), QString::fromUtf16(u"\U0001F36F"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeTransportEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::TransportEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":locomotive:"), QString::fromUtf16(u"\U0001F682"), category},
        {QStringLiteral(":railway_car:"), QString::fromUtf16(u"\U0001F683"), category},
        {QStringLiteral(":high-speed_train:"), QString::fromUtf16(u"\U0001F684"), category},
        {QStringLiteral(":bullet_train:"), QString::fromUtf16(u"\U0001F685"), category},
        {QStringLiteral(":train:"), QString::fromUtf16(u"\U0001F686"), category},
        {QStringLiteral(":metro:"), QString::fromUtf16(u"\U0001F687"), category},
        {QStringLiteral(":light_rail:"), QString::fromUtf16(u"\U0001F688"), category},
        {QStringLiteral(":station:"), QString::fromUtf16(u"\U0001F689"), category},
        {QStringLiteral(":tram:"), QString::fromUtf16(u"\U0001F68A"), category},
        {QStringLiteral(":monorail:"), QString::fromUtf16(u"\U0001F69D"), category},
        {QStringLiteral(":mountain_railway:"), QString::fromUtf16(u"\U0001F69E"), category},
        {QStringLiteral(":tram_car:"), QString::fromUtf16(u"\U0001F68B"), category},
        {QStringLiteral(":bus:"), QString::fromUtf16(u"\U0001F68C"), category},
        {QStringLiteral(":oncoming_bus:"), QString::fromUtf16(u"\U0001F68D"), category},
        {QStringLiteral(":trolleybus:"), QString::fromUtf16(u"\U0001F68E"), category},
        {QStringLiteral(":minibus:"), QString::fromUtf16(u"\U0001F690"), category},
        {QStringLiteral(":ambulance:"), QString::fromUtf16(u"\U0001F691"), category},
        {QStringLiteral(":fire_engine:"), QString::fromUtf16(u"\U0001F692"), category},
        {QStringLiteral(":police_car:"), QString::fromUtf16(u"\U0001F693"), category},
        {QStringLiteral(":oncoming_police_car:"), QString::fromUtf16(u"\U0001F694"), category},
        {QStringLiteral(":taxi:"), QString::fromUtf16(u"\U0001F695"), category},
        {QStringLiteral(":oncoming_taxi:"), QString::fromUtf16(u"\U0001F696"), category},
        {QStringLiteral(":automobile:"), QString::fromUtf16(u"\U0001F697"), category},
        {QStringLiteral(":oncoming_automobile:"), QString::fromUtf16(u"\U0001F698"), category},
        {QStringLiteral(":sport_utility_vehicle:"), QString::fromUtf16(u"\U0001F699"), category},
        {QStringLiteral(":delivery_truck:"), QString::fromUtf16(u"\U0001F69A"), category},
        {QStringLiteral(":articulated_lorry:"), QString::fromUtf16(u"\U0001F69B"), category},
        {QStringLiteral(":tractor:"), QString::fromUtf16(u"\U0001F69C"), category},
        {QStringLiteral(":racing_car:"), QString::fromUtf16(u"\U0001F3CE"), category},
        {QStringLiteral(":motorcycle:"), QString::fromUtf16(u"\U0001F3CD"), category},
        {QStringLiteral(":motor_scooter:"), QString::fromUtf16(u"\U0001F6F5"), category},
        {QStringLiteral(":manual_wheelchair:"), QString::fromUtf16(u"\U0001F9BD"), category},
        {QStringLiteral(":motorized_wheelchair:"), QString::fromUtf16(u"\U0001F9BC"), category},
        {QStringLiteral(":auto_rickshaw:"), QString::fromUtf16(u"\U0001F6FA"), category},
        {QStringLiteral(":bicycle:"), QString::fromUtf16(u"\U0001F6B2"), category},
        {QStringLiteral(":kick_scooter:"), QString::fromUtf16(u"\U0001F6F4"), category},
        {QStringLiteral(":skateboard:"), QString::fromUtf16(u"\U0001F6F9"), category},
        {QStringLiteral(":bus_stop:"), QString::fromUtf16(u"\U0001F68F"), category},
        {QStringLiteral(":motorway:"), QString::fromUtf16(u"\U0001F6E3"), category},
        {QStringLiteral(":railway_track:"), QString::fromUtf16(u"\U0001F6E4"), category},
        {QStringLiteral(":oil_drum:"), QString::fromUtf16(u"\U0001F6E2"), category},
        {QStringLiteral(":fuel_pump:"), QString::fromUtf16(u"\U000026FD"), category},
        {QStringLiteral(":police_car_light:"), QString::fromUtf16(u"\U0001F6A8"), category},
        {QStringLiteral(":horizontal_traffic_light:"), QString::fromUtf16(u"\U0001F6A5"), category},
        {QStringLiteral(":vertical_traffic_light:"), QString::fromUtf16(u"\U0001F6A6"), category},
        {QStringLiteral(":stop_sign:"), QString::fromUtf16(u"\U0001F6D1"), category},
        {QStringLiteral(":construction:"), QString::fromUtf16(u"\U0001F6A7"), category},
        {QStringLiteral(":anchor:"), QString::fromUtf16(u"\U00002693"), category},
        {QStringLiteral(":sailboat:"), QString::fromUtf16(u"\U000026F5"), category},
        {QStringLiteral(":canoe:"), QString::fromUtf16(u"\U0001F6F6"), category},
        {QStringLiteral(":speedboat:"), QString::fromUtf16(u"\U0001F6A4"), category},
        {QStringLiteral(":passenger_ship:"), QString::fromUtf16(u"\U0001F6F3"), category},
        {QStringLiteral(":ferry:"), QString::fromUtf16(u"\U000026F4"), category},
        {QStringLiteral(":motor_boat:"), QString::fromUtf16(u"\U0001F6E5"), category},
        {QStringLiteral(":ship:"), QString::fromUtf16(u"\U0001F6A2"), category},
        {QStringLiteral(":airplane:"), QString::fromUtf16(u"\U00002708"), category},
        {QStringLiteral(":small_airplane:"), QString::fromUtf16(u"\U0001F6E9"), category},
        {QStringLiteral(":airplane_departure:"), QString::fromUtf16(u"\U0001F6EB"), category},
        {QStringLiteral(":airplane_arrival:"), QString::fromUtf16(u"\U0001F6EC"), category},
        {QStringLiteral(":parachute:"), QString::fromUtf16(u"\U0001FA82"), category},
        {QStringLiteral(":seat:"), QString::fromUtf16(u"\U0001F4BA"), category},
        {QStringLiteral(":helicopter:"), QString::fromUtf16(u"\U0001F681"), category},
        {QStringLiteral(":suspension_railway:"), QString::fromUtf16(u"\U0001F69F"), category},
        {QStringLiteral(":mountain_cableway:"), QString::fromUtf16(u"\U0001F6A0"), category},
        {QStringLiteral(":aerial_tramway:"), QString::fromUtf16(u"\U0001F6A1"), category},
        {QStringLiteral(":satellite:"), QString::fromUtf16(u"\U0001F6F0"), category},
        {QStringLiteral(":rocket:"), QString::fromUtf16(u"\U0001F680"), category},
        {QStringLiteral(":flying_saucer:"), QString::fromUtf16(u"\U0001F6F8"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodePersonEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::PersonEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":baby:"), QString::fromUtf16(u"\U0001F476"), category},
        {QStringLiteral(":child:"), QString::fromUtf16(u"\U0001F9D2"), category},
        {QStringLiteral(":boy:"), QString::fromUtf16(u"\U0001F466"), category},
        {QStringLiteral(":girl:"), QString::fromUtf16(u"\U0001F467"), category},
        {QStringLiteral(":person:"), QString::fromUtf16(u"\U0001F9D1"), category},
        {QStringLiteral(":person_blond_hair:"), QString::fromUtf16(u"\U0001F471"), category},
        {QStringLiteral(":man:"), QString::fromUtf16(u"\U0001F468"), category},
        {QStringLiteral(":man_beard:"), QString::fromUtf16(u"\U0001F9D4"), category},
        {QStringLiteral(":man_blond_hair:"), QString::fromUtf16(u"\U0001F471\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":man_red_hair:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9B0"), category},
        {QStringLiteral(":man_curly_hair:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9B1"), category},
        {QStringLiteral(":man_white_hair:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9B3"), category},
        {QStringLiteral(":man_bald:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9B2"), category},
        {QStringLiteral(":woman:"), QString::fromUtf16(u"\U0001F469"), category},
        {QStringLiteral(":woman_blond_hair:"), QString::fromUtf16(u"\U0001F471\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":woman_red_hair:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9B0"), category},
        {QStringLiteral(":woman_curly_hair:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9B1"), category},
        {QStringLiteral(":woman_white_hair:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9B3"), category},
        {QStringLiteral(":woman_bald:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9B2"), category},
        {QStringLiteral(":older_person:"), QString::fromUtf16(u"\U0001F9D3"), category},
        {QStringLiteral(":old_man:"), QString::fromUtf16(u"\U0001F474"), category},
        {QStringLiteral(":old_woman:"), QString::fromUtf16(u"\U0001F475"), category},
        {QStringLiteral(":person_frowning:"), QString::fromUtf16(u"\U0001F64D"), category},
        {QStringLiteral(":man_frowning:"), QString::fromUtf16(u"\U0001F64D\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_frowning:"), QString::fromUtf16(u"\U0001F64D\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_pouting:"), QString::fromUtf16(u"\U0001F64E"), category},
        {QStringLiteral(":man_pouting:"), QString::fromUtf16(u"\U0001F64E\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_pouting:"), QString::fromUtf16(u"\U0001F64E\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_gesturing_NO:"), QString::fromUtf16(u"\U0001F645"), category},
        {QStringLiteral(":man_gesturing_NO:"), QString::fromUtf16(u"\U0001F645\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_gesturing_NO:"), QString::fromUtf16(u"\U0001F645\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_gesturing_OK:"), QString::fromUtf16(u"\U0001F646"), category},
        {QStringLiteral(":man_gesturing_OK:"), QString::fromUtf16(u"\U0001F646\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_gesturing_OK:"), QString::fromUtf16(u"\U0001F646\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_tipping_hand:"), QString::fromUtf16(u"\U0001F481"), category},
        {QStringLiteral(":man_tipping_hand:"), QString::fromUtf16(u"\U0001F481\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_tipping_hand:"), QString::fromUtf16(u"\U0001F481\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_raising_hand:"), QString::fromUtf16(u"\U0001F64B"), category},
        {QStringLiteral(":man_raising_hand:"), QString::fromUtf16(u"\U0001F64B\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_raising_hand:"), QString::fromUtf16(u"\U0001F64B\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":deaf_person:"), QString::fromUtf16(u"\U0001F9CF"), category},
        {QStringLiteral(":deaf_man:"), QString::fromUtf16(u"\U0001F9CF\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":deaf_woman:"), QString::fromUtf16(u"\U0001F9CF\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_bowing:"), QString::fromUtf16(u"\U0001F647"), category},
        {QStringLiteral(":man_bowing:"), QString::fromUtf16(u"\U0001F647\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_bowing:"), QString::fromUtf16(u"\U0001F647\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_facepalming:"), QString::fromUtf16(u"\U0001F926"), category},
        {QStringLiteral(":man_facepalming:"), QString::fromUtf16(u"\U0001F926\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_facepalming:"), QString::fromUtf16(u"\U0001F926\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_shrugging:"), QString::fromUtf16(u"\U0001F937"), category},
        {QStringLiteral(":man_shrugging:"), QString::fromUtf16(u"\U0001F937\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_shrugging:"), QString::fromUtf16(u"\U0001F937\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":man_health_worker:"), QString::fromUtf16(u"\U0001F468\U0000200D\U00002695\U0000FE0F"), category},
        {QStringLiteral(":woman_health_worker:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002695\U0000FE0F"), category},
        {QStringLiteral(":man_student:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F393"), category},
        {QStringLiteral(":woman_student:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F393"), category},
        {QStringLiteral(":man_teacher:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F3EB"), category},
        {QStringLiteral(":woman_teacher:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F3EB"), category},
        {QStringLiteral(":man_judge:"), QString::fromUtf16(u"\U0001F468\U0000200D\U00002696\U0000FE0F"), category},
        {QStringLiteral(":woman_judge:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002696\U0000FE0F"), category},
        {QStringLiteral(":man_farmer:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F33E"), category},
        {QStringLiteral(":woman_farmer:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F33E"), category},
        {QStringLiteral(":man_cook:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F373"), category},
        {QStringLiteral(":woman_cook:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F373"), category},
        {QStringLiteral(":man_mechanic:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F527"), category},
        {QStringLiteral(":woman_mechanic:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F527"), category},
        {QStringLiteral(":man_factory_worker:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F3ED"), category},
        {QStringLiteral(":woman_factory_worker:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F3ED"), category},
        {QStringLiteral(":man_office_worker:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F4BC"), category},
        {QStringLiteral(":woman_office_worker:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F4BC"), category},
        {QStringLiteral(":man_scientist:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F52C"), category},
        {QStringLiteral(":woman_scientist:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F52C"), category},
        {QStringLiteral(":man_technologist:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F4BB"), category},
        {QStringLiteral(":woman_technologist:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F4BB"), category},
        {QStringLiteral(":man_singer:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F3A4"), category},
        {QStringLiteral(":woman_singer:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F3A4"), category},
        {QStringLiteral(":man_artist:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F3A8"), category},
        {QStringLiteral(":woman_artist:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F3A8"), category},
        {QStringLiteral(":man_pilot:"), QString::fromUtf16(u"\U0001F468\U0000200D\U00002708\U0000FE0F"), category},
        {QStringLiteral(":woman_pilot:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002708\U0000FE0F"), category},
        {QStringLiteral(":man_astronaut:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F680"), category},
        {QStringLiteral(":woman_astronaut:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F680"), category},
        {QStringLiteral(":man_firefighter:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F692"), category},
        {QStringLiteral(":woman_firefighter:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F692"), category},
        {QStringLiteral(":police_officer:"), QString::fromUtf16(u"\U0001F46E"), category},
        {QStringLiteral(":man_police_officer:"), QString::fromUtf16(u"\U0001F46E\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_police_officer:"), QString::fromUtf16(u"\U0001F46E\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":detective:"), QString::fromUtf16(u"\U0001F575"), category},
        {QStringLiteral(":man_detective:"), QString::fromUtf16(u"\U0001F575\U0000FE0F\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_detective:"), QString::fromUtf16(u"\U0001F575\U0000FE0F\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":guard:"), QString::fromUtf16(u"\U0001F482"), category},
        {QStringLiteral(":man_guard:"), QString::fromUtf16(u"\U0001F482\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_guard:"), QString::fromUtf16(u"\U0001F482\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":construction_worker:"), QString::fromUtf16(u"\U0001F477"), category},
        {QStringLiteral(":man_construction_worker:"), QString::fromUtf16(u"\U0001F477\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_construction_worker:"), QString::fromUtf16(u"\U0001F477\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":prince:"), QString::fromUtf16(u"\U0001F934"), category},
        {QStringLiteral(":princess:"), QString::fromUtf16(u"\U0001F478"), category},
        {QStringLiteral(":person_wearing_turban:"), QString::fromUtf16(u"\U0001F473"), category},
        {QStringLiteral(":man_wearing_turban:"), QString::fromUtf16(u"\U0001F473\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_wearing_turban:"), QString::fromUtf16(u"\U0001F473\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":man_with_Chinese_cap:"), QString::fromUtf16(u"\U0001F472"), category},
        {QStringLiteral(":woman_with_headscarf:"), QString::fromUtf16(u"\U0001F9D5"), category},
        {QStringLiteral(":man_in_tuxedo:"), QString::fromUtf16(u"\U0001F935"), category},
        {QStringLiteral(":bride_with_veil:"), QString::fromUtf16(u"\U0001F470"), category},
        {QStringLiteral(":pregnant_woman:"), QString::fromUtf16(u"\U0001F930"), category},
        {QStringLiteral(":breast-feeding:"), QString::fromUtf16(u"\U0001F931"), category},
        {QStringLiteral(":baby_angel:"), QString::fromUtf16(u"\U0001F47C"), category},
        {QStringLiteral(":Santa_Claus:"), QString::fromUtf16(u"\U0001F385"), category},
        {QStringLiteral(":Mrs._Claus:"), QString::fromUtf16(u"\U0001F936"), category},
        {QStringLiteral(":superhero:"), QString::fromUtf16(u"\U0001F9B8"), category},
        {QStringLiteral(":man_superhero:"), QString::fromUtf16(u"\U0001F9B8\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_superhero:"), QString::fromUtf16(u"\U0001F9B8\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":supervillain:"), QString::fromUtf16(u"\U0001F9B9"), category},
        {QStringLiteral(":man_supervillain:"), QString::fromUtf16(u"\U0001F9B9\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_supervillain:"), QString::fromUtf16(u"\U0001F9B9\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":mage:"), QString::fromUtf16(u"\U0001F9D9"), category},
        {QStringLiteral(":man_mage:"), QString::fromUtf16(u"\U0001F9D9\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_mage:"), QString::fromUtf16(u"\U0001F9D9\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":fairy:"), QString::fromUtf16(u"\U0001F9DA"), category},
        {QStringLiteral(":man_fairy:"), QString::fromUtf16(u"\U0001F9DA\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_fairy:"), QString::fromUtf16(u"\U0001F9DA\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":vampire:"), QString::fromUtf16(u"\U0001F9DB"), category},
        {QStringLiteral(":man_vampire:"), QString::fromUtf16(u"\U0001F9DB\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_vampire:"), QString::fromUtf16(u"\U0001F9DB\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":merperson:"), QString::fromUtf16(u"\U0001F9DC"), category},
        {QStringLiteral(":merman:"), QString::fromUtf16(u"\U0001F9DC\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":mermaid:"), QString::fromUtf16(u"\U0001F9DC\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":elf:"), QString::fromUtf16(u"\U0001F9DD"), category},
        {QStringLiteral(":man_elf:"), QString::fromUtf16(u"\U0001F9DD\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_elf:"), QString::fromUtf16(u"\U0001F9DD\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":genie:"), QString::fromUtf16(u"\U0001F9DE"), category},
        {QStringLiteral(":man_genie:"), QString::fromUtf16(u"\U0001F9DE\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_genie:"), QString::fromUtf16(u"\U0001F9DE\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":zombie:"), QString::fromUtf16(u"\U0001F9DF"), category},
        {QStringLiteral(":man_zombie:"), QString::fromUtf16(u"\U0001F9DF\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_zombie:"), QString::fromUtf16(u"\U0001F9DF\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_getting_massage:"), QString::fromUtf16(u"\U0001F486"), category},
        {QStringLiteral(":man_getting_massage:"), QString::fromUtf16(u"\U0001F486\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_getting_massage:"), QString::fromUtf16(u"\U0001F486\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_getting_haircut:"), QString::fromUtf16(u"\U0001F487"), category},
        {QStringLiteral(":man_getting_haircut:"), QString::fromUtf16(u"\U0001F487\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_getting_haircut:"), QString::fromUtf16(u"\U0001F487\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_walking:"), QString::fromUtf16(u"\U0001F6B6"), category},
        {QStringLiteral(":man_walking:"), QString::fromUtf16(u"\U0001F6B6\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_walking:"), QString::fromUtf16(u"\U0001F6B6\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_standing:"), QString::fromUtf16(u"\U0001F9CD"), category},
        {QStringLiteral(":man_standing:"), QString::fromUtf16(u"\U0001F9CD\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_standing:"), QString::fromUtf16(u"\U0001F9CD\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_kneeling:"), QString::fromUtf16(u"\U0001F9CE"), category},
        {QStringLiteral(":man_kneeling:"), QString::fromUtf16(u"\U0001F9CE\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_kneeling:"), QString::fromUtf16(u"\U0001F9CE\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":man_with_probing_cane:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9AF"), category},
        {QStringLiteral(":woman_with_probing_cane:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9AF"), category},
        {QStringLiteral(":man_in_motorized_wheelchair:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9BC"), category},
        {QStringLiteral(":woman_in_motorized_wheelchair:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9BC"), category},
        {QStringLiteral(":man_in_manual_wheelchair:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F9BD"), category},
        {QStringLiteral(":woman_in_manual_wheelchair:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F9BD"), category},
        {QStringLiteral(":person_running:"), QString::fromUtf16(u"\U0001F3C3"), category},
        {QStringLiteral(":man_running:"), QString::fromUtf16(u"\U0001F3C3\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_running:"), QString::fromUtf16(u"\U0001F3C3\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":woman_dancing:"), QString::fromUtf16(u"\U0001F483"), category},
        {QStringLiteral(":man_dancing:"), QString::fromUtf16(u"\U0001F57A"), category},
        {QStringLiteral(":man_in_suit_levitating:"), QString::fromUtf16(u"\U0001F574"), category},
        {QStringLiteral(":people_with_bunny_ears:"), QString::fromUtf16(u"\U0001F46F"), category},
        {QStringLiteral(":men_with_bunny_ears:"), QString::fromUtf16(u"\U0001F46F\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":women_with_bunny_ears:"), QString::fromUtf16(u"\U0001F46F\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_in_steamy_room:"), QString::fromUtf16(u"\U0001F9D6"), category},
        {QStringLiteral(":man_in_steamy_room:"), QString::fromUtf16(u"\U0001F9D6\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_in_steamy_room:"), QString::fromUtf16(u"\U0001F9D6\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_climbing:"), QString::fromUtf16(u"\U0001F9D7"), category},
        {QStringLiteral(":man_climbing:"), QString::fromUtf16(u"\U0001F9D7\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_climbing:"), QString::fromUtf16(u"\U0001F9D7\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_fencing:"), QString::fromUtf16(u"\U0001F93A"), category},
        {QStringLiteral(":horse_racing:"), QString::fromUtf16(u"\U0001F3C7"), category},
        {QStringLiteral(":skier:"), QString::fromUtf16(u"\U000026F7"), category},
        {QStringLiteral(":snowboarder:"), QString::fromUtf16(u"\U0001F3C2"), category},
        {QStringLiteral(":person_golfing:"), QString::fromUtf16(u"\U0001F3CC"), category},
        {QStringLiteral(":man_golfing:"), QString::fromUtf16(u"\U0001F3CC\U0000FE0F\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_golfing:"), QString::fromUtf16(u"\U0001F3CC\U0000FE0F\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_surfing:"), QString::fromUtf16(u"\U0001F3C4"), category},
        {QStringLiteral(":man_surfing:"), QString::fromUtf16(u"\U0001F3C4\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_surfing:"), QString::fromUtf16(u"\U0001F3C4\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_rowing_boat:"), QString::fromUtf16(u"\U0001F6A3"), category},
        {QStringLiteral(":man_rowing_boat:"), QString::fromUtf16(u"\U0001F6A3\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_rowing_boat:"), QString::fromUtf16(u"\U0001F6A3\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_swimming:"), QString::fromUtf16(u"\U0001F3CA"), category},
        {QStringLiteral(":man_swimming:"), QString::fromUtf16(u"\U0001F3CA\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_swimming:"), QString::fromUtf16(u"\U0001F3CA\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_bouncing_ball:"), QString::fromUtf16(u"\U000026F9"), category},
        {QStringLiteral(":man_bouncing_ball:"), QString::fromUtf16(u"\U000026F9\U0000FE0F\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_bouncing_ball:"), QString::fromUtf16(u"\U000026F9\U0000FE0F\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_lifting_weights:"), QString::fromUtf16(u"\U0001F3CB"), category},
        {QStringLiteral(":man_lifting_weights:"), QString::fromUtf16(u"\U0001F3CB\U0000FE0F\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_lifting_weights:"), QString::fromUtf16(u"\U0001F3CB\U0000FE0F\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_biking:"), QString::fromUtf16(u"\U0001F6B4"), category},
        {QStringLiteral(":man_biking:"), QString::fromUtf16(u"\U0001F6B4\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_biking:"), QString::fromUtf16(u"\U0001F6B4\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_mountain_biking:"), QString::fromUtf16(u"\U0001F6B5"), category},
        {QStringLiteral(":man_mountain_biking:"), QString::fromUtf16(u"\U0001F6B5\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_mountain_biking:"), QString::fromUtf16(u"\U0001F6B5\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_cartwheeling:"), QString::fromUtf16(u"\U0001F938"), category},
        {QStringLiteral(":man_cartwheeling:"), QString::fromUtf16(u"\U0001F938\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_cartwheeling:"), QString::fromUtf16(u"\U0001F938\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":people_wrestling:"), QString::fromUtf16(u"\U0001F93C"), category},
        {QStringLiteral(":men_wrestling:"), QString::fromUtf16(u"\U0001F93C\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":women_wrestling:"), QString::fromUtf16(u"\U0001F93C\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_playing_water_polo:"), QString::fromUtf16(u"\U0001F93D"), category},
        {QStringLiteral(":man_playing_water_polo:"), QString::fromUtf16(u"\U0001F93D\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_playing_water_polo:"), QString::fromUtf16(u"\U0001F93D\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_playing_handball:"), QString::fromUtf16(u"\U0001F93E"), category},
        {QStringLiteral(":man_playing_handball:"), QString::fromUtf16(u"\U0001F93E\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_playing_handball:"), QString::fromUtf16(u"\U0001F93E\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_juggling:"), QString::fromUtf16(u"\U0001F939"), category},
        {QStringLiteral(":man_juggling:"), QString::fromUtf16(u"\U0001F939\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_juggling:"), QString::fromUtf16(u"\U0001F939\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_in_lotus_position:"), QString::fromUtf16(u"\U0001F9D8"), category},
        {QStringLiteral(":man_in_lotus_position:"), QString::fromUtf16(u"\U0001F9D8\U0000200D\U00002642\U0000FE0F"), category},
        {QStringLiteral(":woman_in_lotus_position:"), QString::fromUtf16(u"\U0001F9D8\U0000200D\U00002640\U0000FE0F"), category},
        {QStringLiteral(":person_taking_bath:"), QString::fromUtf16(u"\U0001F6C0"), category},
        {QStringLiteral(":person_in_bed:"), QString::fromUtf16(u"\U0001F6CC"), category},
        {QStringLiteral(":people_holding_hands:"), QString::fromUtf16(u"\U0001F9D1\U0000200D\U0001F91D\U0000200D\U0001F9D1"), category},
        {QStringLiteral(":women_holding_hands:"), QString::fromUtf16(u"\U0001F46D"), category},
        {QStringLiteral(":woman_and_man_holding_hands:"), QString::fromUtf16(u"\U0001F46B"), category},
        {QStringLiteral(":men_holding_hands:"), QString::fromUtf16(u"\U0001F46C"), category},
        {QStringLiteral(":kiss:"), QString::fromUtf16(u"\U0001F48F"), category},
        {QStringLiteral(":kiss_woman_man:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468"), category},
        {QStringLiteral(":kiss_man_man:"), QString::fromUtf16(u"\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F468"), category},
        {QStringLiteral(":kiss_woman_woman:"),
         QString::fromUtf16(u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F48B\U0000200D\U0001F469"),
         category},
        {QStringLiteral(":couple_with_heart:"), QString::fromUtf16(u"\U0001F491"), category},
        {QStringLiteral(":couple_with_heart_woman_man:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468"), category},
        {QStringLiteral(":couple_with_heart_man_man:"), QString::fromUtf16(u"\U0001F468\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F468"), category},
        {QStringLiteral(":couple_with_heart_woman_woman:"), QString::fromUtf16(u"\U0001F469\U0000200D\U00002764\U0000FE0F\U0000200D\U0001F469"), category},
        {QStringLiteral(":family:"), QString::fromUtf16(u"\U0001F46A"), category},
        {QStringLiteral(":family_man_woman_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_man_woman_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467"), category},
        {QStringLiteral(":family_man_woman_girl_boy:"),
         QString::fromUtf16(u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466"),
         category},
        {QStringLiteral(":family_man_woman_boy_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_man_woman_girl_girl:"),
         QString::fromUtf16(u"\U0001F468\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467"),
         category},
        {QStringLiteral(":family_man_man_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_man_man_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467"), category},
        {QStringLiteral(":family_man_man_girl_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_man_man_boy_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_man_man_girl_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467"), category},
        {QStringLiteral(":family_woman_woman_boy:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_woman_woman_girl:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467"), category},
        {QStringLiteral(":family_woman_woman_girl_boy:"),
         QString::fromUtf16(u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466"),
         category},
        {QStringLiteral(":family_woman_woman_boy_boy:"),
         QString::fromUtf16(u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466"),
         category},
        {QStringLiteral(":family_woman_woman_girl_girl:"),
         QString::fromUtf16(u"\U0001F469\U0000200D\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467"),
         category},
        {QStringLiteral(":family_man_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_man_boy_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F466\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_man_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F467"), category},
        {QStringLiteral(":family_man_girl_boy:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F467\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_man_girl_girl:"), QString::fromUtf16(u"\U0001F468\U0000200D\U0001F467\U0000200D\U0001F467"), category},
        {QStringLiteral(":family_woman_boy:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_woman_boy_boy:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F466\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_woman_girl:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F467"), category},
        {QStringLiteral(":family_woman_girl_boy:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F467\U0000200D\U0001F466"), category},
        {QStringLiteral(":family_woman_girl_girl:"), QString::fromUtf16(u"\U0001F469\U0000200D\U0001F467\U0000200D\U0001F467"), category},
        {QStringLiteral(":speaking_head:"), QString::fromUtf16(u"\U0001F5E3"), category},
        {QStringLiteral(":bust_in_silhouette:"), QString::fromUtf16(u"\U0001F464"), category},
        {QStringLiteral(":busts_in_silhouette:"), QString::fromUtf16(u"\U0001F465"), category},
        {QStringLiteral(":footprints:"), QString::fromUtf16(u"\U0001F463"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodePlaceEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::PlaceEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":globe_showing_Europe-Africa:"), QString::fromUtf16(u"\U0001F30D"), category},
        {QStringLiteral(":globe_showing_Americas:"), QString::fromUtf16(u"\U0001F30E"), category},
        {QStringLiteral(":globe_showing_Asia-Australia:"), QString::fromUtf16(u"\U0001F30F"), category},
        {QStringLiteral(":globe_with_meridians:"), QString::fromUtf16(u"\U0001F310"), category},
        {QStringLiteral(":world_map:"), QString::fromUtf16(u"\U0001F5FA"), category},
        {QStringLiteral(":map_of_Japan:"), QString::fromUtf16(u"\U0001F5FE"), category},
        {QStringLiteral(":compass:"), QString::fromUtf16(u"\U0001F9ED"), category},
        {QStringLiteral(":snow-capped_mountain:"), QString::fromUtf16(u"\U0001F3D4"), category},
        {QStringLiteral(":mountain:"), QString::fromUtf16(u"\U000026F0"), category},
        {QStringLiteral(":volcano:"), QString::fromUtf16(u"\U0001F30B"), category},
        {QStringLiteral(":mount_fuji:"), QString::fromUtf16(u"\U0001F5FB"), category},
        {QStringLiteral(":camping:"), QString::fromUtf16(u"\U0001F3D5"), category},
        {QStringLiteral(":beach_with_umbrella:"), QString::fromUtf16(u"\U0001F3D6"), category},
        {QStringLiteral(":desert:"), QString::fromUtf16(u"\U0001F3DC"), category},
        {QStringLiteral(":desert_island:"), QString::fromUtf16(u"\U0001F3DD"), category},
        {QStringLiteral(":national_park:"), QString::fromUtf16(u"\U0001F3DE"), category},
        {QStringLiteral(":stadium:"), QString::fromUtf16(u"\U0001F3DF"), category},
        {QStringLiteral(":classical_building:"), QString::fromUtf16(u"\U0001F3DB"), category},
        {QStringLiteral(":building_construction:"), QString::fromUtf16(u"\U0001F3D7"), category},
        {QStringLiteral(":brick:"), QString::fromUtf16(u"\U0001F9F1"), category},
        {QStringLiteral(":houses:"), QString::fromUtf16(u"\U0001F3D8"), category},
        {QStringLiteral(":derelict_house:"), QString::fromUtf16(u"\U0001F3DA"), category},
        {QStringLiteral(":house:"), QString::fromUtf16(u"\U0001F3E0"), category},
        {QStringLiteral(":house_with_garden:"), QString::fromUtf16(u"\U0001F3E1"), category},
        {QStringLiteral(":office_building:"), QString::fromUtf16(u"\U0001F3E2"), category},
        {QStringLiteral(":Japanese_post_office:"), QString::fromUtf16(u"\U0001F3E3"), category},
        {QStringLiteral(":post_office:"), QString::fromUtf16(u"\U0001F3E4"), category},
        {QStringLiteral(":hospital:"), QString::fromUtf16(u"\U0001F3E5"), category},
        {QStringLiteral(":bank:"), QString::fromUtf16(u"\U0001F3E6"), category},
        {QStringLiteral(":hotel:"), QString::fromUtf16(u"\U0001F3E8"), category},
        {QStringLiteral(":love_hotel:"), QString::fromUtf16(u"\U0001F3E9"), category},
        {QStringLiteral(":convenience_store:"), QString::fromUtf16(u"\U0001F3EA"), category},
        {QStringLiteral(":school:"), QString::fromUtf16(u"\U0001F3EB"), category},
        {QStringLiteral(":department_store:"), QString::fromUtf16(u"\U0001F3EC"), category},
        {QStringLiteral(":factory:"), QString::fromUtf16(u"\U0001F3ED"), category},
        {QStringLiteral(":Japanese_castle:"), QString::fromUtf16(u"\U0001F3EF"), category},
        {QStringLiteral(":castle:"), QString::fromUtf16(u"\U0001F3F0"), category},
        {QStringLiteral(":wedding:"), QString::fromUtf16(u"\U0001F492"), category},
        {QStringLiteral(":Tokyo_tower:"), QString::fromUtf16(u"\U0001F5FC"), category},
        {QStringLiteral(":Statue_of_Liberty:"), QString::fromUtf16(u"\U0001F5FD"), category},
        {QStringLiteral(":church:"), QString::fromUtf16(u"\U000026EA"), category},
        {QStringLiteral(":mosque:"), QString::fromUtf16(u"\U0001F54C"), category},
        {QStringLiteral(":hindu_temple:"), QString::fromUtf16(u"\U0001F6D5"), category},
        {QStringLiteral(":synagogue:"), QString::fromUtf16(u"\U0001F54D"), category},
        {QStringLiteral(":shinto_shrine:"), QString::fromUtf16(u"\U000026E9"), category},
        {QStringLiteral(":kaaba:"), QString::fromUtf16(u"\U0001F54B"), category},
        {QStringLiteral(":fountain:"), QString::fromUtf16(u"\U000026F2"), category},
        {QStringLiteral(":tent:"), QString::fromUtf16(u"\U000026FA"), category},
        {QStringLiteral(":foggy:"), QString::fromUtf16(u"\U0001F301"), category},
        {QStringLiteral(":night_with_stars:"), QString::fromUtf16(u"\U0001F303"), category},
        {QStringLiteral(":cityscape:"), QString::fromUtf16(u"\U0001F3D9"), category},
        {QStringLiteral(":sunrise_over_mountains:"), QString::fromUtf16(u"\U0001F304"), category},
        {QStringLiteral(":sunrise:"), QString::fromUtf16(u"\U0001F305"), category},
        {QStringLiteral(":cityscape_at_dusk:"), QString::fromUtf16(u"\U0001F306"), category},
        {QStringLiteral(":sunset:"), QString::fromUtf16(u"\U0001F307"), category},
        {QStringLiteral(":bridge_at_night:"), QString::fromUtf16(u"\U0001F309"), category},
        {QStringLiteral(":hot_springs:"), QString::fromUtf16(u"\U00002668"), category},
        {QStringLiteral(":carousel_horse:"), QString::fromUtf16(u"\U0001F3A0"), category},
        {QStringLiteral(":ferris_wheel:"), QString::fromUtf16(u"\U0001F3A1"), category},
        {QStringLiteral(":roller_coaster:"), QString::fromUtf16(u"\U0001F3A2"), category},
        {QStringLiteral(":barber_pole:"), QString::fromUtf16(u"\U0001F488"), category},
        {QStringLiteral(":circus_tent:"), QString::fromUtf16(u"\U0001F3AA"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeSymbolsEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::SymbolsEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":ATM_sign:"), QString::fromUtf16(u"\U0001F3E7"), category},
        {QStringLiteral(":litter_in_bin_sign:"), QString::fromUtf16(u"\U0001F6AE"), category},
        {QStringLiteral(":potable_water:"), QString::fromUtf16(u"\U0001F6B0"), category},
        {QStringLiteral(":wheelchair_symbol:"), QString::fromUtf16(u"\U0000267F"), category},
        {QStringLiteral(":men’s_room:"), QString::fromUtf16(u"\U0001F6B9"), category},
        {QStringLiteral(":women’s_room:"), QString::fromUtf16(u"\U0001F6BA"), category},
        {QStringLiteral(":restroom:"), QString::fromUtf16(u"\U0001F6BB"), category},
        {QStringLiteral(":baby_symbol:"), QString::fromUtf16(u"\U0001F6BC"), category},
        {QStringLiteral(":water_closet:"), QString::fromUtf16(u"\U0001F6BE"), category},
        {QStringLiteral(":passport_control:"), QString::fromUtf16(u"\U0001F6C2"), category},
        {QStringLiteral(":customs:"), QString::fromUtf16(u"\U0001F6C3"), category},
        {QStringLiteral(":baggage_claim:"), QString::fromUtf16(u"\U0001F6C4"), category},
        {QStringLiteral(":left_luggage:"), QString::fromUtf16(u"\U0001F6C5"), category},
        {QStringLiteral(":warning:"), QString::fromUtf16(u"\U000026A0"), category},
        {QStringLiteral(":children_crossing:"), QString::fromUtf16(u"\U0001F6B8"), category},
        {QStringLiteral(":no_entry:"), QString::fromUtf16(u"\U000026D4"), category},
        {QStringLiteral(":prohibited:"), QString::fromUtf16(u"\U0001F6AB"), category},
        {QStringLiteral(":no_bicycles:"), QString::fromUtf16(u"\U0001F6B3"), category},
        {QStringLiteral(":no_smoking:"), QString::fromUtf16(u"\U0001F6AD"), category},
        {QStringLiteral(":no_littering:"), QString::fromUtf16(u"\U0001F6AF"), category},
        {QStringLiteral(":non-potable_water:"), QString::fromUtf16(u"\U0001F6B1"), category},
        {QStringLiteral(":no_pedestrians:"), QString::fromUtf16(u"\U0001F6B7"), category},
        {QStringLiteral(":no_mobile_phones:"), QString::fromUtf16(u"\U0001F4F5"), category},
        {QStringLiteral(":no_one_under_eighteen:"), QString::fromUtf16(u"\U0001F51E"), category},
        {QStringLiteral(":radioactive:"), QString::fromUtf16(u"\U00002622"), category},
        {QStringLiteral(":biohazard:"), QString::fromUtf16(u"\U00002623"), category},
        {QStringLiteral(":up_arrow:"), QString::fromUtf16(u"\U00002B06"), category},
        {QStringLiteral(":up-right_arrow:"), QString::fromUtf16(u"\U00002197"), category},
        {QStringLiteral(":right_arrow:"), QString::fromUtf16(u"\U000027A1"), category},
        {QStringLiteral(":down-right_arrow:"), QString::fromUtf16(u"\U00002198"), category},
        {QStringLiteral(":down_arrow:"), QString::fromUtf16(u"\U00002B07"), category},
        {QStringLiteral(":down-left_arrow:"), QString::fromUtf16(u"\U00002199"), category},
        {QStringLiteral(":left_arrow:"), QString::fromUtf16(u"\U00002B05"), category},
        {QStringLiteral(":up-left_arrow:"), QString::fromUtf16(u"\U00002196"), category},
        {QStringLiteral(":up-down_arrow:"), QString::fromUtf16(u"\U00002195"), category},
        {QStringLiteral(":left-right_arrow:"), QString::fromUtf16(u"\U00002194"), category},
        {QStringLiteral(":right_arrow_curving_left:"), QString::fromUtf16(u"\U000021A9"), category},
        {QStringLiteral(":left_arrow_curving_right:"), QString::fromUtf16(u"\U000021AA"), category},
        {QStringLiteral(":right_arrow_curving_up:"), QString::fromUtf16(u"\U00002934"), category},
        {QStringLiteral(":right_arrow_curving_down:"), QString::fromUtf16(u"\U00002935"), category},
        {QStringLiteral(":clockwise_vertical_arrows:"), QString::fromUtf16(u"\U0001F503"), category},
        {QStringLiteral(":counterclockwise_arrows_button:"), QString::fromUtf16(u"\U0001F504"), category},
        {QStringLiteral(":BACK_arrow:"), QString::fromUtf16(u"\U0001F519"), category},
        {QStringLiteral(":END_arrow:"), QString::fromUtf16(u"\U0001F51A"), category},
        {QStringLiteral(":ON!_arrow:"), QString::fromUtf16(u"\U0001F51B"), category},
        {QStringLiteral(":SOON_arrow:"), QString::fromUtf16(u"\U0001F51C"), category},
        {QStringLiteral(":TOP_arrow:"), QString::fromUtf16(u"\U0001F51D"), category},
        {QStringLiteral(":place_of_worship:"), QString::fromUtf16(u"\U0001F6D0"), category},
        {QStringLiteral(":atom_symbol:"), QString::fromUtf16(u"\U0000269B"), category},
        {QStringLiteral(":om:"), QString::fromUtf16(u"\U0001F549"), category},
        {QStringLiteral(":star_of_David:"), QString::fromUtf16(u"\U00002721"), category},
        {QStringLiteral(":wheel_of_dharma:"), QString::fromUtf16(u"\U00002638"), category},
        {QStringLiteral(":yin_yang:"), QString::fromUtf16(u"\U0000262F"), category},
        {QStringLiteral(":latin_cross:"), QString::fromUtf16(u"\U0000271D"), category},
        {QStringLiteral(":orthodox_cross:"), QString::fromUtf16(u"\U00002626"), category},
        {QStringLiteral(":star_and_crescent:"), QString::fromUtf16(u"\U0000262A"), category},
        {QStringLiteral(":peace_symbol:"), QString::fromUtf16(u"\U0000262E"), category},
        {QStringLiteral(":menorah:"), QString::fromUtf16(u"\U0001F54E"), category},
        {QStringLiteral(":dotted_six-pointed_star:"), QString::fromUtf16(u"\U0001F52F"), category},
        {QStringLiteral(":Aries:"), QString::fromUtf16(u"\U00002648"), category},
        {QStringLiteral(":Taurus:"), QString::fromUtf16(u"\U00002649"), category},
        {QStringLiteral(":Gemini:"), QString::fromUtf16(u"\U0000264A"), category},
        {QStringLiteral(":Cancer:"), QString::fromUtf16(u"\U0000264B"), category},
        {QStringLiteral(":Leo:"), QString::fromUtf16(u"\U0000264C"), category},
        {QStringLiteral(":Virgo:"), QString::fromUtf16(u"\U0000264D"), category},
        {QStringLiteral(":Libra:"), QString::fromUtf16(u"\U0000264E"), category},
        {QStringLiteral(":Scorpio:"), QString::fromUtf16(u"\U0000264F"), category},
        {QStringLiteral(":Sagittarius:"), QString::fromUtf16(u"\U00002650"), category},
        {QStringLiteral(":Capricorn:"), QString::fromUtf16(u"\U00002651"), category},
        {QStringLiteral(":Aquarius:"), QString::fromUtf16(u"\U00002652"), category},
        {QStringLiteral(":Pisces:"), QString::fromUtf16(u"\U00002653"), category},
        {QStringLiteral(":Ophiuchus:"), QString::fromUtf16(u"\U000026CE"), category},
        {QStringLiteral(":shuffle_tracks_button:"), QString::fromUtf16(u"\U0001F500"), category},
        {QStringLiteral(":repeat_button:"), QString::fromUtf16(u"\U0001F501"), category},
        {QStringLiteral(":repeat_single_button:"), QString::fromUtf16(u"\U0001F502"), category},
        {QStringLiteral(":play_button:"), QString::fromUtf16(u"\U000025B6"), category},
        {QStringLiteral(":fast-forward_button:"), QString::fromUtf16(u"\U000023E9"), category},
        {QStringLiteral(":next_track_button:"), QString::fromUtf16(u"\U000023ED"), category},
        {QStringLiteral(":play_or_pause_button:"), QString::fromUtf16(u"\U000023EF"), category},
        {QStringLiteral(":reverse_button:"), QString::fromUtf16(u"\U000025C0"), category},
        {QStringLiteral(":fast_reverse_button:"), QString::fromUtf16(u"\U000023EA"), category},
        {QStringLiteral(":last_track_button:"), QString::fromUtf16(u"\U000023EE"), category},
        {QStringLiteral(":upwards_button:"), QString::fromUtf16(u"\U0001F53C"), category},
        {QStringLiteral(":fast_up_button:"), QString::fromUtf16(u"\U000023EB"), category},
        {QStringLiteral(":downwards_button:"), QString::fromUtf16(u"\U0001F53D"), category},
        {QStringLiteral(":fast_down_button:"), QString::fromUtf16(u"\U000023EC"), category},
        {QStringLiteral(":pause_button:"), QString::fromUtf16(u"\U000023F8"), category},
        {QStringLiteral(":stop_button:"), QString::fromUtf16(u"\U000023F9"), category},
        {QStringLiteral(":record_button:"), QString::fromUtf16(u"\U000023FA"), category},
        {QStringLiteral(":eject_button:"), QString::fromUtf16(u"\U000023CF"), category},
        {QStringLiteral(":cinema:"), QString::fromUtf16(u"\U0001F3A6"), category},
        {QStringLiteral(":dim_button:"), QString::fromUtf16(u"\U0001F505"), category},
        {QStringLiteral(":bright_button:"), QString::fromUtf16(u"\U0001F506"), category},
        {QStringLiteral(":antenna_bars:"), QString::fromUtf16(u"\U0001F4F6"), category},
        {QStringLiteral(":vibration_mode:"), QString::fromUtf16(u"\U0001F4F3"), category},
        {QStringLiteral(":mobile_phone_off:"), QString::fromUtf16(u"\U0001F4F4"), category},
        {QStringLiteral(":female_sign:"), QString::fromUtf16(u"\U00002640"), category},
        {QStringLiteral(":male_sign:"), QString::fromUtf16(u"\U00002642"), category},
        {QStringLiteral(":medical_symbol:"), QString::fromUtf16(u"\U00002695"), category},
        {QStringLiteral(":infinity:"), QString::fromUtf16(u"\U0000267E"), category},
        {QStringLiteral(":recycling_symbol:"), QString::fromUtf16(u"\U0000267B"), category},
        {QStringLiteral(":fleur-de-lis:"), QString::fromUtf16(u"\U0000269C"), category},
        {QStringLiteral(":trident_emblem:"), QString::fromUtf16(u"\U0001F531"), category},
        {QStringLiteral(":name_badge:"), QString::fromUtf16(u"\U0001F4DB"), category},
        {QStringLiteral(":Japanese_symbol_for_beginner:"), QString::fromUtf16(u"\U0001F530"), category},
        {QStringLiteral(":hollow_red_circle:"), QString::fromUtf16(u"\U00002B55"), category},
        {QStringLiteral(":check_mark_button:"), QString::fromUtf16(u"\U00002705"), category},
        {QStringLiteral(":check_box_with_check:"), QString::fromUtf16(u"\U00002611"), category},
        {QStringLiteral(":check_mark:"), QString::fromUtf16(u"\U00002714"), category},
        {QStringLiteral(":multiplication_sign:"), QString::fromUtf16(u"\U00002716"), category},
        {QStringLiteral(":cross_mark:"), QString::fromUtf16(u"\U0000274C"), category},
        {QStringLiteral(":cross_mark_button:"), QString::fromUtf16(u"\U0000274E"), category},
        {QStringLiteral(":plus_sign:"), QString::fromUtf16(u"\U00002795"), category},
        {QStringLiteral(":minus_sign:"), QString::fromUtf16(u"\U00002796"), category},
        {QStringLiteral(":division_sign:"), QString::fromUtf16(u"\U00002797"), category},
        {QStringLiteral(":curly_loop:"), QString::fromUtf16(u"\U000027B0"), category},
        {QStringLiteral(":double_curly_loop:"), QString::fromUtf16(u"\U000027BF"), category},
        {QStringLiteral(":part_alternation_mark:"), QString::fromUtf16(u"\U0000303D"), category},
        {QStringLiteral(":eight-spoked_asterisk:"), QString::fromUtf16(u"\U00002733"), category},
        {QStringLiteral(":eight-pointed_star:"), QString::fromUtf16(u"\U00002734"), category},
        {QStringLiteral(":sparkle:"), QString::fromUtf16(u"\U00002747"), category},
        {QStringLiteral(":double_exclamation_mark:"), QString::fromUtf16(u"\U0000203C"), category},
        {QStringLiteral(":exclamation_question_mark:"), QString::fromUtf16(u"\U00002049"), category},
        {QStringLiteral(":question_mark:"), QString::fromUtf16(u"\U00002753"), category},
        {QStringLiteral(":white_question_mark:"), QString::fromUtf16(u"\U00002754"), category},
        {QStringLiteral(":white_exclamation_mark:"), QString::fromUtf16(u"\U00002755"), category},
        {QStringLiteral(":exclamation_mark:"), QString::fromUtf16(u"\U00002757"), category},
        {QStringLiteral(":wavy_dash:"), QString::fromUtf16(u"\U00003030"), category},
        {QStringLiteral(":copyright:"), QString::fromUtf16(u"\U000000A9"), category},
        {QStringLiteral(":registered:"), QString::fromUtf16(u"\U000000AE"), category},
        {QStringLiteral(":trade_mark:"), QString::fromUtf16(u"\U00002122"), category},
        {QStringLiteral(":keycap_#:"), QString::fromUtf16(u"\U00000023\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_*:"), QString::fromUtf16(u"\U0000002A\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_0:"), QString::fromUtf16(u"\U00000030\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_1:"), QString::fromUtf16(u"\U00000031\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_2:"), QString::fromUtf16(u"\U00000032\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_3:"), QString::fromUtf16(u"\U00000033\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_4:"), QString::fromUtf16(u"\U00000034\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_5:"), QString::fromUtf16(u"\U00000035\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_6:"), QString::fromUtf16(u"\U00000036\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_7:"), QString::fromUtf16(u"\U00000037\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_8:"), QString::fromUtf16(u"\U00000038\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_9:"), QString::fromUtf16(u"\U00000039\U0000FE0F\U000020E3"), category},
        {QStringLiteral(":keycap_10:"), QString::fromUtf16(u"\U0001F51F"), category},
        {QStringLiteral(":input_latin_uppercase:"), QString::fromUtf16(u"\U0001F520"), category},
        {QStringLiteral(":input_latin_lowercase:"), QString::fromUtf16(u"\U0001F521"), category},
        {QStringLiteral(":input_numbers:"), QString::fromUtf16(u"\U0001F522"), category},
        {QStringLiteral(":input_symbols:"), QString::fromUtf16(u"\U0001F523"), category},
        {QStringLiteral(":input_latin_letters:"), QString::fromUtf16(u"\U0001F524"), category},
        {QStringLiteral(":A_button_(blood_type):"), QString::fromUtf16(u"\U0001F170"), category},
        {QStringLiteral(":AB_button_(blood_type):"), QString::fromUtf16(u"\U0001F18E"), category},
        {QStringLiteral(":B_button_(blood_type):"), QString::fromUtf16(u"\U0001F171"), category},
        {QStringLiteral(":CL_button:"), QString::fromUtf16(u"\U0001F191"), category},
        {QStringLiteral(":COOL_button:"), QString::fromUtf16(u"\U0001F192"), category},
        {QStringLiteral(":FREE_button:"), QString::fromUtf16(u"\U0001F193"), category},
        {QStringLiteral(":information:"), QString::fromUtf16(u"\U00002139"), category},
        {QStringLiteral(":ID_button:"), QString::fromUtf16(u"\U0001F194"), category},
        {QStringLiteral(":circled_M:"), QString::fromUtf16(u"\U000024C2"), category},
        {QStringLiteral(":NEW_button:"), QString::fromUtf16(u"\U0001F195"), category},
        {QStringLiteral(":NG_button:"), QString::fromUtf16(u"\U0001F196"), category},
        {QStringLiteral(":O_button_(blood_type):"), QString::fromUtf16(u"\U0001F17E"), category},
        {QStringLiteral(":OK_button:"), QString::fromUtf16(u"\U0001F197"), category},
        {QStringLiteral(":P_button:"), QString::fromUtf16(u"\U0001F17F"), category},
        {QStringLiteral(":SOS_button:"), QString::fromUtf16(u"\U0001F198"), category},
        {QStringLiteral(":UP!_button:"), QString::fromUtf16(u"\U0001F199"), category},
        {QStringLiteral(":VS_button:"), QString::fromUtf16(u"\U0001F19A"), category},
        {QStringLiteral(":Japanese_here_button:"), QString::fromUtf16(u"\U0001F201"), category},
        {QStringLiteral(":Japanese_service_charge_button:"), QString::fromUtf16(u"\U0001F202"), category},
        {QStringLiteral(":Japanese_monthly_amount_button:"), QString::fromUtf16(u"\U0001F237"), category},
        {QStringLiteral(":Japanese_not_free_of_charge_button:"), QString::fromUtf16(u"\U0001F236"), category},
        {QStringLiteral(":Japanese_reserved_button:"), QString::fromUtf16(u"\U0001F22F"), category},
        {QStringLiteral(":Japanese_bargain_button:"), QString::fromUtf16(u"\U0001F250"), category},
        {QStringLiteral(":Japanese_discount_button:"), QString::fromUtf16(u"\U0001F239"), category},
        {QStringLiteral(":Japanese_free_of_charge_button:"), QString::fromUtf16(u"\U0001F21A"), category},
        {QStringLiteral(":Japanese_prohibited_button:"), QString::fromUtf16(u"\U0001F232"), category},
        {QStringLiteral(":Japanese_acceptable_button:"), QString::fromUtf16(u"\U0001F251"), category},
        {QStringLiteral(":Japanese_application_button:"), QString::fromUtf16(u"\U0001F238"), category},
        {QStringLiteral(":Japanese_passing_grade_button:"), QString::fromUtf16(u"\U0001F234"), category},
        {QStringLiteral(":Japanese_vacancy_button:"), QString::fromUtf16(u"\U0001F233"), category},
        {QStringLiteral(":Japanese_congratulations_button:"), QString::fromUtf16(u"\U00003297"), category},
        {QStringLiteral(":Japanese_secret_button:"), QString::fromUtf16(u"\U00003299"), category},
        {QStringLiteral(":Japanese_open_for_business_button:"), QString::fromUtf16(u"\U0001F23A"), category},
        {QStringLiteral(":Japanese_no_vacancy_button:"), QString::fromUtf16(u"\U0001F235"), category},
        {QStringLiteral(":red_circle:"), QString::fromUtf16(u"\U0001F534"), category},
        {QStringLiteral(":orange_circle:"), QString::fromUtf16(u"\U0001F7E0"), category},
        {QStringLiteral(":yellow_circle:"), QString::fromUtf16(u"\U0001F7E1"), category},
        {QStringLiteral(":green_circle:"), QString::fromUtf16(u"\U0001F7E2"), category},
        {QStringLiteral(":blue_circle:"), QString::fromUtf16(u"\U0001F535"), category},
        {QStringLiteral(":purple_circle:"), QString::fromUtf16(u"\U0001F7E3"), category},
        {QStringLiteral(":brown_circle:"), QString::fromUtf16(u"\U0001F7E4"), category},
        {QStringLiteral(":black_circle:"), QString::fromUtf16(u"\U000026AB"), category},
        {QStringLiteral(":white_circle:"), QString::fromUtf16(u"\U000026AA"), category},
        {QStringLiteral(":red_square:"), QString::fromUtf16(u"\U0001F7E5"), category},
        {QStringLiteral(":orange_square:"), QString::fromUtf16(u"\U0001F7E7"), category},
        {QStringLiteral(":yellow_square:"), QString::fromUtf16(u"\U0001F7E8"), category},
        {QStringLiteral(":green_square:"), QString::fromUtf16(u"\U0001F7E9"), category},
        {QStringLiteral(":blue_square:"), QString::fromUtf16(u"\U0001F7E6"), category},
        {QStringLiteral(":purple_square:"), QString::fromUtf16(u"\U0001F7EA"), category},
        {QStringLiteral(":brown_square:"), QString::fromUtf16(u"\U0001F7EB"), category},
        {QStringLiteral(":black_large_square:"), QString::fromUtf16(u"\U00002B1B"), category},
        {QStringLiteral(":white_large_square:"), QString::fromUtf16(u"\U00002B1C"), category},
        {QStringLiteral(":black_medium_square:"), QString::fromUtf16(u"\U000025FC"), category},
        {QStringLiteral(":white_medium_square:"), QString::fromUtf16(u"\U000025FB"), category},
        {QStringLiteral(":black_medium-small_square:"), QString::fromUtf16(u"\U000025FE"), category},
        {QStringLiteral(":white_medium-small_square:"), QString::fromUtf16(u"\U000025FD"), category},
        {QStringLiteral(":black_small_square:"), QString::fromUtf16(u"\U000025AA"), category},
        {QStringLiteral(":white_small_square:"), QString::fromUtf16(u"\U000025AB"), category},
        {QStringLiteral(":large_orange_diamond:"), QString::fromUtf16(u"\U0001F536"), category},
        {QStringLiteral(":large_blue_diamond:"), QString::fromUtf16(u"\U0001F537"), category},
        {QStringLiteral(":small_orange_diamond:"), QString::fromUtf16(u"\U0001F538"), category},
        {QStringLiteral(":small_blue_diamond:"), QString::fromUtf16(u"\U0001F539"), category},
        {QStringLiteral(":red_triangle_pointed_up:"), QString::fromUtf16(u"\U0001F53A"), category},
        {QStringLiteral(":red_triangle_pointed_down:"), QString::fromUtf16(u"\U0001F53B"), category},
        {QStringLiteral(":diamond_with_a_dot:"), QString::fromUtf16(u"\U0001F4A0"), category},
        {QStringLiteral(":radio_button:"), QString::fromUtf16(u"\U0001F518"), category},
        {QStringLiteral(":white_square_button:"), QString::fromUtf16(u"\U0001F533"), category},
        {QStringLiteral(":black_square_button:"), QString::fromUtf16(u"\U0001F532"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeSportEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::SportEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":soccer_ball:"), QString::fromUtf16(u"\U000026BD"), category},
        {QStringLiteral(":baseball:"), QString::fromUtf16(u"\U000026BE"), category},
        {QStringLiteral(":softball:"), QString::fromUtf16(u"\U0001F94E"), category},
        {QStringLiteral(":basketball:"), QString::fromUtf16(u"\U0001F3C0"), category},
        {QStringLiteral(":volleyball:"), QString::fromUtf16(u"\U0001F3D0"), category},
        {QStringLiteral(":american_football:"), QString::fromUtf16(u"\U0001F3C8"), category},
        {QStringLiteral(":rugby_football:"), QString::fromUtf16(u"\U0001F3C9"), category},
        {QStringLiteral(":tennis:"), QString::fromUtf16(u"\U0001F3BE"), category},
        {QStringLiteral(":flying_disc:"), QString::fromUtf16(u"\U0001F94F"), category},
        {QStringLiteral(":bowling:"), QString::fromUtf16(u"\U0001F3B3"), category},
        {QStringLiteral(":cricket_game:"), QString::fromUtf16(u"\U0001F3CF"), category},
        {QStringLiteral(":field_hockey:"), QString::fromUtf16(u"\U0001F3D1"), category},
        {QStringLiteral(":ice_hockey:"), QString::fromUtf16(u"\U0001F3D2"), category},
        {QStringLiteral(":lacrosse:"), QString::fromUtf16(u"\U0001F94D"), category},
        {QStringLiteral(":ping_pong:"), QString::fromUtf16(u"\U0001F3D3"), category},
        {QStringLiteral(":badminton:"), QString::fromUtf16(u"\U0001F3F8"), category},
        {QStringLiteral(":boxing_glove:"), QString::fromUtf16(u"\U0001F94A"), category},
        {QStringLiteral(":martial_arts_uniform:"), QString::fromUtf16(u"\U0001F94B"), category},
        {QStringLiteral(":goal_net:"), QString::fromUtf16(u"\U0001F945"), category},
        {QStringLiteral(":flag_in_hole:"), QString::fromUtf16(u"\U000026F3"), category},
        {QStringLiteral(":ice_skate:"), QString::fromUtf16(u"\U000026F8"), category},
        {QStringLiteral(":fishing_pole:"), QString::fromUtf16(u"\U0001F3A3"), category},
        {QStringLiteral(":diving_mask:"), QString::fromUtf16(u"\U0001F93F"), category},
        {QStringLiteral(":running_shirt:"), QString::fromUtf16(u"\U0001F3BD"), category},
        {QStringLiteral(":skis:"), QString::fromUtf16(u"\U0001F3BF"), category},
        {QStringLiteral(":sled:"), QString::fromUtf16(u"\U0001F6F7"), category},
        {QStringLiteral(":curling_stone:"), QString::fromUtf16(u"\U0001F94C"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeEmotionEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::EmotionEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":kiss_mark:"), QString::fromUtf16(u"\U0001F48B"), category},
        {QStringLiteral(":love_letter:"), QString::fromUtf16(u"\U0001F48C"), category},
        {QStringLiteral(":heart_with_arrow:"), QString::fromUtf16(u"\U0001F498"), category},
        {QStringLiteral(":heart_with_ribbon:"), QString::fromUtf16(u"\U0001F49D"), category},
        {QStringLiteral(":sparkling_heart:"), QString::fromUtf16(u"\U0001F496"), category},
        {QStringLiteral(":growing_heart:"), QString::fromUtf16(u"\U0001F497"), category},
        {QStringLiteral(":beating_heart:"), QString::fromUtf16(u"\U0001F493"), category},
        {QStringLiteral(":revolving_hearts:"), QString::fromUtf16(u"\U0001F49E"), category},
        {QStringLiteral(":two_hearts:"), QString::fromUtf16(u"\U0001F495"), category},
        {QStringLiteral(":heart_decoration:"), QString::fromUtf16(u"\U0001F49F"), category},
        {QStringLiteral(":heart_exclamation:"), QString::fromUtf16(u"\U00002763"), category},
        {QStringLiteral(":broken_heart:"), QString::fromUtf16(u"\U0001F494"), category},
        {QStringLiteral(":red_heart:"), QString::fromUtf16(u"\U00002764"), category},
        {QStringLiteral(":orange_heart:"), QString::fromUtf16(u"\U0001F9E1"), category},
        {QStringLiteral(":yellow_heart:"), QString::fromUtf16(u"\U0001F49B"), category},
        {QStringLiteral(":green_heart:"), QString::fromUtf16(u"\U0001F49A"), category},
        {QStringLiteral(":blue_heart:"), QString::fromUtf16(u"\U0001F499"), category},
        {QStringLiteral(":purple_heart:"), QString::fromUtf16(u"\U0001F49C"), category},
        {QStringLiteral(":brown_heart:"), QString::fromUtf16(u"\U0001F90E"), category},
        {QStringLiteral(":black_heart:"), QString::fromUtf16(u"\U0001F5A4"), category},
        {QStringLiteral(":white_heart:"), QString::fromUtf16(u"\U0001F90D"), category},
        {QStringLiteral(":hundred_points:"), QString::fromUtf16(u"\U0001F4AF"), category},
        {QStringLiteral(":anger_symbol:"), QString::fromUtf16(u"\U0001F4A2"), category},
        {QStringLiteral(":collision:"), QString::fromUtf16(u"\U0001F4A5"), category},
        {QStringLiteral(":dizzy:"), QString::fromUtf16(u"\U0001F4AB"), category},
        {QStringLiteral(":sweat_droplets:"), QString::fromUtf16(u"\U0001F4A6"), category},
        {QStringLiteral(":dashing_away:"), QString::fromUtf16(u"\U0001F4A8"), category},
        {QStringLiteral(":hole:"), QString::fromUtf16(u"\U0001F573"), category},
        {QStringLiteral(":bomb:"), QString::fromUtf16(u"\U0001F4A3"), category},
        {QStringLiteral(":speech_balloon:"), QString::fromUtf16(u"\U0001F4AC"), category},
        {QStringLiteral(":eye_in_speech_bubble:"), QString::fromUtf16(u"\U0001F441\U0000FE0F\U0000200D\U0001F5E8\U0000FE0F"), category},
        {QStringLiteral(":left_speech_bubble:"), QString::fromUtf16(u"\U0001F5E8"), category},
        {QStringLiteral(":right_anger_bubble:"), QString::fromUtf16(u"\U0001F5EF"), category},
        {QStringLiteral(":thought_balloon:"), QString::fromUtf16(u"\U0001F4AD"), category},
        {QStringLiteral(":zzz:"), QString::fromUtf16(u"\U0001F4A4"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeMoneyEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::MoneyEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":money_bag:"), QString::fromUtf16(u"\U0001F4B0"), category},
        {QStringLiteral(":yen_banknote:"), QString::fromUtf16(u"\U0001F4B4"), category},
        {QStringLiteral(":dollar_banknote:"), QString::fromUtf16(u"\U0001F4B5"), category},
        {QStringLiteral(":euro_banknote:"), QString::fromUtf16(u"\U0001F4B6"), category},
        {QStringLiteral(":pound_banknote:"), QString::fromUtf16(u"\U0001F4B7"), category},
        {QStringLiteral(":money_with_wings:"), QString::fromUtf16(u"\U0001F4B8"), category},
        {QStringLiteral(":credit_card:"), QString::fromUtf16(u"\U0001F4B3"), category},
        {QStringLiteral(":receipt:"), QString::fromUtf16(u"\U0001F9FE"), category},
        {QStringLiteral(":chart_increasing_with_yen:"), QString::fromUtf16(u"\U0001F4B9"), category},
        {QStringLiteral(":currency_exchange:"), QString::fromUtf16(u"\U0001F4B1"), category},
        {QStringLiteral(":heavy_dollar_sign:"), QString::fromUtf16(u"\U0001F4B2"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeBodyEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::BodyEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":waving_hand:"), QString::fromUtf16(u"\U0001F44B"), category},
        {QStringLiteral(":raised_back_of_hand:"), QString::fromUtf16(u"\U0001F91A"), category},
        {QStringLiteral(":hand_with_fingers_splayed:"), QString::fromUtf16(u"\U0001F590"), category},
        {QStringLiteral(":raised_hand:"), QString::fromUtf16(u"\U0000270B"), category},
        {QStringLiteral(":vulcan_salute:"), QString::fromUtf16(u"\U0001F596"), category},
        {QStringLiteral(":OK_hand:"), QString::fromUtf16(u"\U0001F44C"), category},
        {QStringLiteral(":pinching_hand:"), QString::fromUtf16(u"\U0001F90F"), category},
        {QStringLiteral(":victory_hand:"), QString::fromUtf16(u"\U0000270C"), category},
        {QStringLiteral(":crossed_fingers:"), QString::fromUtf16(u"\U0001F91E"), category},
        {QStringLiteral(":love-you_gesture:"), QString::fromUtf16(u"\U0001F91F"), category},
        {QStringLiteral(":sign_of_the_horns:"), QString::fromUtf16(u"\U0001F918"), category},
        {QStringLiteral(":call_me_hand:"), QString::fromUtf16(u"\U0001F919"), category},
        {QStringLiteral(":backhand_index_pointing_left:"), QString::fromUtf16(u"\U0001F448"), category},
        {QStringLiteral(":backhand_index_pointing_right:"), QString::fromUtf16(u"\U0001F449"), category},
        {QStringLiteral(":backhand_index_pointing_up:"), QString::fromUtf16(u"\U0001F446"), category},
        {QStringLiteral(":middle_finger:"), QString::fromUtf16(u"\U0001F595"), category},
        {QStringLiteral(":backhand_index_pointing_down:"), QString::fromUtf16(u"\U0001F447"), category},
        {QStringLiteral(":index_pointing_up:"), QString::fromUtf16(u"\U0000261D"), category},
        {QStringLiteral(":thumbs_up:"), QString::fromUtf16(u"\U0001F44D"), category},
        {QStringLiteral(":thumbs_down:"), QString::fromUtf16(u"\U0001F44E"), category},
        {QStringLiteral(":raised_fist:"), QString::fromUtf16(u"\U0000270A"), category},
        {QStringLiteral(":oncoming_fist:"), QString::fromUtf16(u"\U0001F44A"), category},
        {QStringLiteral(":left-facing_fist:"), QString::fromUtf16(u"\U0001F91B"), category},
        {QStringLiteral(":right-facing_fist:"), QString::fromUtf16(u"\U0001F91C"), category},
        {QStringLiteral(":clapping_hands:"), QString::fromUtf16(u"\U0001F44F"), category},
        {QStringLiteral(":raising_hands:"), QString::fromUtf16(u"\U0001F64C"), category},
        {QStringLiteral(":open_hands:"), QString::fromUtf16(u"\U0001F450"), category},
        {QStringLiteral(":palms_up_together:"), QString::fromUtf16(u"\U0001F932"), category},
        {QStringLiteral(":handshake:"), QString::fromUtf16(u"\U0001F91D"), category},
        {QStringLiteral(":folded_hands:"), QString::fromUtf16(u"\U0001F64F"), category},
        {QStringLiteral(":writing_hand:"), QString::fromUtf16(u"\U0000270D"), category},
        {QStringLiteral(":nail_polish:"), QString::fromUtf16(u"\U0001F485"), category},
        {QStringLiteral(":selfie:"), QString::fromUtf16(u"\U0001F933"), category},
        {QStringLiteral(":flexed_biceps:"), QString::fromUtf16(u"\U0001F4AA"), category},
        {QStringLiteral(":mechanical_arm:"), QString::fromUtf16(u"\U0001F9BE"), category},
        {QStringLiteral(":mechanical_leg:"), QString::fromUtf16(u"\U0001F9BF"), category},
        {QStringLiteral(":leg:"), QString::fromUtf16(u"\U0001F9B5"), category},
        {QStringLiteral(":foot:"), QString::fromUtf16(u"\U0001F9B6"), category},
        {QStringLiteral(":ear:"), QString::fromUtf16(u"\U0001F442"), category},
        {QStringLiteral(":ear_with_hearing_aid:"), QString::fromUtf16(u"\U0001F9BB"), category},
        {QStringLiteral(":nose:"), QString::fromUtf16(u"\U0001F443"), category},
        {QStringLiteral(":brain:"), QString::fromUtf16(u"\U0001F9E0"), category},
        {QStringLiteral(":tooth:"), QString::fromUtf16(u"\U0001F9B7"), category},
        {QStringLiteral(":bone:"), QString::fromUtf16(u"\U0001F9B4"), category},
        {QStringLiteral(":eyes:"), QString::fromUtf16(u"\U0001F440"), category},
        {QStringLiteral(":eye:"), QString::fromUtf16(u"\U0001F441"), category},
        {QStringLiteral(":tongue:"), QString::fromUtf16(u"\U0001F445"), category},
        {QStringLiteral(":mouth:"), QString::fromUtf16(u"\U0001F444"), category},
        {QStringLiteral(":red_hair:"), QString::fromUtf16(u"\U0001F9B0"), category},
        {QStringLiteral(":curly_hair:"), QString::fromUtf16(u"\U0001F9B1"), category},
        {QStringLiteral(":white_hair:"), QString::fromUtf16(u"\U0001F9B3"), category},
        {QStringLiteral(":bald:"), QString::fromUtf16(u"\U0001F9B2"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeMailEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::MailEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":envelope:"), QString::fromUtf16(u"\U00002709"), category},
        {QStringLiteral(":e-mail:"), QString::fromUtf16(u"\U0001F4E7"), category},
        {QStringLiteral(":incoming_envelope:"), QString::fromUtf16(u"\U0001F4E8"), category},
        {QStringLiteral(":envelope_with_arrow:"), QString::fromUtf16(u"\U0001F4E9"), category},
        {QStringLiteral(":outbox_tray:"), QString::fromUtf16(u"\U0001F4E4"), category},
        {QStringLiteral(":inbox_tray:"), QString::fromUtf16(u"\U0001F4E5"), category},
        {QStringLiteral(":package:"), QString::fromUtf16(u"\U0001F4E6"), category},
        {QStringLiteral(":closed_mailbox_with_raised_flag:"), QString::fromUtf16(u"\U0001F4EB"), category},
        {QStringLiteral(":closed_mailbox_with_lowered_flag:"), QString::fromUtf16(u"\U0001F4EA"), category},
        {QStringLiteral(":open_mailbox_with_raised_flag:"), QString::fromUtf16(u"\U0001F4EC"), category},
        {QStringLiteral(":open_mailbox_with_lowered_flag:"), QString::fromUtf16(u"\U0001F4ED"), category},
        {QStringLiteral(":postbox:"), QString::fromUtf16(u"\U0001F4EE"), category},
        {QStringLiteral(":ballot_box_with_ballot:"), QString::fromUtf16(u"\U0001F5F3"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeOfficeEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::OfficeEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":pencil:"), QString::fromUtf16(u"\U0000270F"), category},
        {QStringLiteral(":black_nib:"), QString::fromUtf16(u"\U00002712"), category},
        {QStringLiteral(":fountain_pen:"), QString::fromUtf16(u"\U0001F58B"), category},
        {QStringLiteral(":pen:"), QString::fromUtf16(u"\U0001F58A"), category},
        {QStringLiteral(":paintbrush:"), QString::fromUtf16(u"\U0001F58C"), category},
        {QStringLiteral(":crayon:"), QString::fromUtf16(u"\U0001F58D"), category},
        {QStringLiteral(":memo:"), QString::fromUtf16(u"\U0001F4DD"), category},
        {QStringLiteral(":briefcase:"), QString::fromUtf16(u"\U0001F4BC"), category},
        {QStringLiteral(":file_folder:"), QString::fromUtf16(u"\U0001F4C1"), category},
        {QStringLiteral(":open_file_folder:"), QString::fromUtf16(u"\U0001F4C2"), category},
        {QStringLiteral(":card_index_dividers:"), QString::fromUtf16(u"\U0001F5C2"), category},
        {QStringLiteral(":calendar:"), QString::fromUtf16(u"\U0001F4C5"), category},
        {QStringLiteral(":tear-off_calendar:"), QString::fromUtf16(u"\U0001F4C6"), category},
        {QStringLiteral(":spiral_notepad:"), QString::fromUtf16(u"\U0001F5D2"), category},
        {QStringLiteral(":spiral_calendar:"), QString::fromUtf16(u"\U0001F5D3"), category},
        {QStringLiteral(":card_index:"), QString::fromUtf16(u"\U0001F4C7"), category},
        {QStringLiteral(":chart_increasing:"), QString::fromUtf16(u"\U0001F4C8"), category},
        {QStringLiteral(":chart_decreasing:"), QString::fromUtf16(u"\U0001F4C9"), category},
        {QStringLiteral(":bar_chart:"), QString::fromUtf16(u"\U0001F4CA"), category},
        {QStringLiteral(":clipboard:"), QString::fromUtf16(u"\U0001F4CB"), category},
        {QStringLiteral(":pushpin:"), QString::fromUtf16(u"\U0001F4CC"), category},
        {QStringLiteral(":round_pushpin:"), QString::fromUtf16(u"\U0001F4CD"), category},
        {QStringLiteral(":paperclip:"), QString::fromUtf16(u"\U0001F4CE"), category},
        {QStringLiteral(":linked_paperclips:"), QString::fromUtf16(u"\U0001F587"), category},
        {QStringLiteral(":straight_ruler:"), QString::fromUtf16(u"\U0001F4CF"), category},
        {QStringLiteral(":triangular_ruler:"), QString::fromUtf16(u"\U0001F4D0"), category},
        {QStringLiteral(":scissors:"), QString::fromUtf16(u"\U00002702"), category},
        {QStringLiteral(":card_file_box:"), QString::fromUtf16(u"\U0001F5C3"), category},
        {QStringLiteral(":file_cabinet:"), QString::fromUtf16(u"\U0001F5C4"), category},
        {QStringLiteral(":wastebasket:"), QString::fromUtf16(u"\U0001F5D1"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeToolsEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::ToolsEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":hammer:"), QString::fromUtf16(u"\U0001F528"), category},
        {QStringLiteral(":axe:"), QString::fromUtf16(u"\U0001FA93"), category},
        {QStringLiteral(":pick:"), QString::fromUtf16(u"\U000026CF"), category},
        {QStringLiteral(":hammer_and_pick:"), QString::fromUtf16(u"\U00002692"), category},
        {QStringLiteral(":hammer_and_wrench:"), QString::fromUtf16(u"\U0001F6E0"), category},
        {QStringLiteral(":dagger:"), QString::fromUtf16(u"\U0001F5E1"), category},
        {QStringLiteral(":crossed_swords:"), QString::fromUtf16(u"\U00002694"), category},
        {QStringLiteral(":pistol:"), QString::fromUtf16(u"\U0001F52B"), category},
        {QStringLiteral(":bow_and_arrow:"), QString::fromUtf16(u"\U0001F3F9"), category},
        {QStringLiteral(":shield:"), QString::fromUtf16(u"\U0001F6E1"), category},
        {QStringLiteral(":wrench:"), QString::fromUtf16(u"\U0001F527"), category},
        {QStringLiteral(":nut_and_bolt:"), QString::fromUtf16(u"\U0001F529"), category},
        {QStringLiteral(":gear:"), QString::fromUtf16(u"\U00002699"), category},
        {QStringLiteral(":clamp:"), QString::fromUtf16(u"\U0001F5DC"), category},
        {QStringLiteral(":balance_scale:"), QString::fromUtf16(u"\U00002696"), category},
        {QStringLiteral(":probing_cane:"), QString::fromUtf16(u"\U0001F9AF"), category},
        {QStringLiteral(":link:"), QString::fromUtf16(u"\U0001F517"), category},
        {QStringLiteral(":chains:"), QString::fromUtf16(u"\U000026D3"), category},
        {QStringLiteral(":toolbox:"), QString::fromUtf16(u"\U0001F9F0"), category},
        {QStringLiteral(":magnet:"), QString::fromUtf16(u"\U0001F9F2"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodePhoneEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::PhoneEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":mobile_phone:"), QString::fromUtf16(u"\U0001F4F1"), category},
        {QStringLiteral(":mobile_phone_with_arrow:"), QString::fromUtf16(u"\U0001F4F2"), category},
        {QStringLiteral(":telephone:"), QString::fromUtf16(u"\U0000260E"), category},
        {QStringLiteral(":telephone_receiver:"), QString::fromUtf16(u"\U0001F4DE"), category},
        {QStringLiteral(":pager:"), QString::fromUtf16(u"\U0001F4DF"), category},
        {QStringLiteral(":fax_machine:"), QString::fromUtf16(u"\U0001F4E0"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeLockEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::LockEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":locked:"), QString::fromUtf16(u"\U0001F512"), category},
        {QStringLiteral(":unlocked:"), QString::fromUtf16(u"\U0001F513"), category},
        {QStringLiteral(":locked_with_pen:"), QString::fromUtf16(u"\U0001F50F"), category},
        {QStringLiteral(":locked_with_key:"), QString::fromUtf16(u"\U0001F510"), category},
        {QStringLiteral(":key:"), QString::fromUtf16(u"\U0001F511"), category},
        {QStringLiteral(":old_key:"), QString::fromUtf16(u"\U0001F5DD"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeDrinkEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::DrinkEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":baby_bottle:"), QString::fromUtf16(u"\U0001F37C"), category},
        {QStringLiteral(":glass_of_milk:"), QString::fromUtf16(u"\U0001F95B"), category},
        {QStringLiteral(":hot_beverage:"), QString::fromUtf16(u"\U00002615"), category},
        {QStringLiteral(":teacup_without_handle:"), QString::fromUtf16(u"\U0001F375"), category},
        {QStringLiteral(":sake:"), QString::fromUtf16(u"\U0001F376"), category},
        {QStringLiteral(":bottle_with_popping_cork:"), QString::fromUtf16(u"\U0001F37E"), category},
        {QStringLiteral(":wine_glass:"), QString::fromUtf16(u"\U0001F377"), category},
        {QStringLiteral(":cocktail_glass:"), QString::fromUtf16(u"\U0001F378"), category},
        {QStringLiteral(":tropical_drink:"), QString::fromUtf16(u"\U0001F379"), category},
        {QStringLiteral(":beer_mug:"), QString::fromUtf16(u"\U0001F37A"), category},
        {QStringLiteral(":clinking_beer_mugs:"), QString::fromUtf16(u"\U0001F37B"), category},
        {QStringLiteral(":clinking_glasses:"), QString::fromUtf16(u"\U0001F942"), category},
        {QStringLiteral(":tumbler_glass:"), QString::fromUtf16(u"\U0001F943"), category},
        {QStringLiteral(":cup_with_straw:"), QString::fromUtf16(u"\U0001F964"), category},
        {QStringLiteral(":beverage_box:"), QString::fromUtf16(u"\U0001F9C3"), category},
        {QStringLiteral(":mate:"), QString::fromUtf16(u"\U0001F9C9"), category},
        {QStringLiteral(":ice:"), QString::fromUtf16(u"\U0001F9CA"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeVideoEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::VideoEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":movie_camera:"), QString::fromUtf16(u"\U0001F3A5"), category},
        {QStringLiteral(":film_frames:"), QString::fromUtf16(u"\U0001F39E"), category},
        {QStringLiteral(":film_projector:"), QString::fromUtf16(u"\U0001F4FD"), category},
        {QStringLiteral(":clapper_board:"), QString::fromUtf16(u"\U0001F3AC"), category},
        {QStringLiteral(":television:"), QString::fromUtf16(u"\U0001F4FA"), category},
        {QStringLiteral(":camera:"), QString::fromUtf16(u"\U0001F4F7"), category},
        {QStringLiteral(":camera_with_flash:"), QString::fromUtf16(u"\U0001F4F8"), category},
        {QStringLiteral(":video_camera:"), QString::fromUtf16(u"\U0001F4F9"), category},
        {QStringLiteral(":videocassette:"), QString::fromUtf16(u"\U0001F4FC"), category},
        {QStringLiteral(":magnifying_glass_tilted_left:"), QString::fromUtf16(u"\U0001F50D"), category},
        {QStringLiteral(":magnifying_glass_tilted_right:"), QString::fromUtf16(u"\U0001F50E"), category},
        {QStringLiteral(":candle:"), QString::fromUtf16(u"\U0001F56F"), category},
        {QStringLiteral(":light_bulb:"), QString::fromUtf16(u"\U0001F4A1"), category},
        {QStringLiteral(":flashlight:"), QString::fromUtf16(u"\U0001F526"), category},
        {QStringLiteral(":red_paper_lantern:"), QString::fromUtf16(u"\U0001F3EE"), category},
        {QStringLiteral(":diya_lamp:"), QString::fromUtf16(u"\U0001FA94"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeHouseEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::HouseEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":door:"), QString::fromUtf16(u"\U0001F6AA"), category},
        {QStringLiteral(":bed:"), QString::fromUtf16(u"\U0001F6CF"), category},
        {QStringLiteral(":couch_and_lamp:"), QString::fromUtf16(u"\U0001F6CB"), category},
        {QStringLiteral(":chair:"), QString::fromUtf16(u"\U0001FA91"), category},
        {QStringLiteral(":toilet:"), QString::fromUtf16(u"\U0001F6BD"), category},
        {QStringLiteral(":shower:"), QString::fromUtf16(u"\U0001F6BF"), category},
        {QStringLiteral(":bathtub:"), QString::fromUtf16(u"\U0001F6C1"), category},
        {QStringLiteral(":razor:"), QString::fromUtf16(u"\U0001FA92"), category},
        {QStringLiteral(":lotion_bottle:"), QString::fromUtf16(u"\U0001F9F4"), category},
        {QStringLiteral(":safety_pin:"), QString::fromUtf16(u"\U0001F9F7"), category},
        {QStringLiteral(":broom:"), QString::fromUtf16(u"\U0001F9F9"), category},
        {QStringLiteral(":basket:"), QString::fromUtf16(u"\U0001F9FA"), category},
        {QStringLiteral(":roll_of_paper:"), QString::fromUtf16(u"\U0001F9FB"), category},
        {QStringLiteral(":soap:"), QString::fromUtf16(u"\U0001F9FC"), category},
        {QStringLiteral(":sponge:"), QString::fromUtf16(u"\U0001F9FD"), category},
        {QStringLiteral(":fire_extinguisher:"), QString::fromUtf16(u"\U0001F9EF"), category},
        {QStringLiteral(":shopping_cart:"), QString::fromUtf16(u"\U0001F6D2"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeDishwareEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::DishwareEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":chopsticks:"), QString::fromUtf16(u"\U0001F962"), category},
        {QStringLiteral(":fork_and_knife_with_plate:"), QString::fromUtf16(u"\U0001F37D"), category},
        {QStringLiteral(":fork_and_knife:"), QString::fromUtf16(u"\U0001F374"), category},
        {QStringLiteral(":spoon:"), QString::fromUtf16(u"\U0001F944"), category},
        {QStringLiteral(":kitchen_knife:"), QString::fromUtf16(u"\U0001F52A"), category},
        {QStringLiteral(":amphora:"), QString::fromUtf16(u"\U0001F3FA"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeHotelEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::HotelEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":bellhop_bell:"), QString::fromUtf16(u"\U0001F6CE"), category},
        {QStringLiteral(":luggage:"), QString::fromUtf16(u"\U0001F9F3"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::unicodeAwardMedalEmoji()
{
    const EmoticonUnicodeUtils::EmoticonStruct::EmoticonType category = EmoticonUnicodeUtils::EmoticonStruct::AwardMedalEmoji;
    const QVector<EmoticonUnicodeUtils::EmoticonStruct> lst{
        {QStringLiteral(":military_medal:"), QString::fromUtf16(u"\U0001F396"), category},
        {QStringLiteral(":trophy:"), QString::fromUtf16(u"\U0001F3C6"), category},
        {QStringLiteral(":sports_medal:"), QString::fromUtf16(u"\U0001F3C5"), category},
        {QStringLiteral(":1st_place_medal:"), QString::fromUtf16(u"\U0001F947"), category},
        {QStringLiteral(":2nd_place_medal:"), QString::fromUtf16(u"\U0001F948"), category},
        {QStringLiteral(":3rd_place_medal:"), QString::fromUtf16(u"\U0001F949"), category},
    };
    return lst;
}

QVector<EmoticonUnicodeUtils::EmoticonStruct> EmoticonUnicodeUtils::allUnicode()
{
    return EmoticonUnicodeUtils::unicodeFlagsEmoji() + EmoticonUnicodeUtils::unicodeFaceEmoji() + EmoticonUnicodeUtils::unicodeAnimalsEmoji()
        + EmoticonUnicodeUtils::unicodePlantEmoji() + EmoticonUnicodeUtils::unicodeScienceEmoji() + EmoticonUnicodeUtils::unicodeComputerEmoji()
        + EmoticonUnicodeUtils::unicodeBookPaperEmoji() + EmoticonUnicodeUtils::unicodeSoundMusicEmoji() + EmoticonUnicodeUtils::unicodeWeatherEmoji()
        + EmoticonUnicodeUtils::unicodeTimeEmoji() + EmoticonUnicodeUtils::unicodeGameEmoji() + EmoticonUnicodeUtils::unicodeClothingEmoji()
        + EmoticonUnicodeUtils::unicodeEventEmoji() + EmoticonUnicodeUtils::unicodeFoodEmoji() + EmoticonUnicodeUtils::unicodeTransportEmoji()
        + EmoticonUnicodeUtils::unicodePersonEmoji() + EmoticonUnicodeUtils::unicodePlaceEmoji() + EmoticonUnicodeUtils::unicodeSymbolsEmoji()
        + EmoticonUnicodeUtils::unicodeSportEmoji() + EmoticonUnicodeUtils::unicodeEmotionEmoji() + EmoticonUnicodeUtils::unicodeMoneyEmoji()
        + EmoticonUnicodeUtils::unicodeBodyEmoji() + EmoticonUnicodeUtils::unicodeMailEmoji() + EmoticonUnicodeUtils::unicodeOfficeEmoji()
        + EmoticonUnicodeUtils::unicodeToolsEmoji() + EmoticonUnicodeUtils::unicodePhoneEmoji() + EmoticonUnicodeUtils::unicodeLockEmoji()
        + EmoticonUnicodeUtils::unicodeDrinkEmoji() + EmoticonUnicodeUtils::unicodeVideoEmoji() + EmoticonUnicodeUtils::unicodeHouseEmoji()
        + EmoticonUnicodeUtils::unicodeDishwareEmoji() + EmoticonUnicodeUtils::unicodeHotelEmoji() + EmoticonUnicodeUtils::unicodeAwardMedalEmoji();
}
