/*
    Copyright 2013 by Reza Fatahilah Shah <rshah0385@kireihana.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef SDDMKCM_H
#define SDDMKCM_H

#include <KQuickAddons/ManagedConfigModule>

class ThemeConfig;
class AdvancedConfig;
class SddmData;
class SddmSettings;
class ThemesModel;

class SddmKcm : public KQuickAddons::ManagedConfigModule
{
    Q_OBJECT
    Q_PROPERTY(SddmSettings *sddmSettings READ sddmSettings CONSTANT)
    Q_PROPERTY(ThemesModel *themesModel READ themesModel CONSTANT)
public:
    explicit SddmKcm(QObject *parent, const QVariantList &args);
    ~SddmKcm() override;

    Q_INVOKABLE static QString toLocalFile(const QUrl &url);
    Q_INVOKABLE void removeTheme(const QModelIndex &index);
    Q_INVOKABLE void installTheme(const QUrl &url);
    Q_INVOKABLE void synchronizeSettings();
    Q_INVOKABLE void resetSyncronizedSettings();

    SddmSettings *sddmSettings() const;
    ThemesModel *themesModel() const;
public Q_SLOTS:
    void save() override;
Q_SIGNALS:
    void errorOccured(const QString &message);

private:
    SddmData *m_data;
    ThemesModel *m_themesModel;
};

#endif // SDDMKCM_H
