/********************************************************************
 KWin - the KDE window manager
 This file is part of the KDE project.

Copyright (C) 2009 Martin Gräßlin <mgraesslin@kde.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*********************************************************************/
#ifndef KWINDECORATIONCONFIGDIALOG_H
#define KWINDECORATIONCONFIGDIALOG_H
#include <QWidget>
#include <QDialog>
#include <kdecoration.h>
#include <KSharedConfig>
#include "ui_config.h"
#include "ui_auroraeconfig.h"

class QDialogButtonBox;
namespace KWin
{

class KWinAuroraeConfigForm : public QWidget, public Ui::KWinAuroraeConfigForm
{
    Q_OBJECT

public:
    explicit KWinAuroraeConfigForm(QWidget* parent);
    void enableNoSideBorderSupport(bool enable);
Q_SIGNALS:
    void changed();
};

class KWinDecorationConfigForm : public QWidget, public Ui::KWinDecorationConfigForm
{
    Q_OBJECT

public:
    explicit KWinDecorationConfigForm(QWidget* parent);
};

class KWinDecorationConfigDialog : public QDialog, public KDecorationDefines
{
    Q_OBJECT
public:
    KWinDecorationConfigDialog(QString decoLib, const QList<QVariant>& borderSizes,
                               KDecorationDefines::BorderSize size, QWidget* parent = nullptr,
                               Qt::WFlags flags = 0);
    ~KWinDecorationConfigDialog();

    KDecorationDefines::BorderSize borderSize() const;

Q_SIGNALS:
    void pluginSave(KConfigGroup& group);

private Q_SLOTS:
    void slotSelectionChanged();
    void slotAccepted();
    void slotDefault();

private:
    int borderSizeToIndex(KDecorationDefines::BorderSize size, const QList<QVariant>& sizes);

private:
    KWinDecorationConfigForm* m_ui;
    QList<QVariant> m_borderSizes;
    KSharedConfigPtr m_kwinConfig;

    QObject*(*allocatePlugin)(KConfigGroup& conf, QWidget* parent);
    QObject* m_pluginObject;
    QWidget* m_pluginConfigWidget;
    QDialogButtonBox* m_buttons;
};

} // namespace KWin

#endif // KWINDECORATIONCONFIGDIALOG_H
