(Originally written by Alvin on 2020-06-02 ~ 2020-06-03)

Documentation sources:

- https://docs.microsoft.com/en-us/windows/msix/desktop/desktop-to-uwp-manual-conversion
- https://docs.microsoft.com/en-us/uwp/schemas/appxpackage/appx-package-manifest
- https://docs.microsoft.com/en-us/previous-versions/windows/dn934795%28v%3dwin.10%29
- https://docs.microsoft.com/en-us/windows/uwp/design/style/app-icons-and-logos


Assets
---

Most of the assets starts out extracted from the package that the MSIX
Packaging Tool generated, with `fileicon.png` being the exception. Since the
assets are target-based, we need to use `makepri` to generate a `pri` file.

The assets are placed under the `Assets` dir when inside the package, so this
dir structure needs to be replicated. Also, in order to not mess up `makepri`,
the `Assets` dir needs to be placed in its own dir with no other files in it.
I chose to name it `pkg`.

I generated a `priconfig.xml` file using this command:

```
makepri.exe createconfig /cf priconfig.xml /dq en-us
```

... however I also commented out the `packaging` section.

Read more about the app icons on https://docs.microsoft.com/en-us/windows/uwp/design/style/app-icons-and-logos

TODO: On editing the assets...


Manifest
---

The manifest is constructed by referencing the official documentation and the
two manifests generated by DAC (as in Krita 4.2.8 store version) and MSIX
Packaging Tool. A huge portion is manually rewritten though.

There are several issues that couldn't be resolved:

- The property handler just doesn't work so it has been commented out.
- Explorer doesn't add the drop shadow to the thumbnail. In Win32 there is a
  registry value to change it but there is no such option in the manifest.
- Explorer doesn't load the preview image on the preview pane. In Win32 the
  image provided by the thumbnail handler is automatically used, but not for
  Appx for some reason?


Building the MSIX
---

Needs:

- Latest Windows SDK (though I've tested with 10.0.17763.0 and10.0.18362.0)
- Krita x64 NSIS installer EXE file
- 7-Zip
- The cert to sign the package with

Steps (if running manually):

1. Extract the EXE installer to somewhere **outside of the source tree** using
   7-Zip (don't run the installer!)
2. Remove `$PLUGINSDIR` and `uninstall.exe.nsis`/`uninstall.exe` inside
3. Copy `manifest.xml.in` into `manifest.xml` then make necessary amendments to
   it, including replacing the `@`-substitutions.
4. Start a command prompt in this dir, then run
   `set KRITA_DIR=C:\path\where\you\extracted\the\Krita\files`, and then run
   `build_msix.cmd`.
    - If you need to specify the keyfile and password used to sign the MSIX
      file, execute the following command before running the final script:
        ```
        set SIGNTOOL_SIGN_FLAGS=/f "absolute_path_to_keyfile.pfx" /p password
        ```
5. Install and test `out\krita.msix`

The script and related resources are also configured and installed into
`${CMAKE_INSTALL_PREFIX}/krita-msix`, which is then used by the Binary Factory
pipeline. On the Binary Factory, we also need to set `KRITA_SHELLEX` for it
to copy the files required for the shell extension.


Self-signing the package for testing purposes
---------------------------------------------

1. Make a backup of the built pacakge if needed. You will **not** be able to remove the signature after it has been added.
2. Generate a fake certificate for signing by running this command in PowerShell:
   ```
   New-SelfSignedCertificate -Type Custom -Subject "CN=03E730BB-6849-4762-9BDB-10CD7FFDB2C1" -KeyUsage DigitalSignature -FriendlyName "Fake Krita Foundation certificate for debugging only" -CertStoreLocation "Cert:\CurrentUser\My" -TextExtension @("2.5.29.37={text}1.3.6.1.5.5.7.3.3", "2.5.29.19={text}")
   ```
   This command will add the certificate into your 'Personal' storage.
3. Go to 'Manage User Certificates' Windows applet. Export the key into a .ppk file
4. Go to 'Manage Computer Certificates' (needs Administrator rights)
5. Import your .ppk file into "Trusted Root Certificates" storage.
6. Copy the certificate (by Ctrl+D&D) into "Trusted Publishers" section.
