/*
    This file is part of the KDE libraries
    SPDX-FileCopyrightText: 2000 David Faure <faure@kde.org>

    SPDX-License-Identifier: LGPL-2.0-only
*/

#include "kio/skipdialog.h"

#include <assert.h>
#include <stdio.h>

#include <QDialogButtonBox>
#include <QLabel>
#include <QPushButton>
#include <QVBoxLayout>
#include <QWidget>

#include <KLocalizedString>

using namespace KIO;

SkipDialog::SkipDialog(QWidget *parent, KIO::SkipDialog_Options options, const QString &_error_text)
    : QDialog(parent)
    , d(nullptr)
{
    setWindowTitle(i18n("Information"));

    QVBoxLayout *layout = new QVBoxLayout(this);

    auto *label = new QLabel(_error_text, this);
    label->setWordWrap(true);
    layout->addWidget(label);

    QDialogButtonBox *buttonBox = new QDialogButtonBox(this);
    layout->addWidget(buttonBox);

    // Retrying to e.g. copy a file with "*" in the name to a fat32
    // partition will always fail
    if (options & SkipDialog_Replace_Invalid_Chars) {
        QPushButton *replaceCharButton = new QPushButton(i18n("Replace"));
        connect(replaceCharButton, &QAbstractButton::clicked, this, [this]() {
            done(KIO::Result_ReplaceInvalidChars);
        });
        buttonBox->addButton(replaceCharButton, QDialogButtonBox::ActionRole);
    } else {
        QPushButton *retryButton = new QPushButton(i18n("Retry"));
        connect(retryButton, &QAbstractButton::clicked, this, &SkipDialog::retryPressed);
        buttonBox->addButton(retryButton, QDialogButtonBox::ActionRole);
    }

    if (options & SkipDialog_MultipleItems) {
        if (options & SkipDialog_Replace_Invalid_Chars) {
            QPushButton *autoReplaceButton = new QPushButton(i18n("Replace All"));
            connect(autoReplaceButton, &QAbstractButton::clicked, this, [this]() {
                done(KIO::Result_ReplaceAllInvalidChars);
            });
            buttonBox->addButton(autoReplaceButton, QDialogButtonBox::ActionRole);
        }

        QPushButton *skipButton = new QPushButton(i18n("Skip"));
        connect(skipButton, &QAbstractButton::clicked, this, &SkipDialog::skipPressed);
        buttonBox->addButton(skipButton, QDialogButtonBox::ActionRole);

        QPushButton *autoSkipButton = new QPushButton(i18n("Skip All"));
        connect(autoSkipButton, &QAbstractButton::clicked, this, &SkipDialog::autoSkipPressed);
        buttonBox->addButton(autoSkipButton, QDialogButtonBox::ActionRole);
    }

    buttonBox->addButton(QDialogButtonBox::Cancel);
    connect(buttonBox, &QDialogButtonBox::rejected, this, &SkipDialog::cancelPressed);

    resize(sizeHint());
}

SkipDialog::~SkipDialog()
{
}

void SkipDialog::cancelPressed()
{
    done(KIO::Result_Cancel);
}

void SkipDialog::skipPressed()
{
    done(KIO::Result_Skip);
}

void SkipDialog::autoSkipPressed()
{
    done(KIO::Result_AutoSkip);
}

void SkipDialog::retryPressed()
{
    done(KIO::Result_Retry);
}
