/*  -*- C++ -*-
 *  Copyright (C) 1998 <developer@mozilla.org>
 *
 *
 *  Permission is hereby granted, free of charge, to any person obtaining
 *  a copy of this software and associated documentation files (the
 *  "Software"), to deal in the Software without restriction, including
 *  without limitation the rights to use, copy, modify, merge, publish,
 *  distribute, sublicense, and/or sell copies of the Software, and to
 *  permit persons to whom the Software is furnished to do so, subject to
 *  the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included
 *  in all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 *  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 *  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 *  LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 *  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 *  WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "CharDistribution.h"

#include "tables/JISFreq.tab"
#include "tables/Big5Freq.tab"
#include "tables/EUCKRFreq.tab"
#include "tables/EUCTWFreq.tab"
#include "tables/GB2312Freq.tab"

#define SURE_YES 0.99f
#define SURE_NO  0.01f

namespace kencodingprober
{
//return confidence base on received data
float CharDistributionAnalysis::GetConfidence()
{
    //if we didn't receive any character in our consideration range, return negative answer
    if (mTotalChars <= 0) {
        return SURE_NO;
    }

    if (mTotalChars != mFreqChars) {
        float r = mFreqChars / ((mTotalChars - mFreqChars) * mTypicalDistributionRatio);

        if (r < SURE_YES) {
            return r;
        }
    }
    //normalize confidence, (we don't want to be 100% sure)
    return SURE_YES;
}

EUCTWDistributionAnalysis::EUCTWDistributionAnalysis()
{
    mCharToFreqOrder = EUCTWCharToFreqOrder;
    mTableSize = EUCTW_TABLE_SIZE;
    mTypicalDistributionRatio = EUCTW_TYPICAL_DISTRIBUTION_RATIO;
}

EUCKRDistributionAnalysis::EUCKRDistributionAnalysis()
{
    mCharToFreqOrder = EUCKRCharToFreqOrder;
    mTableSize = EUCKR_TABLE_SIZE;
    mTypicalDistributionRatio = EUCKR_TYPICAL_DISTRIBUTION_RATIO;
}

GB2312DistributionAnalysis::GB2312DistributionAnalysis()
{
    mCharToFreqOrder = GB2312CharToFreqOrder;
    mTableSize = GB2312_TABLE_SIZE;
    mTypicalDistributionRatio = GB2312_TYPICAL_DISTRIBUTION_RATIO;
}

Big5DistributionAnalysis::Big5DistributionAnalysis()
{
    mCharToFreqOrder = Big5CharToFreqOrder;
    mTableSize = BIG5_TABLE_SIZE;
    mTypicalDistributionRatio = BIG5_TYPICAL_DISTRIBUTION_RATIO;
}

SJISDistributionAnalysis::SJISDistributionAnalysis()
{
    mCharToFreqOrder = JISCharToFreqOrder;
    mTableSize = JIS_TABLE_SIZE;
    mTypicalDistributionRatio = JIS_TYPICAL_DISTRIBUTION_RATIO;
}

EUCJPDistributionAnalysis::EUCJPDistributionAnalysis()
{
    mCharToFreqOrder = JISCharToFreqOrder;
    mTableSize = JIS_TABLE_SIZE;
    mTypicalDistributionRatio = JIS_TYPICAL_DISTRIBUTION_RATIO;
}
}

