#ifndef SLIDESHOW_H
#define SLIDESHOW_H

#include <qwidget.h>
#include <qevent.h>
#include <kfileitem.h>

class QSize;
class QPixmap;
class QTimer;
class QPopupMenu;

class SlideShow : public QWidget {

    Q_OBJECT

public:

    enum FileNamePosition {
        Off = 0,
        AtTop,
        AtBottom
    };

    SlideShow(const KFileItemList& itemList,
              int timeDelay=3000,
              bool transitionEffect=false,
              int fileNamePos=Off,
              WFlags fl=WType_Popup|WDestructiveClose);
    ~SlideShow();


private:

    QTimer* mTimer;
    QTimer* mTimerSlide;

    KFileItemList mItemList;
    KFileItem* mCurrentItem;

    QPixmap mPrevPixmap;
    QPixmap mCurrentPixmap;
    QPixmap mNextPixmap;

    QSize mDesktopSize;
    QSize mScaledSize;
    int mTimeDelay;
    int mFileNamePosition;

    int* mIntArray;
    bool mEffectRunning;
    bool mPaused;
    bool mTransitionEffect;
    bool mCompleted;
    bool mShowingLastImage;

    QPopupMenu* mPopMenu;

private slots:

    void slot_timeout();
    void slot_timeoutSlide();

private:

    void loadNextImage(const KFileItem* fileItem);
    void loadLastPixmap();
    bool runEffect(bool restart);
    void mouseReleaseEvent(QMouseEvent *event);

    void pause();
    void resume();

};

#endif
