#include <qdir.h>
#include <kconfig.h>

#include "generalsettings.h"

GeneralSettings::GeneralSettings()
{
    config = new KConfig("digikamrc");
    mAlbumPath = QDir::homeDirPath();
    mDefaultIconSize = "Medium";
    mSlideShowDelay = 2;
    mSlideShowTransitionEffect = true;
    mSlideShowFileName = "Off";
    mCameraViewBGColor = QColor(231,235,217);
    mUseInternalImageViewer = true;
    mImageViewer = "";
}

GeneralSettings::~GeneralSettings()
{
    delete config;
}

void GeneralSettings::readSettings()
{
    config->setGroup("Album Settings");
    if (config->hasKey("Album Path"))
        mAlbumPath = config->readEntry("Album Path");

    config->setGroup("General Settings");

    if (config->hasKey("Default Icon Size"))
        mDefaultIconSize = config->readEntry("Default Icon Size");

    if (config->hasKey("SlideShow Delay"))
        mSlideShowDelay = config->readNumEntry("SlideShow Delay");

    if (config->hasKey("SlideShow Transition Effect"))
        mSlideShowTransitionEffect =
            config->readBoolEntry("SlideShow Transition Effect");

    if (config->hasKey("SlideShow Show Filename"))
        mSlideShowFileName =
            config->readEntry("SlideShow Show Filename");

    if (config->hasKey("CameraView Background Color"))
        mCameraViewBGColor =
            config->readColorEntry("CameraView Background Color");

    if (config->hasKey("Use Internal ImageViewer"))
        mUseInternalImageViewer =
            config->readBoolEntry("Use Internal ImageViewer");

    if (config->hasKey("Image Viewer"))
        mImageViewer =
            config->readEntry("Image Viewer");

}

void GeneralSettings::saveSettings()
{
    config->setGroup("Album Settings");
    config->writeEntry("Album Path",mAlbumPath);

    config->setGroup("General Settings");

    config->writeEntry("Default Icon Size",mDefaultIconSize);

    QString slideShowDelayStr;
    slideShowDelayStr.setNum(mSlideShowDelay);
    config->writeEntry("SlideShow Delay", slideShowDelayStr);

    QString slideShowTransitionEffectStr;
    if (mSlideShowTransitionEffect)
        slideShowTransitionEffectStr = "true";
    else
        slideShowTransitionEffectStr = "false";
    config->writeEntry("SlideShow Transition Effect",
                       slideShowTransitionEffectStr);

    config->writeEntry("SlideShow Show Filename", mSlideShowFileName);

    config->writeEntry("CameraView Background Color",
                       mCameraViewBGColor);

    if (mUseInternalImageViewer)
        config->writeEntry("Use Internal ImageViewer", "true");
    else
        config->writeEntry("Use Internal ImageViewer", "false");

    if (!mImageViewer.isEmpty())
        config->writeEntry("Image Viewer",mImageViewer);


    config->sync();

}
