/***************************************************************************
                          digikam.h  -  description
                             -------------------
    begin                : Thu Jul 18 14:58:17 CDT 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DIGIKAM_H
#define DIGIKAM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>

#include "thumbnailsize.h"

class DigikamView;

class KStatusBar;
class KProgress;
class KAction;
class KToggleAction;
class KActionMenu;
class KConfig;

class QString;

/** Digikam is the base class of the project */
class Digikam : public KMainWindow
{
    Q_OBJECT

public:

    /** construtor */
    Digikam();

    /** destructor */
    ~Digikam();

private:

    // View variables
    DigikamView *mView;
    KStatusBar *mStatusBar;
    KProgress  *mProgressBar;

    // Configuration Variables
    ThumbnailSize mThumbnailSize;
    KConfig *config;

    // Album Actions
    KAction *albumNewAction;
    KAction *albumDeleteAction;
    KAction *albumSlideShowAction;
    KAction *albumRefreshAction;
    KAction *albumRegenerateThumbnailsAction;
    KToggleAction *albumPauseThumbnailsAction;

    // Camera Actions
    KAction* camConnectAction;
    KAction* camDisconnectAction;

    KActionMenu* camDownloadAction;
    KAction* camDownloadSelectedAction;
    KAction* camDownloadAllAction;

    KActionMenu* camDeleteAction;
    KAction* camDeleteSelectedAction;
    KAction* camDeleteAllAction;

    KAction* camCancelAction;

    KAction* camCameraInfoAction;

    KAction* camMkFolderAction;
    KAction* camDelFolderAction;
    KAction* camUploadAction;

    // General App Actions

    KAction* appSetupAction;

    KAction* appSelectAllAction;
    KAction* appSelectNoneAction;
    KAction* appSelectInvertAction;

    KToggleAction* appFolderHideAction;
    KToggleAction* appCameraFolderHideAction;
    KToggleAction* appAlbumFolderHideAction;


    KAction* appThumbSizePlusAction;
    KAction* appThumbSizeMinusAction;

    KAction* appQuitAction;


private:

    void setupView();
    void setupActions();
    void setupConnections();

private slots:

    void slot_cameraConnected(bool val);
    void slot_setStatusMsg(const QString& msg);
    void slot_setProgressVal(int val);
    void slot_resetStatusBar();
    void slot_cameraBusy();
    void slot_cameraIdle();

    void slot_appSetup();
    void slot_appSetupFinished();

    void slot_thumbSizePlus();
    void slot_thumbSizeMinus();

    void slot_hideStatusBar();
    void slot_exit();
};

#endif
