#include <qstring.h>
#include <qstringlist.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qpen.h>
#include <qpoint.h>
#include <qpopmenu.h>
#include <qvaluevector.h>

#include <ktrader.h>
#include <kiconloader.h>
#include <klocale.h>

#include "cameradragobject.h"
#include "camerafileiteminfo.h"
#include "camerafileiteminfodialog.h"
#include "cameraiconitem.h"
#include "cameraiconview.h"

CameraIconView::CameraIconView(QWidget *parent) :
    QIconView(parent)
{
    setGridX(mThumbSize.getSizeAsNumber() + 10);
    setGridY(mThumbSize.getSizeAsNumber() + 20);
    setAutoArrange(true);
    setSelectionMode(QIconView::Extended);
    setResizeMode(QIconView::Adjust);
    setSpacing(0);

    mUseInternalImageViewer = true;
    mImageViewerName = "";

    connect(this, SIGNAL(doubleClicked(QIconViewItem*)),
            this, SLOT(slot_doubleClicked(QIconViewItem*)));
    connect(this, SIGNAL(rightButtonClicked(QIconViewItem*,const QPoint&)),
            this, SLOT(slot_rightClicked(QIconViewItem*,const QPoint&)));

}

CameraIconView::~CameraIconView()
{
}


void CameraIconView::setBackGroundColor(const QColor& color)
{
    if (color.isValid())
        setPaletteBackgroundColor(color);
}

void CameraIconView::setThumbnailSize(const ThumbnailSize& thumbSize)
{
    if (mThumbSize == thumbSize)
        return;
    mThumbSize = thumbSize;
    setGridX(mThumbSize.getSizeAsNumber() + 10);
    setGridY(mThumbSize.getSizeAsNumber() + 20);
}

ThumbnailSize CameraIconView::getThumbnailSize()
{
    return mThumbSize;
}

void CameraIconView::resizeThumbnails(const ThumbnailSize& thumbSize)
{
    if (mThumbSize == thumbSize)
        return;

    mThumbSize = thumbSize;
    setGridX(mThumbSize.getSizeAsNumber() + 10);
    setGridY(mThumbSize.getSizeAsNumber() + 20);
    emit signal_resizeThumbnails();
}


void CameraIconView::slot_rightClicked(QIconViewItem* item,
                                       const QPoint& pos)
{
    if (!item) return;

    CameraIconItem *camItem =
        static_cast<CameraIconItem*>(item);
    if (!camItem) return;

    QPopupMenu *popMenu = new QPopupMenu();
    QPopupMenu *openWithMenu = new QPopupMenu();

    //---------------------------------------------------------------------------

    QValueVector<KService::Ptr> serviceVector;

    KTrader::OfferList offers =
        KTrader::self()->query(camItem->fileInfo()->getMime(),
                               "Type == 'Application'");

    KTrader::OfferList::Iterator iter;
    KService::Ptr ptr;
    int index = 100;
    for( iter = offers.begin(); iter != offers.end(); ++iter ) {
        ptr = *iter;
        openWithMenu->insertItem( ptr->pixmap(KIcon::Small),
                                  ptr->name(), index++);
        serviceVector.push_back(ptr);
    }

    //---------------------------------------------------------------------------

    popMenu->insertItem( BarIcon("image", KIcon::SizeSmall),
                        i18n("View"), 10);
    popMenu->insertItem( i18n("Open With ..."), openWithMenu, 11);
    popMenu->insertItem( i18n("Properties ..."), 12);
    popMenu->insertSeparator();
    popMenu->insertItem( BarIcon("filesave", KIcon::SizeSmall),
                         i18n("Save"), 13);
    popMenu->insertItem( BarIcon("edittrash", KIcon::SizeSmall),
                         i18n("Delete"), 14);

    int id = popMenu->exec(pos);
    switch (id) {

    case 10: {
        emit signal_openItem(camItem, 0);
        break;
    }

    case 12: {
        CameraFileItemInfoDialog* fileInfoDlg =
            new CameraFileItemInfoDialog(*(camItem->fileInfo()));
        fileInfoDlg->show();
        break;
    }

    case 13: {
        emit signal_downloadSelectedItems();
        break;
    }

    case 14: {
        emit signal_deleteSelectedItems();
        break;
    }

    default:
        break;
    }

    //---------------------------------------------------------------------------

    KService::Ptr camItemServicePtr = 0;

    if (id >= 100) {
        camItemServicePtr = serviceVector[id-100];
        emit signal_openItem(camItem, camItemServicePtr);
    }

    //---------------------------------------------------------------------------

    serviceVector.clear();
    delete openWithMenu;
    delete popMenu;
}

void CameraIconView::slot_doubleClicked(QIconViewItem* item)
{
    if (!item) return;
    CameraIconItem* camItem = static_cast<CameraIconItem *>(item);
    if (!camItem) return;

    if (mUseInternalImageViewer) {
        emit signal_openItem(camItem, 0);
    }
    else {
        KService::Ptr imageServicePtr;
        imageServicePtr =
            KService::serviceByDesktopName(mImageViewerName.lower());
        if  (imageServicePtr) {
            emit signal_openItem(camItem, imageServicePtr);
        }
    }
}

void CameraIconView::setImageViewerParams(bool useInternal,
                                          const QString& viewerName)
{
    mUseInternalImageViewer = useInternal;
    mImageViewerName = viewerName;

}


// -- Drag ---------------------------------------------

void CameraIconView::startDrag()
{
    QStringList nameList;
    QStringList folderList;

    for (QIconViewItem *it = firstItem(); it; it=it->nextItem()) {
        if (it->isSelected()) {
            CameraIconItem* camItem =
                static_cast<CameraIconItem *>(it);
            nameList.append(camItem->fileInfo()->getName());
            folderList.append(camItem->fileInfo()->getFolder());
        }
    }

    if (nameList.isEmpty()) return;


    CameraDragObject* drag = new CameraDragObject(nameList,
                                                  folderList,
                                                  this);
    drag->setPixmap(SmallIcon("image"));
    drag->dragCopy();
}

