#include <qpixmap.h>

#include "camerafileiteminfo.h"
#include "camerafileitem.h"


CameraFileItem::CameraFileItem(const CameraFileItemInfo&
                               _fileInfo) :
    QObject()
{
    mFileInfo = new CameraFileItemInfo(_fileInfo);
    mThumbnail = 0;
}

CameraFileItem::~CameraFileItem()
{
    emit signal_deleted();

    if (mFileInfo)
        delete mFileInfo;
    if (mThumbnail)
        delete mThumbnail;
}

void CameraFileItem::setPixmap(const QPixmap& pixmap)
{
    if (pixmap.isNull())
        return;

    if (mThumbnail)
        delete mThumbnail;

    mThumbnail = new QPixmap(pixmap);

    emit signal_thumbnailChanged();
}

QPixmap* CameraFileItem::pixmap() const
{
    return mThumbnail;
}

CameraFileItemInfo* CameraFileItem::fileInfo() const
{
    return mFileInfo;
}

void CameraFileItem::setDownloaded(bool val)
{
    if (val)
        mFileInfo->setDownloaded(1);
    else
        mFileInfo->setDownloaded(0);

    emit signal_downloadStatusChanged();

}
