/***************************************************************************
                          image_viewer.cpp  -  description
                             -------------------
    begin                : Tue Jan 15 2002
    copyright            : (C) 2002 by Renchi Raju
    email                : renchi@green.tam.uiuc.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qevent.h>
#include <qsize.h>
#include <qrect.h>
#include <qapplication.h>

#include "image_viewer.h"

#include <iostream.h>

Image_Viewer::Image_Viewer(QWidget* parent,  const char* name, bool modal, WFlags fl)
  : QScrollView(parent, name)
{
}

Image_Viewer::~Image_Viewer(){
}

void Image_Viewer::loadImage(QString filePath) {
  image.load(filePath);
  if (image.isNull()) return;


  QWidget *d = QApplication::desktop();
  if (image.width() > d->width() || image.height() > d->height()) {
    int w, h;
    if (image.width() > d->width()) {
      w= (int) (d->width()*0.90);
      h= (int) (image.height()*((float)w/(float)image.width()));
    }
    if (image.height() > d->height()){
      h= (int) (d->height()*0.90);
      w= (int) (image.width()*((float)h/(float)image.height()));
    }
    image = image.smoothScale(w,h);
  }

  pixmap.convertFromImage(image);
  resizeContents(pixmap.width(), pixmap.height() );
  resize(pixmap.size());
}

void Image_Viewer::drawContents(QPainter* painter,int clipx,int clipy,int clipw,int cliph) {
  
  int scale = 1;
  if (pixmap.isNull()) {
    painter->eraseRect(clipx,clipy,clipw,cliph);
  } else {
    painter->scale(scale,scale);
    painter->drawPixmap( int(clipx/scale),int(clipy/scale),
			 pixmap,
			 int(clipx/scale)-1,int(clipy/scale)-1,
			 int(clipw/scale)+2,int(cliph/scale)+2 );
  }

}

