/*  This file is part of the KDE project
    Copyright (C) 2008 Dario Freddi <drf54321@gmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.

*/

#include "AuthorizationsFilterModel.h"

#include "AuthorizationsModel.h"
#include "pkitem.h"

#include <KDebug>

namespace PolkitKde
{

AuthorizationsFilterModel::AuthorizationsFilterModel(QObject *parent)
        : QSortFilterProxyModel(parent)
{
}

AuthorizationsFilterModel::~AuthorizationsFilterModel()
{
}

bool AuthorizationsFilterModel::filterAcceptsRow(int source_row, const QModelIndex &source_parent) const
{
    QModelIndex index = sourceModel()->index(source_row, 0, source_parent);

    if (((AbstractItem*)index.internalPointer())->isGroup()) {
        return true;
    }

    return (sourceModel()->data(index, AuthorizationsModel::IdRole).toString().contains(filterRegExp()) ||
            sourceModel()->data(index, Qt::DisplayRole).toString().contains(filterRegExp()));
}

}

#include "AuthorizationsFilterModel.moc"
