/* -*- c++ -*-
 *
 * roompage.h
 *
 * Copyright (C) 2003,2004 Sebastian Sauer <mail@dipe.org>
 * Copyright (C) 2003,2004 Petter Stokke <ummo@hellokitty.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __kmldonkey_roompage_h__
#define __kmldonkey_roompage_h__

#include <qmap.h>
#include <qvbox.h>
#include <qsplitter.h>
#include <klocale.h>
#include <ktextbrowser.h>

#include "page.h"
#include "infolist.h"
#include "roominfo.h"

#include <kdeversion.h>

class KTabWidget;

class RoomListViewItem : public InfoItem
{
public:
    RoomListViewItem(KListView* parent, int roomid) : InfoItem(parent, roomid) {}
    ~RoomListViewItem() {}

    QString xtext(int col) const;
    double numeric(int col) const;
    bool isNumeric(int col) const;

    int roomNo() { return fileno; } // fileno comes from InfoItem and we (re-)use it as our roomid
};

class RoomListView : public InfoList
{
public:
    RoomListView(QWidget* parent);
    ~RoomListView();

    RoomListViewItem* getItem(int id);
    void updateItem(int id, RoomInfo* ri);
    void clear();

private:
    QIntDict<RoomListViewItem> items; // for faster access to the items per roomid
};

class RoomTab : public QVBox
{
public:
    RoomTab(QWidget* parent, RoomInfo* ri);
    ~RoomTab();

    RoomInfo* getRoomInfo() { return ri; }
    void appendMessage(RoomMessage*);

private:
    KTextBrowser* view;
    RoomInfo* ri;
};

class RoomPage : public QVBox, public KMLDonkeyPage
{
    Q_OBJECT
public:
    RoomPage(QWidget* parent);

    virtual void setupActions(KActionCollection* actionCollection);
    virtual void deactivatePageActions();

    virtual void applyPreferences(KMLDonkeyPreferences* prefs = 0);
    virtual void saveState(KConfig*);
    virtual void restoreState(KConfig*);
    virtual void clear();

private:
    QSplitter* mainsplitter;
    RoomListView* roomview;
    QIntDict<RoomTab> tabs;
    QPtrList<KAction> RoomActions;
    KAction* ActionCloseAllRooms;
    KTabWidget* pages;

    void closeRoom(RoomListViewItem* item);

protected slots:
    void pleaseUpdateActions();
    void contextRoom(KListView*, QListViewItem*, const QPoint&);
    void actionOpenRoom();
    void actionPausedRoom();
    void actionCloseRoom();
    void actionCloseAllRooms();
    void actionRoomUpdated(int);
    void actionRoomMessage(int, RoomMessage*);

public slots:
    void closeRoom(QWidget*);
    void actionActivatePage();
};

#endif // __kmldonkey_roompage_h__
