/* -*- c++ -*-
 *
 * kio_mldonkey.h
 *
 * Copyright (C) 2003 Petter Stokke <ummo@hellokitty.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __kio_mldonkey_kio_mldonkey_h__
#define __kio_mldonkey_kio_mldonkey_h__

#include <qstring.h>
#include <qcstring.h>
#include <qdict.h>

#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>

#include <hostmanager.h>
#include <donkeymessage.h>
#include <fileinfo.h>

class QCString;
class DonkeyProtocol;
class HostManager;
class KExtendedSocket;

class MLDonkeyURL
{
public:
    MLDonkeyURL(const KURL& url);

    bool isValid() const { return m_isValid; }
    const QString& host() const { return m_host; }
    const QString& path() const { return m_path; }
    const QString& fileName() const { return m_fileName; }

    bool isRoot() const { return m_isRoot; }
    bool isHost() const { return m_isHost; }
    bool isPath() const { return m_isPath; }
    bool isFile() const { return m_isFile; }

    const KURL& url() const { return original; }

private:
    bool m_isValid, m_isRoot, m_isHost, m_isPath, m_isFile;
    QString m_host, m_path, m_fileName;
    KURL original;
};

class MLDonkeyProtocol : public KIO::SlaveBase
{
public:
    MLDonkeyProtocol(const QCString &pool_socket, const QCString &app_socket);
    virtual ~MLDonkeyProtocol();

    virtual void get(const KURL& url);
    virtual void stat(const KURL& url);
    virtual void listDir(const KURL& url);

    DonkeyMessage* readMessage();
    bool sendMessage(DonkeyMessage*);

    bool connectSock(DonkeyHost*);
    void disconnectSock();
    bool connectDonkey(const QString& hostName);

    bool readDownloads(const QString& hostName);
    bool readComplete(const QString& hostName);

    const FileInfo* statDownload(const MLDonkeyURL& url);
    const FileInfo* statDownloaded(const MLDonkeyURL& url);

private:
    HostManager* hostManager;
    KExtendedSocket* sock;
    QString currentHost;
    int proto;

    KURL cachedURL;
    FileInfo cachedStat;

};

#endif
