/* -*- c++ -*-
 *
 * donkeyentry.h
 *
 * Copyright (C) 2003, 2004 Petter Stokke <ummo@hellokitty.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __kcmdonkey_donkeyentry_h__
#define __kcmdonkey_donkeyentry_h__

#include <qlistbox.h>
#include <qstring.h>

class DonkeyEntry : public QListBoxText
{
public:
    DonkeyEntry(QListBox* box, const QString& name, const QString& address, int port, int httpPort,
		const QString& username, const QString& password, int hostMode = 0,
		const QString& binary = QString::null, const QString& root = QString::null,
		int startupMode = 0, bool isDefault = false);

    const QString& getName() { return m_name; }
    const QString& getAddress() { return m_address; }
    int getPort() { return m_port; }
    int getHTTPPort() { return m_httpPort; }
    const QString& getUsername() { return m_username; }
    const QString& getPassword() { return m_password; }
    int getHostMode() { return m_hostMode; }
    int getRealHostMode() { return (m_hostMode == 1) ? 2 : 0; }
    const QString& getBinary() { return m_binary; }
    const QString& getRoot() { return m_root; }
    int getStartupMode() { return m_startupMode; }
    bool getDefault() { return m_default; }

    void setName(const QString& name);
    void setAddress(const QString& address) { m_address = address; }
    void setPort(int port) { m_port = port; }
    void setHTTPPort(int port) { m_httpPort = port; }
    void setUsername(const QString& username) { m_username = username; }
    void setPassword(const QString& password) { m_password = password; }
    void setHostMode(int mode) { m_hostMode = mode; }
    void setBinary(const QString& binary) { m_binary = binary; }
    void setRoot(const QString& root) { m_root = root; }
    void setStartupMode(int mode) { m_startupMode = mode; }
    void setDefault(bool isDefault);

private:
    QString m_name, m_address, m_username, m_password,
	m_binary, m_root;
    int m_port, m_httpPort, m_hostMode, m_startupMode;
    bool m_default;
};

#endif
