/* -*- c++ -*-
 *
 * mldonkeyapplet.h
 *
 * Copyright (C) 2002, 2003 Petter Stokke <ummo@hellokitty.com>
 * Copyright (C) 2003 Sebastian Sauer <mail@dipe.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#ifndef __mldonkeyapplet_h__
#define __mldonkeyapplet_h__

#include <qevent.h>

#include <kpanelapplet.h>

#include <donkeytypes.h>
#include <hostmanager.h>

#include "mldonkeyappletiface.h"

class DCOPClient;
class MLDonkeyAppletGUI;
class AppletConfig;
class KPopupMenu;
class QTimer;
class DonkeyProtocol;
class HostManager;
class HostSelectAction;

class MLDonkeyApplet : public KPanelApplet, virtual public MLDonkeyAppletIface

{
    Q_OBJECT

public:
    MLDonkeyApplet( const QString& configFile, Type t = Stretch,
		    int actions = 0, QWidget *parent = 0,
		    const char *name = 0 );
    ~MLDonkeyApplet();

    int widthForHeight( int height ) const;
    int heightForWidth( int width ) const;
    void about();
    void preferences();

    bool isGUIRunning() const;
    bool isGUIVisible() const;

    bool isMute();

    bool showLabels, showDouble, showMute;
    QStringList activeDisplays;
    QFont appletfont;

protected:

    void dragEnterEvent(QDragEnterEvent* event);
    void dropEvent(QDropEvent* event);
    void mousePressEvent(QMouseEvent *event);

public slots:
    void showGUI(bool);
    void muteDonkey(bool);
    void connectToCore();
    void connectToCore(HostInterface*);
    void refreshDisplay();
    void updateLabels();
    void updateStatus(int64 ul, int64 dl, int64 sh, int nsh, int tul, int tdl, int uul, int udl, int ndl, int ncp, QMap<int,int>*);
    void donkeyDisconnected(int err);
    void donkeyConnected();

    void applicationRemoved(const QCString& appId);

    virtual void kmldonkeyAppeared(bool);
    virtual void mute(bool);

    void configure();
    void showAbout();

protected:
    void resizeEvent(QResizeEvent*);
    void writeConfiguration();
    void restoreConfiguration();
    QString produceStatus(const QString& key, int64 ul, int64 dl, int64 sh, int nsh, int tul, int tdl, int uul, int udl, int ndl, int ncp);

protected slots:
    void applyConfig();

private:
    KAboutData* aboutData;
    MLDonkeyAppletGUI* gui;
    AppletConfig* configDialog;
    KPopupMenu* menu;

    DCOPClient* client;

    QTimer* timer;

    DonkeyProtocol* donkey;
    HostManager* hostManager;
    HostSelectAction* m_connectAction;

    int reconnect;

    int muteUploadRate, muteDownloadRate;
    int normalUploadRate, normalDownloadRate;
};

#endif
