/***************************************************************************
                          arcitem.cpp  -  description
                             -------------------
    begin                : Sam Aug 17 2002
    copyright            : (C) 2003 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ksimpleconfig.h>
#include <klocale.h>
#include "kplchecklistitem.h"
#include "kgraph.h"
#include "arcdlg.h"
#include "arcitem.h"

ArcItem::ArcItem() : width(3.0), height(3.0), dir(0.0), a(0.0), alen(90.0)
{
}

ArcItem::ArcItem(Kpl::AutoStruct* aut) :
 DecoItem(aut), width(3.0), height(3.0), dir(0.0), a(0.0), alen(90.0)
{
  x0 = aut->x0Auto + 0.5 * aut->xlAuto;
  y0 = aut->y0Auto + 0.5 * aut->ylAuto;
}

ArcItem::ArcItem(KSimpleConfig* plo, Kpl::AutoStruct* aut) :
 DecoItem(plo, aut)
{
  width = plo->readDoubleNumEntry("width", 3.0);
  height = plo->readDoubleNumEntry("height", 2.0);
  dir = plo->readDoubleNumEntry("dir");
  a = plo->readDoubleNumEntry("a");
  alen = plo->readDoubleNumEntry("alen", 90.0);
}

ArcItem::ArcItem(bool act, const QString& col, double x, double y, double w,
        double h, double aStart, double a_len, double relSize, double ang) :
 DecoItem(act, col, x, y, relSize), width(w), height(h), dir(ang), a(aStart),
          alen(a_len)
{
}

ArcItem::~ArcItem()
{
}

KplItem::ItemTypes ArcItem::iType() const
{
  return Arc;
}

void ArcItem::draw(KplGraph* g)
{
  if (!g->type())
    bRect.setRect(0, 0, 0, 0);
  if (active) {
    g->setColData(color);
    double sav = g->setRelSize(relsiz);
    g->arc(x0, y0, width, height, a, alen, dir, &bRect);
    g->setRelSize(sav);
  }
}

void ArcItem::writePlo(KSimpleConfig* plo, const KURL& url, bool abs,
                       KplDoc* m) const
{
  plo->writeEntry("Type", "ARCITEM");
  DecoItem::writePlo(plo, url, abs, m);
  plo->writeEntry("width", width);
  plo->writeEntry("height", height);
  plo->writeEntry("dir", dir);
  plo->writeEntry("a", a);
  plo->writeEntry("alen", alen);
}

void ArcItem::setText(KplCheckListItem* it, bool*, bool*) const
{
  it->setText(1, i18n("Arc"));
  QString s1, s2;
  it->setText(2, s1.sprintf("x = %g cm, y = %g cm, ", x0, y0) + i18n("size")
              + s2.sprintf(" %g cm x %g cm", width, height));
}

int ArcItem::editItem(QWidget* parent, KplDoc* m, int)
{
  ArcDlg dlg(parent, m, this);
  return dlg.exec();
}

KplItem* ArcItem::copy() const
{
  return new ArcItem(*this);
}
