/***************************************************************************
                          sourcewidget.h  -  description
                             -------------------
    begin                : Sun Apr 16 2000
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SOURCEWIDGET_H
#define SOURCEWIDGET_H

#include <qmultilinedit.h>

class QFile;
class QString;

/**
  * Source widget class. Provides a multi line edit widget to display the
  * source code of functions.
  * @author Werner Stille
  */
class SourceWidget : public QMultiLineEdit
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param f pointer to QFile opened for input from a file containing
   * the source code to display.
   */
  SourceWidget(QWidget* parent, QFile* f = 0);
  /** Destructor. */
  ~SourceWidget();
  /**
   * Sets widget text.
   * @param f pointer to QFile opened for input from a file containing
   * the source code to display.
   */
  void fill(QFile* f);
  /**
   * Highlights function name.
   * @param func name of the function.
   */
  void highlight(const QString& func);

protected:
  int line, col1, col2;

public slots:
  /** Performs highlighting. */
  void slotHighlight();
};

#endif
