/***************************************************************************
                          kplwidget.h  -  description
                             -------------------
    begin                : Mon Jul 16 2001
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPLWIDGET_H
#define KPLWIDGET_H

#include <qscrollview.h>
#include <qpixmap.h>
#include <qlist.h>
#include <kapp.h>
#include "kgraph.h"

#if (KDE_VERSION_MAJOR > 2) || (KDE_VERSION_MINOR > 1)
class KPrinter;
#else
class QPrinter;
#endif
class KplItem;

/**
  * Kpl widget class. Basic plot widget with scrollbars.
  * @author Werner Stille
  */
class KplWidget : public QScrollView, public KGraph
{
   Q_OBJECT
public:
  /**
    * Constructor.
    * @param parent parent widget.
    */
  KplWidget(QWidget* parent);
  /**
    * Constructor.
    * @param parent parent widget.
    * @param items list of plot items.
    * @param w width.
    * @param h height.
    * @param zoom magnification factor.
    */
  KplWidget(QWidget* parent, QList<KplItem>* items, int w = 640, int h = 480,
            double zoom = 1.0);
  /** Destructor */
  ~KplWidget();
  /**
    * Draws plot items.
    * @param g graphics instance.
    * @param items list of plot items.
    */
  static void drawItems(KplGraph* g, QList<KplItem>* items);
  /**
    * Contains the implementation for printing functionality.
    * @param printer printer device.
    * @param items list of plot items.
    */
#if (KDE_VERSION_MAJOR > 2) || (KDE_VERSION_MINOR > 1)
  static void print(KPrinter* printer, QList<KplItem>* items);
#else
  static void print(QPrinter* printer, QList<KplItem>* items);
#endif
  /**
    * Reimplemented to avoid scrollbars if not necessary.
    */
  QSize sizeHint() const;

protected:
  /**
   * Reimplemented to paint using pixmap.
   */
  virtual void drawContents(QPainter* p, int clipx, int clipy, int clipw,
                            int cliph);
  QPixmap pm;
};

#endif
