#include <sys/time.h>
#include <unistd.h>
#include <string>
#include <fstream>
#include <iostream>

#include <kapp.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <kmessagebox.h>

#include <qfile.h>
#include <qfileinf.h>
#include <qtstream.h>
#include <qregexp.h>
#include <qcombobox.h>
#include <qlistview.h>
#include <qlistbox.h>
#include <qheader.h>
#include <qspinbox.h>
#include <qlabel.h>

#include "tableview.h"
#include "globals.h"
#include "my_sql.h"
#include "PatternPair.h"
#include "e_patternpair.h"
#include "MultiTextInput.h"
#include "tabledescr.h"
#include "selectoutfile.h"
#include "converter.h"
#include "kmysqladmin/helpers/stringlist.h"
#include "stringres.h"
#include "kmysqladmin/helpers/smart_pointer.h"
#include "progressdlg.h"
#include "kmysqladmin/helpers/stringhelper.h"
#include "kmysqladmin/setup/settings.h"
#include "kmysqladmin/helpers/qt_stl_string.h"
#include <qcheckbox.h>


#define Inherited CTableViewData

using namespace std;

CTableView::CTableView (smart_pointer<CMySql> & _sql_server,QWidget* parent,const char* name)
    :Inherited( parent, name,false)/*false,WType_TopLevel|WStyle_MinMax|WStyle_SysMenu|WStyle_NormalBorder )*/
{
    sql_server = _sql_server;
    QString caption;
    caption = GET_TEXT(125);caption+=" - ";caption+=GET_TEXT(106);
    setCaption(caption);
    setIcon(kapp->icon());
    
    // set all texts
#if 0
    setCaption( GET_TEXT(76) );
    SelectTableLabel->setText( GET_TEXT(91) );
    SelDbLabel->setText( GET_TEXT(26) );
    SortByLabel->setText( GET_TEXT(92 ) );
    ModifyRow->setText( GET_TEXT(96) );
    saveButton->setText( GET_TEXT(99 ) );
    DeleteButton->setText( GET_TEXT(97) );
    AddRow->setText( GET_TEXT(95) );
    searchButton->setText( GET_TEXT(98 ) );
    EmptyTableButton->setText( GET_TEXT(100 ) );
    ColumnDisplayLabel->setText( GET_TEXT(89) );
    LimitCountLabel->setText( GET_TEXT(94 ) );
    OffsetLabel->setText( GET_TEXT(93 ) );
    CloseButton->setText( GET_TEXT(113 ) );
    HelpButton->setText( GET_TEXT(111) );
    RefreshListButton->setText( GET_TEXT(102) );
    Go_Button->setText( GET_TEXT(101) );
#endif

    Current_Table_Fields.resize(0);
    Current_Displayed_Fields.resize(0);
    CurrentKeys.resize(0);

    RefreshLists();    
    KConfig * k = KGlobal::config();
    k->setGroup("table_view");
    int w,h;
    QString ws,hs;
    ws = k->readEntry("width","0");
    hs = k->readEntry("height","0");
    w = ws.toInt();
    h = hs.toInt();
    if (w && h) {
        resize(w,h);
    }
    connect(&GlobalSettings,SIGNAL(fixfont_changed()),this,SLOT(FixFontChanged()));
    FixFontChanged();
    OutputList->setAllColumnsShowFocus(true);
    OutputList->setSorting(-1);
}

CTableView::~CTableView()
{
}

void CTableView::RefreshLists()
{
    OutputList->clear();
    SelectDB->clear();
    stringlist list;
    sql_server->get_db_list("%",list);
    if (!list.size()) {
        SelectDB->setEnabled(false);
        return;
    }
    SelectDB->setEnabled(true);
    for (stringlist::iterator iter = list.begin();iter != list.end();++iter) {
        SelectDB->insertItem(iter->c_str());
    }
    db_select(0);
}

void CTableView::MakeRequest()
{
    _make_fetch_request();
}

void CTableView::show()
{
    QDialog::show();
}

void CTableView::db_select(int i)
{
    QString s;
    s = SelectDB->text(i);
    if ( !SelectDB->isEnabled() || s.isEmpty()) {
        TableSelect->setEnabled(false);
        return;
    }
    stringlist Result;
    string _s = QT_TO_STL_STRING(s);
    sql_server->get_table_list("%",_s,Result);
    TableSelect->clear();
    if (Result.size() == 0) {
        table_select(-1);
        TableSelect->setEnabled(false);
        return;
    } else {
        TableSelect->setEnabled(true);
    }
    if (sql_server->is_system_db(_s)) {
        EmptyTableButton->setEnabled(false);
    } else {
        EmptyTableButton->setEnabled(true);
    }
    for (stringlist::iterator iter=Result.begin();iter!=Result.end();++iter) {
        TableSelect->insertItem(iter->c_str());
    }
    table_select(0);
}

void CTableView::table_select(int i)
{
    SortListBox->clear();
    ColumnDisplay->clear();
    ColumnList_iterator ergebnis;
    OutputList->clear();
    while (OutputList->header()->count()>0) {
        OutputList->removeColumn(0);
    }
    Current_Table_Fields.resize(0);
    Current_Displayed_Fields.resize(0);

    QString s = TableSelect->text(i);
    QString t = SelectDB->currentText();

    if (s.isEmpty() || t.isEmpty()) {
        set_buttons(FALSE);
        ColumnDisplay->setEnabled(false);
        ColumnDisplay->update();
        SortListBox->setEnabled(false);
        return;
    }
    sql_server->get_table_keys(QT_TO_STL_STRING(t),QT_TO_STL_STRING(s),CurrentKeys);
    if (!sql_server->get_table_fields(QT_TO_STL_STRING(t),QT_TO_STL_STRING(s),Current_Table_Fields) || Current_Table_Fields.size()==0) {
        SortListBox->setEnabled(false);
        ColumnDisplay->setEnabled(false);
        set_buttons(FALSE);
        return;
    }
    SortListBox->setEnabled(true);
    ColumnDisplay->setEnabled(true);
    int count = 0;
    SortListBox->insertItem("");
    for (ergebnis = Current_Table_Fields.begin();ergebnis!=Current_Table_Fields.end(); ++ergebnis){
        ColumnDisplay->insertItem(ergebnis->get_name().c_str());
        SortListBox->insertItem(ergebnis->get_name().c_str());
        OutputList->addColumn(ergebnis->get_name().c_str());
        ++count;
    }
    Current_Displayed_Fields = Current_Table_Fields;
    set_buttons(TRUE);
    OutputList->setFocus();
}

void CTableView::addRow()
{
    e_PatternList which;
    PatternList*result = 0;
    ColumnList_iterator Field;
    int i;
    QString db;
    QString table;
    CMultiTextInput edit(this);
    table = TableSelect->currentText();
    db = SelectDB->currentText();
    for (Field = Current_Table_Fields.begin();Field != Current_Table_Fields.end();++Field) {
        if (!Field->is_AutoIncrement() ) {
            e_PatternIterator iter;
            which.push_back(e_patternpair(Field->get_name(),Field->get_default()));
            iter = which.end();
            iter--;
            iter->setIsNumeric(Field->is_Numeric());
            iter->setLargeText(Field->is_Blob());
            stringIlist _temp_list = Field->enum_list();
            if (_temp_list.size()>0) {
                if (!Field->is_NotNull()&&!Field->get_is_set())
                    _temp_list.insert(_temp_list.begin(),"");
                iter->set_enumlist(_temp_list);
                iter->set_is_set(Field->get_is_set());
            }
        }
    }
    edit.setCaption(GET_TEXT(77));
    edit.build_widgets(&which);
    if (edit.exec())
        result = edit.get_entries(FALSE);
    else
        return;
    if (!result)
        return;
    i = sql_server->insert_row(QT_TO_STL_STRING(db),QT_TO_STL_STRING(table),result);
    if (i < 0) {
        display_error_box();
    }
    delete result;
}

void CTableView::search_rows()
{
    _make_fetch_request(true);
}

void CTableView::set_buttons(bool how)
{
    searchButton->setEnabled(how);
    saveButton->setEnabled(how);
    AddRow->setEnabled(how); 
    saveButton->setEnabled(how);
    Go_Button->setEnabled(how);
    EmptyTableButton->setEnabled(how);
    DeleteButton->setEnabled(how);
}

void CTableView::OutputMarked(QListViewItem*item)
{
    bool how;
    how = ( (item!=NULL) && (KeyDisplayed()));
    ModifyRow->setEnabled(how);
    DeleteButton->setEnabled(how);
}

void CTableView::modifyRow()
{
    QString Entry;
    QString Breaks;
    e_PatternList BreakList;// =  0;
    PatternList* ModList = 0;
    PatternList KeyList;// = 0;
    PatternList _BreakList;

    CMultiTextInput edit(this);
    int i = 0;

    i = BreakIntoParts(&_BreakList,&KeyList);

    if (i < 0 || _BreakList.size() == 0 || KeyList.size() == 0) {
        return;
    }
    for (unsigned j = 0;j < _BreakList.size();++j) {
        BreakList.push_back(_BreakList[j]);
        for (unsigned a=0;a<Current_Displayed_Fields.size();++a) {
            if (Caseequ()(BreakList[j].get_entry(),Current_Displayed_Fields[a].get_name())) {
                stringIlist _temp_list = Current_Displayed_Fields[a].enum_list();
                if (_temp_list.size()>0) {
                    if (!Current_Displayed_Fields[a].is_NotNull() && !Current_Displayed_Fields[a].get_is_set())
                        _temp_list.insert(_temp_list.begin(),"");
                    BreakList[j].set_enumlist(_temp_list);
                    BreakList[j].set_is_set(Current_Displayed_Fields[a].get_is_set());
                }
                break;
            }
        }
    }
    edit.build_widgets(&BreakList);

    edit.setCaption("Modify");
    if (!edit.exec()) {
        return;
    }

    ModList = edit.get_entries(true);

    if (!ModList || ModList->size() == 0) {
        if (ModList)
            delete ModList;
        return;    
    }
    e_PatternIterator break_iter;
    PatternIterator mod_iter;
    
    break_iter = BreakList.begin();
    mod_iter = ModList->begin();
    while (break_iter!=BreakList.end()) {
        Entry = mod_iter->get_pattern();
        Breaks = break_iter->get_pattern();
        if (Breaks == Entry) {
            mod_iter =  ModList->erase(mod_iter);
        } else {
            ++mod_iter;
        }
        ++break_iter;
    }
    if (ModList->size() == 0) {
        delete ModList;
        return;    
    }
    PatternList::iterator piter;
    for (piter=KeyList.begin();piter!=KeyList.end();++piter) {
        piter->set_no_escape(true);
        piter->set_op("=");
    }
    i = sql_server->update_row(QT_TO_STL_STRING(SelectDB->currentText()),QT_TO_STL_STRING(TableSelect->currentText()),
                               ModList,&KeyList);

    if (i < 0) {
        delete ModList;
        display_error_box();
        return;
    }
    stringlist which;
    list_vector target;
    for (ColumnList_iterator it = Current_Displayed_Fields.begin();it != Current_Displayed_Fields.end();++it) {
        which.push_back(it->get_name());
    }

    PatternList::iterator pit,pit2;
    for (pit=KeyList.begin();pit!=KeyList.end();++pit) {
        for (pit2=ModList->begin();pit2!=ModList->end();++pit2) {
            if (Caseequ()(pit->get_entry(),pit2->get_entry()))
                pit->set_pattern(pit2->get_pattern());
        }
    }
    delete ModList;
    i = sql_server->fetch_rows(SelectDB->currentText().latin1(),TableSelect->currentText().latin1(),
                               "",false,which,target,0,0,&KeyList);
    if (i < 0) {
        display_error_box();
        return;
    }
    QListViewItem*current_item;
    current_item = OutputList->selectedItem();
    if (!current_item || target.size()!=1) {
        return;
    }
    unsigned j = 0;
    for (;j < target[0].size();++j) {
        current_item->setText(j,target[0][j].c_str());
    }
}

void CTableView::delete_row()
{
    PatternList KeyList;
    int i = BreakIntoParts(0,&KeyList);
    if (i < 0 || KeyList.size() == 0) {
        return;
    }
    i = KMessageBox::questionYesNo(this,GET_TEXT(80),
                                   GET_TEXT(79));
    if (i == KMessageBox::No) {
        return;
    }
    PatternList::iterator piter;
    for (piter=KeyList.begin();piter!=KeyList.end();++piter) {
        piter->set_no_escape(true);
        piter->set_op("=");
    }
    i = sql_server->delete_row(QT_TO_STL_STRING(SelectDB->currentText()),QT_TO_STL_STRING(TableSelect->currentText()),&KeyList);
    if (i < 0) {
        display_error_box();
        return;
    }
    QListViewItem*current_item = OutputList->selectedItem();
    list_vector target;
    stringlist which;
    for (ColumnList_iterator it = Current_Displayed_Fields.begin();it != Current_Displayed_Fields.end();++it) {
        which.push_back(it->get_name());
    }
    i = sql_server->fetch_rows(
                               SelectDB->currentText().latin1(),
                               TableSelect->currentText().latin1(),
                               "",false,
                               which,target,0,0,&KeyList);
    if (i < 0) {
        display_error_box();
        return;
    }
    if (target.size()!=0)
        return;
    OutputList->takeItem(current_item);
}

void CTableView::emptyTable()
{
    QString message;
    message = GET_TEXT(81);
    message+="\n";
    message+= GET_TEXT(14);
    message+="\n";
    int i = KMessageBox::questionYesNo (this, message, GET_TEXT(82));
    if (i == KMessageBox::No)
        return;
    i = sql_server->delete_row(QT_TO_STL_STRING(SelectDB->currentText()),QT_TO_STL_STRING(TableSelect->currentText()));
    if (i < 0) {
        display_error_box();
        return;
    }
    OutputList->clear();
    ModifyRow->setEnabled(false);
    DeleteButton->setEnabled(false);
    OutputList->setFocus();
    return;
}

bool CTableView::KeyDisplayed()
{
    
    if (SelectFields.size()==0) {
        return false;
    }
    return true;
}

ColumnList_iterator CTableView::FindTableItem(const char*what,bool all_fields)
{
    vector<CColumnDescriptor>::iterator Entry;
    if (all_fields) {
        for (Entry = Current_Table_Fields.begin();Entry!=Current_Table_Fields.end();++Entry) {
            if (*Entry == what)
                return Entry;
        }
        return Entry;
    } else {
        for (Entry = Current_Displayed_Fields.begin();Entry!=Current_Displayed_Fields.end();++Entry) {
            if (*Entry == what)
                return Entry;
        }
        return Entry;
    }
}

int CTableView::BreakIntoParts(PatternList*BreakList,PatternList*KeyList,QListViewItem*item,
                               bool no_auto_filter)
{
    ColumnList_iterator Field;
    QListViewItem*current_item;

    int i = 0;

    if (Current_Displayed_Fields.size() == 0)
        return -1;
    if (item == 0) 
        current_item = OutputList->selectedItem();
    else
        current_item = item;

    if (!current_item)
        return -1;

    for (i = 0; i < OutputList->columns();++i) {
        if (BreakList)
            BreakList->push_back(CPatternPair("",current_item->text(i).latin1()));
        if (KeyList)
            KeyList->push_back(CPatternPair("",current_item->text(i).latin1()));
    }
    PatternIterator break_iterator;// = BreakList->end();
    PatternIterator key_iterator;// = KeyList->end();
    if (BreakList)
        break_iterator = BreakList->begin();
    if (KeyList)
        key_iterator= KeyList->begin();
    for (Field = Current_Displayed_Fields.begin();Field!=Current_Displayed_Fields.end();++Field) {
        if (BreakList) {
            if (Field->is_AutoIncrement() && !no_auto_filter) {
                break_iterator = BreakList->erase(break_iterator);
            } else {
                if (break_iterator!=BreakList->end()) {
                    break_iterator->set_entry(Field->get_name());
                    break_iterator->setLargeText(Field->is_Blob());
                    ++break_iterator;
                }
            }
        }
        if (KeyList) {
            if (SelectFields.find(Field->get_name())!=SelectFields.end()) {
                if (key_iterator!=KeyList->end()) {
                    key_iterator->set_entry(Field->get_name());
                    ++key_iterator;
                }
            } else {
                key_iterator = KeyList->erase(key_iterator);
            }
        }
    }

    return 0;
}

void CTableView::saveResult()
{
    CSelectOutFile SelectBox(this);
    QString filename;
    QString message;
    QFileInfo finfo;
    int i;
    if (OutputList->childCount() == 0)
        return;
    if (!SelectBox.exec())
        return;
    filename = SelectBox.get_name();
    if (filename.isEmpty())
        return;
    finfo.setFile(filename);
    if (finfo.isDir()) {
        QMessageBox::warning(this,GET_TEXT(83),
                             GET_TEXT(84));
        return;
    }
    if (QFile::exists(filename)) {
        message = GET_TEXT(85);
        message+="\n\n";
        message+=filename;message+="\n\n";
        message+=GET_TEXT(86);
        message+="\n";
        i = KMessageBox::questionYesNo( this,message, GET_TEXT(87));
        if (i == KMessageBox::No )
            return;

        if (!finfo.isWritable()) {
            QMessageBox::warning(this,GET_TEXT(83),
                                 GET_TEXT(88));
            return;
        }
    }
    i = SelectBox.get_type();
    cout << "Select: " << i << "\n";
    switch (i) {
    case 1:
        saveAscii(filename,";");
        break;
    case 2:
        saveHtml(filename);
        break;
    case 3:
        saveLatex(filename);
        break;
    default:
        saveAscii(filename);
    }
}

void CTableView::saveAscii(const char*filename,const char*aSep)
{
    int j = 0;
    
    const char*sep = aSep?aSep:"\t";

    if (!filename || strlen(filename) == 0)
        return;
    if (OutputList->childCount() < 1)
        return;
    QFile outfile(filename);
    outfile.open(IO_WriteOnly|IO_Truncate);
    if (!outfile.isOpen()) 
        return;
    QTextStream st(&outfile);
    QListViewItemIterator it(OutputList);

    for (; it.current();++it) {
        for (j = 0; j < OutputList->columns();++j) {
            st << (j == 0?"":sep);
            st << it.current()->text(j);
        }
        st << "\n";
    }
    outfile.close();
}

void CTableView::saveHtml(const char*filename)
{
    smart_pointer<CConverter> converter(CConverter::get_converter(CConverter::HTML));
    if (!converter)
        return;
    PatternList*KeyList = 0;
    PatternIterator key_iterator;
    ColumnList_iterator desc;
    QString entry;

    if (!filename || strlen(filename) == 0)
        return;
    if (OutputList->childCount() < 1)
        return;
    QFile outfile(filename);
    outfile.open(IO_WriteOnly|IO_Truncate);
    if (!outfile.isOpen()) 
        return;
    QTextStream st(&outfile);
    st << "<HTML>\n<HEAD>\n<TITLE>TableOutput</TITLE>\n</HEAD>\n";
    st << "<BODY>\n<TABLE WIDTH=100% BORDER=1 CELLPADDING=3 CELLSPACING=1>\n";
    st << "  <TR VALIGN=TOP>\n";
    for (desc = Current_Displayed_Fields.begin();desc!= Current_Displayed_Fields.end();++desc) {
        st << "    <TH><P>" << desc->get_name().c_str() << "</TH>\n";
    }
    st << "  </TR>\n";
    KeyList = new PatternList;
    QListViewItemIterator it(OutputList);

    for (; it.current();++it) {
        KeyList->resize(0);
        BreakIntoParts(KeyList,0,it.current(),true);
        st << "  <TR>\n";
        desc = Current_Displayed_Fields.begin();
        key_iterator = KeyList->begin();
        for (key_iterator = KeyList->begin();key_iterator != KeyList->end();++key_iterator) {
            if (desc!=Current_Displayed_Fields.end() && desc->is_Numeric())
                st << "    <TD><P ALIGN=RIGHT>";
            else
                st << "    <TD><P>";
            entry = key_iterator->get_pattern();
            if (entry.length() > 0) {
                st << converter->convert(QT_TO_STL_STRING(entry)).c_str();
            }
            else {
                entry = "<br>";
                st << entry;
            }
            st << "</TD>\n";
            ++desc;
        }
        st << "  </TR>\n";
    }
    st << "</TABLE>\n<P>\n<FONT SIZE=-1>\n"
        "Document created with KMySqlAdmin\n</FONT>\n</BODY>\n</HTML>\n";
    delete KeyList;
}

void CTableView::saveLatex(const char*filename)
{
    PatternList BreakList;
    smart_pointer<CConverter> converter(CConverter::get_converter(CConverter::LATEX));
    if (!converter)
        return;
    ColumnList_iterator desc;
    std::string entry;
    std::string head, head2, head3;
    unsigned int i;
    unsigned int j;
    
    if (!filename || strlen(filename) == 0)
        return;
    if (OutputList->childCount() < 1)
        return;
    ofstream st(filename);
    if (!st) {
        QMessageBox::critical(this,GET_TEXT(112),GET_TEXT(83));
        return;
    }
    unsigned int with = Current_Displayed_Fields.size();
    st << "\\documentclass[10pt,a4paper]{article}\n";
    //with = 120/with;
    st << "\\usepackage[latin1]{inputenc}\n";
    st << "\\usepackage{longtable}\n";
    st << "\\newcommand{\\tabcenter}[1]{\\multicolumn{1}{|c|}{#1}}\n";
    st << "\\newcommand{\\tabright}[1]{\\multicolumn{1}{|r|}{#1}}\n";
    std::string Buffer = FormatSTLString("%u",with);
    head3 = "";
    for (desc = Current_Displayed_Fields.begin();desc!= Current_Displayed_Fields.end();++desc ) {
        if (desc != Current_Displayed_Fields.begin()) {
            head3+=" & ";
        }
        string dummy = converter->convert(desc->get_name());
        if (!dummy.empty()) {
            head3+="\\tabcenter{\\bf ";
            head3+=dummy;
            head3+="}";
        }
        else {
            head3+=" ";
        }
    }
    head3 += "\\\\ \\hline\n";

    head = "\\begin{longtable}{|";
    for (i  = 0;i < Current_Displayed_Fields.size();++i ) {
        head+="l|";
    }
    head+="}\n\\caption*{\\bf Database: ";
    head+=converter->convert(QT_TO_STL_STRING(SelectDB->currentText()));
    head+=" Table: ";
    head+=converter->convert(QT_TO_STL_STRING(TableSelect->currentText()));
    head+="}\\\\ \\hline\n";
    head+=head3;
    head+="\\endfirsthead\n";
    head+="\\caption*{{\\bf ";
    head+=converter->convert(QT_TO_STL_STRING(SelectDB->currentText()));
    head+=".";
    head+=converter->convert(QT_TO_STL_STRING(TableSelect->currentText()));
    head+="} - continued}\\\\ \\hline\n";
    head+=head3;
    head+="\\endhead\n";
    head+="\\hline\\multicolumn{";
    head+=Buffer;
    head+="}{|r|}{\\slshape Continued on next page}\\\\ \\hline\n\\endfoot\n";
    head+="\\hline\\multicolumn{";
    head+=Buffer;
    head+="}{l}{\\small document created with \\textbf{KMySqlAdmin}}\n\\endlastfoot\n";

    st << "\n\\begin{document}\n";
    st << head;
    PatternIterator break_iterator;
    j = 0;
    CProgressDlg prg(0,OutputList->childCount(),"Exporting data",0,"ProgressDlg");
    prg.show();
    QListViewItemIterator it(OutputList);

    for (; it.current();++it) {
        BreakList.resize(0);
        prg.setPos(i);
        BreakIntoParts(&BreakList,0,it.current(),true);
        for (break_iterator=BreakList.begin();break_iterator!=BreakList.end();++break_iterator) {
            if (break_iterator != BreakList.begin())
                st << " & ";
            QString dummy = converter->convert(break_iterator->get_pattern()).c_str();
            if (!dummy.isEmpty()) {
                st << dummy;
            }
            else {
                st << " ";
            }
        }
        st << "\\\\ \\hline\n";
    }
    st << "\\end{longtable}\n%ready with table\n\n";
    st << "\\end{document}\n";
}

void CTableView::build_relevant_keys()
{
    pairIlist e_list;
    bool all_found;
    SelectFields.resize(0);
    unsigned int count;
    if (!Current_Displayed_Fields.size() || !CurrentKeys.size()) {
        return;
    }
    KeyList::iterator k_iterator = CurrentKeys.begin();
    while(k_iterator != CurrentKeys.end()) {
        if (!k_iterator->is_UniqueKey()) {
            CurrentKeys.erase(k_iterator);
        } else {
            ++k_iterator;
        }
    }
    if (!CurrentKeys.size()) {
        return;
    }
    for(k_iterator=CurrentKeys.begin();k_iterator!=CurrentKeys.end();++k_iterator) {
        all_found = true;
        e_list = k_iterator->get_ColList();
        for (count = 0;count < e_list.size();++count) {
            all_found = FindTableItem(e_list[count].first.c_str(),false) != Current_Table_Fields.end();
            if (!all_found)
                break;
        }
        if (all_found) {
            for (count = 0; count < e_list.size();++count) {
                if (SelectFields.find(e_list[count].first)==SelectFields.end()) {
                    SelectFields.push_back(e_list[count].first);
                }
            }
        }
    }
}

//#define _SECOND_VERSION

void CTableView::_make_fetch_request(bool search_it) 
{
    list_vector erg;
    stringlist which;
    ColumnList_iterator Field;
    QString sort;
    QString db;
    QString table;
    QString format;
    unsigned int id;
    int i;

    e_PatternList pattern_list;
    PatternList*result = 0;

    CMultiTextInput edit(this);
    
    table = TableSelect->currentText();
    db = SelectDB->currentText();
    Current_Displayed_Fields.resize(0);
    if (SortListBox->count() == 0) {
        return;
    }
    sort = SortListBox->currentText();
    for (id = 0; id < ColumnDisplay->count();id++) {
        if (ColumnDisplay->isSelected(id)) {
            QString s_ = ColumnDisplay->text(id);
            which.push_back(s_.latin1());
            Field = FindTableItem(s_.latin1());
            /*
             * In this case we only search all fields so it is correct!
             */
            if (Field!=Current_Table_Fields.end()) {
                Current_Displayed_Fields.push_back(*Field);
            }
        }
    }
    if (Current_Displayed_Fields.size() == 0) {
        for (Field = Current_Table_Fields.begin();Field!=Current_Table_Fields.end();++Field) {
            Current_Displayed_Fields.push_back(CColumnDescriptor(*Field));
        }  
    }
    build_relevant_keys();

    if (search_it) {
        for (Field = Current_Table_Fields.begin();Field != Current_Table_Fields.end();++Field) {
            e_PatternIterator p_iter;
            pattern_list.push_back(e_patternpair(Field->get_name(),""));
            p_iter = pattern_list.end();
            --p_iter;
            p_iter->setIsNumeric(Field->is_Numeric());
            p_iter->setLargeText(Field->is_Blob());
            stringIlist _temp_enums = Field->enum_list();
            if (_temp_enums.size() > 0) {
                // we requires the empy one, too
                _temp_enums.insert(_temp_enums.begin(),"");
                p_iter->set_enumlist(_temp_enums);
            }
        }
        edit.setCaption(GET_TEXT(78));
        edit.build_widgets(&pattern_list);
        if (edit.exec()) {
            result = edit.get_entries(FALSE);
        } else {
            return;
        }
    }
    OutputList->clear();
    while(OutputList->header()->count()>0) {
        OutputList->removeColumn(0);
    }

    i = 0;

    for (Field = Current_Displayed_Fields.begin();Field!=Current_Displayed_Fields.end();++Field) {
        OutputList->addColumn(Field->get_name().c_str());
        ++i;
    }
    stringlist SizePattern;
    i = sql_server->fetch_rows(QT_TO_STL_STRING(db),QT_TO_STL_STRING(table),
                               QT_TO_STL_STRING(sort),(desc_box->isChecked()?true:false),which,erg,
                               (unsigned)OffsetEdit->value(),
                               (unsigned)LimitEdit->value(),result);

    if (result) {
        delete result;
        result = 0;
    }
    timeval starttime,endtime; 
    KApplication::kApplication()->processEvents(100);
    list_vector::iterator erg_iter = erg.begin();
    gettimeofday(&starttime,0); 
    // for a higher speed two seperate loops
#ifndef _SECOND_VERSION
    int running = 0;
    QListViewItem*item = 0;
    stringlist::iterator siter;
    unsigned int max_count = OutputList->columns();
    unsigned int count;
    if (erg.size() > 4999) {
        CProgressDlg prg(0,erg.size(),"Inserting data into table view",0,"ProgressDlg");
        prg.show();
        for (;erg_iter != erg.end();++erg_iter) {
            siter = erg_iter->begin();
            item = new QListViewItem(OutputList,item);
            prg.setPos(++running);
            count = 0;
            for (;siter!=erg_iter->end();++siter) {
                item->setText(count,siter->c_str());
                count++;
                if (count == max_count)
                    break;
            }
        }
        prg.hide();
    } else {
        for (;erg_iter != erg.end();++erg_iter) {
            siter = erg_iter->begin();
            item = new QListViewItem(OutputList,item);
            count = 0;
            for (;siter!=erg_iter->end();++siter) {
                item->setText(count,siter->c_str());
                count++;
                if (count == max_count)
                    break;
            }
        }
    }
#else
    int intiter = 0;
    int count_rows = OutputList->numRows();
    debug("Enthaelt bereits %i Zeilen\n",count_rows);
    if (erg.size()>4999) {
        CProgressDlg prg(0,erg.size(),"Inserting data into table view",0,"ProgressDlg");
        prg.show();
        for (;intiter<erg.size();++intiter) {
            //prg.SetPos((int)intiter);
            if (intiter<count_rows) {
                OutputList->changeItem(erg[intiter].c_str(),intiter);
            } else {
                OutputList->appendItem(erg[intiter].c_str());
            }
        }
        prg.hide();
    } else {
        for (;intiter<erg.size();++intiter) {
            if (intiter<count_rows) {
                OutputList->changeItem(erg[intiter].c_str(),intiter);
            } else {
                OutputList->appendItem(erg[intiter].c_str());
            }
        }
    }
    while ( (count_rows = OutputList->numRows())>erg.size()) {
        OutputList->removeItem(count_rows-1);
    }
#endif
    gettimeofday(&endtime,0);
    long int sec,usec;
    sec = endtime.tv_sec - starttime.tv_sec;
    usec = endtime.tv_usec - starttime.tv_usec;
    usec += 1000*1000*sec;
    printf("Inserttime: %li,%06li sec \n",usec/(1000*1000),usec%(1000*1000));
     
    //hope you'll never see it
    if (i < 0) {
        display_error_box();
    }
    OutputList->setSelected(OutputList->firstChild(),true);
    OutputList->setFocus();
}

bool CTableView::close( bool forceKill)
{
    KConfig * k = KGlobal::config();
    if (k) {
        k->setGroup("table_view");
        int w,h;
        w = width();
        h = height();
        QString s;
        s.setNum(w);
        k->writeEntry("width",s);
        s.setNum(h);
        k->writeEntry("height",s);
    }
    return CTableViewData::close(forceKill);
}

void CTableView::FixFontChanged()
{
    QFont font = GlobalSettings.get_fixed_font();
    OutputList->setFont( font );
}

void CTableView::OutputSelected(QListViewItem*)
{
    if (ModifyRow->isEnabled())
        modifyRow();
}

void CTableView::column_sel_change()
{
}

void CTableView::sort_select(int)
{
}
void CTableView::desc_box_toggled(bool)
{
}

void CTableView::showHelp()
{
    KApplication::kApplication()->invokeHelp("kmysqladmin-browsing_tables");
}
