// -*- Mode: C++; -*-

#include "kmysqladmin/profile.h"
#include <string>

#ifndef _settings_h
#define _settings_h

#include "settingsignals.h"
class QFont;
class QColor;

class CSettings:public Settingsignals
{
protected:
    eProfile LastInit;
    bool init_files();

public:
    CSettings();
    ~CSettings();
    void SaveLastLogin(const std::string user,const std::string host,
                       const std::string port,const std::string pass);
    bool RetrieveLastLogin(std::string&user,std::string&host,
                           std::string&port,std::string&pass);
    void set_fixed_font( const QFont&fnt);
    void set_nprop_font( const QFont&fnt);

    QFont get_fixed_font();
    QFont get_nonprop_font();

    int ThreadPolltime()const;
    void ThreadPolltime(int aTimeout);
    
    int StatusPolltime()const;
    void StatusPolltime(int aTimeout);

    bool ScriptOutputAsRich()const;
    void ScriptOutputAsRich(bool);
    bool SyntaxHighlight()const;
    void SyntaxHighlight(bool);
    
    QColor getScriptColor(const std::string&which,const QColor&aDefaultColor);
    void   setScriptColor(const std::string&which,const QColor&aColor);
    bool   getScriptbold(const std::string&which,bool def);
    void   setScriptbold(const std::string&which,bool how);
    bool   getScriptit(const std::string&which,bool def);
    void   setScriptit(const std::string&which,bool how);
};

extern CSettings GlobalSettings;
#endif
