// -*- Mode: C++; -*-
#include "pairs.h"
#include "helpers/stringlist.h"
#include "helpers/stringhelper.h"

#ifndef change_type_included
#define change_type_included

//! helper class for alter tables
struct change_type : public string_pair{
    //! type of change
    enum c_type{
        //! do nothing
        none,
        //! new column
        add,
        //! change column
        mod,
        //! delete column
        del};
    //!
    string_pair columns;
    //! type of change
    c_type typ;

    //! simple contructor
    change_type():columns(){typ = none;}
};

typedef std::vector<change_type> base_change_list;
typedef base_change_list change_list;

inline change_list::const_iterator find_second(const change_list&where,const change_type&what)
{
    change_list::const_iterator a = where.begin();
    for (;a!=where.end();++a) {
        if (Caseequ()(a->columns.second,what.columns.second)) {
            return a;
        }
    }
    return a;
}

inline change_list::iterator find_second(change_list&where,const change_type&what)
{
    change_list::iterator a = where.begin();
    for (;a!=where.end();++a) {
        if (Caseequ()(a->columns.second,what.columns.second)) {
            return a;
        }
    }
    return a;
}

inline change_list::iterator find_second(change_list&where,const std::string&what)
{
    change_list::iterator _search_pos = where.begin();
    for (;_search_pos<where.end();++_search_pos) {
        if (Caseequ()(_search_pos->columns.second,what)) {
            return _search_pos;
        }
    }
    return _search_pos;
}

#endif
