#include <stdlib.h>
#include <stdio.h>
#include <qstring.h>
//#include <kwm.h>
#include <kapp.h>

#include "StatusView.h"
#include "my_sql.h"
#include "stringres.h"
#include "kmysqladmin/setup/settings.h"
#include <qtextview.h>
#include <iostream>

#define Inherited CTextViewData

using namespace std;

CStatusView::CStatusView(smart_pointer<CMySql>& _sql_server,QWidget* parent,const char* name)
    :Inherited( parent, name )
{
    sql_server = _sql_server;
    QString head = CStringRes::get_string(125);head+=" - ";head+=CStringRes::get_string(129);
    setCaption(head);
    setIcon(kapp->icon());
    //setMiniIcon(winId(),kapp->miniIcon());
    
    m_Timeout = GlobalSettings.StatusPolltime();
    timer = new QTimer(this);
    connect( timer, SIGNAL(timeout()),this, SLOT(RefreshOutput()) );
    connect( &GlobalSettings,SIGNAL(statustimer_changed(int)),this,SLOT(newTimeout(int)));
    connect( &GlobalSettings,SIGNAL(npropfont_changed()),this,SLOT(newFont()));
    OutputArea->setFont(GlobalSettings.get_nonprop_font());
}

CStatusView::~CStatusView()
{
}

void CStatusView::get_status()
{
    long seconds;
    QString s;
    QString t;
    char*str2;
    string str1;

    str1 = "";
    str2 = NULL;
    if (!sql_server)
        return;
    
    str1 = sql_server->get_status();
    if (str1.empty())
        return;
    str2 = &str1[8];
    s = str2;
    t = str2;
    t = t.mid(t.find("Thread"),t.length());
    //may be a 3.21 version of mysql
    //it returns another string then 3.22
    if (t.length() == 0) {
        t = str2;
        t = t.mid(t.find('R'),t.length());
    }
    long index = s.find(" ");
    s = s.left(index);
    seconds = s.toLong();
    s.sprintf("Uptime: %ld days %ld hours %ld min\r\n",
         seconds/86500L,
         (seconds % 86400L) / 3600L,
         (seconds % 3600L) / 60L);
    s += t;
    
    OutputArea->setText(s);
    //OutputArea->insertLine(s);
    //OutputArea->setCursorPosition(OutputArea->numLines(),0);
}

void CStatusView::RefreshOutput()
{
    timer->stop();
    get_status();
    timer->start(m_Timeout * 1000,TRUE);
}

void CStatusView::hide()
{
    timer->stop();
    QDialog::hide();
}

void CStatusView::show()
{
    RefreshOutput();
    QDialog::show();
}

void CStatusView::newTimeout(int aValue)
{
    m_Timeout = aValue;
}

void CStatusView::newFont()
{
    OutputArea->setFont(GlobalSettings.get_nonprop_font());
}
