/***************************************************************************
 * eventsignal.h
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 ***************************************************************************/

#ifndef KROSS_API_EVENTSIGNAL_H
#define KROSS_API_EVENTSIGNAL_H

#include <qstring.h>
#include <qvaluelist.h>
#include <qmap.h>
#include <qvariant.h>
#include <qsignalmapper.h>
#include <qguardedptr.h>
#include <qobject.h>
#include <kdebug.h>

namespace Kross { namespace Api {

    // Forward declarations.
    class ScriptContainer;
    class Object;
    class List;
    class QtObject;
    class EventManager;

    /**
     * Each Qt signal and slot connection between a QObject
     * instance and a functionname is represented with
     * a EventSignal and handled by \a EventManager.
     */
    class EventSignal : public QObject
    {
            Q_OBJECT
            friend class EventManager;

        public:

            /**
             * Constructor.
             *
             * \param eventmanager The \a EventManager instance
             *       used to create this EventSignal.
             */
            EventSignal(EventManager* eventmanager);

            /**
             * Destructor.
             */
            virtual ~EventSignal();

        private:
            EventManager* m_eventmanager;
    };

}}

#endif

