/*
 * KMLOFax
 *
 * A utility to process facsimiles received with a modem of the
 * ELSA MicroLink Office family.
 *
 * Copyright (C) 1999,2000,2001,2002 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef CONFIGURE_H
#define CONFIGURE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qtabdialog.h>
#include <qwidget.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qspinbox.h>
#include <qcombobox.h>

#include <kconfig.h>
#include <kdialogbase.h>



class Configure: public KDialogBase
{
	Q_OBJECT
public:
	Configure(QWidget *parent = 0, const char *name = 0);
	~Configure();

protected:
	void reset();

protected slots:
	void previewSelected(int id_);
	void deviceSelected(int id_);

	virtual void slotDefault();
	virtual void slotOk();
	virtual void slotApply();

private:
	KConfig *config;

	QCheckBox *gen_tooltips;
	int gen_viewmode;
	QRadioButton *gen_intern_multi;
	QRadioButton *gen_intern_single;
	QRadioButton *gen_external;
	QRadioButton *gen_custom;
	QLineEdit *gen_viewer;

	QRadioButton *mod_serial;
	QComboBox *mod_ser_device;
	QComboBox *mod_ser_speed;
	QRadioButton *mod_usb;
	QComboBox *mod_usb_device;
	QCheckBox *mod_loadnew;
	QCheckBox *mod_deletefax;

	QSpinBox *prt_lmargin;
	QSpinBox *prt_rmargin;
	QSpinBox *prt_tmargin;
	QSpinBox *prt_bmargin;

	QLineEdit *mail_server;
	QLineEdit *mail_port;
	QLineEdit *mail_name;
	QLineEdit *mail_org;
	QLineEdit *mail_email;
	QLineEdit *mail_reply;
};


#endif // CONFIGURE_H
