/*
     File: khronodock.h
     Khrono : Watch, timer and countdown utility for KDE 2
     Copyright (C) 1999,2000,2001 Axel von Arnim <vonarnim@club-internet.fr>

     This program is free software; you can redistribute it and/or
     modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either
     version 2 of the License, or (at your option) any later
     version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef KHRONO_DOCK_H
#define KHRONO_DOCK_H

#include <kdockwindow.h>
#include "khronotimer.h"

class QMouseEvent;
class KhronoDisplay;

class KhronoDock : public KDockWindow
{
  Q_OBJECT
public:
  KhronoDock( QWidget *parent=0, const char *name=0, KhronoDisplay *app=0 );

protected slots:
  void displayTime();
  void setStart(bool);
  void setPause(bool);
  void setMode(int);
  void lap();
  void setTheme(QColorGroup*);

protected:
  virtual void paintEvent( QPaintEvent * );
  virtual void mousePressEvent( QMouseEvent * );
  
private:
  KhronoDisplay *mainChrono;
  QString *timeStr;
  bool startState;
  bool pauseState;
  int laps_;
};

#endif /* KHRONO_DOCK_H */
