/***************************************************************************
                          symboldlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2001 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYMBOLDLG_H
#define SYMBOLDLG_H

#include <qdialog.h>
#include <qpushbutton.h>

class QButtonGroup;
class KplSpinBox;

/**
  * Symbol button. Provides a button which shows the current
  * plot symbol and opens a dialog to select markers and line
  * types.
  * @author Werner Stille
  */
class SymbolButton : public QPushButton {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param sb pointer to QSpinBox containing the symbol number.
   */
  SymbolButton(QWidget* parent, KplSpinBox* sb);
  /** Destructor. */
  ~SymbolButton();

protected:
  KplSpinBox* symb;

public slots:
  /**
   * Sets pixmap on symbol selection button.
   * @param isymb symbol number.
   */
  void setButtonSymbol(int isymb);

protected slots:
  /** Displays the dialog for selection of lines and markers. */
  void slotSymbol();
};

/**
  * Symbol dialog. Provides a dialog to select markers and line types.
  * @author Werner Stille
  */
class SymbolDlg : public QDialog {
  Q_OBJECT

public:
  /**
   * Constructor.
   * @param parent pointer to parent widget.
   * @param sb pointer to QSpinBox containing the symbol number.
   */
  SymbolDlg(QWidget* parent, KplSpinBox* sb);
  /** Destructor. */
  ~SymbolDlg();

protected:
  KplSpinBox* sb;
  QButtonGroup* bg;

protected slots:
  /** Accepts selection and leaves the dialog. */
  void slotOK();
};

#endif
