/************************************************************************************
                          kbeartransferviewitem.cpp  -  description
                             -------------------
    Begin					: Wed Jul 26 2000
    Copyright				: (C) 2000 by Bjrn Sahlstrm
    Email						: bjorn.sahlstrom@mail.bip.net
 ***********************************************************************************/

/************************************************************************************
 *																																			*
 *   This program is free software; you can redistribute it and/or modify			*
 *   it under the terms of the GNU General Public License as published by	*
 *   the Free Software Foundation; either version 2 of the License, or				*
 *   (at your option) any later version.																		*
 *																																			*
 ************************************************************************************/

#include "kbeartransferviewitem.h"
#include "kbeartransferview.h"
#include <kdebug.h>
//-----------------------------------------------
KBearTransferViewItem::KBearTransferViewItem( KIO::CopyJob* job,
								KBearTransferView* v,	const QString& host, bool move  )
	:	ProgressBase(0),	KBearTreeViewItem( v, host, 0 ),
		p_myTransferView( v ),p_myJob( job )
	
{
	myPix = KGlobal::iconLoader()->loadIcon( "ftp", KIcon::Small );
	setPixmap( &myPix );
	setJob( job );
	connect( p_myTransferView, SIGNAL( showMenu( KBearTransferViewItem* ) ),
	   				this, SLOT( slotShowMenu( KBearTransferViewItem* ) ) );
 	
 	setText( 1, job->srcURLs().first().path() );
	setText( 2 , job->destURL().path() );
	
	if( move )
		setText( 3 , i18n("Moving") );
	else
		setText( 3 , i18n("Copying") );
	
	QString text( i18n("%1 bytes/sec").arg( 0 ) );
	setText( 7 , text );
	QTime t( 0, 0 );
	setText( 8 , t.toString() );
}
//-----------------------------------------------
KBearTransferViewItem::~KBearTransferViewItem(){
}
//-----------------------------------------------
void KBearTransferViewItem::slotTotalSize( KIO::Job*, unsigned long totSize ) {
	QString text( i18n("%1").arg( createSizeString(totSize) ) );
	setText( 4 , text );
	totalSize = totSize;
}
//-----------------------------------------------
void KBearTransferViewItem::slotProcessedSize( KIO::Job*, unsigned long procSize ) {
	QString text( i18n("%1").arg( createSizeString(procSize) ) );
	setText( 5 , text );
	processedSize = procSize;
}
//-----------------------------------------------
void KBearTransferViewItem::slotPercent( KIO::Job*, unsigned long percent ) {
	QString text( i18n("%1 %").arg( percent ) );
	setText( 6 , text );
}
//-----------------------------------------------
void KBearTransferViewItem::slotSpeed( KIO::Job*, unsigned long speed ) {
	QString text( i18n("%1/sec").arg( createSizeString(speed) ) );
	setText( 7 , text );
	if( speed > 0 ) {
		QTime t = KIO::calculateRemaining( totalSize, processedSize, speed );
		setText( 8 , t.toString() );
	}
}
//-----------------------------------------------
void KBearTransferViewItem::slotTotalDirs( KIO::Job*, unsigned long totDirs ) {
	QString text( i18n("%1").arg( totDirs ) );
	setText( 9 , text );
}
//-----------------------------------------------
void KBearTransferViewItem::slotTotalFiles( KIO::Job*, unsigned long totFiles ) {
	QString text( i18n("%1").arg( totFiles ) );
	setText( 10 , text );
}
//-----------------------------------------------
void KBearTransferViewItem::slotShowMenu( KBearTransferViewItem* item ){
	if( item != this )
		return;
	disconnect( p_myTransferView, SIGNAL( showMenu( KBearTransferViewItem* ) ),
	   				this, SLOT( slotShowMenu( KBearTransferViewItem* ) ) );
	QPopupMenu menu( this );
	menu.insertItem( i18n("&Cancel"), this, SLOT( slotStop() ) );
	menu.setMouseTracking( true );
	menu.exec( QCursor::pos() );
}
//-----------------------------------------------
QString KBearTransferViewItem::createSizeString( unsigned long size ){
	unsigned int mb = 1048576; // 1024*1024
	QString text;
	if( size >= mb ) {
		text = i18n("%1 Mb").arg( double(size)/(mb), 0, 'f', 2 );	
	}
	else if( size >= 1024 ) {
		text = i18n("%1 Kb").arg( double(size)/1024, 0, 'f', 2 );	
	}
	else {
		text = i18n("%1 bytes").arg( size );
	}
	return text;
}
//-----------------------------------------------
void KBearTransferViewItem::slotFinished( KIO::Job* ) {
	p_myJob = 0L;
	emit finished();
	ProgressBase::slotFinished(0L);
}
//-----------------------------------------------
void KBearTransferViewItem::slotRemoveItem() {
	delete this;
}
//-----------------------------------------------
void KBearTransferViewItem::slotStop() {
	p_myTransferView->takeItem( this );
	if( p_myJob )
		emit finished();
	p_myJob = 0L;
	ProgressBase::slotStop();
	QTimer::singleShot( 20000, this, SLOT( slotRemoveItem()));
}
//-----------------------------------------------

