//**************************************************************************
//                        viewsettingswidget.cpp  -  description
//                           -------------------
//  begin                : Sat Sep 30 2000
//  copyright            : (C) 2000 by Bjrn Sahlstrm
//  email                : bjorn@kbear.org
//**************************************************************************/

//**************************************************************************
//                                                                         *
//   This program is free software; you can redistribute it and/or modify  *
//   it under the terms of the GNU General Public License as published by  *
//   the Free Software Foundation; either version 2 of the License, or     *
//   (at your option) any later version.                                   *
//                                                                         *
//**************************************************************************/
#include "viewsettingswidget.h"

//-----------------------------------------------
ViewSettingsWidget::ViewSettingsWidget(QWidget *parent, const char *name)
	:	QWidget(parent,name){
	pathString = KGlobal::dirs()->findResourceDir( "data","kbear/pics/detailview_thumb.png" );
	initDialog();
	QWhatsThis::add(p_detailedViewButton,i18n("Check this option if you want the default view to be a detailed list."));
	QWhatsThis::add(p_iconViewButton,i18n("Check this option if you want the default view to be an icon list."));
	QWhatsThis::add(p_transferViewCheckBox,i18n("Check this option if you want the transfer view to be displayed by default."));
	QWhatsThis::add(p_treeViewCheckBox,i18n("Check this option if you want the tree view to be visible by deafult."));
	QWhatsThis::add(p_toolBarCheckBox,i18n("Check this option if you want the toolbar to be visible by default."));
	QWhatsThis::add(p_statusBarCheckBox,i18n("Check this option if you want the statusbar to be visible by default."));
	QWhatsThis::add(p_taskBarCheckBox,i18n("Check this option if you want the taskbar to be visible by default."));
	QWhatsThis::add(p_localFileSysCheckBox,i18n("Check this option if you want the local filesystem view to be visible by default."));
	QWhatsThis::add(p_runSettingsCheckBox,i18n("Check this option if you want the settings used when closing the application to be the default at next startup."));
	viewTypePicture->setBackgroundPixmap(QPixmap(pathString+"kbear/pics/detailview_thumb.png"));
	connect( p_detailedViewButton, SIGNAL( clicked() ), this, SLOT( slotViewSelect() ) );
	connect( p_iconViewButton, SIGNAL( clicked() ), this, SLOT( slotViewSelect() ) );
}
//-----------------------------------------------
ViewSettingsWidget::~ViewSettingsWidget(){
}
//-----------------------------------------------
void ViewSettingsWidget::slotViewSelect(){
	if( p_detailedViewButton->isOn() )
		viewTypePicture->setBackgroundPixmap(QPixmap(pathString+"kbear/pics/detailview_thumb.png"));
	else
		viewTypePicture->setBackgroundPixmap(QPixmap(pathString+"kbear/pics/iconview_thumb.png"));

}
//-----------------------------------------------
