/***************************************************************************
                          kbearfileiconview.h  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KBEARFILEICONVIEW_H
#define KBEARFILEICONVIEW_H

//////////////////////////////////////////////////////
// Qt specific includes
#include <qwidget.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kfileiconview.h>
//////////////////////////////////////////////////////
// application specific includes
#include "kbearfileicondrag.h"
#include "kbeardiroperator.h"

class KBearDirOperator;

/**
	*This is a fileview inherited from KFileIconView.
	*It adds "drag and drop" suitable for KBear
  *@author Bjrn Sahlstrm
  */
class KBearFileIconView : public KFileIconView  {
   Q_OBJECT
public: 
	KBearFileIconView( QWidget* parent, const char *name=0);
	~KBearFileIconView();
	/** Sets the @ref KBearDirOperator that operates for this view */
	virtual void setOperator(QObject *ops);
protected: // Protected methods
	/**  */
	virtual void contentsDragEnterEvent( QDragEnterEvent *e );
	/**  */
	virtual void contentsDragMoveEvent( QDragMoveEvent *e );
	/**  */
	virtual void contentsDragLeaveEvent( QDragLeaveEvent *e );
	/**  */
	virtual void contentsDropEvent( QDropEvent* e );
	/**  */
	virtual QDragObject* dragObject();
	/** Creates the drag item and starts the drag */
	virtual void startDrag();
	
protected slots: // Protected
	/**  */
	void slotOpenFolder();
private: // Protected attributes
	QIconViewItem* dropItem;
	QTimer myAutoOpenTimer;
	QDragObject* myDragObject;
	KBearDirOperator* myOp;
};

#endif
