/***************************************************************************
                          loadoids.cpp  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          main.cpp  -  description                              
                             -------------------                                         
    begin                : Don Jun 15 22:33:56 CEST 2000
                                           
    copyright            : (C) 2000 by Jan Mueller                         
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include "analyze.h"
#include <signal.h>
#include <unistd.h>
#include <qfile.h>
#include "resource.h"

Sql svr1(DB_NAME);
Sql svr2(DB_NAME);
QString target;

void update(QString table, QString field) {
	svr1.exec("begin");
	QString t("select oid,"); t+=field+" from "+table;
	svr1.exec(t);
	for(int i=0; i<svr1.tuples(); i++) {
		if( strcmp(svr1.getValue(i, field), "0")!=0 ) {
			QString s("update "); s+=table+" set "+field+"=lo_import('";
			s+=target+"/"+svr1.getValue(i, field);
			s+="') where oid="; s+=svr1.getValue(i, "oid");
			svr2.exec("begin");
			svr2.exec(s);
			svr2.exec("end");
		}
	}
	svr1.exec("end");
}


int main(int argc, char** argv){

	for(int i=0; i<argc; i++) {
		if(!strcmp(argv[i], "-i")) {
			i++;
			target=argv[i];
		}
	}
	if(target.isEmpty()) {
		cout<<"\nTool loading large objects from a directory in the kaspaliste database.\n" \
					"This program is part of the kaspaliste distribution\n (C) 2000 Jan Mueller\n" \
					"See COPYING file for the licence.\n" \
					"Syntax: loadoids -i <directory>\n";
		exit(1);
	}


try {
	update("author", "memo");
	update("author", "picture");
	update("part", "memo");
	update("note", "memo");
	update("publication", "memo");
	update("partdata", "file");
	
} catch (KaspaErr& err) {
	cout<<"Error: "<< err.error();
}
return EXIT_SUCCESS;
}


