/***************************************************************************
                          partmemo.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: partmemo.h
	Last generated: Sun Sep 26 14:08:25 1999

 *********************************************************************/

#ifndef PartMemo_included
#define PartMemo_included

#include "partmemodata.h"
#include "partbase.h"
#include "kaspaurl.h"

class PartMemo : public PartMemoData
{
    Q_OBJECT
private:
	PartMemo(const PartMemo&);
	PartMemo& operator=(const PartMemo&);

protected:
    PartBase *partmemo;
		void save(bool block=false);
		KaspaURL _url;

public:

    /** Load part from WHERE clause. Must not return more than one row. Calls init().
     */
    PartMemo(KaspaURL url, Sql *conn, QWidget* parent, const char* name);

    /** Updates table, if data has changed and is not read-only. Deletes toolbar and menuitems.
	Clears any messages in the statusline.
     */
    virtual ~PartMemo();

    virtual const char *url() { return _url; }

    /** Creates a toolbar and alters the menu. Called by the constructors.
     */

    virtual void setWorkingGUI();
    virtual void setReadOnlyGUI();
    virtual void setInvalidGUI();
    virtual void setReadWriteGUI();

    /** Locks GUI, if invalid and returns status.
     */
    virtual bool isValid();
    virtual bool isWorking() { return partmemo->isWorking(); }
    virtual bool isReadOnly() { return partmemo->isReadOnly(); }
    virtual bool closeRequest();
    virtual void setFields();

public slots:

    /** Rereads data from table. Sends message with(out) timeout to statusline (if failed).
     */
    virtual void reread();

    /** Flushes data. Sends message with timeout to statusline.
     */
    virtual void flush();

    /** Deletes row. Sends permanent messages to statusline.
     */
    virtual void del();

		void showPart();
		void showPubl();
		KToolBar *getToolBar();
};

#endif // PartMemo_included



















