/***************************************************************************
                          part.h  -  description
                             -------------------
    begin                : Sun Jan 7 2001
    copyright            : (C) 2001 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/**********************************************************************

	--- Qt Architect generated file ---

	File: part.h
	Last generated: Sun Sep 26 13:50:53 1999

 *********************************************************************/

#ifndef Part_included
#define Part_included

#include "partdata.h"
#include "partbase.h"
#include <qpopupmenu.h>
#include "kaspaurl.h"
#include "bibtexfactory.h"

class Part : public PartData
{
    Q_OBJECT

private:
		Part(const Part&);
		Part& operator=(const Part&);

protected:
    PartBase *part;
		KaspaURL _url;
		bool havefirstfile;
		void save(bool block=false);
		BibTexFactory bt;
		PublTitle *pt;

public:

    /** Load part from WHERE clause. Must not return more than one row. Calls init().
     */
    Part(KaspaURL url, Sql *conn, QWidget* parent, const char* name);

    /** Updates table, if data has changed and is not read-only. Deletes toolbar and menuitems.
	Clears any messages in the statusline.
     */
    virtual ~Part();

    virtual const char *url() { return _url; }

    /** Creates a toolbar and alters the menu. Called by the constructors.
     */
    virtual void setWorkingGUI();
    virtual void setReadOnlyGUI();
    virtual void setInvalidGUI();
    virtual void setReadWriteGUI();

    /** Locks GUI, if invalid and returns status.
     */
    virtual bool isValid();
    virtual bool isWorking() { return part->isWorking(); }
    virtual bool isReadOnly() { return part->isReadOnly(); }
    virtual bool closeRequest();
    virtual void setFields();

		virtual void unlockGUI(bool working);
		bool isCollection();

public slots:

    /** Rereads data from table. Sends message with(out) timeout to statusline (if failed).
     */
    virtual void reread();

    /** Flushes data. Sends message with timeout to statusline.
     */
    virtual void flush();

    /** Deletes row. Sends permanent messages to statusline.
     */
    virtual void del();

		void insLink();
		void newLink();
    void remLink();

    void insAuthor();
		void newAuthor();
		void remAuthor();
  	
		void showPubl();
		void showPartMemo();
		void showIntro();

		void editData();

    virtual void generateBibTex();

		KToolBar *getToolBar();
};

#endif // Part_included






























