/***************************************************************************
                          KaspaListBox.h  -  description
                             -------------------
    begin                : Sun Sep 26 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef KaspaListBox_H
#define KaspaListBox_H

#include <qwidget.h>
#include <qlistbox.h>
#include "kaspabase.h"


/**
  *@author Jan Mueller
  */

class KaspaListBox : public QListBox  {
   Q_OBJECT

private:
	KaspaListBox(const KaspaListBox&);
	KaspaListBox& operator=(const KaspaListBox&);
	int maxwidth;

protected:		
	QString title;
	
public:
	KaspaListBox(QWidget *parent=0, const char *name=0);
	~KaspaListBox();
	void set(Title *r);
	void append(Title *r);
	Oid getCurrentOid();
	const char *getCurrentData();
	void setTitle(QString t) {
	  title=t;
	};
};

#endif