/***************************************************************************
                          KaspaListBox.cpp  -  description
                             -------------------
    begin                : Sun Sep 26 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/



#include "kaspalistbox.h"
#include "kaspalistboxitem.h"
#include <qscrollbar.h>

KaspaListBox::KaspaListBox(QWidget *parent, const char *name ) :
		QListBox(parent,name), maxwidth(-1) {
  setFocusPolicy( QWidget::StrongFocus );
  setBackgroundMode( QWidget::PaletteBase );
  setFontPropagation( QWidget::SameFont );
  setPalettePropagation( QWidget::SameFont );
}

KaspaListBox::~KaspaListBox(){
}

void KaspaListBox::set(Title *r) {
	bool au=autoUpdate();
	setAutoUpdate(false);
  clear();
	append(r);
	setAutoUpdate(au);
};

void KaspaListBox::append(Title *r) {
	bool au=autoUpdate();
	setAutoUpdate(false);

  Title *next=r;
  while(next) {
  	KaspaListBoxItem *item=new KaspaListBoxItem(0L, next);
  	insertItem(item,0);
    next=next->getNext();
  }

  // updateGeo(this->width());
	setAutoUpdate(au);
	repaint();
}	

Oid KaspaListBox::getCurrentOid() {
	KaspaListBoxItem *i = dynamic_cast<KaspaListBoxItem*>(item(currentItem()));
	if(i && i->title()) return i->title()->getOid();
	else return InvalidOid;
}


const char *KaspaListBox::getCurrentData() {
	KaspaListBoxItem *i = dynamic_cast<KaspaListBoxItem*>(item(currentItem()));
	if(i && i->title()) return i->title()->getType();
	else return InvalidOid;
}

