/***************************************************************************
                          author.h  -  description
                             -------------------
    begin                : Tue Sep 7 1999
    copyright            : (C) 1999 by Jan Mueller
    email                : janmueller7@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef Author_included
#define Author_included

#include "authordata.h"
#include "authorbase.h"
#include <qpopupmenu.h>
#include <qwidget.h>
#include <kapp.h>
#include <ktoolbar.h>
#include "kaspaurl.h"

/** GUI-class for Authors
 */
class Author : public AuthorData
{
    Q_OBJECT

	private:
		Author &operator=(const Author&);
		Author(const Author&);
    void save(bool block=false);

	protected:
    AuthorBase *author;
		KaspaURL _url;

	public:
    virtual void setFields();

    /** Load author from WHERE clause. Must not return more than one row. Calls init().
     */
    Author(KaspaURL url, Sql *conn, QWidget* parent, const char* name);

    /** Updates table, if data has changed and is not read-only. Deletes toolbar and menuitems.
	Clears any messages in the statusline.
    */
    virtual ~Author();

    /** Locks GUI.
     */
    virtual void setWorkingGUI();

    /** Unlocks the fields.
     */
    virtual void setReadOnlyGUI();
    virtual void setInvalidGUI();
    virtual void setReadWriteGUI();

    /** Locks GUI, if invalid and returns status.
     */
    virtual bool isValid();
    virtual bool isReadOnly() { return author->isReadOnly(); }
    virtual bool isWorking() { return author->isWorking(); }

    virtual bool closeRequest();
    virtual const char *url() { return _url; }

    KToolBar *setToolBar(KToolBar *tb);

 public slots:
    /** Rereads data from table. Sends message with(out) timeout to statusline (if failed).
     */
    virtual void reread();

    /** Flushes data. Sends message with timeout to statusline.
     */
		virtual void flush();

    /** Deletes row. Sends permanent messages to statusline.
     */
    virtual void del();

 		KToolBar *getToolBar();

    /** Creates new Note.
     */
    void newLink();
    void insLink();
    void remLink();
    void newPubl();
    void insPubl();
    void remPubl();
    void insPart();
    void remPart();
};
#endif // Author_included
