/*
 * kvideodb.cpp.
 *
 * Copyright (C) 1998 Carsten Heiming
 *
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <string.h>

#include <kfiledialog.h>
#include <kmsgbox.h>
#include <kiconloader.h>
#include <ktoolbar.h>
#include <kmenubar.h>

#include <qcursor.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qmsgbox.h>
#include <qkeycode.h>
#include <qlistbox.h>
#include <qdialog.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qprinter.h>
#include <qprintdialog.h>
#include <qpainter.h>
#include <qgroupbox.h>

#include "movieWindow.h"
#include "fakebuttons.h"
#include "kvideodb.h"
#include "movies.h"
#include "options.h"
#include "hilfsrout.h"
#include "cass.h"
#include "bstar.h"
#include "search.h"
#include "print.h"
#include "cassette.h"
#include "spaceWin.h"

//#include "database.h"

// globale Variablen
cassWindow *kassette;
bool changed=FALSE;
bool titleChange = FALSE;

extern void changeOptions(const char *,QString);
extern Movie *gCurMov;

extern QStrList printerConf;

// 1. Datei-Pfade
char appsPath[50];
char localConfigPath[60];

// 2. Konfigurations-Einstellungen
Config config;

// 3. global internal Variables
int properties = 1;
QString VideoFile="";

BStarTree *anchor = new BStarTree();

extern Movie *dummy;

// Config-Variables
int defaultIcons = 1;

// Variables to determine where the Menubar and Toolbar are located
int menuFloating = 0;
int menuTop = 1;
int toolbarFloating = 0;
int toolbarTop = 1;
int toolbarSide = 0;
int toolbarWidth = 0;
int toolbarHeight = 0;
const int xSize = 750;
const int ySize = 540;


/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//                       Constructor for the Main Window                   //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

KVideoDB::KVideoDB(){

  setMinimumSize(750,485);
  setMaximumSize(780,540);
  setFixedSize(750,540);
  
  setCaption(i18n("KVideoDB - Homevideo Database"));
  char aboutText[500] = "KVideoDB " VERSION "\n\n";
  strcat(aboutText, " 1998 Carsten Heiming\n");
  strcat(aboutText, i18n("Documentation by Stefan Siegel\n")); 
  strcat(aboutText, i18n("Danish Translation by Martin Mller\n"));
  strcat(aboutText, i18n("Database to help the user managing his Homevideo-collection"));
  
  // Build a Frame around the Buttons and Labels for a nice look
  
  buttonFrame = new QFrame(this,"",0,TRUE);
  buttonFrame->setGeometry(290,70,440,455);
  buttonFrame->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);

  // TabBar

  dataTab = new KTabCtl(this,"dataTab");
  dataTab->setGeometry(295,75,430,445);
  
  page1 = new QWidget(dataTab,"p1");
  page2 = new QWidget(dataTab,"p2");
  page3 = new QWidget(dataTab,"p3");

  dataTab->addTab(page1,i18n("&Data"));
  dataTab->addTab(page2,i18n("&Properties"));
  dataTab->addTab(page3,i18n("&Comment"));


  // create a DropZone over the entire window and connect it
  // to the slotDropEvent

  connect( new KDNDDropZone( this , DndURL), 
	   SIGNAL( dropAction( KDNDDropZone *) ), 
	   SLOT( slotDropEvent( KDNDDropZone *) ) );

  ///////////////////////////////////////////////////////////////////////////
  // build a menubar
  // File Menu
  file = new QPopupMenu;
  file->insertItem(i18n("&New"), this, SLOT(slotNewWindow()), CTRL+Key_N,1);
  file->insertItem(i18n("&Open..."), this, SLOT(slotLoadFile()), CTRL+Key_O,2);
  file->insertSeparator();
  recentFile = new QPopupMenu;
  config.recent.first();
  int menuIndex=1;

  while(config.recent.current()){
    if (strlen(config.recent.current())>1){
      char count[5];
      sprintf(count,"&%d. ",menuIndex);
      menuIndex++;
      QString menuString = count;
      menuString += config.recent.current();
      recentFile->insertItem(menuString);
    }
    config.recent.next();
  }
  file->insertItem(i18n("Open &Recent"),recentFile);
  connect(recentFile, SIGNAL(activated(int)), SLOT(slotRecent(int)));

  file->insertSeparator();
  file->insertItem(i18n("&Save"), this, SLOT(slotSaveKnownFile()), CTRL+Key_S,4);
  file->insertItem(i18n("Save &As..."), this, SLOT(slotSaveFile()), CTRL+Key_A,5);
  file->insertSeparator();
  file->insertItem(i18n("&Print..."), this, SLOT(slotPrintFile()), CTRL+Key_P,6);
  file->insertSeparator();
  file->insertItem(i18n("&Quit"), this, SLOT(slotQuit()), CTRL+Key_Q);
  file->setItemEnabled(4,FALSE);
  file->setItemEnabled(5,FALSE);
  file->setItemEnabled(6,FALSE);

  menuBar()->insertItem(i18n("&File"), file);
  
  // Edit Menu
  edit = new QPopupMenu;
  edit->insertItem(i18n("&Add Movie"), this, SLOT(slotAddMovie()));
  edit->insertItem(i18n("&Edit Movie"), this, SLOT(slotEditMovie()));
  edit->insertItem(i18n("&Delete Movie"), this, SLOT(slotDelMovie()));
  edit->insertSeparator();
  edit->insertItem(i18n("&Search Movie"), this, SLOT(slotSearch()));
  edit->insertSeparator();
  edit->insertItem(i18n("&Reset Movie-List"),this,SLOT(slotReset()));
  edit->setItemEnabled(edit->idAt(1),FALSE);
  edit->setItemEnabled(edit->idAt(2),FALSE);
  edit->setItemEnabled(edit->idAt(4),FALSE);
  edit->setItemEnabled(edit->idAt(6),FALSE);
  menuBar()->insertItem(i18n("&Edit"), edit);

  // Options Menu
  options = new QPopupMenu;
  options->setCheckable(TRUE);
  
  options->insertItem(i18n("Show all &Properties"),this,SLOT(slotOptionsProp()));
  options->setId(1,1);
  if (config.defIcons == "Yes")
    options->setItemChecked( options->idAt( 0 ), TRUE );
  else
    options->setItemChecked( options->idAt( 0 ), FALSE);
  options->insertSeparator();

  options->insertItem(i18n("Show &Cassette Window"),this,SLOT(slotShowCassWin()));
  if (config.showC == "Yes")
    options->setItemChecked( options->idAt( 2 ), TRUE );
  else 
    options->setItemChecked( options->idAt( 2 ), FALSE );
  
  options->insertItem(i18n("S&wallow Cassette Window"),this,SLOT(slotSwallowCassWin()));
  if (config.swallowC == "Yes")
    options->setItemChecked( options->idAt( 3 ), TRUE );
  else 
    options->setItemChecked( options->idAt( 3 ), FALSE );
  
  options->insertSeparator();

  options->insertItem(i18n("As&k when deleting"),this,SLOT(slotAskDel()));
  if (config.askDelete == "Yes")
    options->setItemChecked( options->idAt( 5 ), TRUE );
  else 
    options->setItemChecked( options->idAt( 5 ), FALSE );
  
  options->insertSeparator();

  options->insertItem(i18n("&Options..."),this,SLOT(slotConfigure()));
  options->insertSeparator();
  options->insertItem(i18n("&Save Options"),this,SLOT(slotSaveOptions()));
  menuBar()->insertItem(i18n("&Options"),options);
  
  // Separator for the Help Menu
  menuBar()->insertSeparator();

  // Help Menu
  // let KDE generate a nifty help menu
  QPopupMenu* help = kapp->getHelpMenu(true,aboutText);
  menuBar()->insertItem(i18n("&Help"), help);
  connect( menuBar(), SIGNAL(moved(menuPosition)), SLOT(slotBarMoved()));  
  ////////////////////////////////////////////////////////////////////////////

  ////////////////////////////////////////////////////////////////////////////
  // build a toolbar
  toolBar()->insertButton(Icon("exit.xpm"),TOOLBAR_EXIT, true,i18n("Exit"));
  toolBar()->insertButton(Icon("filenew.xpm"),11,true,i18n("New File"));
  toolBar()->insertButton(Icon("fileopen.xpm"),TOOLBAR_OPEN, true,i18n("Open File"));
  toolBar()->insertButton(Icon("filefloppy.xpm"),12,true,i18n("Save File"));
  toolBar()->insertButton(Icon("fileprint.xpm"),13,true,i18n("Print Data"));
  
  toolBar()->insertSeparator();

  toolBar()->insertButton(Icon("start.xpm"),21,true,i18n("Goto start of list"));
  toolBar()->insertButton(Icon("back.xpm"),20,true,i18n("Goto previous record"));
  toolBar()->insertButton(myIcon("reset.xpm"),43,true,i18n("Reset Movie-List"));
  toolBar()->insertButton(Icon("forward.xpm"),23,true,i18n("Goto next record"));
  toolBar()->insertButton(Icon("finish.xpm"),22,true,i18n("Goto end of list"));
  
  toolBar()->insertSeparator();

  toolBar()->insertButton(myIcon("add.xpm"),40,true,i18n("Add Movie"));
  toolBar()->insertButton(myIcon("edit.xpm"),41,true,i18n("Edit Movie"));
  toolBar()->insertButton(myIcon("delete.xpm"),42,true,i18n("Delete Movie"));
  toolBar()->insertButton(myIcon("findf.xpm"),30,true,i18n("Search in database"));
  
  toolBar()->insertButton(myIcon("findc.xpm"),50,true,i18n("Find a certain Cassette"));
  toolBar()->insertLined("",51,SIGNAL(returnPressed()),this,SLOT(slotSearchCass()));
  toolBar()->insertButton(myIcon("finds.xpm"),52,true,i18n("Find a Cassette with equal or more free space"));
  toolBar()->insertLined("",53,SIGNAL(returnPressed()),this,SLOT(slotSearchSpace()));
  toolBar()->alignItemRight(53,TRUE);
  toolBar()->alignItemRight(52,TRUE);
  toolBar()->alignItemRight(51,TRUE);
  toolBar()->alignItemRight(50,TRUE);

  connect(toolBar(), SIGNAL(clicked(int)), SLOT(slotToolbarClicked(int)));
  connect(toolBar(), SIGNAL(moved(BarPosition)), SLOT(slotBarMoved()));
  
  toolbarWidth  = toolBar()->width();
  toolbarHeight = toolBar()->height();

  // disable some buttons
  toolBar()->setItemEnabled(12,FALSE);
  toolBar()->setItemEnabled(13,FALSE);
  toolBar()->setItemEnabled(20,FALSE);
  toolBar()->setItemEnabled(21,FALSE);
  toolBar()->setItemEnabled(22,FALSE);
  toolBar()->setItemEnabled(23,FALSE);
  toolBar()->setItemEnabled(30,FALSE);
  toolBar()->setItemEnabled(41,FALSE);
  toolBar()->setItemEnabled(42,FALSE);
  toolBar()->setItemEnabled(43,FALSE);
  toolBar()->setItemEnabled(50,FALSE);
  toolBar()->setItemEnabled(51,FALSE);
  toolBar()->setItemEnabled(52,FALSE);
  toolBar()->setItemEnabled(53,FALSE);
  
  ///////////////////////////////////////////////////////////////////////////

  ///////////////////////////////////////////////////////////////////////////
  // build Buttons for Video-Description

  xStart = 20;
  int yStart = 20;     // Startvalues for x- und y-Coordinate
  int yOffset = 15;    // Offsets for x- and y-Coordinate
  int xSizeLabel = 130;
  int xSizeButton = 250;
  int ySize =25;       // Size of the Buttons in x- und y-direction
  

  /////////////////////////////////////////////////////////////////////////
  // the Buttons and their Labels

  title_l = new QLabel(i18n("Movie Name:"),page1,"titel",0);
  title_l->setGeometry(xStart,yStart,xSizeLabel,ySize);

  title_b = new FakeButton( page1, "title" );
  title_b->setGeometry( xStart+xSizeLabel+5, yStart, xSizeButton, ySize );
    
  original_l = new QLabel(i18n("Original Name:"),page1,"orig",0);
  original_l->setGeometry(xStart,yStart+ySize,xSizeLabel, ySize);

  original_b = new FakeButton(page1, "original" );
  original_b->setGeometry( xStart+xSizeLabel+5, yStart+ySize, xSizeButton, ySize );
  
  tape_l = new QLabel(i18n("Cassette / Index / Start:"),page1,"kassette",0);
  tape_l->setGeometry(xStart,yStart+2*ySize+yOffset,xSizeLabel,ySize);

  tapeNr_b = new QPushButton( "", page1, "tapeNr" );
  tapeNr_b->setGeometry( xStart+xSizeLabel+5, yStart+2*ySize+yOffset, xSizeButton/4, ySize );
  connect(tapeNr_b, SIGNAL(clicked()), SLOT(slotCassetteClicked()));  
  QToolTip::add(tapeNr_b,i18n("Click here to get all the movies with that property"));
  
  indexNr_b = new FakeButton(page1, "indexNr" );
  indexNr_b->setGeometry( xStart+xSizeLabel+5+xSizeButton/4, yStart+2*ySize+yOffset, xSizeButton/4+1, ySize);

  time_b = new FakeButton(page1,"time");
  time_b->setGeometry(xStart+xSizeLabel+5+xSizeButton/2,yStart+2*ySize+yOffset,xSizeButton/2,ySize);
  
  length_l = new QLabel(i18n("Length / orig. Length:"),page1,"length",0);
  length_l->setGeometry(xStart,yStart+3*ySize+yOffset,xSizeLabel, ySize);

  length_b = new FakeButton(page1, "length" );
  length_b->setGeometry( xStart+xSizeLabel+5, yStart+3*ySize+yOffset, xSizeButton/2, ySize );
  
  olength_b = new FakeButton(page1, "olength" );
  olength_b->setGeometry( xStart+xSizeLabel+5+xSizeButton/2, yStart+3*ySize+yOffset, xSizeButton/2, ySize );

  release_l = new QLabel(i18n("Country / Year:"),page1,"release",0);
  release_l->setGeometry(xStart,yStart+4*ySize+yOffset,xSizeLabel,ySize);

  country_b = new QPushButton( "", page1, "country" );
  country_b->setGeometry( xStart+xSizeLabel+5, yStart+4*ySize+yOffset, xSizeButton/2, ySize );
  connect(country_b, SIGNAL(clicked()), SLOT(slotCountryClicked()));  
  QToolTip::add(country_b,i18n("Click here to get all the movies with that property"));
  
  year_b = new QPushButton( "", page1, "year" );
  year_b->setGeometry( xStart+xSizeLabel+5+xSizeButton/2, yStart+4*ySize+yOffset, xSizeButton/2, ySize );
  connect(year_b, SIGNAL(clicked()), SLOT(slotYearClicked()));  
  QToolTip::add(year_b,i18n("Click here to get all the movies with that property"));

  date_l = new QLabel(i18n("Date of Recording:"),page1,"date",0);
  date_l->setGeometry(xStart,yStart+5*ySize+yOffset,xSizeLabel,ySize);

  date_b = new QPushButton( "", page1, "date" );
  date_b->setGeometry( xStart+xSizeLabel+5, yStart+5*ySize+yOffset, xSizeButton, ySize );
  connect(date_b, SIGNAL(clicked()), SLOT(slotDateClicked()));  
  QToolTip::add(date_b,i18n("Click here to get all the movies with that property"));

  director_l = new QLabel(i18n("Director:"),page1,"regie",0);
  director_l->setGeometry(xStart,yStart+6*ySize+2*yOffset,xSizeLabel,ySize);

  director_b = new QPushButton( "", page1, "director" );
  director_b->setGeometry( xStart+xSizeLabel+5, yStart+6*ySize+2*yOffset, xSizeButton, ySize );
  connect(director_b, SIGNAL(clicked()), SLOT(slotDirectorClicked()));  
  QToolTip::add(director_b,i18n("Click here to get all the movies with that property"));
  
  producer_l = new QLabel(i18n("Producer:"),page1,"prod",0);
  producer_l->setGeometry(xStart,yStart+7*ySize+2*yOffset,xSizeLabel,ySize);

  producer_b = new QPushButton( "", page1, "producer" );
  producer_b->setGeometry( xStart+xSizeLabel+5,yStart+7*ySize+2*yOffset , xSizeButton, ySize );
  connect(producer_b, SIGNAL(clicked()), SLOT(slotProducerClicked()));  
  QToolTip::add(producer_b,i18n("Click here to get all the movies with that property"));

  composer_l = new QLabel(i18n("Composer:"),page1,"prod",0);
  composer_l->setGeometry(xStart,yStart+8*ySize+2*yOffset,xSizeLabel,ySize);

  composer_b = new QPushButton( "", page1, "producer" );
  composer_b->setGeometry( xStart+xSizeLabel+5,yStart+8*ySize+2*yOffset , xSizeButton, ySize );
  connect(composer_b, SIGNAL(clicked()), SLOT(slotComposerClicked()));  
  QToolTip::add(composer_b,i18n("Click here to get all the movies with that property"));

  cast1_l = new QLabel(i18n("Cast 1:"),page1,"cast1l",0);
  cast1_l->setGeometry(xStart,yStart+9*ySize+3*yOffset,xSizeLabel,ySize);

  cast1_b = new QPushButton( "", page1, "cast1" );
  cast1_b->setGeometry( xStart+xSizeLabel+5, yStart+9*ySize+3*yOffset, xSizeButton, ySize );
  connect(cast1_b, SIGNAL(clicked()), SLOT(slotCast1Clicked()));  
  QToolTip::add(cast1_b,i18n("Click here to get all the movies with that property"));
  
  cast2_l = new QLabel(i18n("Cast 2:"),page1,"cast2l",0);
  cast2_l->setGeometry(xStart,yStart+10*ySize+3*yOffset,xSizeLabel,ySize);

  cast2_b = new QPushButton( "", page1, "cast2" );
  cast2_b->setGeometry( xStart+xSizeLabel+5, yStart+10*ySize+3*yOffset, xSizeButton, ySize );
  connect(cast2_b, SIGNAL(clicked()), SLOT(slotCast2Clicked()));  
  QToolTip::add(cast2_b,i18n("Click here to get all the movies with that property"));
  
  cast3_l = new QLabel(i18n("Cast 3:"),page1,"cast3l",0);
  cast3_l->setGeometry(xStart,yStart+11*ySize+3*yOffset,xSizeLabel,ySize);

  cast3_b = new QPushButton( "", page1, "cast3" );
  cast3_b->setGeometry( xStart+xSizeLabel+5,yStart+11*ySize+3*yOffset, xSizeButton, ySize );
  connect(cast3_b, SIGNAL(clicked()), SLOT(slotCast3Clicked()));  
  QToolTip::add(cast3_b,i18n("Click here to get all the movies with that property"));

  cast4_l = new QLabel(i18n("Cast 4:"),page1,"cast4l",0);
  cast4_l->setGeometry(xStart,yStart+12*ySize+3*yOffset,xSizeLabel,ySize);

  cast4_b = new QPushButton( "", page1, "cast4" );
  cast4_b->setGeometry( xStart+xSizeLabel+5,yStart+12*ySize+3*yOffset, xSizeButton, ySize );
  connect(cast4_b, SIGNAL(clicked()), SLOT(slotCast4Clicked()));  
  QToolTip::add(cast4_b,i18n("Click here to get all the movies with that property"));
  
  ///////////////////////////////
  //                           //
  //           2nd Page        //
  //                           // 
  ///////////////////////////////

  yStart = 20;
  xSizeButton = 220;
  
  category_l = new QLabel(i18n("Category 1:"),page2,"category1l",0);
  category_l->setGeometry(xStart,yStart,xSizeLabel,ySize);

  category1_b = new QPushButton( "", page2, "category1" );
  category1_b->setGeometry( xStart+xSizeLabel+5,yStart, xSizeButton, ySize );
  connect(category1_b, SIGNAL(clicked()), SLOT(slotCat1Clicked()));  
  QToolTip::add(category1_b,i18n("Click here to get all the movies with that property"));
  
  QLabel *category2_l = new QLabel(i18n("Category 2:"),page2,"category2l",0);
  category2_l->setGeometry(xStart,yStart+ySize,xSizeLabel,ySize);

  category2_b = new QPushButton( "", page2, "category2" );
  category2_b->setGeometry( xStart+xSizeLabel+5,yStart+ySize, xSizeButton, ySize );
  connect(category2_b, SIGNAL(clicked()), SLOT(slotCat2Clicked()));  
  QToolTip::add(category2_b,i18n("Click here to get all the movies with that property"));

  flags_l = new QLabel(i18n("Properties:"),page2,"flagsl",0);
  flags_l->setGeometry(xStart,yStart+2*ySize+yOffset,xSizeLabel,ySize);

  sound_b = new QPushButton( "", page2, "sound" );
  sound_b->setGeometry( xStart+xSizeLabel+5,yStart+2*ySize+yOffset,xSizeButton/5, ySize );
  connect(sound_b, SIGNAL(clicked()), SLOT(slotSoundClicked()));  

  color_b = new QPushButton( "", page2, "color" );
  color_b->setGeometry(xStart+xSizeLabel+5+xSizeButton/5,yStart+2*ySize+yOffset, xSizeButton/5, ySize );
  connect(color_b, SIGNAL(clicked()), SLOT(slotColorClicked()));  
  
  speed_b = new QPushButton( "", page2, "speed" );
  speed_b->setGeometry(xStart+xSizeLabel+5+2*xSizeButton/5,yStart+2*ySize+yOffset, xSizeButton/5, ySize );
  connect(speed_b, SIGNAL(clicked()), SLOT(slotSpeedClicked()));  

  commercial_b = new QPushButton( "", page2, "commercial" );
  commercial_b->setGeometry(xStart+xSizeLabel+5+3*xSizeButton/5,yStart+2*ySize+yOffset, xSizeButton/5, ySize );
  connect(commercial_b, SIGNAL(clicked()), SLOT(slotCommercialClicked()));  
    
  source_b = new QPushButton( "", page2, "source" );
  source_b->setGeometry(xStart+xSizeLabel+5+4*xSizeButton/5,yStart+2*ySize+yOffset, xSizeButton/5, ySize );
  connect(source_b, SIGNAL(clicked()), SLOT(slotSourceClicked()));  

  widescreen_b = new QPushButton( "", page2, "wide" );
  widescreen_b->setGeometry( xStart+xSizeLabel+5,yStart+3*ySize+yOffset,xSizeButton/5, ySize );
  connect(widescreen_b, SIGNAL(clicked()), SLOT(slotWidescreenClicked()));  
  
  omu_b = new QPushButton( "", page2, "omu" );
  omu_b->setGeometry(xStart+xSizeLabel+5+xSizeButton/5,yStart+3*ySize+yOffset, xSizeButton/5, ySize );
  connect(omu_b, SIGNAL(clicked()), SLOT(slotSubtitlesClicked()));  
  
  fsk_b = new QPushButton( "", page2, "fsk" );
  fsk_b->setGeometry(xStart+xSizeLabel+5+2*xSizeButton/5,yStart+3*ySize+yOffset, xSizeButton/5, ySize );
  connect(fsk_b, SIGNAL(clicked()), SLOT(slotFskClicked()));  
  
  caption_b = new QPushButton( "", page2, "caption" );
  caption_b->setGeometry(xStart+xSizeLabel+5+3*xSizeButton/5,yStart+3*ySize+yOffset, xSizeButton/5, ySize );
  connect(caption_b, SIGNAL(clicked()), SLOT(slotCaptionClicked()));  
  
  movie_b = new QPushButton( "", page2, "movie" );
  movie_b->setGeometry(xStart+xSizeLabel+5+4*xSizeButton/5,yStart+3*ySize+yOffset, xSizeButton/5, ySize );
  connect(movie_b, SIGNAL(clicked()), SLOT(slotVideonormClicked()));  

  recType_l = new QLabel(i18n("Recording-Type:"),page2,"rTypel",0);
  recType_l->setGeometry(xStart,yStart+4*ySize+2*yOffset,xSizeLabel,ySize);

  recType_b = new QPushButton( "", page2, "rType" );
  recType_b->setGeometry( xStart+xSizeLabel+5,yStart+4*ySize+2*yOffset,xSizeButton, ySize );
  connect(recType_b, SIGNAL(clicked()), SLOT(slotRTypeClicked()));  
  QToolTip::add(recType_b,i18n("Click here to get all the movies with that property"));

  QGroupBox *cassFrame = new QGroupBox(page2,"");
  cassFrame->setGeometry(xStart-10,215,xSizeLabel+xSizeButton+25,185);
  cassFrame->setFrameStyle(QFrame::Box|QFrame::Raised);
  cassFrame->setTitle(i18n("Cassette-Properties:"));

  tapeLength_l = new QLabel(i18n("Tape-Length:"),page2,"tLenl",0);
  tapeLength_l->setGeometry(xStart,yStart+6*ySize+5*yOffset,xSizeLabel,ySize);

  tapeLength_b = new QPushButton( "", page2, "tLen" );
  tapeLength_b->setGeometry( xStart+xSizeLabel+5,yStart+6*ySize+5*yOffset,xSizeButton, ySize );
  connect(tapeLength_b, SIGNAL(clicked()), SLOT(slotTLengthClicked()));  
  QToolTip::add(tapeLength_b,i18n("Click here to get all the movies with that property"));

  tapeType_l = new QLabel(i18n("Tape-Type:"),page2,"tTypel",0);
  tapeType_l->setGeometry(xStart,yStart+7*ySize+5*yOffset,xSizeLabel,ySize);

  tapeType_b = new QPushButton( "", page2, "tType" );
  tapeType_b->setGeometry( xStart+xSizeLabel+5,yStart+7*ySize+5*yOffset,xSizeButton, ySize );
  connect(tapeType_b, SIGNAL(clicked()), SLOT(slotTTypeClicked()));  
  QToolTip::add(tapeType_b,i18n("Click here to get all the movies with that property"));

  freeSearch_l = new QLabel(i18n("Cassette usage:"),page2,"sFSpl",0);
  freeSearch_l->setGeometry(xStart,yStart+8*ySize+6*yOffset,xSizeLabel,ySize);
  cassNo = new QLabel("",page2,"",0);
  cassNo->setGeometry(xStart,yStart+9*ySize+6*yOffset,xSizeLabel,ySize);
  
  freeFrame = new QFrame(page2,"",0,TRUE);
  freeFrame->setGeometry(xStart+xSizeLabel+5,yStart+8*ySize+6*yOffset,xSizeButton,2*ySize);
  freeFrame->setFrameStyle(QFrame::WinPanel|QFrame::Sunken);

  freeLabel = new QLabel("",page2,"",0);
  freeLabel->setPalette(QPalette(QColor(0,255,0)));
  freeLabel->setGeometry(xStart+xSizeLabel+7,yStart+8*ySize+6*yOffset+2,xSizeButton-4,2*ySize-4);
  freeLabel->hide();

  QLabel *division[9];
  division[0] = new QLabel("|",page2,"",0);
  division[0]->setGeometry(xStart+xSizeLabel+5,yStart+10*ySize+6*yOffset,10,ySize-15);
  division[1] = new QLabel("|",page2,"",0);
  division[1]->setGeometry(xStart+xSizeLabel+5+xSizeButton/8,yStart+10*ySize+6*yOffset,10,ySize-20);
  division[2] = new QLabel("|",page2,"",0);
  division[2]->setGeometry(xStart+xSizeLabel+5+xSizeButton/4,yStart+10*ySize+6*yOffset,10,ySize-15);
  division[3] = new QLabel("|",page2,"",0);
  division[3]->setGeometry(xStart+xSizeLabel+5+3*xSizeButton/8,yStart+10*ySize+6*yOffset,10,ySize-20);
  division[4] = new QLabel("|",page2,"",0);
  division[4]->setGeometry(xStart+xSizeLabel+5+xSizeButton/2,yStart+10*ySize+6*yOffset,10,ySize-15);
  division[5] = new QLabel("|",page2,"",0);
  division[5]->setGeometry(xStart+xSizeLabel+5+5*xSizeButton/8,yStart+10*ySize+6*yOffset,10,ySize-20);
  division[6] = new QLabel("|",page2,"",0);
  division[6]->setGeometry(xStart+xSizeLabel+5+3*xSizeButton/4,yStart+10*ySize+6*yOffset,10,ySize-15);
  division[7] = new QLabel("|",page2,"",0);
  division[7]->setGeometry(xStart+xSizeLabel+5+7*xSizeButton/8,yStart+10*ySize+6*yOffset,2,ySize-20);
  division[8] = new QLabel("|",page2,"",0);
  division[8]->setGeometry(xStart+xSizeLabel+5+xSizeButton-2,yStart+10*ySize+6*yOffset,2,ySize-15);
    
  time[0] = new QLabel("0",page2,"",0);
  time[0]->setGeometry(xStart+xSizeLabel+5-2,yStart+10*ySize+7*yOffset,25,ySize-10);
  time[0]->setAlignment(AlignLeft|AlignTop);
  time[1] = new QLabel("",page2,"",0);
  time[1]->setGeometry(xStart+xSizeLabel+5+xSizeButton/4-12,yStart+10*ySize+7*yOffset,25,ySize-10);
  time[1]->setAlignment(AlignHCenter|AlignTop);
  time[2] = new QLabel("",page2,"",0);
  time[2]->setGeometry(xStart+xSizeLabel+5+2+xSizeButton/2-12,yStart+10*ySize+7*yOffset,25,ySize-10);
  time[2]->setAlignment(AlignHCenter|AlignTop);
  time[3] = new QLabel("",page2,"",0);
  time[3]->setGeometry(xStart+xSizeLabel+5+3*xSizeButton/4-12,yStart+10*ySize+7*yOffset,25,ySize-10);
  time[3]->setAlignment(AlignHCenter|AlignTop);
  time[4] = new QLabel("",page2,"",0);
  time[4]->setGeometry(xStart+xSizeLabel+5+xSizeButton-23,yStart+10*ySize+7*yOffset,25,ySize-10);
  time[4]->setAlignment(AlignRight|AlignTop);

  for (int u=0; u < 13; u++){
    movieLabel[u] = new labelFrame("",page2,"");
    movieLabel[u]->hide();
    if (u%2 == 0)
      movieLabel[u]->setPalette(QPalette(QColor(0,255,0)));
    else
      movieLabel[u]->setPalette(QPalette(QColorGroup(QColor(255,0,0),QColor(255,0,0),QColor(255,0,0),QColor(255,0,0),QColor(255,0,0),QColor(255,255,255),QColor(255,0,0)),
					 QColorGroup(QColor(255,0,0),QColor(255,0,0),QColor(255,0,0),QColor(255,0,0),QColor(255,0,0),QColor(255,255,255),QColor(255,0,0)),
					 QColorGroup(QColor(255,0,0),QColor(255,0,0),QColor(255,0,0),QColor(255,0,0),QColor(255,0,0),QColor(255,255,255),QColor(255,0,0))));
  }

  QString prop = i18n("Sound");
  QToolTip::add(sound_b,i18n("Click here to get all the movies with the same ") + prop + i18n("-Attribute"));
  prop = i18n("Color");
  QToolTip::add(color_b,i18n("Click here to get all the movies with the same ") + prop + i18n("-Attribute"));
  prop = i18n("Speed");
  QToolTip::add(speed_b,i18n("Click here to get all the movies with the same ") + prop + i18n("-Attribute"));
  prop = i18n("Commercials");
  QToolTip::add(commercial_b,i18n("Click here to get all the movies with the same ") + prop + i18n("-Attribute"));
  prop = i18n("Source");
  QToolTip::add(source_b,i18n("Click here to get all the movies with the same ") + prop + i18n("-Attribute"));
  prop = i18n("Widescreen");
  QToolTip::add(widescreen_b,i18n("Click here to get all the movies with the same ") + prop + i18n("-Attribute"));
  prop = i18n("Subtitles");
  QToolTip::add(omu_b,i18n("Click here to get all the movies with the same ") + prop + i18n("-Attribute"));
  prop = i18n("Rating");
  QToolTip::add(fsk_b,i18n("Click here to get all the movies with the same ") + prop + i18n("-Attribute"));
  prop = i18n("Closed Captions");
  QToolTip::add(caption_b,i18n("Click here to get all the movies with the same ") + prop + i18n("-Attribute"));
  prop = i18n("Videonorm");
  QToolTip::add(movie_b,i18n("Click here to get all the movies with the same ") + prop + i18n("-Attribute"));
  /////////////////////////////////////////////////////////////////////////////
  // the ratingbar
  rating_b = new QPushButton("",page2,"ratb");
  rating_b->setGeometry(390,375,25,25);
  rating_b->setPixmap(QPixmap::QPixmap(myIcon("findf.xpm")));
  connect(rating_b,SIGNAL(clicked()),SLOT(slotRatingClicked()));
  QToolTip::add(rating_b,i18n("Click here to get all the movies with that property"));

  rating_l = new QLabel("",page2,"ratingl",0);
  rating_l->setGeometry(390,yStart,25,355);
  rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar.xpm")));
  rating_l->setBackgroundPixmap(QPixmap::QPixmap(picPath("ratingbar.xpm")));
  rating_l->setBackgroundMode(NoBackground);

  ////////////////////////////////
  //                            //
  //          3rd Page          //
  //                            //
  ////////////////////////////////

  comments = new QMultiLineEdit(page3,"comment_e");
  comments->setGeometry(20,20,390,375);
  comments->setReadOnly(TRUE);

  ///////////////////////////////////////////////////////////////////////////
  // Buttons for the swallowed cassette-window
  movieB[0] = new QPushButton("",this,"mov1");
  movieB[0]->setGeometry(20,375,250,25);
  connect(movieB[0],SIGNAL(clicked()),SLOT(slotB1Clicked()));
  movieB[1] = new QPushButton("",this,"mov2");
  movieB[1]->setGeometry(20,400,250,25);
  connect(movieB[1],SIGNAL(clicked()),SLOT(slotB2Clicked()));
  movieB[2] = new QPushButton("",this,"mov3");
  movieB[2]->setGeometry(20,425,250,25);
  connect(movieB[2],SIGNAL(clicked()),SLOT(slotB3Clicked()));
  movieB[3] = new QPushButton("",this,"mov4");
  movieB[3]->setGeometry(20,450,250,25);
  connect(movieB[3],SIGNAL(clicked()),SLOT(slotB4Clicked()));
  movieB[4] = new QPushButton("",this,"mov5");
  movieB[4]->setGeometry(20,475,250,25);
  connect(movieB[4],SIGNAL(clicked()),SLOT(slotB5Clicked()));
  movieB[5] = new QPushButton("",this,"mov6");
  movieB[5]->setGeometry(20,500,250,25);
  connect(movieB[5],SIGNAL(clicked()),SLOT(slotB6Clicked()));
  /////////////////////////////////////////////////////////////////////////////
  /////////////////////////////////////////////////////////////////////////////

  yStart = 80;
  // Build a QListBox to browse the Movies
  movies = new QListBox(this,"",0);
  if (config.swallowC == "Yes")
    movies->setGeometry(20,yStart-10,250,290);
  else
    movies->setGeometry(20,yStart-10,250,455);
  connect(movies, SIGNAL(highlighted(int)), SLOT(slotListClicked()));  
  connect(movies, SIGNAL(selected(int)), SLOT(slotListdClicked(int)));
}


///////////////////////////////////////////////////////////////////////////////////
//                                                                               //
//                               ToolBar-Slots                                   //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////

// How to react when an Icon of the Toolbar has been clicked
// to be done in future
void KVideoDB::slotToolbarClicked(int item){
  switch (item) {
  case TOOLBAR_OPEN: // open file
    slotLoadFile();
    break;
  case TOOLBAR_EXIT: // exit program
    slotQuit();
    break;
  case 11:  // new file
    slotNewWindow();
    break;
  case 12: // save
    slotSaveKnownFile();
    break;
  case 13: // print
    slotPrintFile();
    break;
  case 20: // goto first item of the list
    if (0 < movies->currentItem())
      movies->setCurrentItem(movies->currentItem()-1);
    movies->centerCurrentItem();
    break;
  case 21: // goto previous item
    movies->setCurrentItem(0);
    movies->centerCurrentItem();
    break;
  case 22: // goto next item
    movies->setCurrentItem(movies->count()-1);
    movies->setBottomItem(movies->currentItem());
    break;
  case 23: // goto last item of the list
    if ((int)movies->count()-1 > movies->currentItem())
      movies->setCurrentItem(movies->currentItem()+1);
    movies->centerCurrentItem();
    break;
  case 30: // search the list
    slotSearch();
    break;
  case 40: // add a new movie
    slotAddMovie();
    break;
  case 41: // edit the highlighted movie
    slotEditMovie();
    break;
  case 42: // delete the highlighted movie
    slotDelMovie();
    break;
  case 43: // reset the movie-list
    slotReset();
    break;
  case 50: // search cassette
    slotSearchCass();
    break;
  case 52:
    slotSearchSpace();
    break;
  default:
    break;
    
  }
}

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//          Routines how to react if an arbitrary bar has been moved        //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

// An arbitrary bar has been moved,
// now move the widgets so they still fit the window
void KVideoDB::moveWidgets(int dx, int dy)
{
  int yStart = 80;

  movies->move(20+dx,yStart-10+dy);
  movieB[0]->move(20+dx,375+dy);
  movieB[1]->move(20+dx,400+dy);
  movieB[2]->move(20+dx,425+dy);
  movieB[3]->move(20+dx,450+dy);
  movieB[4]->move(20+dx,475+dy);
  movieB[5]->move(20+dx,500+dy);
  buttonFrame->move(290+dx,yStart-10+dy);

  dataTab->move(295+dx,75+dy);
}


// a bar has been moved
void KVideoDB::slotBarMoved()
{
  int dTB = min(toolBar()->width(),toolBar()->height());

  // first decide where the menubar is located and where
  // the toolbar can be found
  // then move the widgets accordingly

  // menubar top
  if (menuBar()->menuBarPos() == KMenuBar::Top)
    if (toolBar()->barPos() == KToolBar::Top){
      moveWidgets(0,0);
      this->setFixedSize(xSize,ySize);
    }
    else if (toolBar()->barPos() == KToolBar::Right){
      moveWidgets(0,-(15));
      this->setFixedSize(xSize+70,ySize+10);
    }     
    else if (toolBar()->barPos() == KToolBar::Left){
      moveWidgets(70,-(15));
      this->setFixedSize(xSize+70,ySize+10);
    }
    else if (toolBar()->barPos() == KToolBar::Bottom){
      moveWidgets(0,-(toolBar()->height()));
      this->setFixedSize(xSize,ySize);
    }
    else if (toolBar()->barPos() == KToolBar::Floating){
      moveWidgets(0,-dTB);
      this->setFixedSize(xSize,ySize-dTB);
    }
    else;

    // menubar bottom
  else if (menuBar()->menuBarPos() == KMenuBar::Bottom)
    if (toolBar()->barPos() == KToolBar::Top){
      moveWidgets(0,-(menuBar()->height()));
      this->setFixedSize(xSize,ySize);
    }
    else if (toolBar()->barPos() == KToolBar::Right){
      moveWidgets(0,-(toolBar()->width()+menuBar()->height()));
      this->setFixedSize(xSize+toolBar()->width(),ySize-toolBar()->width());
    }     
    else if (toolBar()->barPos() == KToolBar::Left){
      moveWidgets(toolBar()->width(),-(toolBar()->width()+menuBar()->height()));
      this->setFixedSize(xSize+toolBar()->width(),ySize-toolBar()->width());
    }
    else if (toolBar()->barPos() == KToolBar::Bottom){
      moveWidgets(0,-(toolBar()->height()+menuBar()->height()));
      this->setFixedSize(xSize,ySize);
    }
    else if (toolBar()->barPos() == KToolBar::Floating){
      moveWidgets(0,-(dTB+menuBar()->height()));
      this->setFixedSize(xSize,ySize-dTB);
    }
    else;
 
    // menubar floating   
  else if (menuBar()->menuBarPos() == KMenuBar::Floating)
    if (toolBar()->barPos() == KToolBar::Top){
      moveWidgets(0,-(menuBar()->height()));
      this->setFixedSize(xSize,ySize-menuBar()->height());
    }
    else if (toolBar()->barPos() == KToolBar::Right){
      moveWidgets(0,-(toolBar()->width()+menuBar()->height()));
      this->setFixedSize(xSize+toolBar()->width(),ySize-menuBar()->height()-toolBar()->width());
    }     
    else if (toolBar()->barPos() == KToolBar::Left){
      moveWidgets(toolBar()->width(),-(toolBar()->width()+menuBar()->height()));
      this->setFixedSize(xSize+toolBar()->width(),ySize-menuBar()->height()-toolBar()->width());
    }
    else if (toolBar()->barPos() == KToolBar::Bottom){
      moveWidgets(0,-(toolBar()->height()+menuBar()->height()));
      this->setFixedSize(xSize,ySize-menuBar()->height());
    }
    else if (toolBar()->barPos() == KToolBar::Floating){
      moveWidgets(0,-(dTB+menuBar()->height()));
      this->setFixedSize(xSize,ySize-menuBar()->height()-dTB);
    }
    else;
}

///////////////////////////////////////////////////////////////////////////////////
//                                                                               //
//                             Dropzone-Routines                                 //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////


// How to react if sth has been dropped over the window
void KVideoDB::slotDropEvent( KDNDDropZone *zone){
  // the user dropped something on our window.
  // get the name of the file
  QString u = zone->getURLList().first();
  
  // remove the prefix (normally "file:/")
  u = u.right(u.length()-u.find('/'));

  // add the file to the "Open Recent" menu-item
  this->addToRecent(u);

  // load file
  if (!this->loadFile(u.data()))
    return;
  // clear the movie-list and write all the movies in it
  this->movies->setUpdatesEnabled(FALSE);
  this->movies->clear();
  this->insertMovies();

  // set global filename
  VideoFile = u;

  // remove all path info for the caption
  while (u.find('/') > -1)
      u = u.right(u.length()-u.find('/')-1);
  
  // set caption
  QString capt = i18n("KVideoDB - Homevideo Database");
  setCaption(capt + " - " + u);

  if (this->movies->count() > 0){
    this->movies->setCurrentItem(0);
    this->setFocus();
    this->movies->setFocus();
  }
  this->movies->setUpdatesEnabled(TRUE);
  this->movies->repaint();
  // set cursor to normal arrow
  KApplication::setOverrideCursor(arrowCursor);
}


///////////////////////////////////////////////////////////////////////////////////
//                                                                               //
//                   Help-Routines for the Button-Slots                          //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////


// one of the cast-buttons has been clicked
// now search the database for that name in the casts
void KVideoDB::findCast(QString content)
{
  Movie *current;
  QStrList movs;
  QString curText = this->movies->text(this->movies->currentItem());
  
  movs.clear();
  
  this->movies->clear();
  
  current = anchor->firstMovie();
  
  while (current){
    if (current->cast.contains(content.data()))
      movs.append(current->title);
    current = anchor->nextMovie();
  }
  this->movies->insertStrList(&movs);
  this->movies->setCurrentItem(this->gotoCurrent(curText));
  this->movies->centerCurrentItem();
}

// a category-button has been clicked
// now search the database for that category
void KVideoDB::findCategory(QString content)
{
  Movie *current;
  QStrList movs;
  QString curText = this->movies->text(this->movies->currentItem());
  
  movs.clear();

  this->movies->clear();
  
  current=anchor->firstMovie();
  
  while (current){
    if (current->category.contains(content.data()))
      movs.inSort(current->title);
    current = anchor->nextMovie();
  }
  this->movies->insertStrList(&movs);
  this->movies->setCurrentItem(this->gotoCurrent(curText));
  this->movies->centerCurrentItem();
}

///////////////////////////////////////////////////////////////////////////////////
//                                                                               //
//                            Button-Slots                                       //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////

// a cast-button has been clicked
void KVideoDB::slotCast1Clicked()
{
  QString content=this->cast1_b->text();
  if (content != ""){
    // enable the reset-button
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->setUpdatesEnabled(FALSE);
    this->findCast(content);
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotCast2Clicked()
{
  QString content=this->cast2_b->text();
  if (content != ""){
    // enable the reset-button
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->setUpdatesEnabled(FALSE);
    this->findCast(content);
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotCast3Clicked()
{
  QString content=this->cast3_b->text();
  if (content != ""){
    // enable the reset-button
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->setUpdatesEnabled(FALSE);
    this->findCast(content);
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotCast4Clicked()
{
  QString content=this->cast4_b->text();
  if (content != ""){
    // enable the reset-button
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->setUpdatesEnabled(FALSE);
    this->findCast(content);
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

// the cassette-button has been clicked
void KVideoDB::slotCassetteClicked()
{
  QString content = this->tapeNr_b->text();
  Movie *current;
  QString curText = this->movies->text(this->movies->currentItem());
  
  QStrList movs;
  this->movies->setUpdatesEnabled(FALSE);
  
  movs.clear();
  
  if (content != ""){
    // clear the movie-list and enable the reset-buttons
    this->movies->clear();
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    
    // get the first movie
    current=anchor->firstMovie();
    
    // run through the database and find all the movies with the same property
    while (current){
      if (current->cassette == content.data())
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(curText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

// the country.button has been clicked
void KVideoDB::slotCountryClicked()
{
  QString content = this->country_b->text();
  Movie *current;
  QStrList movs;
  QString curText = this->movies->text(this->movies->currentItem());

  this->movies->setUpdatesEnabled(FALSE);
  movs.clear();
  
  if (content != ""){
    // clear the movie-list and enable the reset-buttons
    this->movies->clear();
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    
    // get the first movie
    current=anchor->firstMovie();
    
    // run through the database and find all the movies with the same property
    while (current){
      if (current->country == content.data())
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(curText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

// the year-button has been clicked
void KVideoDB::slotYearClicked()
{
  Movie *curMov;
  QString content = this->year_b->text();
  int year = content.toInt();
  QString curText = this->movies->text(this->movies->currentItem());
  
  QStrList movs;
  
  this->movies->setUpdatesEnabled(FALSE);
  movs.clear();
  
  if (content != ""){
    this->movies->clear();
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);

    curMov=anchor->firstMovie();
    
    while (curMov){
      if (curMov->year == year){
	movs.inSort(curMov->title.data());
      }
      curMov = anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(curText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}


// the date-button has been clicked
void KVideoDB::slotDateClicked()
{
  Movie *current;
  QString content = this->date_b->text();
  QString curText = this->movies->text(this->movies->currentItem());
  
  QStrList movs;
  
  this->movies->setUpdatesEnabled(FALSE);
  movs.clear();

  if (content != ""){
    this->toolBar()->setItemEnabled(43,TRUE);    
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    
    current=anchor->firstMovie();
    
    while (current){
      if (current->date->toString() == content)
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(curText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

// the director-button has been clicked
void KVideoDB::slotDirectorClicked()
{
  Movie *current;
  QString content = this->director_b->text();
  QString curText = this->movies->text(this->movies->currentItem());
  
  QStrList movs;
  
  this->movies->setUpdatesEnabled(FALSE);
  movs.clear();

  if (content != ""){
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    
    current=anchor->firstMovie();
    
    while (current){
      if (current->director == content.data())
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(curText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

// the producer-button has been clicked
void KVideoDB::slotProducerClicked()
{
  Movie *current;
  QString content = this->producer_b->text();
  QString curText = this->movies->text(this->movies->currentItem());
  
  QStrList movs;
  
  this->movies->setUpdatesEnabled(FALSE);
  movs.clear();

  if (content != ""){
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    
    current=anchor->firstMovie();
    
    while (current){
      if (current->producer == content.data())
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(curText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotComposerClicked()
{
}

// a category-button has been clicked
void KVideoDB::slotCat1Clicked()
{
  QString content = this->category1_b->text();

  if (content != ""){
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->setUpdatesEnabled(FALSE);
    if (content != i18n("<no Category>"))
      this->findCategory(content);
    else{
      this->findCategory("<?>");
    }
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}
void KVideoDB::slotCat2Clicked()
{
  QString content = this->category2_b->text();

  if (content != ""){
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->setUpdatesEnabled(FALSE);
    if (content != i18n("<no Category>"))
      this->findCategory(content);
    else
      this->findCategory("<?>");
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  } 
}


// the ratingbar-button has been clicked
void KVideoDB::slotRatingClicked()
{
  Movie *current;
  QString key;
  int rating;
  QStrList movs;
  QString curText = this->movies->text(this->movies->currentItem());
  
  this->movies->setUpdatesEnabled(FALSE);
  movs.clear();
  
  if (this->movies->currentItem() > -1){
    key = this->movies->text(this->movies->currentItem());
    current = anchor->currentMovie(key);
    rating  = current->rating;
    
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    
    current = anchor->firstMovie();
    
    while (current){
      if (current->rating == rating)
	movs.inSort(current->title);
      current=anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(curText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotSoundClicked()
{
  QString mText;
  Movie *curMov;
  Movie *current;
  QString bText;
  QStrList movs;

  if (this->movies->currentItem() > -1){
    mText = this->movies->text(this->movies->currentItem());
    curMov = anchor->currentMovie(mText);
    current = anchor->firstMovie();
    bText = curMov->sound;

    this->movies->setUpdatesEnabled(FALSE);
    movs.clear();
  
    while(current){
      if (current->sound == bText.data()){
	movs.inSort(current->title);
      }
      current = anchor->nextMovie();
    }
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(mText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotSpeedClicked()
{
  QString mText;
  Movie *curMov;
  Movie *current;
  QString bText;
  QStrList movs;

  if (this->movies->currentItem() > -1){
    mText = this->movies->text(this->movies->currentItem());
    curMov = anchor->currentMovie(mText);
    current = anchor->firstMovie();
    bText = curMov->speed;

    this->movies->setUpdatesEnabled(FALSE);
    movs.clear();
  
    while(current){
      if (current->speed == bText.data()){
	movs.inSort(current->title);
      }
      current = anchor->nextMovie();
    }
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(mText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotSourceClicked()
{
  QString mText;
  Movie *curMov;
  Movie *current;
  QString bText;
  QStrList movs;

  if (this->movies->currentItem() > -1){
    mText = this->movies->text(this->movies->currentItem());
    curMov = anchor->currentMovie(mText);
    current = anchor->firstMovie();
    bText = curMov->source;

    this->movies->setUpdatesEnabled(FALSE);
    movs.clear();
  
    while(current){
      if (current->source == bText.data()){
	movs.inSort(current->title);
      }
      current = anchor->nextMovie();
    }
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(mText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotVideonormClicked()
{
  QString mText;
  Movie *curMov;
  Movie *current;
  QString bText;
  QStrList movs;

  if (this->movies->currentItem() > -1){
    mText = this->movies->text(this->movies->currentItem());
    curMov = anchor->currentMovie(mText);
    current = anchor->firstMovie();
    bText = curMov->videonorm;

    this->movies->setUpdatesEnabled(FALSE);
    movs.clear();
  
    while(current){
      if (current->videonorm == bText.data()){
	movs.inSort(current->title);
      }
      current = anchor->nextMovie();
    }
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(mText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotFskClicked()
{
  QString mText;
  Movie *curMov;
  Movie *current;
  QString bText;
  QStrList movs;

  if (this->movies->currentItem() > -1){
    mText = this->movies->text(this->movies->currentItem());
    curMov = anchor->currentMovie(mText);
    current = anchor->firstMovie();
    bText = curMov->fsk;

    this->movies->setUpdatesEnabled(FALSE);
    movs.clear();
  
    while(current){
      if (current->fsk == bText.data()){
	movs.inSort(current->title);
      }
      current = anchor->nextMovie();
    }
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(mText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotColorClicked()
{
  QString mText;
  Movie *curMov;
  Movie *current;
  bool bFlag;
  QStrList movs;

  if (this->movies->currentItem() > -1){
    mText = this->movies->text(this->movies->currentItem());
    curMov = anchor->currentMovie(mText);
    current = anchor->firstMovie();
    if (curMov->flags & 1)
      bFlag = TRUE;
    else 
      bFlag = FALSE;
    this->movies->setUpdatesEnabled(FALSE);
    movs.clear();
  
    while(current){
      if ((bFlag && (current->flags & 1)) || (!bFlag && !(current->flags & 1)))
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(mText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotCommercialClicked()
{
  QString mText;
  Movie *curMov;
  Movie *current;
  bool bFlag;
  QStrList movs;

  if (this->movies->currentItem() > -1){
    mText = this->movies->text(this->movies->currentItem());
    curMov = anchor->currentMovie(mText);
    current = anchor->firstMovie();
    if (curMov->flags & 2)
      bFlag = TRUE;
    else 
      bFlag = FALSE;
    this->movies->setUpdatesEnabled(FALSE);
    movs.clear();
  
    while(current){
      if ((bFlag && (current->flags & 2)) || (!bFlag && !(current->flags & 2)))
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(mText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotWidescreenClicked()
{
  QString mText;
  Movie *curMov;
  Movie *current;
  bool bFlag;
  QStrList movs;

  if (this->movies->currentItem() > -1){
    mText = this->movies->text(this->movies->currentItem());
    curMov = anchor->currentMovie(mText);
    current = anchor->firstMovie();
    if (curMov->flags & 4)
      bFlag = TRUE;
    else 
      bFlag = FALSE;
    this->movies->setUpdatesEnabled(FALSE);
    movs.clear();
  
    while(current){
      if ((bFlag && (current->flags & 4)) || (!bFlag && !(current->flags & 4)))
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(mText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotSubtitlesClicked()
{
  QString mText;
  Movie *curMov;
  Movie *current;
  bool bFlag;
  QStrList movs;

  if (this->movies->currentItem() > -1){
    mText = this->movies->text(this->movies->currentItem());
    curMov = anchor->currentMovie(mText);
    current = anchor->firstMovie();
    if (curMov->flags & 8)
      bFlag = TRUE;
    else 
      bFlag = FALSE;
    this->movies->setUpdatesEnabled(FALSE);
    movs.clear();
  
    while(current){
      if ((bFlag && (current->flags & 8)) || (!bFlag && !(current->flags & 8)))
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(mText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotCaptionClicked()
{
  QString mText;
  Movie *curMov;
  Movie *current;
  bool bFlag;
  QStrList movs;

  if (this->movies->currentItem() > -1){
    mText = this->movies->text(this->movies->currentItem());
    curMov = anchor->currentMovie(mText);
    current = anchor->firstMovie();
    if (curMov->flags & 16)
      bFlag = TRUE;
    else 
      bFlag = FALSE;
    this->movies->setUpdatesEnabled(FALSE);
    movs.clear();
  
    while(current){
      if ((bFlag && (current->flags & 16)) || (!bFlag && !(current->flags & 16)))
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(mText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotTLengthClicked()
{
  Movie *curMov;
  QString content = this->tapeLength_b->text();
  int tLen = content.toInt();
  QString curText = this->movies->text(this->movies->currentItem());
  
  QStrList movs;
  
  this->movies->setUpdatesEnabled(FALSE);
  movs.clear();
  
  if (content != ""){
    this->movies->clear();
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);

    curMov=anchor->firstMovie();
    
    while (curMov){
      if (curMov->tapeLength == tLen){
	movs.inSort(curMov->title.data());
      }
      curMov = anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(curText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotTTypeClicked()
{
  Movie *current;
  QString content = this->tapeType_b->text();
  QString curText = this->movies->text(this->movies->currentItem());
  
  QStrList movs;
  
  this->movies->setUpdatesEnabled(FALSE);
  movs.clear();

  if (content != ""){
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    
    current=anchor->firstMovie();
    
    while (current){
      if (content != i18n("<Unknown>")){
	if (current->tapeType == content.data())
	  movs.inSort(current->title);
      } else {
	if (current->recType == "<?>")
	  movs.inSort(current->title);
      }
      current = anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(curText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotRTypeClicked()
{
  Movie *current;
  QString content = this->recType_b->text();
  QString curText = this->movies->text(this->movies->currentItem());
  
  QStrList movs;
  
  this->movies->setUpdatesEnabled(FALSE);
  movs.clear();

  if (content != ""){
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    
    current=anchor->firstMovie();
    
    while (current){
      if (content != i18n("<Unknown>")){
	if (current->recType == content.data())
	  movs.inSort(current->title);
      } else {
	if (current->recType == "<?>")
	  movs.inSort(current->title);
      }
      current = anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(this->gotoCurrent(curText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  } 
}


// a button of the swallowed cassette window has been clicked
// set the current movie to the one on the clicked button
void KVideoDB::slotB1Clicked()
{
  QString bText = this->movieB[0]->text();
  
  if (bText != ""){
    this->movies->setUpdatesEnabled(FALSE);
    if ((unsigned int)this->gotoCurrent(bText) >= this->movies->count())
      this->movies->inSort(bText);
    this->movies->setCurrentItem(this->gotoCurrent(bText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotB2Clicked()
{
  QString bText = this->movieB[1]->text();
  
  if (bText != ""){
    this->movies->setUpdatesEnabled(FALSE);
    if ((unsigned int)this->gotoCurrent(bText) >= this->movies->count())
      this->movies->inSort(bText);
    this->movies->setCurrentItem(this->gotoCurrent(bText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotB3Clicked()
{
  QString bText = this->movieB[2]->text();
  
  if (bText != ""){
    this->movies->setUpdatesEnabled(FALSE);
    if ((unsigned int)this->gotoCurrent(bText) >= this->movies->count())
      this->movies->inSort(bText);
    this->movies->setCurrentItem(this->gotoCurrent(bText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotB4Clicked()
{
  QString bText = this->movieB[3]->text();
  
  if (bText != ""){
    this->movies->setUpdatesEnabled(FALSE);
    if ((unsigned int)this->gotoCurrent(bText) >= this->movies->count())
      this->movies->inSort(bText);
    this->movies->setCurrentItem(this->gotoCurrent(bText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotB5Clicked()
{
  QString bText = this->movieB[4]->text();
  
  if (bText != ""){
    this->movies->setUpdatesEnabled(FALSE);
    if ((unsigned int)this->gotoCurrent(bText) >= this->movies->count())
      this->movies->inSort(bText);
    this->movies->setCurrentItem(this->gotoCurrent(bText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}

void KVideoDB::slotB6Clicked()
{
  QString bText = this->movieB[5]->text();
  
  if (bText != ""){
    this->movies->setUpdatesEnabled(FALSE);
    if ((unsigned int)this->gotoCurrent(bText) >= this->movies->count())
      this->movies->inSort(bText);
    this->movies->setCurrentItem(this->gotoCurrent(bText));
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                            List-Slots                                     //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

// a movie has been double-clicked
// open an edit-window for that movie
void KVideoDB::slotListdClicked(int index)
{
  this->slotEditMovie();
}


// a movie has been highlighted in the list
// first get all the data of the specified movie
// then print it on the buttons
void KVideoDB::slotListClicked()
{
  QString key;
  Movie *current;
  char dummy[20];
  
  key = this->movies->text(this->movies->currentItem());
  current = anchor->currentMovie(key);
  kassette->showMovies(current->cassette);
  this->showMovies(current->cassette);

  // show the data on the buttons
  // 1) text-data
  if (current->title.right(1) == " ")
    this->title_b->setText(current->title.left(current->title.length()-1));
  else
    this->title_b->setText(current->title);
  this->original_b->setText(current->original.data());
  this->director_b->setText(current->director.data());
  this->producer_b->setText(current->producer.data());
  this->composer_b->setText(current->composer.data());
  this->country_b->setText(current->country.data());
  if (current->date->isValid())
    this->date_b->setText(current->date->toString());
  else
    this->date_b->setText("");
  
  this->tapeNr_b->setText(current->cassette.data());
  QString cassDummy;
  cassDummy = i18n("Cassette-No.:");
  cassDummy += " ";
  cassNo->setText(cassDummy+current->cassette);
  
  if (strcmp(current->category.first(),"<?>"))
    this->category1_b->setText(current->category.first());
  else
    this->category1_b->setText(i18n("<no Category>"));
  if (strcmp(current->category.last(),"<?>"))
    this->category2_b->setText(current->category.last());
  else
    this->category2_b->setText(i18n("<no Category>"));

  if (current->index > 0){
    sprintf(dummy,"%d",current->index);
    this->indexNr_b->setText(dummy);
  } else
    this->indexNr_b->setText("");
  
  if(current->length[0] > 0){
    sprintf(dummy,"%d min. / %s",current->length[0],calcLength(current->length[0]));
    this->length_b->setText(dummy);
  } else
    this->length_b->setText("");
  if(current->length[1] > 0){
    sprintf(dummy,"%d min. / %s",current->length[1],calcLength(current->length[1]));
    this->olength_b->setText(dummy);
  } else
    this->olength_b->setText("");
  if(current->start != -1){
    sprintf(dummy,"%d min. / %s",current->start,calcLength(current->start));
    this->time_b->setText(dummy);
  } else
    this->time_b->setText("");
  if(current->year != 0){
    sprintf(dummy,"%d",current->year);
    this->year_b->setText(dummy);
  } else
    this->year_b->setText("");
  
  this->cast1_b->setText(current->cast.first());
  this->cast2_b->setText(current->cast.next());
  this->cast3_b->setText(current->cast.next());
  this->cast4_b->setText(current->cast.next());

  // 2) icon-data
  if (current->rating == 0)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar.xpm")));
  else if (current->rating == 1)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar1.xpm")));
  else if (current->rating == 2)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar2.xpm")));
  else if (current->rating == 3)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar3.xpm")));
  else if (current->rating == 4)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar4.xpm")));
  else if (current->rating == 5)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar5.xpm")));
  else if (current->rating == 6)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar6.xpm")));
  else if (current->rating == 7)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar7.xpm")));
  else if (current->rating == 8)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar8.xpm")));
  else if (current->rating == 9)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar9.xpm")));
  else if (current->rating == 10)
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar10.xpm")));
  else
    this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar.xpm")));

  if (config.defIcons == "Yes"){
    // The Configuration says: Show all Icons, no matter if default or not
    if ((current->sound != "") && (current->sound != "<?>"))
      this->sound_b->setPixmap(QPixmap::QPixmap(picPath(strcat(lowerString(current->sound.data()),".xpm"))));
    else
      this->sound_b->setPixmap(QPixmap::QPixmap(picPath("unknown.xpm")));
    if ((current->speed != "") && (current->speed != "<?>"))
      this->speed_b->setPixmap(QPixmap::QPixmap(picPath(strcat(lowerString(current->speed.data()),".xpm"))));
    else
      this->speed_b->setPixmap(QPixmap::QPixmap(picPath("unknown.xpm")));
    if ((current->source != "") && (current->source != "<?>"))
      this->source_b->setPixmap(QPixmap::QPixmap(picPath(strcat(lowerString(current->source.data()),".xpm"))));
    else
      this->source_b->setPixmap(QPixmap::QPixmap(picPath("unknown.xpm")));
    if ((current->videonorm != "") && (current->videonorm != "<?>"))
      this->movie_b->setPixmap(QPixmap::QPixmap(picPath(strcat(lowerString(current->videonorm.data()),".xpm"))));
     else
      this->movie_b->setPixmap(QPixmap::QPixmap(picPath("unknown.xpm")));
    if ((current->fsk != "") && (current->fsk != "<?>"))
      this->fsk_b->setPixmap(QPixmap::QPixmap(picPath(strcat(lowerString(current->fsk.data()),".xpm"))));
    else
      this->fsk_b->setPixmap(QPixmap::QPixmap(picPath("unknown.xpm")));
    if (current->flags & 1)
      this->color_b->setPixmap(QPixmap::QPixmap(picPath(i18n("bw.xpm"))));
    else
      this->color_b->setPixmap(QPixmap::QPixmap(picPath(i18n("color.xpm"))));
    if (current->flags & 2)
      this->commercial_b->setPixmap(QPixmap::QPixmap(picPath(i18n("commercial.xpm"))));
    else
      this->commercial_b->setPixmap(QPixmap::QPixmap(picPath(i18n("nocommercial.xpm"))));
    if (current->flags & 4)
      this->widescreen_b->setPixmap(QPixmap::QPixmap(picPath(i18n("widescreen.xpm"))));
    else
      this->widescreen_b->setPixmap(QPixmap::QPixmap(picPath(i18n("smallscreen.xpm"))));
    if (current->flags & 8)
      this->omu_b->setPixmap(QPixmap::QPixmap(picPath(i18n("omu.xpm"))));
    else
      this->omu_b->setPixmap(QPixmap::QPixmap(picPath(i18n("noomu.xpm"))));
    if (current->flags & 16)
      this->caption_b->setPixmap(QPixmap::QPixmap(picPath(i18n("caption.xpm"))));
    else
      this->caption_b->setPixmap(QPixmap::QPixmap(picPath(i18n("nocaption.xpm"))));
  } else {
    // The Configuration says: Show only Icons if not Default
    if (current->sound != config.sound.first())
      this->sound_b->setPixmap(QPixmap::QPixmap(picPath(strcat(lowerString(current->sound.data()),".xpm"))));
    else
      this->sound_b->setPixmap(QPixmap::QPixmap(picPath("")));
    if (current->speed != config.speed.first())
      this->speed_b->setPixmap(QPixmap::QPixmap(picPath(strcat(lowerString(current->speed.data()),".xpm"))));
    else
      this->speed_b->setPixmap(QPixmap::QPixmap(picPath("")));
    if (current->source != config.source.first())
      this->source_b->setPixmap(QPixmap::QPixmap(picPath(strcat(lowerString(current->source.data()),".xpm"))));
    else
      this->source_b->setPixmap(QPixmap::QPixmap(picPath("")));
    if (current->videonorm != config.videonorm.first())
      this->movie_b->setPixmap(QPixmap::QPixmap(picPath(strcat(lowerString(current->videonorm.data()),".xpm"))));
    else
      this->movie_b->setPixmap(QPixmap::QPixmap(picPath("")));
    this->fsk_b->setPixmap(QPixmap::QPixmap(picPath(strcat(lowerString(current->fsk.data()),".xpm"))));
    if (current->flags & 1)
      this->color_b->setPixmap(QPixmap::QPixmap(picPath("bw.xpm")));
    else
      this->color_b->setPixmap(QPixmap::QPixmap(picPath("")));
    if (current->flags & 2)
      this->commercial_b->setPixmap(QPixmap::QPixmap(picPath("commercial.xpm")));
    else
      this->commercial_b->setPixmap(QPixmap::QPixmap(picPath("")));
    if (current->flags & 4)
      this->widescreen_b->setPixmap(QPixmap::QPixmap(picPath("widescreen.xpm")));
    else
      this->widescreen_b->setPixmap(QPixmap::QPixmap(picPath("")));
    if (current->flags & 8)
      this->omu_b->setPixmap(QPixmap::QPixmap(picPath("omu.xpm")));
    else
      this->omu_b->setPixmap(QPixmap::QPixmap(picPath("")));
    if (current->flags & 16)
      this->caption_b->setPixmap(QPixmap::QPixmap(picPath("caption.xpm")));
    else
      this->caption_b->setPixmap(QPixmap::QPixmap(picPath("")));
  }
  if (current->recType == "")
    this->recType_b->setText("");
  else if (current->recType == "<?>")
    this->recType_b->setText(i18n("<Unknown>"));
  else
    this->recType_b->setText(current->recType);
  if (current->tapeType == "")
    this->tapeType_b->setText("");
  else if (current->tapeType == "<?>")
    this->tapeType_b->setText(i18n("<Unknown>"));
  else
    this->tapeType_b->setText(current->tapeType);
  if (current->tapeLength > 0){
    sprintf(dummy,"%d",current->tapeLength);
    this->tapeLength_b->setText(dummy);
  } else
    this->tapeLength_b->setText(i18n("<Unknown>"));

  if (current->tapeLength > 0){
    char timeDummy[5];
    for (int u=0; u < 13; u++)
      movieLabel[u]->hide();
    int u=1;
    freeLabel->show();
    sprintf(timeDummy,"%d",current->tapeLength/4);
    this->time[1]->setText(timeDummy);
    sprintf(timeDummy,"%d",current->tapeLength/2);
    this->time[2]->setText(timeDummy);
    sprintf(timeDummy,"%d",3*current->tapeLength/4);
    this->time[3]->setText(timeDummy);
    sprintf(timeDummy,"%d",current->tapeLength);
    this->time[4]->setText(timeDummy);
    Movie *timeMov = anchor->firstMovie();
    Cassette *cass = new Cassette();
    cass->nr = current->cassette;
    while (timeMov){
      if (timeMov->cassette == current->cassette.data()){
	int speedIndex = config.speed.find(timeMov->speed);
	double factor;
	if (speedIndex > -1)
	  factor = atof(config.speedFac.at(speedIndex));
	else
	  factor = 0.0;
	if (timeMov->index > 0){
	  cass->length[timeMov->index] = timeMov->length[0];
	  cass->start[timeMov->index] = timeMov->start;
	  cass->factor[timeMov->index] = factor;
	  cass->title[timeMov->index] = timeMov->title.data();
	  cass->speed[timeMov->index] = timeMov->speed.data();
	}
      }
      timeMov = anchor->nextMovie();
    }
    
    for (int z=1; z < 7; z++){
      int sub=0;
      for (int y=1; y<z; y++){
	if (cass->factor[y] < 1.0)
	  sub+=(cass->length[y]-(int)((float)cass->length[y]*cass->factor[y]));
      }
      int ende = (int)((216.0/(float)current->tapeLength)*(cass->start[z]-sub+(cass->length[z]*cass->factor[z])));
      if (ende <= 216)
	movieLabel[u]->setGeometry(157+(int)((216.0/(float)current->tapeLength)*(cass->start[z]-sub)),
				   312,(int)((216.0/(float)current->tapeLength)*cass->length[z]*cass->factor[z]),46);
      else
	movieLabel[u]->setGeometry(157+(int)((216.0/(float)current->tapeLength)*(cass->start[z]-sub)),
				   312,216-(int)((216.0/(float)current->tapeLength)*(cass->start[z]-sub)),46);
      if (!cass->title[z].isEmpty())
	movieLabel[u]->show();
      sprintf(timeDummy,"%d",cass->length[z]);
      QString labelText = " " + cass->title[z] + "\n ";
      labelText += timeDummy;
      labelText += i18n(" min.");
      labelText += " / ";
      labelText += calcLength(cass->length[z]);
      labelText += ", ";
      labelText += cass->speed[z];
      movieLabel[u]->setText(labelText);
      labelText = cass->title[z] + "\n";
      labelText += timeDummy;
      labelText += i18n(" min.");
      labelText += " / ";
      labelText += calcLength(cass->length[z]);
      labelText += ", ";
      labelText += cass->speed[z];
      QToolTip::add(movieLabel[u]->myLabel, labelText);
      u=u+2;
    }
    delete(cass);
  } else {
    freeLabel->hide();
    for (int u=0; u < 13; u++)
      movieLabel[u]->hide();
    this->time[1]->setText("");
    this->time[2]->setText("");
    this->time[3]->setText("");
    this->time[4]->setText("");    
  } 
  
  this->comments->setText(current->comment);
  
  // enable some buttons and menu-items
  this->toolBar()->setItemEnabled(13,TRUE);
  this->toolBar()->setItemEnabled(20,TRUE);
  this->toolBar()->setItemEnabled(21,TRUE);
  this->toolBar()->setItemEnabled(22,TRUE);
  this->toolBar()->setItemEnabled(23,TRUE);
  this->toolBar()->setItemEnabled(42,TRUE);
  this->toolBar()->setItemEnabled(41,TRUE);
  this->toolBar()->setItemEnabled(30,TRUE);
  this->toolBar()->setItemEnabled(50,TRUE);
  this->toolBar()->setItemEnabled(51,TRUE);
  this->toolBar()->setItemEnabled(52,TRUE);
  this->toolBar()->setItemEnabled(53,TRUE);
  this->file->setItemEnabled(5,TRUE);
  this->file->setItemEnabled(6,TRUE);
  this->edit->setItemEnabled(edit->idAt(1),TRUE);
  this->edit->setItemEnabled(edit->idAt(2),TRUE);
  this->edit->setItemEnabled(edit->idAt(4),TRUE);
  
}


///////////////////////////////////////////////////////////////////////////////////
//                                                                               //
//                   Help-Routines for the Menu-Slots                            //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////


// function to load a KVideoDB-File
bool KVideoDB::loadFile(const char *name)
{
  Movie *dummy;
  QFile dataFile(name);
  QString line;
  bool fehler;
  bool openOK;
  
  // set the cursor to a watch
  KApplication::setOverrideCursor(waitCursor);
  
  // enable/disable soe buttons/menu-items
  this->toolBar()->setItemEnabled(12,FALSE);
  this->toolBar()->setItemEnabled(13,TRUE);
  this->toolBar()->setItemEnabled(30,TRUE);
  this->file->setItemEnabled(4,FALSE);
  this->file->setItemEnabled(5,TRUE);
  this->file->setItemEnabled(6,TRUE);
  this->edit->setItemEnabled(edit->idAt(4),TRUE);

  // create new Tree
  anchor = new BStarTree();
  // open file and textstream
  openOK = dataFile.open(IO_ReadOnly);
  if (!openOK){
    KMsgBox::message(this,i18n("Error"),i18n("Error reading file - perhaps wrong permissions"),0,"OK");    
    return FALSE;
  }
  QTextStream dataStream(&dataFile);

  // read all the commentaries
  do
    line = dataStream.readLine();
  while ((line != "[1]") && (!dataStream.eof()));

  // read the movies
  while (!dataStream.eof()){
    // create a new movie
    dummy = new Movie();

    // read a whole line and process it
    line = dataStream.readLine();
    line = removeLeadingSpaces(line.data());
    
    while ((line.left(1) != "[") && (!dataStream.eof())){
      if (line.left(8) == "Title = "){
	dummy->title = line.right(line.length()-8);
      }
      else if (line.left(11) == "Original = ")
	dummy->original = line.right(line.length()-11);
      else if (line.left(11) == "Cassette = ")
	dummy->cassette = line.right(line.length()-11);
      else if (line.left(8) == "Index = "){
	dummy->index = line.right(line.length()-8).toInt(&fehler);
	if (!fehler){
	  cerr << "Error in File, Index set to -1\n";
	  this->file->setItemEnabled(4,TRUE);
	  this->toolBar()->setItemEnabled(12,TRUE);
	  dummy->index = -1;
	}
      }
      else if (line.left(13) == "Start-Time = "){
	dummy->start = line.right(line.length()-13).toInt(&fehler);
	if (!fehler){
	  cerr << "Error in File, Start set to -1\n";
	  this->file->setItemEnabled(4,TRUE);
	  this->toolBar()->setItemEnabled(12,TRUE);
	  dummy->start = -1;
	}
      }
      else if (line.left(9) == "Length = "){
	dummy->length[0] = line.right(line.length()-9).toInt(&fehler);
	if (!fehler){
	  cerr << "Error in File, Length set to 0\n";
	  this->file->setItemEnabled(4,TRUE);
	  this->toolBar()->setItemEnabled(12,TRUE);
	  dummy->length[0] = 0;
	}
      }
      else if (line.left(15) == "orig. Length = "){
	dummy->length[1] = line.right(line.length()-15).toInt(&fehler);
	if (!fehler){
	  cerr << "Error in File, orig. Length set to 0\n";
	  this->file->setItemEnabled(4,TRUE);
	  this->toolBar()->setItemEnabled(12,TRUE);
	  dummy->length[1] = 0;
	}
      }
      else if (line.left(10) == "Country = "){
	if ((!config.country.contains(line.right(line.length()-10))) && 
	    (line.right(line.length()-10) != "")){
	  QString countryText;
	  countryText = i18n("Unknown Country \"");
	  countryText += line.right(line.length()-10);
	  countryText += i18n("\"\nShould it be added to Country-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),countryText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.country.append(line.right(line.length()-10));
	    addToRCFile("country",config.country);
	    dummy->country = line.right(line.length()-10);
	    break;
	  case 2:
	    cout << "Country set to \"\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->country = "";
	    break;
	  }
	} else
	  dummy->country = line.right(line.length()-10);
      }
      else if (line.left(7) == "Year = "){
	dummy->year = line.right(line.length()-7).toInt(&fehler);
	if (!fehler){
	  cerr << "Error in File, Year set to 0\n";
	  this->file->setItemEnabled(4,TRUE);
	  this->toolBar()->setItemEnabled(12,TRUE);
	  dummy->year = 0;
	}
      }
      else if (line.left(20) == "Date of recording = "){
	int d,m,y;
	bool f1,f2,f3;
	if (line.length() > 20){
	  line = line.right(line.length()-line.find('=')-2);
	  d = line.left(line.find('.')).toInt(&f1);
	  line = line.right(line.length()-line.find('.')-1);
	  m = line.left(line.find('.')).toInt(&f2);
	  line = line.right(line.length()-line.find('.')-1);
	  y = line.toInt(&f3);
	  if (!f1 || !f2 || !f3){
	    dummy->date = new QDate();
	    cerr << "Error in File, Date of recording set to NULL-Date\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	  }
	  else
	    dummy->date->setYMD(y,m,d);
	}
      }
      else if (line.left(12) == "Tape-Type = "){
	if ((!config.tapeType.contains(line.right(line.length()-12)))&&
	     (line.right(line.length()-12) != "") && (line.right(line.length()-12) != "<?>")){
	  QString tTypeText;
	  tTypeText = i18n("Unknown Tape-Type \"");
	  tTypeText += line.right(line.length()-12);
	  tTypeText += i18n("\"\nShould it be added to Tape-Type-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),tTypeText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.tapeType.append(line.right(line.length()-12));
	    addToRCFile("tapeType",config.tapeType);
	    dummy->tapeType = line.right(line.length()-12);
	    break;
	  case 2:
	    cout << "Tape-Type set to \"" << i18n("<Unknown>") << "\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->tapeType = "<?>";
	    break;
	  }
	} else
	  dummy->tapeType = line.right(line.length()-12);	
      }
      else if (line.left(14) == "Tape-Length = "){
	if ((!config.tapeLength.contains(line.right(line.length()-14)))&& 
	     (line.right(line.length()-14) != "") && (line.right(line.length()-14) != "0")){
	  QString tLenText;
	  tLenText = i18n("Unknown Tape-Length \"");
	  tLenText += line.right(line.length()-14);
	  tLenText += i18n("\"\nShould it be added to Tape-Length-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),tLenText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.tapeLength.append(line.right(line.length()-14));
	    addToRCFile("tapeLength",config.tapeLength);
	    dummy->tapeLength = atoi(line.right(line.length()-14));
	    break;
	  case 2:
	    cout << "Tape-Length set to \"0\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->tapeLength = 0;
	    break;
	  }
	} else
	  if (!strcmp(line.right(line.length()-14),""))
	    dummy->tapeLength = 0;
	  else
	    dummy->tapeLength = atoi(line.right(line.length()-14));	
      }

      else if (line.left(17) == "Recording-Type = "){
	if ((!config.recType.contains(line.right(line.length()-17))) &&
	     (line.right(line.length()-17) != "") && (line.right(line.length()-17) != "<?>")){
	  QString rTypeText;
	  rTypeText = i18n("Unknown Recording-Type \"");
	  rTypeText += line.right(line.length()-17);
	  rTypeText += i18n("\"\nShould it be added to Recording-Type-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),rTypeText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.recType.append(line.right(line.length()-17));
	    addToRCFile("recType",config.recType);
	    dummy->recType = line.right(line.length()-17);
	    break;
	  case 2:
	    cout << "Recording-Type set to \"" << i18n("<Unknown>") << "\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->recType = "<?>";
	    break;
	  }
	} else
	  dummy->recType = line.right(line.length()-17);	
      }
      else if (line.left(11) == "Director = ")
	dummy->director = line.right(line.length()-11);
      else if (line.left(11) == "Producer = ")
	dummy->producer = line.right(line.length()-11);
      else if (line.left(11) == "Composer = ")
	dummy->composer = line.right(line.length()-11);
      else if (line.left(8) == "Cast1 = ")
	dummy->cast.insert(0,line.right(line.length()-8));
      else if (line.left(8) == "Cast2 = ")
	dummy->cast.insert(1,line.right(line.length()-8));
      else if (line.left(8) == "Cast3 = ")
	dummy->cast.insert(2,line.right(line.length()-8));
      else if (line.left(8) == "Cast4 = ")
	dummy->cast.insert(3,line.right(line.length()-8));
      else if (line.left(17) == "Quality-Points = "){
	dummy->rating = line.right(line.length()-17).toInt(&fehler);
	if ((!fehler) || (dummy->rating > 10) || (dummy->rating < -1)){
	  cerr << "Error in File, Quality-Points set to 0\n";
	  this->file->setItemEnabled(4,TRUE);
	  this->toolBar()->setItemEnabled(12,TRUE);
	  dummy->rating=0;
	}
      }
      else if (line.left(12) == "Category1 = "){
	if ((!config.category.contains(line.right(line.length()-12))) &&
	    (line.right(line.length()-12) != "<?>") && (line.right(line.length()-12) != "")){
	  QString categoryText;
	  categoryText = i18n("Unknown Category \"");
	  categoryText += line.right(line.length()-12);
	  categoryText += i18n("\"\nShould it be added to Category-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),categoryText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.category.inSort(line.right(line.length()-12));
	    addToRCFile("category",config.category);
	    dummy->category.insert(0,line.right(line.length()-12));
	    break;
	  case 2:
	    cout << "Category set to \"" << i18n("<no Category>") << "\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->category.insert(0,"<?>");
	    break;
	  }
	} else
	  dummy->category.insert(0,line.right(line.length()-12));
      }
      else if (line.left(12) == "Category2 = "){
	if ((!config.category.contains(line.right(line.length()-12))) && 
	    (line.right(line.length()-12) != "<?>") && (line.right(line.length()-12) != "")){
	  QString categoryText;
	  categoryText = i18n("Unknown Category \"");
	  categoryText += line.right(line.length()-12);
	  categoryText += i18n("\"\nShould it be added to Category-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),categoryText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.category.inSort(line.right(line.length()-12));
	    addToRCFile("category",config.category);
	    dummy->category.insert(1,line.right(line.length()-12));
	    break;
	  case 2:
	    cout << "Category set to \"" << i18n("<no Category>") << "\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->category.insert(1,"<?>");
	    break;
	  }
	} else
	  dummy->category.insert(1,line.right(line.length()-12));
      }
      else if (line.left(8) == "Sound = "){
	if ((!config.sound.contains(line.right(line.length()-8))) && 
	    (line.right(line.length()-8) != "") && (line.right(line.length()-8) != "<?>")){
	  QString sndText;
	  sndText = i18n("Unknown Sound-System \"");
	  sndText += line.right(line.length()-8);
	  sndText += i18n("\"\nShould it be added to Sound-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),sndText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.sound.append(line.right(line.length()-8));
	    addToRCFile("sound",config.sound);
	    dummy->sound = line.right(line.length()-8);
	    break;
	  case 2:
	    cout << "Sound-System set to \"" << i18n("<Unknown>") << "\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->sound = "<?>";
	    break;
	  }
	} else
	  dummy->sound = line.right(line.length()-8);
      }
      else if (line.left(8) == "Speed = "){
	if ((!config.speed.contains(line.right(line.length()-8))) &&
	    (line.right(line.length()-8) != "") && (line.right(line.length()-8) != "<?>")){
	  QString spdText;
	  spdText = i18n("Unknown Speed \"");
	  spdText += line.right(line.length()-8);
	  spdText += i18n("\"\nShould it be added to Speed-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),spdText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.speed.append(line.right(line.length()-8));
	    addToRCFile("speed",config.speed);
	    dummy->speed = line.right(line.length()-8);
	    break;
	  case 2:
	    cout << "Speed set to \"" << i18n("<Unknown>") << "\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->speed = "<?>";
	    break;
	  }
	} else
	  dummy->speed = line.right(line.length()-8);
      }
      else if (line.left(9) == "Source = "){
	if ((!config.source.contains(line.right(line.length()-9))) &&
	    (line.right(line.length()-9) != "") && (line.right(line.length()-9) != "<?>")){
	  QString srcText;
	  srcText = i18n("Unknown Source \"");
	  srcText += line.right(line.length()-9);
	  srcText += i18n("\"\nShould it be added to Source-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),srcText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.source.append(line.right(line.length()-9));
	    addToRCFile("source",config.source);
	    dummy->source = line.right(line.length()-9);
	    break;
	  case 2:
	    cout << "Source set to \"" << i18n("<Unknown>") << "\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->source = "<?>";
	    break;
	  }
	} else
	  dummy->source = line.right(line.length()-9);
      }
      else if (line.left(12) == "Videonorm = "){
	if ((!config.videonorm.contains(line.right(line.length()-12))) &&
	    (line.right(line.length()-12) != "") && (line.right(line.length()-12) != "<?>")){
	  QString nrmText;
	  nrmText = i18n("Unknown Videonorm \"");
	  nrmText += line.right(line.length()-12);
	  nrmText += i18n("\"\nShould it be added to Videonorm-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),nrmText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.videonorm.append(line.right(line.length()-12));
	    addToRCFile("videonorm",config.videonorm);
	    dummy->videonorm = line.right(line.length()-12);
	    break;
	  case 2:
	    cout << "Videonorm set to \"" << i18n("<Unknown>") << "\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->videonorm = "<?>";
	    break;
	  }
	} else
	  dummy->videonorm = line.right(line.length()-12);
      }
      else if (line.left(11) == "Rated as = "){
	if ((!config.fsk.contains(line.right(line.length()-11))) &&
	    (line.right(line.length()-11) != "") && (line.right(line.length()-11) != "<?>")){
	  QString fskText;
	  fskText = i18n("Unknown Rating \"");
	  fskText += line.right(line.length()-11);
	  fskText += i18n("\"\nShould it be added to Rating-List?");    
	  KApplication::setOverrideCursor(arrowCursor);
	  int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),fskText,8);
	  KApplication::setOverrideCursor(waitCursor);
	  switch(buttonPressed) {
	  case 1:
	    config.fsk.append(line.right(line.length()-11));
	    addToRCFile("fsk",config.fsk);
	    dummy->fsk = line.right(line.length()-11);
	    break;
	  case 2:
	    cout << "Rating set to \"" << i18n("<Unknown>") << "\"" << "\n";
	    this->file->setItemEnabled(4,TRUE);
	    this->toolBar()->setItemEnabled(12,TRUE);
	    dummy->fsk = "<?>";
	    break;
	  }
	} else
	  dummy->fsk = line.right(line.length()-11);
      }
      else if (line.left(9) == "B&W = Yes")
	dummy->flags += 1;
      else if (line.left(17) == "Commercials = Yes")
	dummy->flags += 2;
      else if (line.left(16) == "Widescreen = Yes")
	dummy->flags += 4;
      else if (line.left(15) == "Subtitles = Yes")
	dummy->flags += 8;
      else if (line.left(14) == "Captions = Yes")
	dummy->flags += 16;
      else if (line.left(10) == "Comment = "){
	dummy->comment = "";
	QString commentDummy = line.right(line.length()-10);
	for (unsigned int i=0; i < commentDummy.length(); i++){
	  if (commentDummy.at(i) == '\\'){
	    if (commentDummy.at(i+1) == 'n'){
	      dummy->comment += '\n';
	      i++;
	    }
	  }
	  else
	    dummy->comment += commentDummy.at(i);
	}
      }
      line = dataStream.readLine();
      line = removeLeadingSpaces(line);
    }
    ///////////////////////////////////////////////
    // Check the data for the Cassette
    if (!cassDataOK(dummy)){
      QString cassData = i18n("Conflicting Cassette Data of Cassette No.");
      cassData += " ";
      cassData += dummy->cassette;
      cassData += "\n ";
      cassData += i18n("Tape-Type:");
      cassData += " ";
      if (dummy->tapeType == "<?>")
	cassData += i18n("<Unknown>");
      else
	cassData += dummy->tapeType;
      cassData += "\n ";
      cassData += i18n("Tape-Length:");
      cassData += " ";
      if (dummy->tapeLength == 0){
	cassData += i18n("<Unknown>");
	cassData += "\n";
      }else{
	char len[80];
	sprintf(len,"%d\n",dummy->tapeLength);
	cassData += len;
      }
      cassData += i18n("Is this data correct?");
      KApplication::setOverrideCursor(arrowCursor);
      int buttonPressed = KMsgBox::yesNo(this,i18n("Question"),cassData,8);
      KApplication::setOverrideCursor(waitCursor);
      switch(buttonPressed) {
      case 1:
	changeCassData(dummy);
	break;
      case 2:
	changeThisCassData(dummy);
	break;
      }
      this->file->setItemEnabled(4,TRUE);
      this->toolBar()->setItemEnabled(12,TRUE);
    }
      
    // add the read movie to the B*-Tree
    anchor->insert(dummy);
  }
  return TRUE;
}

// function to add a file-name to
// the "Open recent" menu-item
void KVideoDB::addToRecent(QString add)
{
  // create a new recent-list
  QStrList newRList;
  
  // append the current file to that new list
  newRList.append(add);

  // append the first four different filenames 
  // of the old list to the new one
  config.recent.first();
  for (int i=0;i<5;i++){
    if (config.recent.current() != add)
      newRList.append(config.recent.current());
    config.recent.next();
  }
  // assign the new list to the old one
  config.recent = newRList;
 
  // write the new list to the config-file
  KConfig *kconfig = KApplication::getKApplication()->getConfig();
  
  if (kconfig){
    kconfig->setGroup("recent");
    kconfig->writeEntry("1",config.recent.first());
    kconfig->writeEntry("2",config.recent.next());
    kconfig->writeEntry("3",config.recent.next());
    kconfig->writeEntry("4",config.recent.next());
    kconfig->writeEntry("5",config.recent.next());
  }
  kconfig->sync();
  
  // write the new list to the menu-item
  this->recentFile->clear();
  config.recent.first();
  for(int i=0; i <5; i++){
    if (strlen(config.recent.current())>1){
      char count[5];
      sprintf(count,"&%d. ",i+1);
      QString menuString = count;
      menuString+=config.recent.current();
      recentFile->insertItem(menuString);
    }
    config.recent.next();
  }
}


///////////////////////////////////////////////////////////////////////////////////
//                                                                               //
//                                 Menu-Slots                                    //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////


// How to react if one wants to create a new file
// to be done in future
void KVideoDB::slotNewWindow(){
  // this slot is invoked from File->New
  // new Tree
  anchor = new BStarTree;

  // clear all widgets
  this->movies->clear();
  this->clearAll(TRUE);
  this->toolBar()->setItemEnabled(43,FALSE);
  kassette->hideAll();

  // set global filename to empty
  VideoFile = "";
}

// How to react if one wants to add a new movie
void KVideoDB::slotAddMovie(){
  // Create a new Window
  addMovieWindow *addmovie = new addMovieWindow(this,"");
  addmovie->setActiveWindow();
  // Show it
  addmovie->show();
}

// delete a movie was clicked
void KVideoDB::slotDelMovie()
{
  Movie *current;
  QString curText;
  int buttonPressed=1;
  
  // if the prog should ask before deleting, do it!
  if (config.askDelete == "Yes")
    buttonPressed = KMsgBox::yesNo(this,i18n("Question"),i18n("Are you sure?"),8);

  // if the movie should be deleted
  if (buttonPressed == 1){
    // get title
    curText = this->movies->text(this->movies->currentItem());
    // get the movie
    current = anchor->currentMovie(curText);
    // remove it from datastructure, movie-list
    anchor->remove(current);
    this->movies->removeItem(this->movies->currentItem());
    if (this->movies->count() <= 0){
      this->clearAll(FALSE);
      kassette->hideAll();
    }
    // enable the save-buttons
    this->file->setItemEnabled(4,TRUE);
    toolBar()->setItemEnabled(12,TRUE);
    // global changed-flag set TRUE
    changed = TRUE;
  }
}

// How to react if one wants to edit a movie
void KVideoDB::slotEditMovie(){
  Movie *current;
  QString curText;
  char dString[80];
  
  // has a movie been selected?
  if (this->movies->currentItem() >= 0){
    // Create a new Window
    curText = this->movies->text(this->movies->currentItem());
    current = anchor->currentMovie(curText);
    addMovieWindow *editmovie = new addMovieWindow(this,"",TRUE,current);
    // set caption
    editmovie->setCaption(i18n("Edit Movie"));
    editmovie->setActiveWindow();

    // set texts in the editWindow
    editmovie->title_e->setText(current->title);
    editmovie->original_e->setText(current->original);
    editmovie->director_e->setText(current->director);
    editmovie->producer_e->setText(current->producer);
    editmovie->composer_e->setText(current->composer);
    editmovie->cast1_e->setText(current->cast.first());
    editmovie->cast2_e->setText(current->cast.next());
    editmovie->cast3_e->setText(current->cast.next());
    editmovie->cast4_e->setText(current->cast.next());
    editmovie->country_e->setText(current->country);
    
    if (current->year > 0){
      sprintf(dString,"%d",current->year);
      editmovie->year_e->setText(dString);
    }
    
    editmovie->kass_e->setText(current->cassette);
    if (current->start > -1){
      sprintf(dString,"%d",current->start);
      editmovie->start_e->setText(dString);
    }
    if (current->length[0] > 0){
      sprintf(dString,"%d",current->length[0]);
      editmovie->length_e->setText(dString);
    }
    if (current->length[1] > 0){
      sprintf(dString,"%d",current->length[1]);
      editmovie->olength_e->setText(dString);
    }
        
    if (current->date->isValid()){
      sprintf(dString,"%02d.%02d.%d",current->date->day(),current->date->month(),current->date->year());
      editmovie->date_e->setText(dString);
    }
    editmovie->index_e->setCurrentItem(current->index);
    int i=0;
    
    if ((i=config.category.find(current->category.first())) > -1)
      editmovie->category1_e->setCurrentItem(i+1);
    if ((i=config.category.find(current->category.last())) > -1)
      editmovie->category2_e->setCurrentItem(i+1);
    else
      editmovie->category2_e->setCurrentItem(0);
    
    if ((i=config.sound.find(current->sound)) > -1)
      editmovie->sound_e->setCurrentItem(i+1);
    else
      editmovie->sound_e->setCurrentItem(0);

    if ((i=config.speed.find(current->speed)) > -1)
      editmovie->lp_e->setCurrentItem(i+1);
    else
      editmovie->lp_e->setCurrentItem(0);

    if ((i=config.fsk.find(current->fsk)) > -1)
      editmovie->fsk_e->setCurrentItem(i+1);
    else
      editmovie->fsk_e->setCurrentItem(0);

    if ((i=config.source.find(current->source)) > -1)
      editmovie->source_e->setCurrentItem(i+1);
    else
      editmovie->source_e->setCurrentItem(0);

    if ((i=config.videonorm.find(current->videonorm)) > -1)
      editmovie->videonorm_e->setCurrentItem(i+1);
    else
      editmovie->videonorm_e->setCurrentItem(0);

    if ((i=config.recType.find(current->recType)) > -1)
      editmovie->recType_e->setCurrentItem(i+1);
    else
      editmovie->recType_e->setCurrentItem(0);

    if ((i=config.tapeType.find(current->tapeType)) > -1)
      editmovie->tapeType_e->setCurrentItem(i+1);
    else
      editmovie->tapeType_e->setCurrentItem(0);

    char dummy[80];
    sprintf(dummy,"%d",current->tapeLength);
    if ((i=config.tapeLength.find(dummy)) > -1)
      editmovie->tapeLength_e->setCurrentItem(i+1);
    else
      editmovie->tapeLength_e->setCurrentItem(0);

    if (current->rating < editmovie->rating_e->count())
      editmovie->rating_e->setCurrentItem(current->rating+1);
    

    if (current->flags & 1)
      editmovie->color_e->setOn(TRUE);
    if (current->flags & 2)
      editmovie->commercial_e->setOn(TRUE);
    if (current->flags & 4)
      editmovie->widescreen_e->setOn(TRUE);
    if (current->flags & 8)
      editmovie->omu_e->setOn(TRUE);
    if (current->flags & 16)
      editmovie->caption_e->setOn(TRUE);
    
    editmovie->comments->setText(current->comment);
    
    editmovie->show();
    titleChange=FALSE;
    if (this->movies->currentItem() < 0)
      this->movies->setCurrentItem(0);
    this->slotListClicked();
  }else{
    KMsgBox::message(this,i18n("Error"),i18n("First select the movie you want to edit"),0,"OK");    
  }
}


// How to react if one wants to load a file
void KVideoDB::slotLoadFile(){
  // this slot is invoked from File->Open
  
  // has the current file been changed recently?
  if (changed && (this->movies->count()>0)){
    // yes: ask whether to save it first
    int bPressed = KMsgBox::yesNo(this,i18n("Question"),i18n("Save current file first?"),8);
    if (bPressed == 1){
      if (!saveFile(VideoFile)){
	KMsgBox::message(this,i18n("Error"),i18n("Error writing file - perhaps wrong permissions"),0,"OK");    
	return;
      } else 
	changed = FALSE;
    } else
      changed = FALSE;
  }
  // get the name of the file which should be opened
  QString s = KFileDialog::getOpenFileName(0,"*.vdb",this);
  
  if (!s.isEmpty()){
    // if the name is not empty -- load it
    if (!loadFile(s))
      return;
    // set global file-name
    VideoFile = s;
    // add it to the "Open Recent" menu-item
    this->addToRecent(s);
    // discard all path-info for the caption
    while (s.find('/') > -1)
      s = s.right(s.length()-s.find('/')-1);
    QString capt = i18n("KVideoDB - Homevideo Database");
    setCaption(capt + " - " + s);
    // clear the movielist and insert the new movies
    this->movies->setUpdatesEnabled(FALSE);
    this->movies->clear();
    this->insertMovies();
    // set the cursor back to the normal arrow
    KApplication::setOverrideCursor(arrowCursor);
    // set the highlighted element of the movie-browser to first movie
    if (this->movies->count() > 0){
      this->movies->setCurrentItem(0);
      this->movies->setFocus();
    }
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  }
}


// How to react if one wants to save the present file
void KVideoDB::slotSaveKnownFile(){
  // this slot is invoked from File->Save
  if (!VideoFile.isEmpty()){
    // if the global filename is not empty -- save it
    if (!saveFile(VideoFile)){
      KMsgBox::message(this,i18n("Error"),i18n("Error writing file - perhaps wrong permissions"),0,"OK");    
      return;
    }
  } else
    // ask what the name of the file should be
    // equiv. to save as
    slotSaveFile();
  // disable the save buttons
  this->file->setItemEnabled(4,FALSE);
  this->toolBar()->setItemEnabled(12,FALSE);
}


// How to react if one wants to save the present file under a new name
// or a new file for the first time
void KVideoDB::slotSaveFile(){
  // this slot is invoked from File->Save As

  // get the filename 
  QString s = KFileDialog::getSaveFileName(0,"*.vdb",this);
  if (!s.isEmpty()){
    // if it is not empty, add ending if not there
    if (!s.contains(".vdb"))
      s += ".vdb";
    // save the file
    if (!saveFile(s)){
      KMsgBox::message(this,i18n("Error"),i18n("Error writing file - perhaps wrong permissions"),0,"OK");    
      return;
    }
    // discard all path-info for the caption
    while (s.find('/') > -1)
      s = s.right(s.length()-s.find('/')-1);
    setCaption("KVideoDB - Homevideo Database - " + s);
  }
  // disable the save-buttons
  this->file->setItemEnabled(4,FALSE);
  this->toolBar()->setItemEnabled(12,FALSE);
}


// the search-button has been clicked
// what now?
// to be done in the future
void KVideoDB::slotSearch()
{
  //  KMsgBox::message(this,i18n("Info"),i18n("Not implemented yet!"),0,"OK");    
  searchWindow *sW = new searchWindow(this);
  sW->show();
}

// the reset-button has been clicked
void KVideoDB::slotReset()
{
  Movie *current;
  QStrList movs;
  QString curText = this->movies->text(this->movies->currentItem());
  
  movs.clear();

  this->movies->setUpdatesEnabled(FALSE);
  this->movies->clear();
  
  current=anchor->firstMovie();
  
  // insert all the movie-titles in the movie-list
  while (current){
    movs.inSort(current->title);
    current = anchor->nextMovie();
  }
  this->movies->insertStrList(&movs);
  
  // disable the reset button
  this->toolBar()->setItemEnabled(43,FALSE);
  this->edit->setItemEnabled(edit->idAt(6),FALSE);
  this->movies->setCurrentItem(this->gotoCurrent(curText));
  if (this->movies->currentItem() < 0)
    this->movies->setCurrentItem(0);
  this->movies->centerCurrentItem();
  this->movies->setUpdatesEnabled(TRUE);
  this->movies->repaint();
}


// the "Open Recent" menu-item has been chosen
void KVideoDB::slotRecent(int index)
{
  QString name;

  // has the current file been changed recently?
  if (changed && (this->movies->count() > 0)){
    // yes: ask whether to save this first
    int bPressed = KMsgBox::yesNo(this,i18n("Question"),i18n("Save current file first?"),8);
    if (bPressed == 1){
      if (!saveFile(VideoFile)){
	KMsgBox::message(this,i18n("Error"),i18n("Error writing file - perhaps wrong permissions"),0,"OK");    
	return;
      } else
	changed = FALSE;
    } else
      changed = FALSE;
  }

  // determine the name of the file to open
  config.recent.first();
  for (int i=0;i<index;i++)
    config.recent.next();
  name = config.recent.current();
  name = name.right(name.find(" ")-1);
  // load this file
  if (!this->loadFile(name.data()))
    return;
  // clear the movie-list and insert the new movies
  this->movies->setUpdatesEnabled(FALSE);
  this->movies->clear();
  this->insertMovies();
  // set global filename
  VideoFile = name;
  // add this filename to the "Open Recent" menu-item
  this->addToRecent(name);
  
  // discard all the path-infos for the caption
  while (name.find('/') > -1)
      name = name.right(name.length()-name.find('/')-1);

  QString capt = i18n("KVideoDB - Homevideo Database");
  setCaption(capt + " - " + name);
  // set the cursor to the normal arrow
  KApplication::setOverrideCursor(arrowCursor);
  
  // set the highlighted element of the movie-browser to the first movie
  if (this->movies->count() > 0){
    this->movies->setCurrentItem(0);
    this->movies->setFocus();
  }
  this->movies->setUpdatesEnabled(TRUE);
  this->movies->repaint();
}

void KVideoDB::slotSearchCass()
{
  Movie *current;
  QString content = toolBar()->getLinedText(51);
  
  QStrList movs;
  
  this->movies->setUpdatesEnabled(FALSE);
  movs.clear();

  if (content != ""){
    this->toolBar()->setItemEnabled(43,TRUE);
    this->edit->setItemEnabled(edit->idAt(6),TRUE);
    this->movies->clear();
    
    current=anchor->firstMovie();
    
    while (current){
      if (current->cassette == content.data())
	movs.inSort(current->title);
      current = anchor->nextMovie();
    }
    this->movies->insertStrList(&movs);
    this->movies->setCurrentItem(0);
    this->movies->centerCurrentItem();
    this->movies->setUpdatesEnabled(TRUE);
    this->movies->repaint();
  } 
}

void KVideoDB::slotSearchSpace()
{
  QStrList cassettes;
  QStrList noCass;
  QString content = toolBar()->getLinedText(53);
  int minutes = atoi(content);
  Movie *current = anchor->firstMovie();
  int noIndex =7;
  
  while (current){
    if ((!cassettes.contains(current->cassette)) && (!noCass.contains(current->cassette))){
      Movie *cur2=anchor->firstMovie();
      Cassette *cass = new Cassette();
      cass->nr = current->cassette;
      cass->lenTot = current->tapeLength;
      while(cur2){
	if (cur2->cassette==cass->nr.data())
	  if (cur2->index > 0) {
	    int speedIndex = config.speed.find(cur2->speed);
	    if (speedIndex > -1)
	      cass->factor[cur2->index] = atof(config.speedFac.at(speedIndex));
	    else
	      cass->factor[cur2->index] = 0.0;
	    cass->start[cur2->index]=cur2->start;
	    cass->length[cur2->index]=cur2->length[0];
	    cass->title[cur2->index]=cur2->title.data();
	    cass->speed[cur2->index]=cur2->speed.data();
	  } else {
	    int speedIndex = config.speed.find(cur2->speed);
	    if (speedIndex > -1)
	      cass->factor[noIndex] = atof(config.speedFac.at(speedIndex));
	    else
	      cass->factor[noIndex] = 0.0;
	    cass->start[noIndex]=cur2->start;
	    cass->length[noIndex]=cur2->length[0];
	    cass->title[noIndex]=cur2->title.data();
	    cass->speed[noIndex]=cur2->speed.data();	
	    noIndex++;
	  }
	cur2=anchor->nextMovie();
      }
      if (cass->maxSpace() > minutes)
	cassettes.append(cass->nr);
      else
	noCass.append(cass->nr);
      current = anchor->firstMovie();
    }
    current=anchor->nextMovie();
  }
  spaceWindow *cWin = new spaceWindow(this);
  cWin->show();
  cWin->cassettes->insertStrList(&cassettes);
  cassettes.first();
  while(cassettes.current()){
    cout << cassettes.current();
    cout << " ";
    cassettes.next();
  }
  cout << "\n";
}


///////////////////////////////////////////////////////////////////////////////
//                                                                           //
//                              Configuration-Slots                          //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////


// if the configuration says "ask before deleting",
// here is what to do
void KVideoDB::slotAskDel()
{
  if (this->options->isItemChecked(options->idAt(5))){
    this->options->setItemChecked(options->idAt(5),FALSE);
    config.askDelete = "No";
  } else {
    this->options->setItemChecked(options->idAt(5),TRUE);
    config.askDelete = "Yes";
  }
}


// How to react if one doesnt like default Icons
void KVideoDB::slotOptionsProp()
{
  if (this->options->isItemChecked(options->idAt(0))){
    this->options->setItemChecked(options->idAt(0),FALSE);
    config.defIcons = "No";
  } else {
    this->options->setItemChecked(options->idAt(0),TRUE);
    config.defIcons = "Yes";
  }
  if (this->movies->count())
    this->slotListClicked();
}


// How to react if one wants to configure the application
void KVideoDB::slotConfigure()
{
  // build a Configuration-Window (s. files.cpp)
  configWindow *confWin = new configWindow(this,"");
  // Show it
  confWin->show();
}

// How to react if someone wants to save the Options
void KVideoDB::slotSaveOptions()
{
  // get the actual Configuration
  KConfig *kconfig = KApplication::getKApplication()->getConfig();
  // goto the Configuration Group
  kconfig->setGroup("config");
  // write the new Configuration
  kconfig->writeEntry("defaultIcons",config.defIcons);
  kconfig->writeEntry("showCassWin",config.showC);
  kconfig->writeEntry("swallowCassWin",config.swallowC);
  kconfig->writeEntry("askDelete",config.askDelete);
  // write the RC-File
  kconfig->sync();
}

// the "Show Cassette Window"-option has been clicked
void KVideoDB::slotShowCassWin()
{
  if (this->options->isItemChecked(options->idAt(2))){
    this->options->setItemChecked(options->idAt(2),FALSE);
    config.showC = "No";
    if (config.swallowC == "No")
      kassette->hide();
    else
      this->movies->resize(250,455);
  } else {
    this->options->setItemChecked(options->idAt(2),TRUE);
    config.showC = "Yes";
    if (config.swallowC == "No"){
      kassette->show();
      this->setFocus();
    }
    else{
      this->movies->resize(250,290);
      this->movies->centerCurrentItem();
    }
  }
}

// the "Swallow Cassette Window"-option has been clicked
void KVideoDB::slotSwallowCassWin()
{
  if (this->options->isItemChecked(options->idAt(3))){
    this->options->setItemChecked(options->idAt(3),FALSE);
    config.swallowC = "No";
    if (config.showC == "Yes"){
      kassette->show();
      this->setFocus();
    }
    this->movies->resize(250,455);
  } else {
    this->options->setItemChecked(options->idAt(3),TRUE);
    config.swallowC = "Yes";
    kassette->hide();
    if (config.showC == "Yes"){
      this->movies->resize(250,290);
      this->movies->centerCurrentItem();
    }
  }
}

//////////////////////////////////////////////////////////////////////////
//                                                                      //
//                             other Slots                              //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

// show the movies on a certain cassette on the buttons
// of the swallowed cassette-window
void KVideoDB::showMovies(QString cass)
{
  Movie *current = anchor->firstMovie();
  int i;
  
  for (i=0; i<6; i++)
    this->movieB[i]->setText("");

  while(current){
    if (current->cassette == cass){
      switch(current->index){
      case 1:
	this->movieB[0]->setText(current->title);
	break;
      case 2:
	this->movieB[1]->setText(current->title);
	break;
      case 3:
	this->movieB[2]->setText(current->title);
	break;
      case 4:
	this->movieB[3]->setText(current->title);
	break;
      case 5:
	this->movieB[4]->setText(current->title);
	break;
      case 6:
	this->movieB[5]->setText(current->title);
	break;
      default:
	break;
      }
    }
    current = anchor->nextMovie();
  }
}


// Exit-procedure
void KVideoDB::slotQuit()
{
  // if the file has been changed, ask whether to save it
  if (changed && (this->movies->count() > 0)){
    int bPressed = KMsgBox::yesNo(this,i18n("Question"),i18n("Save current File first?"),8);
    if (bPressed == 1){
      if(!saveFile(VideoFile)){
	KMsgBox::message(this,i18n("Error"),i18n("Error writing file - perhaps wrong permissions"),0,"OK");    
	return;
      } else 
	changed = FALSE;
    }
  }
  kapp->quit();
}

void KVideoDB::slotPrintFile()
{
//   int bPressed = KMsgBox::yesNo(this,i18n("Question"),i18n("Not really implemented yet.\nDo you want an HTML-output to the file\n\"kvideodb-export.html\"?"),8);
//   if (bPressed == 1)
//     export2html();
  printWindow *prnWin = new printWindow(this);
  prnWin->show();
  
  kvdbPrint(this);
}

//////////////////////////////////////////////////////////////////////
//                                                                  //
//                           help-routines                          //
//                                                                  //
//////////////////////////////////////////////////////////////////////

// How to react on Arguments
void computeArgs(int argCnt,char **args)
{
  int i=1;
  
  while (i<argCnt){
    if ((!strcmp(args[i],"--help")) || (!strcmp(args[i],"--version"))){
      displayVersion();
      if (!strcmp(args[i],"--help"))
	displayHelp();
      exit(0);
    }
    else if (!strcmp(args[i],"-p")){
      config.defIcons="No";
    }
    else if (!strcmp(args[i],"-c")){
      config.showC = "No";
    }
    else if (!strcmp(args[i],"-s")){
      config.swallowC = "Yes";
    }
    else if (!strcmp(args[i],"-d")){
      config.askDelete = "Yes";
    }
    else{
      VideoFile=args[i];
    }
    
    i++;
  }
}

// Get the Configuration from the RC-File
void readConfig(KConfig *kconfig)
{
  QStrList dummy;
  QString dummy2;
  bool error=FALSE;
  kconfig->setGroup("entries");
  kconfig->readListEntry("category",config.category);
  kconfig->readListEntry("country",config.country);
  kconfig->readListEntry("sound",config.sound);
  kconfig->readListEntry("speed",dummy);
  dummy2 = dummy.first();
  while(dummy2){
    if (dummy2.find("<")>-1){
      config.speed.append(dummy2.left(dummy2.find("<")));
      config.speedFac.append(dummy2.mid(dummy2.find("=")+1,dummy2.find("*")-dummy2.find("=")-1));
    }
    else{
      error = TRUE;
      config.speed.append(dummy2);
      config.speedFac.append("1");
    }
    dummy2 = dummy.next();
  }

  if (error){
    KMsgBox::message(0,i18n("Message"),i18n("Please close the application and edit your local config-file:\n\nIn the speed section give each entry a factor in relation to SP.\nSo each entry should look like this:\n\n  LP<=0.5*SP>\n\nwith the 0.5 as the factor.\nOr copy this line from your global config-file.\n\nOtherwise every movie is regarded as being recorded in SP."),0,"OK");
    QStrList speeds;
    QString sd;
    for (unsigned int c=0; c<config.speed.count();c++){
      sd = config.speed.at(c);
      sd+= "<=1.0*SP>";
      speeds.insert(c,sd);
    }
    kconfig->writeEntry("speed",speeds);
  }

  kconfig->readListEntry("source",config.source);
  kconfig->readListEntry("fsk",config.fsk);
  kconfig->readListEntry("videonorm",config.videonorm);
  kconfig->readListEntry("tapeLength",config.tapeLength);
  kconfig->readListEntry("tapeType",config.tapeType);
  kconfig->readListEntry("recType",config.recType);

  kconfig->setGroup("config");
  if (config.defIcons != "No")
    config.defIcons=kconfig->readEntry("defaultIcons", "Yes");
  if (config.showC != "No")
    config.showC=kconfig->readEntry("showCassWin", "Yes");
  if (config.swallowC != "Yes")
    config.swallowC=kconfig->readEntry("swallowCassWin", "Yes");
  if (config.askDelete != "Yes")
    config.askDelete=kconfig->readEntry("askDelete", "No");

  kconfig->setGroup("recent");
  config.recent.append(kconfig->readEntry("1",""));
  config.recent.append(kconfig->readEntry("2",""));
  config.recent.append(kconfig->readEntry("3",""));
  config.recent.append(kconfig->readEntry("4",""));
  config.recent.append(kconfig->readEntry("5",""));

  kconfig->setGroup("history");
  kconfig->readListEntry("a",config.searchHistory1);
  kconfig->readListEntry("b",config.searchHistory2);

  kconfig->setGroup("printer");
  config.device = kconfig->readEntry("device","Printer");
  config.name = kconfig->readEntry("name","");
  config.paperSize = kconfig->readEntry("papersize","A4");
  config.orientation = kconfig->readEntry("orientation","Portrait");
  config.what = kconfig->readEntry("format","Cards");
  config.range = kconfig->readEntry("range","All");
  config.copies = kconfig->readEntry("copies","1");

  printerConf.insert(0,"None");
  printerConf.insert(1,config.device);
  printerConf.insert(2,config.name);
  printerConf.insert(3,config.paperSize);
  printerConf.insert(4,config.orientation);
  printerConf.insert(5,config.what);
  printerConf.insert(6,config.range);
  printerConf.insert(7,config.copies);
  
  kconfig->setGroup("version");
  kconfig->writeEntry("ver",VERSION);
    
}

// Function to insert the movies into the 
// Movie-Browser in the Main-Window
void KVideoDB::insertMovies()
{
  Movie *current = anchor->firstMovie();
  
  while (current){
    this->movies->inSort(current->title.data());
    current = anchor->nextMovie();
  }
}

void KVideoDB::clearAll(bool all)
{
  this->title_b->setText("");
  this->original_b->setText("");
  this->tapeNr_b->setText("");
  this->indexNr_b->setText("");
  this->time_b->setText("");
  this->length_b->setText("");
  this->olength_b->setText("");
  this->country_b->setText("");
  this->year_b->setText("");
  this->date_b->setText("");
  this->director_b->setText("");
  this->producer_b->setText("");
  this->cast1_b->setText("");
  this->cast2_b->setText("");
  this->cast3_b->setText("");
  this->cast4_b->setText("");
  this->category1_b->setText("");
  this->category2_b->setText("");
  this->sound_b->setPixmap(QPixmap::QPixmap(picPath("")));
  this->color_b->setPixmap(QPixmap::QPixmap(picPath("")));
  this->speed_b->setPixmap(QPixmap::QPixmap(picPath("")));
  this->commercial_b->setPixmap(QPixmap::QPixmap(picPath("")));
  this->source_b->setPixmap(QPixmap::QPixmap(picPath("")));
  this->widescreen_b->setPixmap(QPixmap::QPixmap(picPath("")));
  this->omu_b->setPixmap(QPixmap::QPixmap(picPath("")));
  this->fsk_b->setPixmap(QPixmap::QPixmap(picPath("")));
  this->caption_b->setPixmap(QPixmap::QPixmap(picPath("")));
  this->movie_b->setPixmap(QPixmap::QPixmap(picPath("")));
  for (int i=0; i < 6; i++)
    this->movieB[i]->setText("");
  this->rating_l->setPixmap(QPixmap::QPixmap(picPath("ratingbar.xpm")));
  if (all)
    this->setCaption(i18n("KVideoDB - Homevideo Database"));
  this->file->setItemEnabled(4,FALSE);
  this->file->setItemEnabled(5,FALSE);
  this->file->setItemEnabled(6,FALSE);
  this->edit->setItemEnabled(this->edit->idAt(1),FALSE);
  this->edit->setItemEnabled(this->edit->idAt(2),FALSE);
  this->edit->setItemEnabled(this->edit->idAt(4),FALSE);
  this->toolBar()->setItemEnabled(12,FALSE);
  this->toolBar()->setItemEnabled(13,FALSE);
  this->toolBar()->setItemEnabled(20,FALSE);
  this->toolBar()->setItemEnabled(21,FALSE);
  this->toolBar()->setItemEnabled(22,FALSE);
  this->toolBar()->setItemEnabled(23,FALSE);
  this->toolBar()->setItemEnabled(30,FALSE);
  this->toolBar()->setItemEnabled(41,FALSE);
  this->toolBar()->setItemEnabled(42,FALSE);
  this->toolBar()->setItemEnabled(50,FALSE);
  this->toolBar()->setItemEnabled(51,FALSE);
  this->toolBar()->setItemEnabled(52,FALSE);
  this->toolBar()->setItemEnabled(53,FALSE);
}


int KVideoDB::gotoCurrent(QString bText)
{
  unsigned int index=0;
  
  while (index < this->movies->count()){
    if (this->movies->text(index) == bText)
      return index;
    index++;
  }
  return index;
}

void KVideoDB::closeEvent(QCloseEvent *ev) {
  slotQuit();
}

//////////////////////////////////////////////////////////////////////////
//                                                                      //
//                             Main-Function                            //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

// Main Function
int main(int argc, char* argv[]) {
  
  if (argc > 1)
    computeArgs(argc,argv);
  // New KApplication
  anchor = new BStarTree();

  KApplication a(argc,argv);  
  
  // find out some KDE-Paths
  strcpy(appsPath,a.kde_datadir());
  strcpy(localConfigPath,a.localconfigdir());

  // read the current config-File
  KConfig *kconfig = KApplication::getKApplication()->getConfig();
  if (kconfig){
    readConfig(kconfig);
  } else {
    cout << "error reading config-file\n";
  }
  
  presetEmptyConfig();
  
  // has "a" been restored in a previous session?
  if (a.isRestored())
    // yes: restore it
    RESTORE(KVideoDB)
  else {
    // no: just create a new main window
    KVideoDB* kvideodb = new KVideoDB;
    kassette = new cassWindow(kvideodb,"",0);
    if (VideoFile != ""){
      kvideodb->loadFile(VideoFile);
      kvideodb->addToRecent(VideoFile);
      QString s = VideoFile;
      while (s.find('/') > -1)
	s = s.right(s.length()-s.find('/')-1);
      QString capt = i18n("KVideoDB - Homevideo Database");
      kvideodb->setCaption(capt + " - " + s);
      kvideodb->movies->setUpdatesEnabled(FALSE);
      kvideodb->movies->clear();
      kvideodb->insertMovies();
      if (kvideodb->movies->count() > 0){
	kvideodb->movies->setCurrentItem(0);
	kvideodb->movies->setFocus();
      }
      kvideodb->movies->setUpdatesEnabled(TRUE);
      kvideodb->movies->repaint();
      KApplication::setOverrideCursor(arrowCursor);
    }
    //Show Main Window
    if ((config.showC == "Yes") && (config.swallowC == "No"))
      kassette->show();
    kvideodb->show();
  }
  
  a.exec();
}
