    /*

    view.C  for  ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem   
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */



#include <iostream.h>
#include <math.h>
#include <values.h>
#include <kapp.h>
#include <kmsgbox.h>

#include "view.h"
#include "graphicdialog.h"


View::View( int pointsShape, int pointsColour, int pointsSize,
            int linesStyle, int linesColour, int linesWidth )
        : KTMainWindow()
  {
  // set all values appropriately
  _pointsShape = pointsShape;
  _pointsColour = pointsColour;
  _pointsSize = pointsSize;
  _linesStyle = linesStyle;
  _linesColour = linesColour;
  _linesWidth = linesWidth;

  // create the main widget of View
  w = new Canvas( this, "View Display" );
  CHECK_PTR( w );

  // tell KTMW that w is the main widget
  setView( w );

  // Set a better title than "KTsp <2>"
  setCaption( i18n( "TSP Viewer" ) );
  }


View::~View()
  {
  }



void View::drawTsp( Point *tsp )
  {
  if ( tsp == 0 )
    {
    // This can't happen because we enable the corresponding
    // menu entry only when there realls is something to view.
    // We do this anyway, just in case ...
    KMsgBox box( this, i18n( "TSP Error" ),
                       i18n( "No TSP ready for displaying!" ),
                       KMsgBox::STOP,
                       i18n( "Dismiss" ) );
    box.exec();
    close();
    }
  else
    {
    points = tsp;
    calcScale();
    w->setFixedSize( w->width(), ( w->width() * _height ) / _width );
    w->setPoints( points );
    w->setParameters( _width, _height, _marginX, _marginY );
    w->setGraphicParameters( _pointsShape, _pointsColour, _pointsSize,
                             _linesStyle, _linesColour, _linesWidth );
    updateRects();
    }
  }


void View::calcScale()
  {
  Point *p = points;
  DBL minX, maxX, minY, maxY, tmp;
  minX = minY = MAXDBL;
  maxX = maxY = MINDBL;

  do
    {
    tmp = p->x();
    if ( tmp < minX ) minX = tmp;
    if ( tmp > maxX ) maxX = tmp;
    tmp = p->y();
    if ( tmp < minY ) minY = tmp;
    if ( tmp > maxY ) maxY = tmp;
    p = p->nextPointer();
    } while( p != points );
  _width = ( maxX - minX );
  _height = ( maxY - minY );
  _marginX = minX;
  _marginY = minY;
  }


