    /*

    tspio.h  for ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#ifndef __TSPIO__
#define __TSPIO__


#include <qstring.h>

#include "point.h"
#include "random.h"


class TspIO
  {
  public:
    TspIO();
    ~TspIO();
    Point *generateTsp( int points = 300, int neighbours = 10 );
    Point *loadTsp( QString name, int neighbours = 10,
                    bool remove = false );
    bool saveTsp( QString name, Point *tsp, int points );
    int numberOfPoints();
    int numberOfNeighbours();

  private:
    int _numberOfPoints;
    int _numberOfNeighbours;
    Random *random;
    bool ignore( QString s );
    bool isTsp( QString s );
    bool isCorrectVersion( QString s );
  };





#endif      // __TSPIO__
