    /*

    graphicdialog.C  for ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */



#include <iostream.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <kapp.h>

#include "graphicdialog.h"



GraphicDialog::GraphicDialog( int pointsShape, int pointsShapeDefault,
                              int pointsColour, int pointsColourDefault,
                              int pointsSize, int pointsSizeDefault,
                              int linesStyle, int linesStyleDefault,
                              int linesColour, int linesColourDefault,
                              int linesWidth, int linesWidthDefault,
                              QWidget *parent,
                              const char *name )
         : QDialog( parent, name, true )
  {
  // set all values appropriately
  _pointsShape = pointsShape;
  _pointsShapeDefault = pointsShapeDefault;
  _pointsColour = pointsColour;
  _pointsColourDefault = pointsColourDefault;
  _pointsSize = pointsSize;
  _pointsSizeDefault = pointsSizeDefault;
  _linesStyle = linesStyle;
  _linesStyleDefault = linesStyleDefault;
  _linesColour = linesColour;
  _linesColourDefault = linesColourDefault;
  _linesWidth = linesWidth;
  _linesWidthDefault = linesWidthDefault;

  // first the two QGroupBoxes
  QGroupBox *pointsBox = new QGroupBox( i18n( "Points" ),
                                        this, "Points Box" );
  CHECK_PTR( pointsBox );
  QGroupBox *linesBox = new QGroupBox( i18n( "Lines" ),
                                       this, "Lines Box" );
  CHECK_PTR( linesBox );

  // and a QLabel used temporarely
  QLabel *label;

  // our toplevel layout
  QVBoxLayout *layout = new QVBoxLayout( this, 5 );
  CHECK_PTR( layout );

  // the layout for the buttons
  QHBoxLayout *buttons = new QHBoxLayout();
  CHECK_PTR( buttons );

  // the layouts for the 2 boxes
  QGridLayout *box1 = new QGridLayout( pointsBox, 3, 2, 20 );
  CHECK_PTR( box1 );
  box1->setColStretch( 0, 1 );
  box1->setColStretch( 1, 4 );
  QGridLayout *box2 = new QGridLayout( linesBox, 3, 2, 20 );
  CHECK_PTR( box2 );
  box2->setColStretch( 0, 1 );
  box2->setColStretch( 1, 4 );


  // now we glue the whole layout hierarchy together
  layout->addWidget( pointsBox );
  layout->addWidget( linesBox );
  layout->addSpacing( 10 );
  layout->addLayout( buttons );


  // the first box
  label = new QLabel( i18n( "Shape" ), pointsBox, "Points Shape Label" );
  CHECK_PTR( label );
  label->setMinimumSize( label->sizeHint() );

  pointsShapeCombo = new QComboBox( false, pointsBox, "Points Shape Combo" );
  CHECK_PTR( pointsShapeCombo );
  pointsShapeCombo->insertItem( i18n( "Circle" ), Circle );
  pointsShapeCombo->insertItem( i18n( "Square" ), Square );
  pointsShapeCombo->setCurrentItem( pointsShape );
  pointsShapeCombo->setMinimumSize( pointsShapeCombo->sizeHint() );
  connect( pointsShapeCombo, SIGNAL( activated( int ) ),
           this, SLOT( slotPointsShapeChanged( int ) ) );

  //  into the layouts with them
  box1->addWidget( label, 0, 0 );
  box1->addWidget( pointsShapeCombo, 0, 1 );

  label = new QLabel( i18n( "Colour" ), pointsBox, "Points Colour Label" );
  CHECK_PTR( label );
  label->setMinimumSize( label->sizeHint() );

  pointsColourCombo = new QComboBox( false, pointsBox, "Points Colour Combo" );
  CHECK_PTR( pointsColourCombo );
  pointsColourCombo->insertItem( i18n( "Red" ), Red );
  pointsColourCombo->insertItem( i18n( "Green" ), Green );
  pointsColourCombo->insertItem( i18n( "Blue" ), Blue );
  pointsColourCombo->insertItem( i18n( "Black" ), Black );
  pointsColourCombo->setCurrentItem( pointsColour );
  pointsColourCombo->setMinimumSize( pointsColourCombo->sizeHint() );
  connect( pointsColourCombo, SIGNAL( activated( int ) ),
           this, SLOT( slotPointsColourChanged( int ) ) );

  //  into the layouts with them
  box1->addWidget( label, 1, 0 );
  box1->addWidget( pointsColourCombo, 1, 1 );

  label = new QLabel( i18n( "Size" ), pointsBox, "Points Size Label" );
  CHECK_PTR( label );
  label->setMinimumSize( label->sizeHint() );

  pointsSizeCombo = new QComboBox( false, pointsBox, "Points Size Combo" );
  CHECK_PTR( pointsSizeCombo );
  pointsSizeCombo->insertItem( i18n( "Small" ), Small );
  pointsSizeCombo->insertItem( i18n( "Medium" ), Medium );
  pointsSizeCombo->insertItem( i18n( "Large" ), Large );
  pointsSizeCombo->setCurrentItem( pointsSize );
  pointsSizeCombo->setMinimumSize( pointsSizeCombo->sizeHint() );
  connect( pointsSizeCombo, SIGNAL( activated( int ) ),
           this, SLOT( slotPointsSizeChanged( int ) ) );

  //  into the layouts with them
  box1->addWidget( label, 2, 0 );
  box1->addWidget( pointsSizeCombo, 2, 1 );



  // the second box
  label = new QLabel( i18n( "Style" ), linesBox, "Lines Style Label" );
  CHECK_PTR( label );
  label->setMinimumSize( label->sizeHint() );

  linesStyleCombo = new QComboBox( false, linesBox, "Lines Style Combo" );
  CHECK_PTR( linesStyleCombo );
  linesStyleCombo->insertItem( i18n( "Solid" ), Solid );
  linesStyleCombo->insertItem( i18n( "Dashed" ), Dash );
  linesStyleCombo->insertItem( i18n( "Dotted" ), Dotted );
  linesStyleCombo->insertItem( i18n( "Dash dot" ), Dashdot );
  linesStyleCombo->setCurrentItem( linesStyle );
  linesStyleCombo->setMinimumSize( linesStyleCombo->sizeHint() );
  connect( linesStyleCombo, SIGNAL( activated( int ) ),
           this, SLOT( slotLinesStyleChanged( int ) ) );

  //  into the layouts with them
  box2->addWidget( label, 0, 0 );
  box2->addWidget( linesStyleCombo, 0, 1 );

  label = new QLabel( i18n( "Colour" ), linesBox, "Lines Colour Label" );
  CHECK_PTR( label );
  label->setMinimumSize( label->sizeHint() );

  linesColourCombo = new QComboBox( false, linesBox, "Lines Colour Combo" );
  CHECK_PTR( linesColourCombo );
  linesColourCombo->insertItem( i18n( "Red" ), Red );
  linesColourCombo->insertItem( i18n( "Green" ), Green );
  linesColourCombo->insertItem( i18n( "Blue" ), Blue );
  linesColourCombo->insertItem( i18n( "Black" ), Black );
  linesColourCombo->setCurrentItem( linesColour );
  linesColourCombo->setMinimumSize( linesColourCombo->sizeHint() );
  connect( linesColourCombo, SIGNAL( activated( int ) ),
           this, SLOT( slotLinesColourChanged( int ) ) );

  //  into the layouts with them
  box2->addWidget( label, 1, 0 );
  box2->addWidget( linesColourCombo, 1, 1 );

  label = new QLabel( i18n( "Width" ), linesBox, "Lines Width Label" );
  CHECK_PTR( label );
  label->setMinimumSize( label->sizeHint() );

  linesWidthCombo = new QComboBox( false, linesBox, "Lines Width Combo" );
  CHECK_PTR( linesWidthCombo );
  linesWidthCombo->insertItem( i18n( "Small" ), Small );
  linesWidthCombo->insertItem( i18n( "Medium" ), Medium );
  linesWidthCombo->insertItem( i18n( "Large" ), Large );
  linesWidthCombo->setCurrentItem( linesWidth );
  linesWidthCombo->setMinimumSize( linesWidthCombo->sizeHint() );
  connect( linesWidthCombo, SIGNAL( activated( int ) ),
           this, SLOT( slotLinesWidthChanged( int ) ) );

  //  into the layouts with them
  box2->addWidget( label, 2, 0 );
  box2->addWidget( linesWidthCombo, 2, 1 );


  // the buttons
  QPushButton *ok = new QPushButton( i18n( "OK" ), this, "OK Button" );
  CHECK_PTR( ok );
  connect( ok, SIGNAL( clicked() ), this, SLOT( slotOK() ) );
  ok->setDefault( true );
  QPushButton *defaults = new QPushButton( i18n( "Defaults" ), this,
                                                "Defaults Button" );
  CHECK_PTR( defaults );
  connect( defaults, SIGNAL( clicked() ), this, SLOT( slotDefaults() ) );
  QPushButton *cancel = new QPushButton( i18n( "Cancel" ), this,
                                              "Cancel Button" );
  CHECK_PTR( cancel );
  connect( cancel, SIGNAL( clicked() ), this, SLOT( reject() ) );

  QSize s = ok->sizeHint();
  if ( defaults->sizeHint().width() > s.width() )
                s.setWidth( defaults->sizeHint().width() );
  if ( cancel->sizeHint().width() > s.width() )
                s.setWidth( cancel->sizeHint().width() );

  ok->setFixedSize( s );
  defaults->setFixedSize( s );
  cancel->setFixedSize( s );

  // in the layout with them
  buttons->addWidget( ok );
  buttons->addSpacing( 10 );
  buttons->addStretch();
  buttons->addWidget( defaults );
  buttons->addSpacing( 10 );
  buttons->addStretch();
  buttons->addWidget( cancel );


  box1->activate();
  box2->activate();
  layout->activate();

  resize( 0, 0 );
  layout->freeze();

  }



GraphicDialog::~GraphicDialog()
  {
  }


void GraphicDialog::slotPointsShapeChanged( int value )
  {
  _pointsShape = value;
  }


void GraphicDialog::slotPointsColourChanged( int value )
  {
  _pointsColour = value;
  }


void GraphicDialog::slotPointsSizeChanged( int value )
  {
  _pointsSize = value;
  }


void GraphicDialog::slotLinesStyleChanged( int value )
  {
  _linesStyle = value;
  }


void GraphicDialog::slotLinesColourChanged( int value )
  {
  _linesColour = value;
  }


void GraphicDialog::slotLinesWidthChanged( int value )
  {
  _linesWidth = value;
  }


void GraphicDialog::slotDefaults()
  {
  _pointsShape = _pointsShapeDefault;
  _pointsColour = _pointsColourDefault;
  _pointsSize = _pointsSizeDefault;
  _linesStyle = _linesStyleDefault;
  _linesColour = _linesColourDefault;
  _linesWidth = _linesWidthDefault;
  pointsShapeCombo->setCurrentItem( _pointsShape );
  pointsColourCombo->setCurrentItem( _pointsColour );
  pointsSizeCombo->setCurrentItem( _pointsSize );
  linesStyleCombo->setCurrentItem( _linesStyle );
  linesColourCombo->setCurrentItem( _linesColour );
  linesWidthCombo->setCurrentItem( _linesWidth );
  }


void GraphicDialog::slotOK()
  {
  emit pointsShapeChanged( _pointsShape );
  emit pointsColourChanged( _pointsColour );
  emit pointsSizeChanged( _pointsSize );
  emit linesStyleChanged( _linesStyle );
  emit linesColourChanged( _linesColour );
  emit linesWidthChanged( _linesWidth );
  accept();
  }


