    /*

    gda.h  for  ktsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@uwix.alt.na

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */



/*
This is an abstract class. Use GdaMin or GdaMax instead!
*/



#ifndef __GDA__
#define __GDA__



#include <qobject.h>
#include <qstring.h>

#include "globals.h"



class Gda : public QObject
  {
  Q_OBJECT

  public:
    Gda();
    virtual ~Gda();
    // This starts one run of GDA.
    // scaleFactor adjusts the rain speed to the scale of the problem.
    // qual is the initial quality of the problem.
    // loopLength tells GDA how long one loop through all possibilities is.
    void startGda( DBL scaleFactor, DBL qual, int loopLength );
    // This stops a running calculation. Must be implemented by derived
    // classes.
    void stop();
    int confFactor();

  signals:
    // All these signals are meant for the GUI. They provide informations
    // about the internal state of GDA. The GUI may or may not display
    // them.
    void quality( double qual );
    void actions( int act );
    void accepted( int accep );
    void better( int bet );
    void rejected( int rej );
    void worseAccepted( int wor );

  public slots:
    void setConfFactor( int factor );

  protected:
    // Since GDA doesn't know anything about the real problem the next three
    // member functions have to be implemented as abstract members. The
    // derived class that implements the real problems has to implement them
    // as well.
    virtual DBL nextAction() = 0;
    virtual void acceptAction() = 0;
    virtual DBL calcQuality() = 0;
    // A flag that indicates that a running calculation has been stopped.
    bool stopped;

  private:
    // Internal memeber functions.
    void loopComplete();
    void afterLoop();
    void evaluateAction( DBL qual );
    void adjustWaterLevel();

    DBL _waterLevel;
    DBL _quality;
    DBL _rainFactor;
    DBL _rainMin;
    DBL _confFactor;

    int _actions;
    int _accepted;
    int _better;
    int _rejected;
    int _loopLength;

    bool _changed;
    bool _finished;
  };



#endif  // __GDA__

