    /*

    actionsdisplay.C  for  KTsp-0.1.0

    Copyright (C) 1999 Uwe Thiem
                       uwe@kde.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */


#include <iostream.h>
#include <kapp.h>

#include "actionsdisplay.h"


ActionsDisplay::ActionsDisplay( QWidget *parent, const char *name )
      : GraphDisplay( i18n( "Current run" ),
                      i18n( "Course length over actions" ),
                      parent, name )
  {
  graph->setHScale( 120 );
  receivedValues = 0;
  }


ActionsDisplay::~ActionsDisplay()
  {
  }


void ActionsDisplay::slotClearDisplay()
  {
  graph->clear();
  graph->setHScale( 120 );
  receivedValues = 0;
  }


void ActionsDisplay::slotNextValue( double value )
  {
  switch ( receivedValues )
    {
    case 0:
      break;
    case 1:
      graph->setVScale( value );
    default:
      graph->slotNextValue( value );
      break;
    }
  receivedValues++;
  }


