// ----------------------------------------------------------------------------
// Filename:    DockWidget.h
// $Date: 2000/02/17 23:28:02 $
// $Revision: 1.2 $
// ----------------------------------------------------------------------------

#ifndef _DOCKWIDGET_H
#define _DOCKWIDGET_H

#include <qpixmap.h>
#include <qapplication.h>

/**
 * Docking widget, used to dock the KTimeclock into KPanel.
 */
class DockWidget : public QWidget
{
    Q_OBJECT
public:
    /**
     * Constructor.
     *
     * @param   mainwin Handle to main window
     * @param   name    Name of this widget.
     */
    DockWidget (QWidget* mainwin, const char* name=0);

    /**
     * Destructor.
     */
    ~DockWidget ();

    /**
     * Returns a boolean value stating whether or not the window is currently
     * docked into KPanel.
     *
     * @returns Are we docked into KPanel?
     */
    const bool isDocked ();

public slots:
    /**
     * Docks the application into KPanel.
     */
    void dock ();

    /**
     * Un-docks the application from KPanel.
     */
    void undock ();

protected:
    /**
     * Over-ridden painting event; we use this to paint our own icon onto our
     * display in the KPanel.
     */
    void paintEvent (QPaintEvent*);

    /**
     * Over-ridden mouse press event; used to toggle our main window in and out
     * of hiding.
     *
     * @param   e       Event to respond to
     */
    void mousePressEvent (QMouseEvent* e);

private:
    bool    _docked;
    QPixmap _pixmap;
    QWidget* _mainwin;
};

#endif
