/***************************************************************************
                          getcmdline.cpp  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Rolf Jakob
    email                : rjakob@duffy1.franken.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "getcmdline.h"
#include "getcmdline.moc"
// #include <qfiledlg.h>

kgetcmdlinedlg :: kgetcmdlinedlg(QWidget *parent, const char *name, bool modal)
	: QDialog(parent,name,modal)
{
	this->setFocusPolicy(QWidget::StrongFocus);

	if (name) setCaption(name);
	ret_flag=FALSE;
	ismodal=modal;

	frame = new QGroupBox(i18n("Command line"),this,"frame1");

	label=new QLabel(this);
	if (name) label->setText(name);
	cmd=new QLineEdit(this);
	okbutton=new QPushButton(i18n("OK"),this);
	okbutton->resize(okbutton->sizeHint());
	cancelbutton=new QPushButton(i18n("Cancel"),this);
	cancelbutton->resize(cancelbutton->sizeHint());

	connect(okbutton,SIGNAL(clicked()),this,SLOT(okpressed()));
	connect(cancelbutton,SIGNAL(clicked()),this,SLOT(cancelpressed()));
	connect(cmd,SIGNAL(returnPressed()),this,SLOT(okpressed()));

	cmd->setFocus();
	setFixedSize(330,130);
}

void kgetcmdlinedlg :: okpressed()
{
	ret_flag=TRUE;
	closeEvent((QCloseEvent*)0);
}

void kgetcmdlinedlg :: cancelpressed()
{
	ret_flag=FALSE;
	closeEvent((QCloseEvent*)0);
}


void kgetcmdlinedlg :: setvalue(char *b)
{
	cmd->setText(b);
}

void kgetcmdlinedlg :: setlabel(const char *text)
{
	label->setText(text);
}

void kgetcmdlinedlg :: resizeEvent(QResizeEvent *)
{
	frame->setGeometry(5,5,width()-10,80);
	label->resize(label->sizeHint());
	label->setGeometry(20,25,label->width(),25);
	cmd->setGeometry(label->width()+30,25,
		width()-label->width()-70,25);
	okbutton->setGeometry(15,height()-30,
		okbutton->width(),25);
	cancelbutton->setGeometry(width()-cancelbutton->width()-25,height()-30,
		cancelbutton->width(),25);
}

void kgetcmdlinedlg :: closeEvent(QCloseEvent *)
{
	printf("got close signal\n");
//	if (e) (void)e;
	emit dialog_closed(ret_flag);
	printf("emit dialog_closed signal\n");
	if (ismodal) {
		delete this;
		printf("deleted\n");
		}
}

