/***************************************************************************
                          kmsgmodem.cpp  -  description
                             -------------------                                         
    begin                : Mon Apr  5 09:53:56 MEST 1999
                                           
    copyright            : (C) 1999 by Torsten Uhlmann                         
    email                : TUhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qscrollview.h>
#include <qmessagebox.h>
#include <qstring.h>
#include <qstrlist.h>
#include <kprocess.h>
#include <kfiledialog.h>

#include "kmsgmodem.h"
#include "settingsdialog.h"
#include "voicemessagesdialog.h"
#include "voicedial.h"
#include "ModemControl.h"
#include "ModemStatus.h"
#include "ModemTerminal.h"
#include "aboutdialog.h"


KMsgModemApp::KMsgModemApp()
{
  setCaption(i18n("KDE Message Modem, Version " VERSION));

  ///////////////////////////////////////////////////////////////////
  // read the config file options
  readOptions();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initView();
  initModem();

  ///////////////////////////////////////////////////////////////////
  // enable bars dependend on config file setups
  if (!configuration.bViewToolbar)
    enableToolBar(KToolBar::Hide,0);
  if (!configuration.bViewStatusbar)
    enableStatusBar(KStatusBar::Hide);

  menuBar()->setMenuBarPos(configuration.menu_bar_pos);
  toolBar()->setBarPos(configuration.tool_bar_pos);

  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
	disableCommand(ID_FAX_POPUP_VIEW);
	disableCommand(ID_FAX_POPUP_SAVE);
	disableCommand(ID_FAX_POPUP_PRINT);
	disableCommand(ID_FAX_POPUP_MAIL);
	disableCommand(ID_VOICE_POPUP_SAVE);
	disableCommand(ID_VOICE_POPUP_PLAY_INTERN);
	disableCommand(ID_VOICE_POPUP_PLAY_CARD);
	disableCommand(ID_VOICE_POPUP_MAIL);
	disableCommand(ID_GENERIC_POPUP_SAVE);
	disableCommand(ID_GENERIC_POPUP_MAIL);

  _tabListIndex = -1;
  _faxIndex     = -1;
  memset(&_moGeneral,0,sizeof(_moGeneral));
  //memset(&_moMsgList,0,sizeof(_moMsgList));
  _moMsgList.setAutoDelete(true);

  voiceMessagesDialog = 0;
  voiceDial = 0;
  mUrlLabel = 0;
  mAboutDialog = 0;

  // initialize status dialog
 	statusDialog 	= new ModemStatus();
	// connect gotData to statusDialog->update
  connect(this, SIGNAL(gotData(const ModemGeneralInfo&, ModemMessageList)),
					statusDialog, SLOT(slotUpdateStatus(const ModemGeneralInfo&)));

	if (_modemInitialized) slotGetMemoryInfo();
}

KMsgModemApp::~KMsgModemApp()
{
	if (modem) 								delete modem;
	if (statusDialog)					delete statusDialog;
	if (voiceMessagesDialog) 	delete voiceMessagesDialog;
	if (voiceDial) 						delete voiceDial;
	if (mUrlLabel)						delete mUrlLabel;
  if (mAboutDialog)					delete mAboutDialog;
}

void KMsgModemApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void KMsgModemApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}


void KMsgModemApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR  

  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  //file_menu->insertItem(Icon("mini/kmsgmodemapp.xpm"), i18n("New &Window"), ID_FILE_NEW_WINDOW );
  //file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print"), ID_FILE_PRINT );
  file_menu->insertItem(Icon("exit.xpm"),	i18n("E&xit"), ID_FILE_QUIT );
  file_menu->setAccel(CTRL+Key_Q, ID_FILE_QUIT);


  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("Tool&bar"), ID_VIEW_TOOLBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );

  view_menu->setItemChecked(ID_VIEW_TOOLBAR, configuration.bViewToolbar);
  view_menu->setItemChecked(ID_VIEW_STATUSBAR, configuration.bViewStatusbar);

  ///////////////////////////////////////////////////////////////////
  // EDIT YOUR APPLICATION SPECIFIC MENUENTRIES HERE

  // modem_menu
  modem_menu = new QPopupMenu();
  modem_menu->insertItem(Icon("find.xpm")									,i18n("Get Memory &Information")	, ID_MODEM_GET_INFO);
  modem_menu->insertItem(Icon("lassoo.xpm")								,i18n("&Get Modem Memory")				, ID_MODEM_GET_MEMORY);
  modem_menu->insertSeparator();
  //modem_menu->insertItem(i18n("&Control Modem")					, ID_MODEM_CONTROL);
  //modem_menu->insertItem(i18n("Modem Info &Dialog")			, ID_MODEM_INFO_DIALOG);
  modem_menu->insertItem(i18n("Modem &Terminal...")				, ID_MODEM_TERMINAL);
  modem_menu->insertSeparator();
  modem_menu->insertItem(i18n("&Voice Phone")							, ID_MODEM_VOICEDIAL);

  modem_menu->insertSeparator();
  modem_menu->insertItem(Icon("delete.xpm")	,i18n("&Clear Modem Memory")			, ID_MODEM_CLEAR_MEMORY);
  modem_menu->insertItem(i18n("&Reset Modem Clock")				,	ID_MODEM_RESET_CLOCK);
  modem_menu->insertItem(i18n("Commit C&hanges")					,	ID_MODEM_COMMIT_SETUP);


  // modem_menu
  config_menu = new QPopupMenu();
  config_menu->insertItem(i18n("Application &Settings..."), ID_CONFIG_CONFIG);
  config_menu->insertSeparator();
  config_menu->insertItem(i18n("&Control Modem...")				, ID_MODEM_CONTROL);
  config_menu->insertItem(i18n("&Voice Messages...")			, ID_MODEM_VOICEMESSAGES);
  config_menu->insertSeparator();
  config_menu->insertItem(i18n("Modem Info &Dialog...")		, ID_MODEM_INFO_DIALOG);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  help_menu = new QPopupMenu();
  help_menu->insertItem(i18n("Help on KMsgModem"),
												KApplication::getKApplication(),
												SLOT(appHelpActivated()), Key_F1);
  help_menu->insertSeparator();
  help_menu->insertItem(i18n("About &KMsgModem...")	,this	, SLOT(showAboutDialog()) );
  help_menu->insertItem(i18n("About &Qt")						,this	, SLOT(slotAboutQt()));
  help_menu->insertItem(i18n("About &KDE")					,
												KApplication::getKApplication(),
												SLOT(aboutKDE()));

  help_menu->setAccel(CTRL+Key_A, ID_HELP_ABOUT);

  // create the fax popup menu
  fax_popup_menu = new QPopupMenu();
  fax_popup_menu->insertItem(Icon("filefloppy.xpm")				,i18n("&Save Fax as ..."),ID_FAX_POPUP_SAVE);
  fax_popup_menu->insertSeparator();
  fax_popup_menu->insertItem(Icon("message_send.xpm")			,i18n("Send Fax as &Mail"),ID_FAX_POPUP_MAIL);
  fax_popup_menu->insertItem(Icon("print_preview.xpm")		,i18n("&View Fax"),ID_FAX_POPUP_VIEW);
  fax_popup_menu->insertItem(Icon("kmsgmodem_print.xpm")	,i18n("&Print Fax"),ID_FAX_POPUP_PRINT);

  // create the voice popup menu
  voice_popup_menu = new QPopupMenu();
  voice_popup_menu->insertItem(Icon("filefloppy.xpm")			,i18n("&Save Message as ...")	,ID_VOICE_POPUP_SAVE);
  voice_popup_menu->insertSeparator();
  voice_popup_menu->insertItem(Icon("message_send.xpm")		,i18n("Send Message as &Mail"),ID_VOICE_POPUP_MAIL);
  voice_popup_menu->insertItem(Icon("play_intern.xpm")		,i18n("Play &internal")				,ID_VOICE_POPUP_PLAY_INTERN);
  voice_popup_menu->insertItem(Icon("play_soundcard.xpm")	,i18n("Play via &Soundcard")	,ID_VOICE_POPUP_PLAY_CARD);

  // popup_menu key accelerators
  fax_popup_menu->setAccel(CTRL+Key_V, ID_FAX_POPUP_VIEW);
  fax_popup_menu->setAccel(CTRL+Key_S, ID_FAX_POPUP_SAVE);
  fax_popup_menu->setAccel(CTRL+Key_P, ID_FAX_POPUP_PRINT);
  fax_popup_menu->setAccel(CTRL+Key_M, ID_FAX_POPUP_MAIL);

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // set menuBar() the current menuBar and the position due to config file
  menuBar()->insertItem(i18n("&File") 		, file_menu);
  menuBar()->insertItem(i18n("&View") 		, view_menu);
  menuBar()->insertItem(i18n("&Modem")		, modem_menu);
  menuBar()->insertItem(i18n("&Fax")  		, fax_popup_menu);
  menuBar()->insertItem(i18n("&Voice") 		, voice_popup_menu);
  menuBar()->insertItem(i18n("&Settings")	, config_menu);

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC MENUENTRIES HERE


  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE SUBMENU SLOTS WITH SIGNALS

  CONNECT_CMD(file_menu );
  CONNECT_CMD(view_menu );
  CONNECT_CMD(modem_menu);
  CONNECT_CMD(config_menu);
  CONNECT_CMD(fax_popup_menu);
  CONNECT_CMD(voice_popup_menu);
}

void KMsgModemApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  // set toolBar() the current toolBar and the position due to config file
  toolBar()->insertButton(Icon("exit.xpm")         		, ID_FILE_QUIT, true, i18n("Exit"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("delete.xpm")       		, ID_MODEM_CLEAR_MEMORY, true, i18n("Clear Modem Memory"));
  toolBar()->insertButton(Icon("find.xpm")         		, ID_MODEM_GET_INFO, true, i18n("Get Memory Information"));
  toolBar()->insertButton(Icon("lassoo.xpm")       		, ID_MODEM_GET_MEMORY, true, i18n("Get Modem Memory"));
  toolBar()->insertButton(Icon("print_preview.xpm")		, ID_FAX_POPUP_VIEW, true, i18n("View the selected Fax"));
  toolBar()->insertButton(Icon("kmsgmodem_print.xpm")	, ID_FAX_POPUP_PRINT, true, i18n("Print the selected Fax"));
  toolBar()->insertButton(Icon("play_intern.xpm")			, ID_VOICE_POPUP_PLAY_INTERN, true, i18n("Play the selected message via internal speaker"));
  toolBar()->insertButton(Icon("play_soundcard.xpm")	, ID_VOICE_POPUP_PLAY_CARD, true, i18n("Play the selected message via soundcard"));
  toolBar()->insertButton(Icon("filefloppy.xpm")   		, ID_GENERIC_POPUP_SAVE, true, i18n("Save the selected message"));
  toolBar()->insertButton(Icon("message_send.xpm") 		, ID_GENERIC_POPUP_MAIL, true, i18n("Mail the selected message"));
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help.xpm"), ID_HELP, SIGNAL(pressed()), kapp, SLOT(appHelpActivated()), true, i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE -e.g. tool_bar_1:
  // add functionality for new created toolbars in:
  // enableCommand, disableCommand, in the menuBar() and an additional function slotViewToolbar_1
  // for that also create a bViewToolbar_1 and a KConfig entry (see Constructor).
  // Also update resource values and commands 


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars
  CONNECT_TOOLBAR(toolBar());

}

void KMsgModemApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //STATUSBAR
  statusBar()->insertItem(IDS_DEFAULT, ID_STATUS_MSG );
  statusBar()->setInsertOrder(KStatusBar::RightToLeft);

}

void KMsgModemApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // set the main widget here
  KApplication *app=KApplication::getKApplication();
  view = new KMsgModemView(app,this);
  setView(view);
  connect( view, SIGNAL(popupMenu  ( int,int )), SLOT(slotOpenPopup   ( int,int )) );
  connect( view, SIGNAL(highlighted( int,int )), SLOT(slotSetFaxIndex ( int,int )) );
  connect(this, SIGNAL(gotData(const ModemGeneralInfo&, ModemMessageList)),
					view, SLOT(slotGotData(const ModemGeneralInfo&, ModemMessageList)));
}

void KMsgModemApp::initModem()
{
  // Create a modem object and initialize it with serial line
  modem = new USRModem(configuration.serialLine,
  										 configuration.baudrate,
  										 configuration.lockfile);
  CHECK_PTR(modem);
  if (!modem->initSerialLine())
  {
    _modemInitialized = false;
    QMessageBox::information(0,i18n("Initializing Modem"),
      i18n("Could not initialize serial line!\n"
      "Please check the device entry\nin the settings dialog."),
      QMessageBox::Ok | QMessageBox::Default);
    slotDisableMost();
  } else {
  	if (!modem->initModem())
  	{
    	_modemInitialized = false;
    	QMessageBox::information(0,i18n("Initializing Modem"),
      	i18n("Could not initialize Modem!\n"
      	"Please check if the modem is attached\n"
      	"to the specified device."),
      	QMessageBox::Ok | QMessageBox::Default);
    	slotDisableMost();
  	} else
    	_modemInitialized = true;
  }
}

bool KMsgModemApp::queryExit()
{

	if (!_modemInitialized)
		return true;
		
  int mode=KMsgBox::yesNoCancel(this, i18n("Standalone Mode"),
  			i18n("Do you want to switch in Standalone Mode?"));

  if (mode != 3)
  {
	  if(mode==1)
  	  modem->setStandaloneMode();
  	else
  		modem->unsetStandaloneMode();
  		
  	return true;
  }
 	return false;
}

void KMsgModemApp::saveOptions()
{

	//create separate object that handles configurable values
	
  KConfig *config = kapp->getConfig();

  config->setGroup("APPEARANCE");
  config->writeEntry("ShowToolbar"		,toolBar()->isVisible());
  config->writeEntry("ShowStatusbar"	,statusBar()->isVisible());
  config->writeEntry("MenuBarPos"			, (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBar_Pos"		, (int)toolBar()->barPos());

  // write modem settings
  config->setGroup("MODEM");
  config->writeEntry("SerialLine"			,	configuration.serialLine);
  config->writeEntry("Baudrate"				,	configuration.baudrate);
  config->writeEntry("Lockfile"				,	configuration.lockfile);

  // write SOUND settings
  config->setGroup("SOUND");
  config->writeEntry("AudioDevice"		,	configuration.audioDevice);

  // write SOUND settings
  config->setGroup("USER");
  config->writeEntry("DefaultEMail"		,	configuration.defaultEMail);

  // helper applications
  config->setGroup("HELPER");
  config->writeEntry("FaxViewer"			,	configuration.faxViewer);
  config->writeEntry("VoiceProcessor"	,	configuration.voiceProcessor);
  config->writeEntry("PrintCommand"		,	configuration.printCommand);
  config->writeEntry("MailCommand"		,	configuration.mailCommand);
  config->writeEntry("Wav2GsmCommand"	,	configuration.wav2gsmCommand);
}

void KMsgModemApp::readOptions()
{
  ///////////////////////////////////////////////////////////////////
  // read the config file entries
  KConfig *config = kapp->getConfig();

 
  config->setGroup("APPEARANCE");
  configuration.bViewToolbar 		= config->readBoolEntry("ShowToolbar", true);
  configuration.bViewStatusbar 	= config->readBoolEntry("ShowStatusbar", true);
  configuration.menu_bar_pos 		= (KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);
  configuration.tool_bar_pos 		= (KToolBar::BarPosition)config->readNumEntry("ToolBar_Pos", KToolBar::Top);

  // read modem settings
  config->setGroup("MODEM");
  configuration.serialLine 			= config->readEntry("SerialLine"	, MODEMDEVICE);
  configuration.baudrate 				= config->readEntry("Baudrate"		, BAUDRATE);
  configuration.lockfile				= config->readEntry("Lockfile"		, LOCKFILE);

  // read SOUND settings
  config->setGroup("SOUND");
  configuration.audioDevice			= config->readEntry("AudioDevice", AUDIODEVICE);

  // read USER settings
  config->setGroup("USER");
  configuration.defaultEMail		= config->readEntry("DefaultEMail", DEFAULTEMAIL);

  // read helper settings
  config->setGroup("HELPER");
  configuration.faxViewer 			= config->readEntry("FaxViewer"			, FAXVIEWER);
  configuration.voiceProcessor	= config->readEntry("VoiceProcessor", VOICEPROCESSOR);
  configuration.printCommand 		= config->readEntry("PrintCommand"	, PRINTCOMMAND);
  configuration.mailCommand 		= config->readEntry("MailCommand"		, MAILCOMMAND);
  configuration.wav2gsmCommand 	= config->readEntry("Wav2GsmCommand", WAV2GSMCOMMAND);
}


/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KMsgModemApp::slotFileQuit()
{ 

  ///////////////////////////////////////////////////////////////////
  // exits the Application
  if(this->queryExit())
    {
    	// should we turn on self mode?
      saveOptions();
      KTMainWindow::deleteAll();
      kapp->quit();
    }
  else
    slotStatusMsg(IDS_DEFAULT);
    return;
}

void KMsgModemApp::slotViewToolBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  configuration.bViewToolbar=!configuration.bViewToolbar;
  menuBar()->setItemChecked(ID_VIEW_TOOLBAR, configuration.bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  slotStatusMsg(IDS_DEFAULT);

}

void KMsgModemApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  configuration.bViewStatusbar=!configuration.bViewStatusbar;
  menuBar()->setItemChecked(ID_VIEW_STATUSBAR, configuration.bViewStatusbar);
  enableStatusBar();
  slotStatusMsg(IDS_DEFAULT);
}


void KMsgModemApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void KMsgModemApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}

void KMsgModemApp::slotOpenPopup(int index, int column)
{
/*  _tabListIndex = index;
  QString str = view->text(index,0);
  _faxIndex = str.toInt();

  str = view->text(index,1);
  if (str == "Fax")
  	_msgType = Fax;
  else
  	if (str == "Voice")
  		_msgType = Voice;
  	else
  		_msgType = unknown;
*/
	slotSetFaxIndex(index,column);
			
  //debug("Message index: %i, Message Type: %i",_faxIndex,_msgType);
  switch (_msgType)
  {
  	case Fax: fax_popup_menu->exec( QCursor::pos() );
  		break;
  	case Voice: voice_popup_menu->exec( QCursor::pos() );
  		break;
  	default:
  		QMessageBox::information(0,i18n("Open Popup"),
   			i18n("Message type unknown!"),
   	  	QMessageBox::Ok | QMessageBox::Default);
   	 	return;

  }
}


void KMsgModemApp::commandCallback(int id_){
  switch (id_){
    ON_CMD(ID_FILE_QUIT,                slotFileQuit())

    ON_CMD(ID_VIEW_TOOLBAR,             slotViewToolBar())
    ON_CMD(ID_VIEW_STATUSBAR,           slotViewStatusBar())

    ON_CMD(ID_MODEM_GET_INFO,           slotGetMemoryInfo())
    ON_CMD(ID_MODEM_GET_MEMORY,         slotGetMemory())
    ON_CMD(ID_MODEM_CLEAR_MEMORY,       slotClearMemory())

    ON_CMD(ID_MODEM_RESET_CLOCK				,	slotResetClock())
    ON_CMD(ID_MODEM_COMMIT_SETUP			,	slotCommitSetup())

    ON_CMD(ID_CONFIG_CONFIG,       			slotSettings())
    ON_CMD(ID_MODEM_CONTROL,       			slotModemControl())
    ON_CMD(ID_MODEM_INFO_DIALOG,   			slotModemInfoDialog())
    ON_CMD(ID_MODEM_TERMINAL,   				slotModemTerminal())
    ON_CMD(ID_MODEM_VOICEMESSAGES,			slotModemVoiceMessages())
    ON_CMD(ID_MODEM_VOICEDIAL,					slotModemVoiceDial())

    ON_CMD(ID_FAX_POPUP_VIEW,           slotViewFax())
    ON_CMD(ID_FAX_POPUP_SAVE,           slotSaveFax())
    ON_CMD(ID_FAX_POPUP_PRINT,          slotPrintFax())
    ON_CMD(ID_FAX_POPUP_MAIL,           slotMailFax())

    ON_CMD(ID_GENERIC_POPUP_SAVE, 			slotSaveGeneric())
    ON_CMD(ID_GENERIC_POPUP_MAIL, 			slotMailGeneric())

    ON_CMD(ID_VOICE_POPUP_SAVE, 				slotSaveVoice())
    ON_CMD(ID_VOICE_POPUP_PLAY_INTERN, 	slotPlayIntern())
    ON_CMD(ID_VOICE_POPUP_PLAY_CARD,  	slotPlaySoundcard())
    ON_CMD(ID_VOICE_POPUP_MAIL,         slotMailVoice())
  }
}

void KMsgModemApp::statusCallback(int id_){
  switch (id_){
    ON_STATUS_MSG(ID_FILE_QUIT,         			i18n("Exits the program"))

    ON_STATUS_MSG(ID_VIEW_TOOLBAR,      			i18n("Enables / disables the actual Toolbar"))
    ON_STATUS_MSG(ID_VIEW_STATUSBAR,    			i18n("Enables / disables the Statusbar"))

    ON_STATUS_MSG(ID_MODEM_GET_INFO,    			i18n("Get memory status from fax modem"))
    ON_STATUS_MSG(ID_MODEM_GET_MEMORY,  			i18n("Get used memory from fax modem"))
    ON_STATUS_MSG(ID_MODEM_CLEAR_MEMORY,			i18n("Clear memory of fax modem"))

    ON_STATUS_MSG(ID_MODEM_RESET_CLOCK			,	i18n("Reset modem clock"))
    ON_STATUS_MSG(ID_MODEM_COMMIT_SETUP			,	i18n("Commit changes"))

    ON_STATUS_MSG(ID_CONFIG_CONFIG,	    			i18n("Configure application settings"))
    ON_STATUS_MSG(ID_MODEM_CONTROL,	    			i18n("Configure Modem settings"))
    ON_STATUS_MSG(ID_MODEM_INFO_DIALOG,  			i18n("Show a general info dialog"))
    ON_STATUS_MSG(ID_MODEM_TERMINAL,  				i18n("speak directly to the modem"))
    ON_STATUS_MSG(ID_MODEM_VOICEMESSAGES,			i18n("Manipulate outgoing and full message"))
    ON_STATUS_MSG(ID_MODEM_VOICEDIAL,					i18n("Manual Dial Dialog"))

    ON_STATUS_MSG(ID_FAX_POPUP_VIEW,    			i18n("View selected fax within Faxviewer"))
    ON_STATUS_MSG(ID_FAX_POPUP_SAVE,    			i18n("Save selected fax as G3 files"))
    ON_STATUS_MSG(ID_FAX_POPUP_PRINT,   			i18n("Print selected fax"))
    ON_STATUS_MSG(ID_FAX_POPUP_MAIL,    			i18n("Send the selected fax as EMail"))

    ON_STATUS_MSG(ID_GENERIC_POPUP_SAVE,			i18n("Save selected message"))
    ON_STATUS_MSG(ID_GENERIC_POPUP_MAIL,			i18n("Mail selected message"))

    ON_STATUS_MSG(ID_VOICE_POPUP_SAVE,				i18n("Save selected message as gsm file"))
    ON_STATUS_MSG(ID_VOICE_POPUP_PLAY_INTERN, i18n("Play selected message via modem"))
    ON_STATUS_MSG(ID_VOICE_POPUP_PLAY_CARD,		i18n("Play selected message via soundcard"))
    ON_STATUS_MSG(ID_VOICE_POPUP_MAIL,   			i18n("Send the selected message as EMail"))
  }
}

// OWN SLOT DEFINITIONS

void KMsgModemApp::slotGetMemoryInfo()
{

  slotStatusMsg(i18n("Get modem memory info..."));

  // clean up the info list
  _moMsgList.clear();
  if (modem->getMemoryInfo(_moGeneral, _moMsgList))
  {
    emit gotData(_moGeneral, _moMsgList);
  }
  //_moMsgList = moMsgList;

  slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotGetFax(const QString &filename)
{
  slotStatusMsg(i18n("Extracting selected fax..."));

  if (_faxIndex > 0)
  {
    modem->getFax(_faxIndex, filename);
  }

  slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotGetVoice(const QString &filename, int index)
{
  slotStatusMsg(i18n("Extracting selected message..."));

  modem->getVoice(index, filename);

  slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotGetUserPageVoice(const QString &filename, int index)
{
  slotStatusMsg(i18n("Extracting message from user sector..."));

  modem->getUserPageVoice(index, filename);

  slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotGetMemory()
{
  slotStatusMsg(i18n("Get modem memory ..."));

  if (!modem->memoryInfoValid())
  	slotGetMemoryInfo();
  	
  if (!modem->getMemory())
  {
     QMessageBox::information(0,i18n("Get Memory"),
       i18n("Could not read fax memory!"),
       QMessageBox::Ok | QMessageBox::Default);
  } else {
    QMessageBox::information(0,i18n("Get Memory"),
      i18n("Fax Memory downloaded..."),
      QMessageBox::Ok | QMessageBox::Default);
  }

  slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotClearMemory()
{
  slotStatusMsg(i18n("Clear modem memory..."));

  int mode = KMsgBox::yesNo(this, i18n("Clear Modem Memory"),
  			i18n("Do you want to delete all messages?"));

  if(mode==1)
  {
	  if (modem->clearMemory())
  	{
    	view->clear();
    	QMessageBox::information(0,i18n("Clear Modem Memory"),
      	i18n("Fax memory is now empty."),
      	QMessageBox::Ok | QMessageBox::Default);
  	} else {
    	QMessageBox::information(0,i18n("Clear Modem Memory"),
      	i18n("Fax memory could not be cleared!"),
      	QMessageBox::Ok | QMessageBox::Default);
  	}
  }
  slotStatusMsg(IDS_DEFAULT);
}

/** handles one fax
		return is no of pages written */
int KMsgModemApp::faxHandler()
{
  int  		pagesWritten	= 0;
  QString filename			= 0;

  if (_faxIndex < 1)
  {
    QMessageBox::information(0,i18n("Get Fax"),
      i18n("You need to select the desired fax!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
  	return 0;
  }

  if (_msgType != Fax)
  {
    QMessageBox::information(0,i18n("Get Fax"),
      i18n("You need to select a fax message!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
  	return 0;
  }

  if (!(filename = modem->getMemoryFileName()))
  {
    if (!modem->getMemory())
    {
      QMessageBox::information(0,i18n("Get Fax"),
        i18n("Could not read fax memory!"),
        QMessageBox::Ok | QMessageBox::Default);
		  slotStatusMsg(IDS_DEFAULT);
      return 0;
    }
  }
  slotGetFax(0);
  if (!(filename = modem->getFaxFileName()))
  {
    QMessageBox::information(0,i18n("Get Fax"),
      i18n("Could not extract the selected fax!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
    return 0;
  }

  debug("Fax stored in %s-<nr>",filename.data());

  if (!(pagesWritten = modem->getPagesWritten()))
  {
    slotStatusMsg(i18n("No pages written!"));

    QMessageBox::information(0,i18n("Get Fax"),
      i18n("There were no pages written!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
    return 0;
  }
  return pagesWritten;
}

/** handles one voice message
		return is ok or not ok */
bool KMsgModemApp::voiceHandler(int index)
{
  QString filename = 0;

  if (index < 0)
  {
  	if (_faxIndex < 1)
  	{
    	QMessageBox::information(0,i18n("Get Message"),
      	i18n("You need to select the desired message!"),
      	QMessageBox::Ok | QMessageBox::Default);
	  	slotStatusMsg(IDS_DEFAULT);
  		return false;
  	}

  	if (_msgType != Voice)
  	{
    	QMessageBox::information(0,i18n("Get Message"),
      	i18n("You need to select a voice message!"),
      	QMessageBox::Ok | QMessageBox::Default);
	  	slotStatusMsg(IDS_DEFAULT);
  		return false;
  	}
  	index = _faxIndex;
  	
	  if (!(filename = modem->getMemoryFileName()))
  	{
  	  if (!modem->getMemory())
 	  	{
   	  	QMessageBox::information(0,i18n("Get Message"),
      	  i18n("Could not read modem memory!"),
 	      	QMessageBox::Ok | QMessageBox::Default);
			  slotStatusMsg(IDS_DEFAULT);
 	  	  return false;
    	}
  	}
  	slotGetVoice(0, index);
  } else {
  	// read a message from user sector

	  //if (!(filename = modem->getUserMemoryFileName()))
  	//{
 			debug ("read page for index %d",index);
  	  if (!modem->getMemoryPage(((index == 0) ? 0:1),((index == 0) ? 0:1)))
 	  	{
    	  QMessageBox::information(0,i18n("Get Message"),
 	    	  i18n("Could not read modem memory!"),
   	    	QMessageBox::Ok | QMessageBox::Default);
			  slotStatusMsg(IDS_DEFAULT);
 	    	return false;
    	}
    //}
  	slotGetUserPageVoice(0, index);
	}
	
 	if (!(filename = modem->getVoiceFileName()))
 	{
   	QMessageBox::information(0,i18n("Get Message"),
     	i18n("Could not extract the selected message!"),
     	QMessageBox::Ok | QMessageBox::Default);
  	slotStatusMsg(IDS_DEFAULT);
   	return false;
 	}
  debug("Message stored in %s.gsm",filename.data());
  return true;
}

void KMsgModemApp::slotViewFax()
{
  bool success       	= false;
  bool multiple				= false;
  int  pagesWritten  	= 0;
  int  i             	= 0;
  QString arg        	= 0;
  QString argLst			= 0;
  QString filename		= 0;
  QString cmdLine			= 0;
  KShellProcess proc;

  slotStatusMsg(i18n("View the selected fax..."));

  if (((pagesWritten = faxHandler()) > 0) &&
  		(filename = modem->getFaxFileName()))
  {
  	// now spawn Faxviewer process with pages as parameters
  	slotStatusMsg(i18n("starting Faxviewer..."));
  	
		if (cmdLine.find("%FILE",0,false) != -1) multiple = true;
			
	  for (i=1; i <= pagesWritten; i++)
  	{
    	arg = "";
	    arg.sprintf("%s-%i.g3 ",filename.data(),i);
  	  debug("Argument %i: %s",i,arg.data());
  	  argLst += arg;
  		if (multiple)
  		{
  			cmdLine = configuration.faxViewer.copy();
  			substituteKeyWord(cmdLine,"%FILE",arg);
	  	  debug("command: %s",cmdLine.data());
		  	proc.clearArguments();
  			proc << cmdLine;
		  	success = proc.start(KProcess::DontCare);
	  		if (success)
		  	  slotStatusMsg(i18n("Faxviewer started..."));
	  		else {
		    	slotStatusMsg(i18n("Could not start Faxviewer!"));
			    QMessageBox::information(0,i18n("Viewing Fax"),
  			    i18n("Could not start Faxviewer!"),
    	  		QMessageBox::Ok | QMessageBox::Default);
	  		}
  		}
	  }
	  if (!multiple)
	  {
	  	cmdLine = configuration.faxViewer.copy();
	  	substituteKeyWord(cmdLine,"%FILE_LST",argLst);
  	  debug("command: %s",cmdLine.data());
	  	proc.clearArguments();
	  	proc << cmdLine;;
  		success = proc.start(KProcess::DontCare);
	  	if (success)
  	  	slotStatusMsg(i18n("Faxviewer started..."));
	  	else
  		{
    		slotStatusMsg(i18n("Could not start Faxviewer!"));

	    	QMessageBox::information(0,i18n("Viewing Fax"),
  	    	i18n("Could not start Faxviewer!"),
    	  	QMessageBox::Ok | QMessageBox::Default);
	  	}
	  }
  }

  slotStatusMsg(IDS_DEFAULT);
}

bool KMsgModemApp::messageMailGeneric(int type, int pagesWritten, QString filename)
{
  bool 		success       = false;
  int  		i             = 0;
  int msgSize						= 0;
  QString arg        		= 0;
  QString argLst				= 0;
  QString tmp						= 0;
  QString callerId			= "not set";
  QString cmdLine				= configuration.mailCommand.copy();

  KShellProcess proc;

 	// get senderId
 	_moMsgList.first();
 	while (_moMsgList.current())
 		if (_moMsgList.current()->msgIndex == _faxIndex)
 		{
  		callerId 	= _moMsgList.current()->callerId.simplifyWhiteSpace();
  		msgSize		= _moMsgList.current()->msgSize;
  		break;
  	} else
 			_moMsgList.next();
  			
 	// now spawn sending process with pages as parameters
  slotStatusMsg(i18n("Start mail sending process..."));
  proc.clearArguments();
  			
  // replace sender_id
  if (callerId.isEmpty())	callerId.setStr(i18n("unknown"));
  if (type == MSG_FAX)
  {
	  substituteKeyWord(cmdLine,"%TYPE","FAX");
	  tmp.setNum(pagesWritten);
	}	else {
	  substituteKeyWord(cmdLine,"%TYPE","VOICE");
	  tmp.setNum(msgSize);
	}
	
  substituteKeyWord(cmdLine,"%PAGE_CNT",tmp);
  substituteKeyWord(cmdLine,"%EMAIL",configuration.defaultEMail);
  substituteKeyWord(cmdLine,"%SENDER_ID",callerId);
  		
 	debug("pages: %i",pagesWritten);
 	if (type == MSG_FAX)
 	{
		// list of fax files
		for (i=1; i <= pagesWritten; i++)
  	{
   		arg = "";
  		arg.sprintf("%s-%i.g3 ",filename.data(),i);
	    debug("Argument %i: %s",i,arg.data());
  	 	argLst += arg;
		}
	} else {
  	argLst.sprintf("%s.gsm ",filename.data());
  }
 	substituteKeyWord(cmdLine,"%FILE_LST",argLst);
 	debug("command: %s",cmdLine.data());
	proc << cmdLine;
 	success = proc.start(KProcess::Block); //DontCare
 	
  if (success)
 	  slotStatusMsg(i18n("Mail sending process started..."));
  else
   	slotStatusMsg(i18n("Could not start Mail sender!"));
   	
  slotStatusMsg(IDS_DEFAULT);
  return success;
}

void KMsgModemApp::slotMailFax()
{
  int  		pagesWritten	= 0;
  QString filename			= 0;

  slotStatusMsg(i18n("Mail the selected fax..."));

  if (((pagesWritten = faxHandler()) > 0) &&
  		(filename = modem->getFaxFileName()))
  {
	  if (!messageMailGeneric(MSG_FAX,pagesWritten,filename))
	    QMessageBox::information(0,i18n("Sending Fax as EMail"),
  	    i18n("Could not start mail sending process!"),
    	  QMessageBox::Ok | QMessageBox::Default);
  }
  slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotMailVoice()
{
  QString filename			= 0;

  slotStatusMsg(i18n("Mail the selected fax..."));

  if ((voiceHandler(-1)) &&	(filename = modem->getVoiceFileName()))
  {
	  if (!messageMailGeneric(MSG_VOICE,1,filename))
	    QMessageBox::information(0,i18n("Sending Message as EMail"),
  	    i18n("Could not start mail sending process!"),
    	  QMessageBox::Ok | QMessageBox::Default);
  }
  slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotMailGeneric()
{

  if (_faxIndex < 1)
  {
    QMessageBox::warning(0,i18n("Mail Message As..."),
      i18n("You need to select the desired message!"),
      i18n("Ok"));
	  slotStatusMsg(IDS_DEFAULT);
  	return;
  }

  switch(_msgType)
  {
  	case Fax: 	slotMailFax(); 		break;
  	case Voice: slotMailVoice(); 	break;
  	default:
  		QMessageBox::warning(0,i18n("Mail Message As..."),
      i18n("You have chosen an unsupported message type!"),
      i18n("Ok"));
  }
}

void KMsgModemApp::slotSaveFax()
{

  int  		pagesWritten  = 0;
  QString	filename			= 0;
  QString saveFileName  = 0;

  slotStatusMsg(i18n("Save the selected fax..."));

  if (_faxIndex < 1)
  {
    QMessageBox::information(0,i18n("Save Fax As..."),
      i18n("You need to select the desired fax!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
  	return;
  }

  if (_msgType != Fax)
  {
    QMessageBox::information(0,i18n("Save Fax As..."),
      i18n("You need to select a fax message!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
  	return;
  }

  saveFileName = KFileDialog::getSaveFileName();

	if (!saveFileName.isEmpty())
  {
  	debug("files will be stored in %s",saveFileName.data());
	  if (!(filename = modem->getMemoryFileName()))
	  {
	    if (!modem->getMemory())
	    {
  	    QMessageBox::information(0,i18n("Save Fax As..."),
   	     i18n("Could not read fax memory!"),
   	     QMessageBox::Ok | QMessageBox::Default);
			  slotStatusMsg(IDS_DEFAULT);
   	   return;
	    }
  	}
	  slotGetFax(saveFileName);
  	if (!(filename = modem->getFaxFileName()))
	  {
  	  QMessageBox::information(0,i18n("Save Fax As..."),
    	  i18n("Could not extract the selected fax!"),
      	QMessageBox::Ok | QMessageBox::Default);
		  slotStatusMsg(IDS_DEFAULT);
  	  return;
	  }

  	debug("Fax stored in %s-<nr>",filename.data());

	  if (!(pagesWritten = modem->getPagesWritten()))
  	{
	    slotStatusMsg(i18n("No pages written!"));

  	  QMessageBox::information(0,i18n("Save Fax As..."),
    	  i18n("There were no pages written!"),
      	QMessageBox::Ok | QMessageBox::Default);
		  slotStatusMsg(IDS_DEFAULT);
  	  return;
	  }
  }
  slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotSetFaxIndex(int index, int column)
{
  _tabListIndex = index;
  QString str = view->text(index,0);
  _faxIndex = str.toInt();

  str = view->text(index,1);
  if (str == "Fax")
  	_msgType = Fax;
  else
  	if (str == "Voice")
  		_msgType = Voice;
  	else
  		_msgType = unknown;

  switch(_msgType)
  {
		case Fax:
			enableCommand(ID_FAX_POPUP_VIEW);
			enableCommand(ID_FAX_POPUP_SAVE);
			enableCommand(ID_FAX_POPUP_PRINT);
			enableCommand(ID_FAX_POPUP_MAIL);
			disableCommand(ID_VOICE_POPUP_SAVE);
			disableCommand(ID_VOICE_POPUP_PLAY_INTERN);
			disableCommand(ID_VOICE_POPUP_PLAY_CARD);
			disableCommand(ID_VOICE_POPUP_MAIL);
			enableCommand(ID_GENERIC_POPUP_SAVE);
			enableCommand(ID_GENERIC_POPUP_MAIL);
			break;
		case Voice:
			disableCommand(ID_FAX_POPUP_VIEW);
			disableCommand(ID_FAX_POPUP_SAVE);
			disableCommand(ID_FAX_POPUP_PRINT);
			disableCommand(ID_FAX_POPUP_MAIL);
			enableCommand(ID_VOICE_POPUP_SAVE);
			enableCommand(ID_VOICE_POPUP_PLAY_INTERN);
			enableCommand(ID_VOICE_POPUP_PLAY_CARD);
			enableCommand(ID_VOICE_POPUP_MAIL);
			enableCommand(ID_GENERIC_POPUP_SAVE);
			enableCommand(ID_GENERIC_POPUP_MAIL);
			break;
		default:
			disableCommand(ID_FAX_POPUP_VIEW);
			disableCommand(ID_FAX_POPUP_SAVE);
			disableCommand(ID_FAX_POPUP_PRINT);
			disableCommand(ID_FAX_POPUP_MAIL);
			disableCommand(ID_VOICE_POPUP_SAVE);
			disableCommand(ID_VOICE_POPUP_PLAY_INTERN);
			disableCommand(ID_VOICE_POPUP_PLAY_CARD);
			disableCommand(ID_VOICE_POPUP_MAIL);
			disableCommand(ID_GENERIC_POPUP_SAVE);
			disableCommand(ID_GENERIC_POPUP_MAIL);
	}
  debug("Message index: %i, Message Type: %i",_faxIndex,_msgType);
}

void KMsgModemApp::slotPrintFax()
{
  bool success       	= false;
  int  pagesWritten  	= 0;
  int  i             	= 0;
  QString arg        	= 0;
  QString filename		= 0;
  QString cmdLine			= 0;
  KShellProcess	printer;

  slotStatusMsg(i18n("printing selected fax..."));

  if (((pagesWritten = faxHandler()) > 0) &&
  		(filename = modem->getFaxFileName()))
  {
  	// now spawn print process with pages as parameters
  	slotStatusMsg(i18n("printing to your default printer..."));
	  for (i=1; i <= pagesWritten; i++)
  	{
	  	printer.clearArguments();
    	arg = "";
		  cmdLine	= configuration.printCommand.copy();
	    arg.sprintf("%s-%i.g3", filename.data(),i);
    	substituteKeyWord(cmdLine,"%FILE",arg);
  	  debug("String %i: %s",i,cmdLine.data());
    	printer << cmdLine.data();
	  	success = printer.start(KProcess::Block);
	  	if (success)
	  	{
  	  	slotStatusMsg(i18n("Page sent to printer..."));
  	  	//sleep(2);
  	 	}
	  	else
  		{
    		slotStatusMsg(i18n("Could not print page!"));

	    	QMessageBox::information(0,i18n("Print Fax"),
  	    	i18n("Could not print page!"),
    	  	QMessageBox::Ok | QMessageBox::Default);
	  	}
	  }
  }

	slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotSaveGeneric()
{

  if (_faxIndex < 1)
  {
    QMessageBox::information(0,i18n("Save Message As..."),
      i18n("You need to select the desired message!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
  	return;
  }

  switch(_msgType)
  {
  	case Fax: 	slotSaveFax(); 		break;
  	case Voice: slotSaveVoice(); 	break;
  	default:
  		QMessageBox::information(0,i18n("Save Message As..."),
      i18n("You have chosen an unsupported message type!"),
      QMessageBox::Ok | QMessageBox::Default);
  }
}

void KMsgModemApp::slotSaveVoice()
{
  QString filename = 0;
  QString saveFileName;

	slotStatusMsg(i18n("Save selected message..."));

  if (_faxIndex < 1)
  {
    QMessageBox::information(0,i18n("Save Message As..."),
      i18n("You need to select the desired message!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
  	return;
  }

  if (_msgType != Voice)
  {
    QMessageBox::information(0,i18n("Save Message As..."),
      i18n("You need to select a voice message!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
  	return;
  }

  saveFileName = KFileDialog::getSaveFileName();

	if (!saveFileName.isEmpty())
  {
  	debug("file will be stored in %s",saveFileName.data());
	  if (!(filename = modem->getMemoryFileName()))
	  {
	    if (!modem->getMemory())
	    {
  	    QMessageBox::information(0,i18n("Save Message As..."),
   	     i18n("Could not read modem memory!"),
   	     QMessageBox::Ok | QMessageBox::Default);
			  slotStatusMsg(IDS_DEFAULT);
   	   return;
	    }
  	}
	  slotGetVoice(saveFileName, _faxIndex);
  	if (!(filename = modem->getVoiceFileName()))
	  {
  	  QMessageBox::information(0,i18n("Save Message As..."),
    	  i18n("Could not extract the selected message!"),
      	QMessageBox::Ok | QMessageBox::Default);
		  slotStatusMsg(IDS_DEFAULT);
  	  return;
	  }

  	debug("Message stored in %s.gsm",filename.data());
  }
	slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotPlayIntern()
{
	slotStatusMsg(i18n("Play selected message via modem..."));

  if (_faxIndex < 1)
  {
    QMessageBox::information(0,i18n("Play Message"),
      i18n("You need to select the desired message!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
  	return;
  }

  if (_msgType != Voice)
  {
    QMessageBox::information(0,i18n("Play Message"),
      i18n("You need to select a voice message!"),
      QMessageBox::Ok | QMessageBox::Default);
	  slotStatusMsg(IDS_DEFAULT);
  	return;
  }

 	modem->playVoiceIntern(_faxIndex);

	slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotPlaySoundcard()
{
	playVoiceSoundcard(-1);
}

bool KMsgModemApp::playFileSoundcard(const QString &filename)
{
  bool success      = false;
  QString cmdLine		= configuration.voiceProcessor.copy();
  KShellProcess	sound;

	//QString transformedFile = transformToGSM(filename);
	QString transformedFile = filename.copy();	

	slotStatusMsg(i18n("Play upload file via soundcard..."));

 	// now spawn voiceProcessor process with file as parameter
 	slotStatusMsg(i18n("playing message..."));
 	sound.clearArguments();
  substituteKeyWord(cmdLine,"%FILE",transformedFile.data());
  substituteKeyWord(cmdLine,"%AUDIO_DEVICE",configuration.audioDevice);
  debug("spawn: %s",cmdLine.data());
 	sound << cmdLine.data();
	success = sound.start(KProcess::DontCare);
  if (success)
 	  slotStatusMsg(i18n("playing..."));
  else
 	{
   	slotStatusMsg(i18n("Could not start process!"));

    QMessageBox::information(0,i18n("Playing Message"),
 	   i18n("Could not play the upload file!"),
   	  QMessageBox::Ok | QMessageBox::Default);
  }
	slotStatusMsg(IDS_DEFAULT);
	return success;
}

bool KMsgModemApp::playVoiceSoundcard(int index)
{
  bool success      = false;
  QString arg       = 0;
  QString filename	= 0;
  QString cmdLine		= configuration.voiceProcessor.copy();
  KShellProcess	sound;

	slotStatusMsg(i18n("Play selected message via soundcard..."));

	debug("Play message %d",index);
	
  if ((voiceHandler(index)) &&	(filename = modem->getVoiceFileName()))
  {
  	// now spawn voiceProcessor process with file as parameter
  	slotStatusMsg(i18n("playing message..."));
  	sound.clearArguments();
   	arg = "";
    arg.sprintf("%s.gsm",filename.data());
    substituteKeyWord(cmdLine,"%FILE",arg);
    substituteKeyWord(cmdLine,"%AUDIO_DEVICE",configuration.audioDevice);
 	  debug("spawn: %s",cmdLine.data());
   	sound << cmdLine.data();
  	success = sound.start(KProcess::DontCare);
	  if (success)
  	  slotStatusMsg(i18n("playing..."));
	  else
  	{
    	slotStatusMsg(i18n("Could not start process!"));

	    QMessageBox::information(0,i18n("Playing Message"),
  	   i18n("Could not play the selected message!"),
    	  QMessageBox::Ok | QMessageBox::Default);
	  }
  }
	slotStatusMsg(IDS_DEFAULT);
	return success;
}

bool KMsgModemApp::uploadVoiceMessage(QString filename, bool outgoing)
{
	QString file = filename.copy();
	// the file exists and can be opened
	// We take only gsm files for the moment
	if (filename.right(4) != (QString)".gsm")
	{
		QMessageBox::information(0,i18n("Uploading Message"),
  		i18n("Message is not of type gsm!"),
    	QMessageBox::Ok | QMessageBox::Default);
    return false;
  }
	if (!modem->uploadVoiceMessage(file,outgoing))
	{
		QMessageBox::information(0,i18n("Uploading Message"),
  		i18n("Message could not be uploaded!"),
    	QMessageBox::Ok | QMessageBox::Default);
    return false;
	} else {
		slotGetMemoryInfo();
	}
	return true;
}

void KMsgModemApp::slotResetClock()
{
	slotStatusMsg(i18n("Reset Clock..."));

  int mode=KMsgBox::yesNo(this, i18n("Reset Modem Clock"),
  			i18n("Do you want to reset the modem clock?"));

  if(mode==1)
  	modem->resetClock();
  	
	slotStatusMsg(IDS_DEFAULT);
}


void KMsgModemApp::slotCommitSetup()
{
	slotStatusMsg(i18n("Commit Changes..."));
	
  int mode=KMsgBox::yesNo(this, i18n("Commit Changes"),
  			i18n("Do you want to save changes?"));

  if(mode==1)
  	modem->commitSetup();
  	
	slotStatusMsg(IDS_DEFAULT);
}

int KMsgModemApp::setModemControlValues(struct ModemControlStruct mcontrol,
																				struct ModemControlStruct mcsave)
{
	int changes = 0;
	
	slotStatusMsg(i18n("Write changes back to the modem..."));
	
	if (mcontrol.faxReception != mcsave.faxReception)
	{
		changes++;
  	if (mcontrol.faxReception)
  		modem->setFaxReception();
  	else
  		modem->unsetFaxReception();
 	}

	if (mcontrol.voiceReception != mcsave.voiceReception)
	{
		changes++;
	  if (mcontrol.voiceReception)
  		modem->setVoiceReception();
  	else
  		modem->unsetVoiceReception();
	}

	if (mcontrol.controlMonitor != mcsave.controlMonitor)
	{
		changes++;
	  if (mcontrol.controlMonitor)
  		modem->setControlMonitor();
  	else
  		modem->unsetControlMonitor();
	}

	if (mcontrol.numberOfRings != mcsave.numberOfRings)
	{
		changes++;
		modem->setSetupRings(mcontrol.numberOfRings);
	}

	if (mcontrol.voiceDuration != mcsave.voiceDuration)
	{
		changes++;
		modem->setVoiceDuration(mcontrol.voiceDuration);
	}
		
	if (mcontrol.faxId != mcsave.faxId)
	{
		changes++;
		modem->setSetupFaxId(mcontrol.faxId);
	}
	
	slotStatusMsg(IDS_DEFAULT);
	return changes;
}

void KMsgModemApp::getModemControlValues(struct ModemControlStruct &mcontrol,
																				struct ModemControlStruct &mcsave)
{
	slotStatusMsg(i18n("Get modem settings..."));
	
	mcontrol.faxReception 		= modem->getFaxReception();
	if (mcontrol.faxReception)
	  debug("true");
	else
		debug("false");
		
	mcontrol.voiceReception 	= modem->getVoiceReception();
	if (mcontrol.voiceReception)
	  debug("true");
	else
		debug("false");
	
	mcontrol.controlMonitor	= modem->getControlMonitor();
	if (mcontrol.controlMonitor)
	  debug("true");
	else
		debug("false");
		
	mcontrol.numberOfRings		= modem->getSetupRings();
	mcontrol.voiceDuration		= modem->getVoiceDuration();
	mcontrol.faxId.setStr(modem->getSetupFaxId().data());
	
	// store settings in mcsave
	mcsave.faxReception = mcontrol.faxReception;
	mcsave.voiceReception = mcontrol.voiceReception;
	mcsave.controlMonitor = mcontrol.controlMonitor;
	mcsave.numberOfRings	= mcontrol.numberOfRings;
	mcsave.voiceDuration	= mcontrol.voiceDuration;
	mcsave.faxId.setStr(mcontrol.faxId);
	
	slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotModemControl()
{

	struct ModemControlStruct mcontrol;
	struct ModemControlStruct mcsave;
	
  slotStatusMsg(i18n("configure Message Modem..."));

  getModemControlValues(mcontrol, mcsave);
	ModemControl *dialog = new ModemControl(&mcontrol);
	
	int ret = dialog->exec();
	if (ret == QDialog::Accepted)
	{
		debug("OK pressed");
		if (setModemControlValues(mcontrol, mcsave) > 0)
		{
    	QMessageBox::information(0,i18n("Changed Settings"),
      	i18n("New settings were written to the modem.\n"
      			"If you want to make them permanent, please\nchoose "
      			"\"Commit Setup\" from the Modem Menu."),
      	QMessageBox::Ok | QMessageBox::Default);
    }
	} else {
		debug("Cancel pressed");
	}
	slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotModemInfoDialog()
{
	statusDialog->show();
	statusDialog->slotUpdateStatus(_moGeneral);
}

void KMsgModemApp::slotModemTerminal()
{
	slotStatusMsg(i18n("speak directly to the modem"));
	ModemTerminal *dialog = new ModemTerminal(modem);
	dialog->exec();
	if (dialog) delete dialog;
	slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotModemVoiceDial()
{
	slotStatusMsg(i18n("Call manual Dial Dialog"));
	if (!voiceDial)
		voiceDial = new VoiceDial(this, modem);
	else
		voiceDial->slotDialogInit();
	voiceDial->show();
	slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotModemVoiceMessages()
{
	slotStatusMsg(i18n("Manipulate outgoing and full message of the modem"));
	if (!voiceMessagesDialog)
		voiceMessagesDialog = new VoiceMessagesDialog(this, modem);
	voiceMessagesDialog->show();
	slotStatusMsg(IDS_DEFAULT);
}

void KMsgModemApp::slotSettings()
{
	QString tmpStr;
	int idx = 0;
  slotStatusMsg(i18n("configure KMsgModem..."));
	SettingsDialog *dialog = new SettingsDialog(configuration);
	if (dialog->exec() == QDialog::Accepted)
	{
		debug("OK pressed");
		// do something with the new settings
		configuration.serialLine 			= dialog->getSerialDevice();
		configuration.audioDevice			= dialog->getAudioDevice();
		configuration.faxViewer 			= dialog->getFaxViewer();
		configuration.baudrate 				= dialog->getBaudrate();
		configuration.defaultEMail		= dialog->getDefaultEMail();
		configuration.printCommand		= dialog->getPrintCommand();
		configuration.mailCommand			= dialog->getMailCommand();
		configuration.wav2gsmCommand	= dialog->getWav2GsmCommand();
		configuration.voiceProcessor	= dialog->getVoiceProcessor();
		tmpStr = dialog->getSerialDevice();
		idx = tmpStr.findRev('/');
		configuration.lockfile.sprintf("%s/LCK..%s",LOCKPATH,
									tmpStr.right(tmpStr.length() - idx - 1 ).data());
    QMessageBox::information(0,i18n("Changed Settings"),
      i18n("New settings will take effect after restart."),
      QMessageBox::Ok | QMessageBox::Default);
	} else {
		debug("Cancel pressed");
	}
	slotStatusMsg(IDS_DEFAULT);
}


void KMsgModemApp::slotDisableMost()
{
	disableCommand(ID_FAX_POPUP_VIEW);
	disableCommand(ID_FAX_POPUP_SAVE);
	disableCommand(ID_FAX_POPUP_PRINT);
	disableCommand(ID_FAX_POPUP_MAIL);
	disableCommand(ID_VOICE_POPUP_MAIL);
	disableCommand(ID_VOICE_POPUP_SAVE);
	disableCommand(ID_VOICE_POPUP_PLAY_INTERN);
	disableCommand(ID_VOICE_POPUP_PLAY_CARD);
	disableCommand(ID_GENERIC_POPUP_SAVE);
	disableCommand(ID_GENERIC_POPUP_MAIL);
	disableCommand(ID_MODEM_GET_INFO);
	disableCommand(ID_MODEM_GET_MEMORY);
	disableCommand(ID_MODEM_CLEAR_MEMORY);
	disableCommand(ID_MODEM_RESET_CLOCK);
	disableCommand(ID_MODEM_COMMIT_SETUP);
	disableCommand(ID_MODEM_CONTROL);
	disableCommand(ID_MODEM_INFO_DIALOG);
	disableCommand(ID_MODEM_TERMINAL);
}


void KMsgModemApp::showAboutDialog( void )
{
  if( mAboutDialog == 0 )
  {
    mAboutDialog = new CAboutDialog( 0, "About" );
    if( mAboutDialog == 0 ) { return; }
  }
  if( mAboutDialog->isVisible() == false )
  {
    //centerDialog( mAboutDialog, topLevelWidget() );
    mAboutDialog->show();
  }
  else
  {
    mAboutDialog->raise();
  }

}

void KMsgModemApp::slotAboutQt()
{
	QMessageBox::aboutQt(this, i18n("About Qt"));
}

/** substitute a keyword with a given string.
		Returns true if keyword was found, false otherwise. */
bool KMsgModemApp::substituteKeyWord(QString &cmd, QString key, QString sub)
{
	//debug("cmd: %s\nkey: %s\nsub: %s",cmd.data(),key.data(),sub.data());
	int idx = cmd.find(key,0,false);
	if (idx != -1)
	{
		// string found, replace it
		cmd.replace(idx,key.length(),sub);
		return true;
	}
  return false;
}
