/**********************************************************************

	--- Qt Architect generated file ---

	File: ModemStatus.cpp
	Last generated: Tue May 11 14:49:23 1999

 *********************************************************************/

#include <qpainter.h>
#include <kledlamp.h>

#include "ModemStatus.h"
#include "usrmodem.h"

#define Inherited ModemStatusData

ModemStatus::ModemStatus(QWidget* parent,const char* name ) :
						Inherited( parent, name )
{
	_buffer.resize(paintArea->width(),paintArea->height());
	_buffer.fill(paintArea->backgroundColor());
}


ModemStatus::~ModemStatus()
{
}

void ModemStatus::paintEvent(QPaintEvent *event)
{
	bitBlt(paintArea, 0, 0, &_buffer);
}

void ModemStatus::slotUpdateStatus(const ModemGeneralInfo &moGeneral)
{
	drawMemoryPie(moGeneral.memUsed);
	totalMemory->display(moGeneral.memSize);
	percentageUsed->display(moGeneral.memUsed);
	noFaxMsg->display(moGeneral.noFaxMsg);
	noFaxUnreleased->display(moGeneral.noFaxUnreleased);
	noVoiceMsg->display(moGeneral.noVoiceMsg);
	noVoiceUnreleased->display(moGeneral.noVoiceUnreleased);
	
	if (moGeneral.outMsgPresent)
		outMsgPresent->on();
	else
		outMsgPresent->off();
		
	if (moGeneral.fullMsgPresent)
		fullMsgPresent->on();
	else
		fullMsgPresent->off();
}

void ModemStatus::drawMemoryPie(int percentUsed)
{
	int alen = 5760 * percentUsed / 100 * -1;
	int ilen = 5750 + alen;
	
	QRect rect1(10,10,_buffer.width()-20,_buffer.width()-160);
	QRect rect2(rect1.x(),rect1.y()+20,rect1.width(),rect1.height());
	
	QPainter windowpainter;
	windowpainter.begin(&_buffer);
	windowpainter.setBrush(green);
	windowpainter.setPen(green);
	for (int i = rect1.y(); i <= rect2.y() ; i++)
		windowpainter.drawPie(rect1.x(),i,rect1.width(),rect1.height(),0,ilen);

	if (percentUsed)
	{
		windowpainter.setBrush(red);
		windowpainter.setPen(red);
		for (int i = rect1.y(); i <= rect2.y() ; i++)
			windowpainter.drawPie(rect1.x(),i,rect1.width(),rect1.height(),0,alen);
	}
	windowpainter.flush();
	windowpainter.end();
	paintEvent(0);
}

