#include "RefCounter.h"

RefCounter::RefCounter(void)
	{
	for(int i=0; i<MAX_REF; i++)
		{
		refs[i] = 0;
		counts[i] = 0;
		}
	}

bool RefCounter::add(void *ref)
	{
	for(int i=0; i<MAX_REF; i++)
		if(refs[i] == 0)
			{
			refs[i] = ref;
			counts[i] = 0;
			return true;
			}
	return false;
	}

bool RefCounter::remove(void *ref)
	{
	for(int i=0; i<MAX_REF; i++)
		if(refs[i] == ref)
			{
			refs[i] = 0;
			counts[i] = 0;
			return true;
			}
	return false;		
	}

bool RefCounter::increase(void *ref)
	{
	for(int i=0; i<MAX_REF; i++)
		if(refs[i] == ref)
			{
			counts[i]++;
			return true;
			}
	return false;		
	}

bool RefCounter::decrease(void *ref)
	{
	for(int i=0; i<MAX_REF; i++)
		if(refs[i] == ref)
			{
			counts[i]--;
			return true;
			}
	return false;		
	}

int RefCounter::count(void *ref)
	{
	for(int i=0; i<MAX_REF; i++)
		if(refs[i] == ref)
			return counts[i];
	return -1;
	}

bool RefCounter::exists(void *ref)
	{
	for(int i=0; i<MAX_REF; i++)
		if(refs[i] == ref)
			return true;
	return false;
	}
