/*
 * macro_dialog.cpp
 *
 * Copyright (C) 1999 Lubos Lunak <l.lunak@email.cz>
 */

#include <qpixmap.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qmessagebox.h>
#include "macro_dialog.h"

macro_dialog::macro_dialog( const QString& macro_P )
    : QDialog( 0, 0, true )
    {
	setCaption( i18n( "Edit macro" ));
	QLabel* qtarch_label;
	qtarch_label = new QLabel( this, "label_actions" );
	qtarch_label->setGeometry( 0, 0, 70, 10 );
	qtarch_label->setFixedSize( 150, 15 );
	qtarch_label->setFocusPolicy( QWidget::NoFocus );
	qtarch_label->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_label->setFontPropagation( QWidget::NoChildren );
	qtarch_label->setPalettePropagation( QWidget::NoChildren );
	qtarch_label->setText( i18n("Macro keys :" ));
	qtarch_label->setAlignment( 289 );
	qtarch_label->setMargin( -1 );

	macro_list = new QListBox_ign( this );
	macro_list->setGeometry( 5, 15, 253, 245 );
	macro_list->setMinimumSize( 200, 100 );
	connect( macro_list, SIGNAL(highlighted(int)), SLOT(highlighted(int)) );
	macro_list->setFocusPolicy( QWidget::StrongFocus );
	macro_list->setBackgroundMode( QWidget::PaletteBase );
	macro_list->setFontPropagation( QWidget::SameFont );
	macro_list->setPalettePropagation( QWidget::SameFont );
	macro_list->setFrameStyle( 51 );
	macro_list->setLineWidth( 2 );
	macro_list->setMidLineWidth( 0 );
	macro_list->QFrame::setMargin( 0 );
	macro_list->setDragSelect( TRUE );
	QToolTip::add( macro_list, i18n( "This is the sequence of keys in this macro." ));

	QPushButton* qtarch_ok_button;
	qtarch_ok_button = new QPushButton( this, "ok_button" );
	qtarch_ok_button->setGeometry( 264, 25, 150, 30 );
	qtarch_ok_button->setMinimumSize( 100, 30 );
	qtarch_ok_button->setMaximumSize( 150, 30 );
	connect( qtarch_ok_button, SIGNAL(clicked()), SLOT(ok_pressed()) );
	qtarch_ok_button->setFocusPolicy( QWidget::TabFocus );
	qtarch_ok_button->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_ok_button->setFontPropagation( QWidget::NoChildren );
	qtarch_ok_button->setPalettePropagation( QWidget::NoChildren );
	qtarch_ok_button->setText( i18n( "Ok" ));
	qtarch_ok_button->setAutoRepeat( FALSE );
	qtarch_ok_button->setAutoResize( FALSE );
	qtarch_ok_button->setDefault( true );

	QPushButton* qtarch_cancel_button;
	qtarch_cancel_button = new QPushButton( this, "cancel_button" );
	qtarch_cancel_button->setGeometry( 264, 210, 150, 30 );
	qtarch_cancel_button->setMinimumSize( 100, 30 );
	qtarch_cancel_button->setMaximumSize( 150, 30 );
	connect( qtarch_cancel_button, SIGNAL(clicked()), SLOT(reject()));
	qtarch_cancel_button->setFocusPolicy( QWidget::TabFocus );
	qtarch_cancel_button->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_cancel_button->setFontPropagation( QWidget::NoChildren );
	qtarch_cancel_button->setPalettePropagation( QWidget::NoChildren );
	qtarch_cancel_button->setText( i18n( "Cancel" ));
	qtarch_cancel_button->setAutoRepeat( FALSE );
	qtarch_cancel_button->setAutoResize( FALSE );

	QPushButton* qtarch_new_button;
	qtarch_new_button = new QPushButton( this );
	qtarch_new_button->setGeometry( 264, 25, 150, 30 );
	qtarch_new_button->setMinimumSize( 100, 30 );
	qtarch_new_button->setMaximumSize( 150, 30 );
	connect( qtarch_new_button, SIGNAL(clicked()), SLOT(new_pressed()) );
	qtarch_new_button->setFocusPolicy( QWidget::TabFocus );
	qtarch_new_button->setBackgroundMode( QWidget::PaletteBackground );
	qtarch_new_button->setFontPropagation( QWidget::NoChildren );
	qtarch_new_button->setPalettePropagation( QWidget::NoChildren );
	qtarch_new_button->setText( i18n( "New" ));
	qtarch_new_button->setAutoRepeat( FALSE );
	qtarch_new_button->setAutoResize( FALSE );

	delete_button = new QPushButton( this );
	delete_button->setGeometry( 264, 25, 150, 30 );
	delete_button->setMinimumSize( 100, 30 );
	delete_button->setMaximumSize( 150, 30 );
	connect( delete_button, SIGNAL(clicked()), SLOT(delete_pressed()) );
	delete_button->setFocusPolicy( QWidget::TabFocus );
	delete_button->setBackgroundMode( QWidget::PaletteBackground );
	delete_button->setFontPropagation( QWidget::NoChildren );
	delete_button->setPalettePropagation( QWidget::NoChildren );
	delete_button->setText( i18n( "Delete" ));
	delete_button->setAutoRepeat( FALSE );
	delete_button->setAutoResize( FALSE );

	moveup_button = new QPushButton( this );
	moveup_button->setGeometry( 264, 25, 150, 30 );
	moveup_button->setMinimumSize( 100, 30 );
	moveup_button->setMaximumSize( 150, 30 );
	connect( moveup_button, SIGNAL(clicked()), SLOT(moveup_pressed()) );
	moveup_button->setFocusPolicy( QWidget::TabFocus );
	moveup_button->setBackgroundMode( QWidget::PaletteBackground );
	moveup_button->setFontPropagation( QWidget::NoChildren );
	moveup_button->setPalettePropagation( QWidget::NoChildren );
	moveup_button->setText( i18n( "Move up" ));
	moveup_button->setAutoRepeat( FALSE );
	moveup_button->setAutoResize( FALSE );

	movedown_button = new QPushButton( this );
	movedown_button->setGeometry( 264, 25, 150, 30 );
	movedown_button->setMinimumSize( 100, 30 );
	movedown_button->setMaximumSize( 150, 30 );
	connect( movedown_button, SIGNAL(clicked()), SLOT(movedown_pressed()) );
	movedown_button->setFocusPolicy( QWidget::TabFocus );
	movedown_button->setBackgroundMode( QWidget::PaletteBackground );
	movedown_button->setFontPropagation( QWidget::NoChildren );
	movedown_button->setPalettePropagation( QWidget::NoChildren );
	movedown_button->setText( i18n( "Move down" ));
	movedown_button->setAutoRepeat( FALSE );
	movedown_button->setAutoResize( FALSE );

	KKeyEntry* tmp = make_key_entry( i18n( "None" ), 0 );
	dict.insert( "Internal", tmp );
	keys = new KKeyChooser_ign( &dict, this, false );
	keys->setGeometry( 5, 265, 410, 30 );
	keys->setMinimumSize( 300, 100 );

	QBoxLayout* qtarch_layout_1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, NULL );
	qtarch_layout_1->addStrut( 0 );
	QBoxLayout* qtarch_layout_1_1 = new QBoxLayout( QBoxLayout::LeftToRight, 5, NULL );
	qtarch_layout_1->addLayout( qtarch_layout_1_1, 5 );
	qtarch_layout_1_1->addStrut( 0 );
	QBoxLayout* layout_1_2 = new QVBoxLayout;
	qtarch_layout_1_1->addLayout( layout_1_2, 5 );
	layout_1_2->addWidget( qtarch_label, 0, AlignLeft );
	layout_1_2->addWidget( macro_list, 1, 36 );
	QBoxLayout* qtarch_layout_1_1_2 = new QBoxLayout( QBoxLayout::TopToBottom, 5, NULL );
	qtarch_layout_1_1->addLayout( qtarch_layout_1_1_2, 1 );
	qtarch_layout_1_1_2->addStrut( 0 );
	qtarch_layout_1_1_2->addSpacing( 20 );
	qtarch_layout_1_1_2->addWidget( qtarch_ok_button, 1, 36 );
	qtarch_layout_1_1_2->addStretch( 1 );
	qtarch_layout_1_1_2->addWidget( qtarch_cancel_button, 1, 36 );
	qtarch_layout_1_1_2->addStretch( 1 );
	qtarch_layout_1_1_2->addWidget( qtarch_new_button, 1, 36 );
	qtarch_layout_1_1_2->addStretch( 1 );
	qtarch_layout_1_1_2->addWidget( delete_button, 1, 36 );
	qtarch_layout_1_1_2->addStretch( 1 );
	qtarch_layout_1_1_2->addWidget( moveup_button, 1, 36 );
	qtarch_layout_1_1_2->addStretch( 1 );
	qtarch_layout_1_1_2->addWidget( movedown_button, 1, 36 );
	qtarch_layout_1_1_2->addStretch( 3 );
	qtarch_layout_1_1_2->addSpacing( 20 );
	qtarch_layout_1->addWidget( keys, 1, 36 );
	resize( 420, 500 );

    dict.setAutoDelete( true );
    if( macro_P != "" )
	{
	bool was_invalid_key = false;
	int last_index = -1, start = 0;
        while(( last_index = macro_P.find( ':', last_index + 1 )) != -1 ) // find next ';'
    	    {
	    uint keycode = stringToKey( macro_P.mid( start, last_index - start ));
	    if( keycode == 0 )
		{
		was_invalid_key = true;
		macro_list->insertItem( i18n( "None" ));
		}
	    else
	        macro_list->insertItem( macro_P.mid( start, last_index - start ));
	    start = last_index + 1;
	    }
        // and the last one
	uint keycode = stringToKey( macro_P.mid( start, macro_P.length()));
        if( keycode == 0 )
	    {
	    was_invalid_key = true;
	    macro_list->insertItem( i18n( "None" ));
	    }
	else
	    macro_list->insertItem( macro_P.mid( start, macro_P.length()));
	KKeyEntry* tmp = make_key_entry( i18n( "Macro key" ), keycode );
	dict.clear(); // replace the empty one
	dict.insert( "Internal", tmp );
//	macro_list->setSelected( macro_list->count() - 1, true );
	if( was_invalid_key )
	    QMessageBox::warning( NULL, i18n( "KHotKeys" ),
		i18n( "One or more of the macro keys are invalid.\n"
		    "They will be replaced by empty keys.\n"
		    "If you want to fix them manually, press Cancel in the dialog." ));
	}
    keys->listSync();
    macro_list->setFocus();
    previous_pos = macro_list->count() - 1;
    macro_list->setSelected( macro_list->count() - 1, true );
    check_enabled();
    }


KKeyEntry* macro_dialog::make_key_entry( const QString& name_P, uint keycode_P )
    {
    KKeyEntry* tmp = new KKeyEntry;
    tmp->aDefaultKeyCode = 0;
    tmp->aConfigKeyCode = tmp->aCurrentKeyCode = keycode_P;
    tmp->bConfigurable = true;
    tmp->bEnabled = true;
    tmp->aAccelId = 0;
    tmp->receiver = 0;
    tmp->member = 0;
    tmp->descr = name_P;
    return tmp;
    }

void macro_dialog::check_enabled()
    {
    keys->setEnabled( macro_list->count() != 0 );
    delete_button->setEnabled( macro_list->currentItem() >= 0 );
    moveup_button->setEnabled( macro_list->currentItem() > 0 );
    movedown_button->setEnabled(
	macro_list->currentItem() < ( int ) macro_list->count() - 1 ); // static_cast<>
    }

void macro_dialog::highlighted( int pos )
    {
    if( pos == previous_pos )
	return;
    KKeyEntry* key = dict.find( "Internal" );
    QString key_txt = keyToString( key->aConfigKeyCode );
    if( key_txt == "" )
	key_txt = i18n( "None" );
    macro_list->changeItem( key_txt, previous_pos );
    previous_pos = pos;
    key_txt = macro_list->text( pos );
    if( key_txt == i18n( "None" ))
	key_txt = "";
    key = make_key_entry( i18n( "Macro key" ), stringToKey( key_txt ));
    dict.clear();
    dict.insert( "Internal", key );
    keys->listSync();
    check_enabled();
    }
    
void macro_dialog::ok_pressed()
    {
    for( int i = 0;
	 i < ( int ) macro_list->count(); // static_cast<>
	 ++i )
	{
	QString key_txt;
	if( i == macro_list->currentItem())
	    {
	    KKeyEntry* key = dict.find( "Internal" );
	    key_txt = keyToString( key->aConfigKeyCode );
	    }
	else
	    key_txt = macro_list->text( i );
	if( key_txt != "" && key_txt != i18n( "None" ))
	    {
	    ret_macro_text += key_txt;
	    ret_macro_text += ':';
	    }
	}
    ret_macro_text.truncate( ret_macro_text.length() - 1 ); // last ':'
    accept();
    }

void macro_dialog::new_pressed()
    {
    int pos = macro_list->currentItem() + 1;
    macro_list->insertItem( i18n( "None" ), pos );
    macro_list->setSelected( pos, true );
    }

void macro_dialog::delete_pressed()
    {
    int pos = macro_list->currentItem();
    if( macro_list->count() == 1 )
	{
        dict.clear();
        dict.insert( "Internal", make_key_entry( i18n( "None" ), 0 ));
        keys->listSync();
	}
    else if( pos < ( int )macro_list->count() - 1 ) // static_cast<>
	macro_list->setSelected( pos + 1, true );
    else
	macro_list->setSelected( pos - 1, true );
    macro_list->removeItem( pos );
    check_enabled();
    }

void macro_dialog::moveup_pressed()
    {
    int pos = macro_list->currentItem();
    QString tmp = macro_list->text( pos - 1 );
    macro_list->changeItem( macro_list->text( pos ), pos - 1 );
    macro_list->setSelected( pos - 1, true ); // this calls highlighted()
    macro_list->changeItem( tmp, pos );
    }

void macro_dialog::movedown_pressed()
    {
    int pos = macro_list->currentItem();
    QString tmp = macro_list->text( pos + 1 );
    macro_list->changeItem( macro_list->text( pos ), pos + 1 );
    macro_list->setSelected( pos + 1, true ); // this calls highlighted() 
    macro_list->changeItem( tmp, pos );
    }

void QListBox_ign::keyPressEvent( QKeyEvent *e )
    {
    e->ignore();
    QListBox::keyPressEvent( e );
    }

void KKeyChooser_ign::keyPressEvent( QKeyEvent *e )
    {
    if ( !bKeyIntercept )
	{
        e->ignore();
	return;
	}
    KKeyChooser::keyPressEvent( e );
    }

