/* -*- C++ -*-
 * This file declares the class for interfacing xhost.
 * It is part of khost.
 * khost is a GUI to xhost.
 *
 * khost is part of the K Desktop Environment
 * copyright:  (C) Mirko Sucker, 1999
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@unibw-hamburg.de>
 * requires:   recent C++-compiler, at least Qt 1.4
 * $Revision: 1.3 $
 */

#ifndef XHOSTINTERFACE_H_INCLUDED
#define XHOSTINTERFACE_H_INCLUDED

class KProcess;

#include <kprocess.h>
#include <qobject.h>
#include <qstring.h>
#include <qtimer.h>

/** XHostInterface provides all services used from xhost and
 *  the functionality provided by khost in simple methods. */
class XHostInterface : public QObject
{
  // ############################################################################
  Q_OBJECT
  // ----------------------------------------------------------------------------
public:
  /** The constructor. */
  XHostInterface();
  /** The destructor. */
  ~XHostInterface();
  /** Returns \e false if xhost cannot be called. */
  // bool isXHostAvailable(); 
  /** Enable or disable control. */
  bool enableHostAccessControl(bool state); 
  /** Add this host to the list of hosts allowed to access the display. */
  bool addAllowedHost(const char* name); 
  /** Remove this host from the list of hosts allowed to access the display. */
  bool removeHostname(const char* name);
  // ----------------------------------------------------------------------------
protected slots:
  /** Called when xhost finished a requested operation. */
  void done(KProcess *proc);
  /** Called when a specific time has gone until a call to xhost. */
  void timeout();
  // ----------------------------------------------------------------------------
signals:
  /** KHost receives this to show the message in the status line. */
  void setStatus(const QString&);
  // ----------------------------------------------------------------------------
protected:
  /** The path to the xhost binary. */
  QString xhostPath;
  /** The KProcess object to call xhost. */
  KProcess *proc;
  /** The timer to watch for hanging child processes. */
  QTimer timer;
  /** Do a command calling xhost. All elements in argv will be passed as
   *  parameters.*/
  bool callXHost(int argc, char** argv);
  // ############################################################################
};


#endif // XHOSTINTERFACE_H_INCLUDED
